unit ImgGrid;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids;

type
  { forward class declaration to satisfy compiler }
  TGLDBImageGrid = class ;

  TTestDataCondition = procedure (Grid : TGLDBImageGrid ;
                       Column : TColumn ;
                       State: TGridDrawState ;
                       var ImageNumber : integer) of object ;

  TGLDBImageGrid = class(TDBGrid)
  private
     FTestDataCondition : TTestDataCondition ;
     FImageList : TImageList ;   { storage location }
  protected
     procedure Notification(AComponent: TComponent;
               Operation: TOperation); override ;
     procedure DrawColumnCell(const Rect: TRect;
               DataCol: Integer; Column: TColumn;
               State: TGridDrawState); override ;
  public
     constructor Create(AOwner : TComponent) ; override ;
  published
     property ImageList : TImageList read FImageList write FImageList ;
     property TestDataCondition : TTestDataCondition
              read FTestDataCondition write FTestDataCondition ;
  end;

procedure Register;

implementation

constructor TGLDBImageGrid.Create(AOwner : TComponent) ;
begin
     inherited ;
{$IFDEF SHOW_COPYRIGHT}
     if csDesigning in ComponentState then
        MessageDlg('TGLDBImageGrid 1.01 - Copyright  1998 Greg Lief' + #13 + 'This component is part of the G.L.A.D. collection' + #13 + 'To remove this message and receive the source code, ' + #13 + 'register at http://www.greglief.com/delphi.shtml' + #13 + 
                   'http://www.greglief.com',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
end ;

procedure TGLDBImageGrid.Notification(AComponent: TComponent;
          Operation: TOperation);
begin
     if (Operation = opRemove) and (AComponent = FImageList) then
        FImageList := nil ;
end ;


procedure TGLDBImageGrid.DrawColumnCell(const Rect: TRect;
  DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
   ImageNumber : integer ;
   FBitmap : TBitmap ;
begin
     ImageNumber := -1 ;
     if Assigned(FTestDataCondition) and Assigned(FImageList) then
        FTestDataCondition(self, Column, State, ImageNumber) ;
     Canvas.FillRect(Rect) ;
     if (ImageNumber <> -1) and (ImageNumber <= FImageList.Count) then begin
        FBitmap := TBitmap.Create ;
        FImageList.GetBitmap(ImageNumber, FBitmap) ;
        Canvas.Draw(Rect.Left + 1, Rect.Top + 1, FBitmap) ;
        Canvas.TextOut(Rect.Left + FBitmap.Width + 5, Rect.Top,
                       Column.Field.AsString) ;
        FBitmap.Free ;
     end
     else
        Canvas.TextOut(Rect.Left + 1, Rect.Top + 1,
                       Column.Field.AsString) ;
end;

procedure Register;
begin
  RegisterComponents('GLAD: DBGrids', [TGLDBImageGrid]);
end;

end.
