unit gldfiles ;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, ShellAPI ;

type
  TGLDropFilesEvent = procedure (FileNames : TStringList) of object ;

  TGLDropFiles = class(TComponent)
  private
     FOnDropFiles : TGLDropFilesEvent ;
     FFileNames : TStringList ;
     FOldWindowProc : TWndMethod ;
     procedure NewWindowProc(var Message: TMessage) ;
  public
     constructor Create(AOwner : TComponent) ; override ;
     destructor Destroy ; override ;
     property FileNames : TStringList read FFileNames ;
  published
     property OnDropFiles : TGLDropFilesEvent read FOnDropFiles write FOnDropFiles ;
  end;

procedure Register;

implementation

constructor TGLDropFiles.Create(AOwner : TComponent) ;
begin
     inherited ;
     FFileNames := TStringList.Create ;
     if not (csDesigning in ComponentState) then begin
        DragAcceptFiles((Owner as TForm).Handle, True);
        FOldWindowProc := (Owner as TForm).WindowProc ;
        (Owner as TForm).WindowProc := NewWindowProc ;
     end
{$IFDEF SHOW_COPYRIGHT}
     else
        MessageDlg('TGLDropFiles 1.0 - Copyright  1998 Greg Lief' + #13 + 'This component is part of the G.L.A.D. collection' + #13 + 'To remove this message and receive the source code, ' + #13 + 'register at http://www.greglief.com/delphi.shtml',
                    mtInformation, [mbOK], 0) ;
{$ENDIF}
end ;

destructor TGLDropFiles.Destroy ;
begin
     if (Owner <> nil) and (not (csDesigning in ComponentState) ) then begin
        DragAcceptFiles((Owner as TForm).Handle, False);
        (Owner as TForm).WindowProc := FOldWindowProc ;
     end ;
     FFileNames.Free ;
     inherited ;
end ;

procedure TGLDropFiles.NewWindowProc(var Message: TMessage);
var
   pFileName : PChar ;
   NumFiles : integer ;
   x : integer ;
const
   BUFF_SIZE = 512 ;
begin
     if Message.Msg = WM_DROPFILES then begin
        FFileNames.Clear ;
        NumFiles := DragQueryFile(Message.WParam, $FFFFFFFF, nil, 0) ;
        pFileName := StrAlloc(BUFF_SIZE) ;
        for x := 0 to NumFiles - 1 do begin
           DragQueryFile(Message.WParam, x, pFileName, BUFF_SIZE);
           FFileNames.Add( string(pFileName) ) ;
        end ;
        StrDispose(pFileName) ;
        DragFinish(Message.WParam);
        if Assigned(FOnDropFiles) then
           FOnDropFiles(FileNames) ;
    end
    else
       FOldWindowProc(Message) ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: Misc.', [TGLDropFiles]);
end;

end.
