(*
   CurrencyToString function -- accepts a currency value and returns its verbose description
   Ideal for check printing
   Example: CurrencyToString(123.45) = 'One Hundred Twenty-Three and 45/100ths'
   Copyright  1998 Greg Lief
   Compatible with Delphi 2 and 3
*)

unit curr_str ;

interface

function CurrencyToString(Amount : currency) : string ;

implementation

uses SysUtils, Math ;

function CurrencyToString(Amount : currency) : string ;

   function IntToString(Amount : integer) : string ;
   const
      Amounts : array[0..26] of string =
                ('One', 'Two', 'Three', 'Four', 'Five', 'Six',
                 'Seven', 'Eight', 'Nine', 'Ten', 'Eleven',
                 'Twelve', 'Thirteen', 'Fourteen', 'Fifteen',
                 'Sixteen', 'Seventeen', 'Eighteen', 'Nineteen',
                 'Twenty', 'Thirty', 'Forty', 'Fifty', 'Sixty', 'Seventy',
                 'Eighty', 'Ninety') ;
   var
      temp : integer ;
   begin
      Result := '' ;
      if Amount > 99 then begin
         temp := Amount div 100 ;
         Result := Result + Amounts[temp - 1] + ' Hundred' ;
         Dec(Amount, temp * 100) ;
         if Amount > 0 then
            Result := Result + #32 ;
      end ;
      case Amount of
         1..19  : Result := Result + Amounts[Amount - 1] ;
         20..99 : begin
                     temp := Amount div 10 ;
                     Result := Result + Amounts[temp + 17] ;
                     Dec(Amount, temp * 10) ;
                     if Amount <> 0 then
                        Result := Result + '-' + Amounts[Amount - 1] ;
                  end ;
      end ;
   end ;

var
   iTemp : integer ;
   x : integer ;
begin
     Result := '' ;
     x := 6 ;
     while x >= 0 do begin
        if Amount >= Power(10, x) then begin
           iTemp := Trunc(Amount / Power(10,x)) ;
           Result := Result + IntToString(iTemp) ;
           case x of
              3 : Result := Result + ' Thousand' ;
              6 : Result := Result + ' Million' ;
           end ;
           Amount := Amount - (iTemp * Power(10,x)) ;
           if Amount > 0 then
              Result := Result + #32 ;
        end ;
        Dec(x, 3) ;
     end ;
     if Amount <> Trunc(Amount) then
        Result := Result + 'and ' +
                  FloatToStr(Frac(Amount) * 100) + '/100ths'
     else
        Result := Result + ' exactly'
end ;


end.
