unit GLADMisc ;
(*
    G.L.A.D. Registration Unit for GLAD-Misc package
    Copyright  1998 Greg Lief
*)

interface

uses Classes,
     DsgnIntf,
     AppSet,
     Elastic,
     gldfiles,
     gleaster,
     glrunone,
     PrnFile,
     SaveWin,
     SWatch,
     TErrLog,
     Timed_ev,
     TimeOut,
     Ver_Info,
     WPChange ;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('GLAD: Misc.',
                                  [TGLAppSettings,
                                   TGLDropFiles,
                                   TGLEasterEgg,
                                   TGLElastic,
                                   TGLErrorLogger,
                                   TGLPrintTextFile,
                                   TGLRunOnce,
                                   TGLSaveWindow,
                                   TGLStopwatch,
                                   TGLTimedEvents,
                                   TGLTimeOut,
                                   TGLVersionInfo,
                                   TGLWallPaperChanger] ) ;
  RegisterPropertyEditor( TypeInfo(TMyFilename), TGLPrintTextFile,
                           'Filename', TMyFileNameEditor );

  RegisterComponentEditor(TGLWallpaperChanger, TGLWallpaperChangerEditor) ;

  RegisterPropertyEditor( TypeInfo(TMyFilename), TGLWallpaperChanger,
                          'Filename', TMyFileNameEditor );

  RegisterPropertyEditor(TypeInfo(string),      // data type of property
                         {$IFDEF VER100}
                         TGLEvent,              // component class
                         {$ELSE}
                         TGLTimedEvents,        // component class
                         {$ENDIF}
                         'TheDate',             // property name
                         TGLDateEditor) ;       // property editor class

  RegisterPropertyEditor(TypeInfo(string),      // data type of property
                         {$IFDEF VER100}
                         TGLEvent,              // component class
                         {$ELSE}
                         TGLTimedEvents,        // component class
                         {$ENDIF}
                         'TheTime',             // property name
                         TGLTimeEditor) ;       // property editor class
end;

end.
