unit GLADDatabase ;
(*
    G.L.A.D. Registration Unit for GLAD-Database package
    Copyright  1998 Greg Lief
*)

interface

uses Classes,
     CloneRec,
     DsgnIntf,
     DBPropEd,
     DBRepeat,
     DmpQry,
     DupeChk,
     Flt_Dlg,
     glmtable,
     glprogrs,
     glqbe,
     glqbe2,
     HTMLTbl,
     IndxList,
     rec_repl,
     RecSrch,
     SLabel,
     SrchEdit,
     Tbl_Mgr,
     XLS ;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('GLAD: Database',
                                  [TGLCloneRecord,
                                   TGLDBProperEdit,
                                   TGLDBRepeatButton,
                                   TGLDumpQuery,
                                   TGLDupeCheck,
                                   TGLFilterDialog,
                                   TGLHTMLTable,
                                   TGLIndexList,
                                   TGLModifyTable,
                                   TGLProgress,
                                   TGLQBE,
                                   TGLQBE2,
                                   TGLRecordReplace,
                                   TGLRecordSearch,
                                   TGLSearchEdit,
                                   TGLStateLabel,
                                   TGLTableManager,
                                   TGLXLS] ) ;

  RegisterComponentEditor(TGLFilterDialog, TGLFilterDialogEditor) ;
  RegisterComponentEditor(TGLModifyTable, TGLModifyTableEditor) ;
  RegisterComponentEditor(TGLQBE, TGLQBEEditor) ;
  RegisterComponentEditor(TGLQBE2, TGLQBE2Editor) ;
  RegisterComponentEditor(TGLRecordReplace, TGLRecordReplaceEditor) ;

  RegisterPropertyEditor(TypeInfo(TMyFieldName), TGLSearchEdit, 'FieldName', TMyFieldNameEditor);
  RegisterPropertyEditor(TypeInfo(string),    // data type
                         TGLXLS,              // name of component class
                         'FileName',          // name of property
                         TFileNameProperty) ; // property editor class
  RegisterPropertyEditor(TypeInfo(string),    // data type
                         TGLXLS,              // name of component class
                         'Server',            // name of property
                         TServerProperty)   ; // property editor class
  RegisterComponentEditor(TGLXLS,             // component class
                          TGLXLSEditor)     ; // component editor class
  RegisterComponentEditor(TGLHTMLTable,           // component class
                          TGLHTMLTableEditor) ;   // component editor class

  RegisterPropertyEditor(TypeInfo(TGLBgColor),    // data type
                         TGLHTMLTable,            // name of component class
                         'BgColor',               // name of property
                         TGLHTMLColorProperty) ;  // property editor class

  RegisterPropertyEditor(TypeInfo(TGLBgColor),    // data type
                         TGLHTMLFontInfo,         // name of component class
                         'Color',                 // name of property
                         TGLHTMLColorProperty) ;  // property editor class

  RegisterPropertyEditor(TypeInfo(TGLBgColor),    // data type
                         TGLHTMLColumn,           // name of component class
                         'TitleBgColor',          // name of property
                         TGLHTMLColorProperty) ;  // property editor class

  RegisterPropertyEditor(TypeInfo(TGLBgColor),    // data type
                         TGLHTMLColumn,           // name of component class
                         'BgColor',               // name of property
                         TGLHTMLColorProperty) ;  // property editor class

  RegisterPropertyEditor(TypeInfo(string),        // data type
                         TGLHTMLTable,            // name of component class
                         'FileName',              // name of property
                         TGLFileNameProperty) ;   // property editor class

  RegisterPropertyEditor(TypeInfo(TGLAlignment),  // data type
                         TGLHTMLTable,            // name of component class
                         'Alignment',             // name of property
                         TGLAlignmentProperty) ;  // property editor class

  RegisterPropertyEditor(TypeInfo(TGLAlignment),  // data type
                         TGLHTMLColumn,           // name of component class
                         'Alignment',             // name of property
                         TGLAlignmentProperty) ;  // property editor class

  RegisterPropertyEditor(TypeInfo(string),        // data type
                         TGLHTMLColumn,           // name of component class
                         'FieldName',             // name of property
                         TGLFieldNameProperty) ;  // property editor class
end;

end.
