import java.applet.*;
import java.awt.*;
import java.net.*;
import java.io.*;
import java.util.*;

public class vmaxweareopenedii extends Applet implements Runnable
 {long delta;
  Date DLSTStart;
  Date StandardStart;
  String days[]={"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
  String[] months={"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
  String[] keywords={"First","Second","Third","Fourth","Last"}; 
  long tzoffset=0;
  long DLSTbias=0;
  Image dbi;
  Graphics dbg;
  Color bgcolor,textcolor,openedcolor,closedcolor,crosscolor,gridcolor;
  int w,h,fh;
  Font font;
  String dlstname,standardname;
  FontMetrics fm;
  long clientbias;
  String servertime;
  Date localdate1= new Date();
  Date localdate2= new Date();
  
  Thread thread;
  URL base;
  boolean inside=false;
  boolean lock;
  
  int shadow;
  boolean openeddays[]={true,true,true,true,true,true,true};
  boolean openedhours[] = new boolean[168];
    
  public void init()
   {w=size().width;
    h=size().height;
    Date serverdate = new Date(0);
    
    base = getDocumentBase();
    
    if(base.getProtocol().toLowerCase().startsWith("http"))
     {try{
        String host=base.getHost();
        int port=base.getPort();
        if(port==-1) port=80;
        Socket sock = new Socket(host,port);    
        DataInputStream dis =new DataInputStream(sock.getInputStream());
        PrintStream     os  =new PrintStream(sock.getOutputStream());
        os.println("HEAD "+base.getFile()+" HTTP/1.0\n\n");
        localdate1=new Date();
        String iLine,all="",s;
        while((iLine=dis.readLine())!=null) 
           {iLine=iLine.trim();
            println(iLine);
            if(iLine.equals("")) break;
            if(iLine.toLowerCase().startsWith("date:"))
               {s=iLine.substring(5).trim();
                serverdate  = new Date(s);
                localdate2  = new Date();
               }
           } 
        sock.close();
       }  
     catch(IOException ioe){println("Can't connect to server:" +base);}
     delta = serverdate.getTime()-(localdate1.getTime()+localdate2.getTime())/2;
    }
    else delta=0;
    
    // so later use localdate + delta to get server date 
    tzoffset=parsenum(getParameter("TIMEZONE"),10,0)*60000;    
    StandardStart=new Date(parseDate(getParameter("STANDARDSTART"),tzoffset));
    DLSTStart    =new Date(parseDate(getParameter("DLSTSTART"),tzoffset));
    DLSTbias     =parsenum(getParameter("DLSTBIAS"),10,0)*60000;    
    println("StandardStart:"+StandardStart.toGMTString());
    println("DLSTStart    :"+DLSTStart.toGMTString());
    
    bgcolor   = parsecolor("BGCOLOR",0xffffff);
    textcolor = parsecolor("TEXTCOLOR",0x000000);
    openedcolor  = parsecolor("OPENEDCOLOR",0x00c000);
    closedcolor  = parsecolor("CLOSEDCOLOR",0xffffff);
    crosscolor  = parsecolor("CROSSCOLOR",0x0000ff);
    gridcolor  = parsecolor("GRIDCOLOR",0xc0c0c0);
    
    dlstname=getParameter("DLSTNAME");
    if(dlstname==null) {dlstname="";}
    standardname=getParameter("STANDARDNAME");
    if(standardname==null) {standardname="";}    
    lock=unlock();  
    
    font=parsefont(getParameter("FONT"),new Font("dialog",1,10));
    fh = font.getSize()*5/4;
    setFont(font);
  
    String s;
    if((s=getParameter("OPENEDDAYS"))!=null)
      {for(int i=0;i<s.length()||i<7;i++)
        {if(s.charAt(i)!='+') openeddays[i]=false;}
      }
      
    for(int i=0;i<24;i++) openedhours[i]=false;
    s=getParameter("OPENEDHOURS");
    if(s!=null)
     {for(int j=0;j<7;j++)
       {for(int i=0;i<s.length()||i<24;i++)
         {if((s.charAt(i)=='+')&&(openeddays[j])) 
              {openedhours[j*24+i]=true;}
         }
       }
     }
     

     s=localdate1.toString();
     String syear=s.substring(s.lastIndexOf(" "));
     s=s.substring(0,s.lastIndexOf(" "));
     StringTokenizer st = new StringTokenizer(s ," ,\n\r");
     String s2="";
     for(int i=0;(i<4 && st.hasMoreTokens());i++) s2+=st.nextToken()+" ";
     s2=s2.trim()+" GMT "+syear;

     
     Date dummy = new Date(s2);
     clientbias =dummy.getTime()-localdate1.getTime();
     

     delta=delta-clientbias+tzoffset;
     if(isDLST(localdate1)) delta+=DLSTbias;
     delta=(long)(Math.round(delta));
     
     
   }
   
  public void paint(Graphics g)
   {update(g);} 
   
  public void update(Graphics g)
   {if(dbi==null) 
     {dbi=createImage(w,h);
      dbg=dbi.getGraphics();
      dbg.setFont(font);
      fm=dbg.getFontMetrics();
     }
    draw(dbg);
    g.drawImage(dbi,0,0,this);
   } 
    
   
  public void draw(Graphics g) 
   {Date now = new Date();
    now = new Date(now.getTime()+delta);
    int nowday  =now.getDay();
    int nowhour =now.getHours();
    int nowmin  =now.getMinutes();
    int nowyear =now.getYear()+1900;
    int nowmonth=now.getMonth()+1;
    int nowdate =now.getDate();
    int nowwday =now.getDay();
   
    g.setColor(bgcolor);
    g.fillRect(0,0,size().width,size().height);
    int x=fh/2,y=0,sw;
    
    String s;
    g.setColor(textcolor);
    FontMetrics fm = g.getFontMetrics();
    for(int i=0;i<25;i+=4)
      {s=""+i;
       sw=fm.stringWidth(s);
       g.drawString(s,fh/2+i*fh-sw/2,y+(fh-2)/2+fh/4);
      }
    y+=fh;  

    Color col;
    for(int j=0;j<7;j++)
     {x=fh/2;
      for(int i=0;i<24;i++) 
       {if(openedhours[(int)(j*24+i)]) col=openedcolor;
        else col=closedcolor;
        g.setColor(col);  
        g.fillRect(x,y,fh,fh);
        x+=fh;
       } 
      g.setColor(textcolor);
      g.drawString(days[j],x+fh/2,y+(fh)/2+fh/4);
      g.setColor(gridcolor);
      g.drawLine(fh/2,y,x,y);
      if(j==nowday) {g.setColor(crosscolor);
                     g.drawLine(fh/2,y+fh/2,x,y+fh/2);
                    }
      y+=fh; 
     } 
    g.setColor(gridcolor); 
    
    g.drawLine(fh/2,y,x,y); 
    x=fh/2;
    for(int i=0;i<25;i++) 
       {g.setColor(gridcolor); 
        g.drawLine(x,fh,x,fh*8);
        x+=fh;
       }
    g.setColor(crosscolor);
    g.drawLine(fh/2+fh*nowhour+(fh*nowmin+fh/2)/60,fh,fh/2+fh*nowhour+(fh*nowmin+fh/2)/60,fh*9);
    g.drawLine(fh/2+fh*nowhour+(fh*nowmin+fh/2)/60,fh*9,fh*13,fh*9);

           
    y+=fh/2;   

    servertime = to2digits(nowhour)+":"+to2digits(nowmin)+"  "+days[nowwday]+" "+months[nowmonth]+","+nowdate+" "+nowyear;
    if(getParameter("OURTIMETEXT")!=null);
    servertime = getParameter("OURTIMETEXT")+" "+servertime;
    
    sw=fm.stringWidth(servertime);
    
    g.drawRect((fh*26-sw)/2-2,y-1,sw+4,fh);
    g.setColor(bgcolor);
    g.fillRect((fh*26-sw)/2-1,y,sw+2,fh-2);
    
    g.setColor(textcolor);
    g.drawString(servertime,(fh*26-sw)/2,y+(fh)/2+fh/4);
    
    
    
    y+=fh*3/2;

    if(openedhours[nowday*24+nowhour])
        {s=getParameter("OPENEDTEXT");}
    else{s=getParameter("CLOSEDTEXT");}
    if(inside && !lock) s="Applet by Virtual_Max, click to get copy.";
    if(s==null)  s="";
    sw=fm.stringWidth(s);
    g.drawString(s,(fh*26-sw)/2,y+(fh)/2+fh/4);
   }
   
  public boolean mouseEnter(Event e, int x, int y)
   {inside=true;
    repaint();
    if(!lock) {getAppletContext().showStatus("Click to get copy of this applet");}
    return true;
   }
   
  public boolean mouseExit(Event e, int x, int y)   
   {inside=false;
    getAppletContext().showStatus("");
    repaint();
    return true;
   }
   
  public boolean mouseDown(Event e, int x, int y)
   {try{if(!lock) 
           {URL url=new URL("http://come.to/vmax"); 
            getAppletContext().showDocument(url,"_top");
           }
         }
    catch(MalformedURLException me){}    
    return true; 
   } 
  
  String to2digits(int v)
  {String s=""+v;
   while(s.length()<2) s="0"+s;
   return s;
  } 
  
  
  public void start()
  {if(thread==null) 
    {thread=new Thread(this);
     thread.start();
     }
  }
  public void stop()
  {thread.stop(); 
   thread=null;
  }
  
  public void run()
  {thread.setPriority(Thread.MIN_PRIORITY);
   while(thread==Thread.currentThread())
     {try{repaint();
          thread.sleep(1000);
         }
      catch (InterruptedException ie){break;}
     }
  }
   
  public boolean isDLST(Date d)
   {if(DLSTStart.before(StandardStart))
     {//northen hemisphere rules
      return( d.after(DLSTStart) && d.before(StandardStart));
     }
    else if(StandardStart.equals(DLSTStart))
     {//none DLST start == Standard Start
      return false;
     }    
    else 
     {//southern hemisphere 
      return (d.before(StandardStart) || d.after(DLSTStart));
     }
   }
 
  long parseDate(String s, long tzoffset)
   {if(s==null) s="";
    StringTokenizer st = new StringTokenizer(s," ,\n\r");
    String t;
    int mon=0;
    int wd=-1;
    boolean parsed;
    int mod=-1;
    int min=0;
    int hour=0;
    int date=1;
    int year=(new Date()).getYear();
    
    while(st.hasMoreTokens())
      {t=st.nextToken().trim().toLowerCase();
       parsed=false;
       for(int i=0;i<months.length && (!parsed);i++) 
         { if(t.startsWith(months[i].toLowerCase())){mon=i; parsed=true;}}
       for(int i=0;i<days.length && (!parsed);i++) 
         { if(t.startsWith(days[i].toLowerCase())){wd=i; parsed=true;}} 
       for(int i=0;i<keywords.length && (!parsed);i++) 
         { if(t.startsWith(keywords[i].toLowerCase())){mod=i; parsed=true;}}   
       int inx;  
       if(((inx=t.indexOf(":"))!=-1) &&(!parsed))
         {hour=parsenum(t.substring(0,inx),10,0);
          min =parsenum(t.substring(inx+1),10,0);
          parsed=true;
         }     
       if(!parsed) {date=parsenum(t,10,1); parsed=true;}
      }    
      
    long UTC = Date.UTC(year,mon,date,hour,min,1)+tzoffset;
    if(wd>=0)
    while((new Date(UTC)).getDay()!=wd) {UTC+=86400000l;}
    
    if(mod>0 && mod<keywords.length-1)
      {UTC+=86400000l*7*mod;}
       
    if(mod==keywords.length-1)    
      {while ( (new Date(UTC+86400000l*7)).getMonth()==(new Date(UTC)).getMonth() )
         {UTC+=86400000l*7;}
      }
      
    return UTC;    
   }
 
  public void println(String s)
   {if(getParameter("DEBUG")!=null) System.out.println(s);}
   
   
 
  //---------------
 int parsenum(String s, int radix, int def)
 {int ret=def;
  try{ret=Integer.parseInt(s,radix);}
  catch(NumberFormatException e) {return def;}
  catch(NullPointerException ne) {return def;}
  return ret;
 }
 
 
 Font parsefont(String s,Font defaultfont)
 {String name,t;
  int fh,fs;
  if(defaultfont==null) defaultfont=getFont();
  try{StringTokenizer st=new StringTokenizer(s,",; ");
      name=st.nextToken().trim();
      fs=parsenum(st.nextToken().trim(),10,0);
      fh=parsenum(st.nextToken().trim(),10,12);
     } 
  catch(NoSuchElementException e) {return defaultfont;}
  catch(NullPointerException ne)  {return defaultfont;}
  return new Font(name,fs,fh);
 }
 
 
 Color parsecolor(String p,int defaultcolor)
  {String s=getParameter(p);
   Color col=new Color(defaultcolor),col1;
   if(s==null) return col;
   try{col1=new Color(Integer.parseInt(s,16));}
   catch(NumberFormatException e){col1=col;}
   return col1;   
  } 

 //------------------------------------------------
 final boolean unlock()
  {String s=getParameter("AUTHOR");
   if(s==null)  return false;
   s=s.toLowerCase();
   if((s.indexOf("virtual_max")==-1)&& 
      (s.indexOf("kollegov")==-1))
                    return false;
   if(getDocumentBase().getProtocol().equalsIgnoreCase("file")) return true;
   s=getDocumentBase().getHost();
   if(getParameter("KEY")==null) return false;
   if(getParameter("KEY").trim().equalsIgnoreCase(encrypt(s,getClass().getName())))  
        {return true;}
   return false;  
  }
    
 final String encrypt(String s,String n) 
  {int i;
   n=n.toLowerCase().trim();
   s=s.toLowerCase().trim();
   s=s+n;
   int l=s.length();
   if(l<40) for(i=0;i<40-l;i++) s+=i%10;
   if(l>40) s=s.substring(0,40);
   
   byte chars[] = new byte[40];
   s.getBytes(0,40,chars,0);
   for(i=0;i<20;i++)
    {chars[i]+=chars[39-i];}
   s="";
   for(i=0;i<10;i++) 
    {chars[i]^=(byte)(((int)chars[10+i]<<8)+chars[19-i])>>(chars[i]&3);
     s+=Integer.toString((int)chars[i],9);
    }
   return s;   
  }

} 