/*
   Direct MCI Functions for WIN-PROLOG - Brian D Steel - 20 Aug 98 / 10 Feb 99
   ===========================================================================

   The mci/1 and mci/2 predicate are used to send command strings
   to the WINMM.DLL (Windows MultiMedia) API, and permits supported
   files to be played under Prolog control. For example:

      ?- mci( `play \windows\tada.wav` ).

   plays the Windows "TADA" sound file, TADA.WAV, while:

      ?- mci( `play d:\videos\pcmag.avi`, Result ).

   displays and runs the "PCMAG" video file, and returns the result.
*/

% perform the given MCI command and check the result

mci( Command ) :-
  catch( Error, mci(Command,(Return,_)) ),
  !,
  throw( Error, mci(Command) ),
  (  Return = 0
  -> true
  ;  Return = -1
  -> fail
  ;  Code is Return + 10000,
     throw( Code, mci(Command) )
  ).

% perform the given MCI command and return the result

mci( Command, Result ) :-
  fcreate( mci, [], -2, 256 ),
  catch( Error, winapi((winmm,mciSendStringA),[Command,mci,256,0],Return) ),
  !,
  wintxt( mci, 0, String ),
  fclose( mci ),
  throw( Error, mci(Command,Result) ),
  Result = (Return,String).
