/*
   Listbox Example - Alan Westwood & Brian D Steel - 12 Jan 99 / 10 Feb 99
   =======================================================================

   This example demonstrates the use of the windows messaging predicate
   sndmsg/5 to control a listbox. A list of strings is given to the
   program, and these are displayed in a listbox. When the user selects
   one, it is returned by the program.

   For example, type the command:

      ?- list_select( [`the`,`quick`,`brown`,`fox`], S ).

   A listbox will be displayed showing the four given words. Choose, for
   example, "brown", and then click on "OK", and the program will return:

      S = `brown`
*/

list_select( Items, Selected ) :-
   Dstyle = [ws_popup,ws_sysmenu,ws_caption,dlg_modalframe],
   Lstyle = [ws_child,ws_visible,ws_border,ws_tabstop,ws_vscroll,lbs_sort],
   Bstyle = [ws_child,ws_visible,ws_tabstop,bs_defpushbutton],
   wdcreate(  list,      `Listbox example`,  233, 41, 426, 150, Dstyle ),
   wccreate( (list,500), listbox, `List`,     10, 10, 310, 120, Lstyle ),
   wccreate( (list,1),   button,   `OK`,     330,  8,  80,  22, Bstyle ),
   wccreate( (list,2),   button,   `Cancel`, 330, 38,  80,  22, Bstyle ),
   fcreate( list, [], -2, 0 ),
   fill_list( (list,500), Items ),
   window_handler( list, list_handler ),
   call_dialog( list, Selected ),
   fclose( list ),
   Selected \= cancel .

% on a close message return "cancel"

list_handler( _, msg_close, _, cancel ).

% on an "OK" button return the selection

list_handler( (Window,1), msg_button, _, Result ) :-
   get_selected_item( (Window,500), Result ).

% on a cancel button return "cancel"

list_handler( (Window,2), msg_button, _, cancel ).

% fill the named list-box with the list of items, preselecting the first item

fill_list( Window, Items ) :-
   sndmsg( Window, lb_resetcontent, 0, 0, _ ),
   forall( member( Item, Items ),
           sndmsg( Window, lb_addstring, 0, Item, _ )
         ),
   sndmsg( Window, lb_setcursel, 0, 0, _ ).

% get the selected item

get_selected_item( Window, Item ) :-
   sndmsg( Window, lb_getcursel, 0, 0, R ),
   (  R = -1
   -> Item = ``
   ;  sndmsg( Window, lb_gettext, R, list, _ ),
      wintxt( list, 0, Item )
   ).
