/*
    Key interrogation example - Phil Vasey - 04 Apr 96
    --------------------------------------------------

    This example shows the use of the keys/1 predicate and the '/\' (and)
    bitwise operator available with is/2, to get the status of the system
    keys.
*/

/************************************************************************
** returns a list of all the status keys currently selected or held down
************************************************************************/

keys_down( KeyNames ) :-
  findall(
           KeyName,
           key_down( KeyName ),
           KeyNames
         ).

/************************************************************************
** returns a single key currently selected or held down
************************************************************************/

% the keys/1 predicate returns a 16-bit value that indicates the current
% keyboard status. This status is then checked against a mask for a single
% key to see if that key is selected, if it is the name of the key is
% returned, if not the predicate backtracks to get the next key mask

key_down( KeyName ) :-
  keys( Keys ),
  key_down( KeyName, Mask ),
  Mask is Keys /\ Mask .

/************************************************************************
** succeeds if either shift key is held down
************************************************************************/

% this predicate uses a specific mask of 3 that corresponds to both shift
% keys being selected. If the result is not zero when this mask is
% combined with the current key status using 'and' then at least one of
% the shift keys must be selected.

shift_key_down :-
  keys( Keys ),
  ShiftKeys is Keys /\ 3,
  ShiftKeys \= 0.

/************************************************************************
** a keyname and key value database
************************************************************************/

key_down( right_shift,  1 ).
key_down(  left_shift,  2 ).
key_down(        ctrl,  4 ).
key_down(         alt,  8 ).
key_down( scroll_lock, 16 ).
key_down(    num_lock, 32 ).
key_down(   caps_lock, 64 ).
