/*
   The Towers of Hanoi - Copyright (c) Brian D Steel - 11 Dec 98 / 10 Feb 99
   =========================================================================

   In this classic children's puzzle, a pile of discs is stored on the
   left three poles, with each disc being smaller than the one beneath it.
   The object of the game is to transfer the whole pile to the right hand
   pole, one disc at a time, with the help of the middle pole, but at no
   stage may a larger disc be placed on a smaller one.

   The idea is simple. Suppose you have a pile of discs on the LEFT pole,
   and want to transfer them legally to the RIGHT pole. If you can somehow
   transfer all but the very bottom disc to the MIDDLE pole, then all you
   you need to do is move the remaining disc from LEFT to RIGHT, and then
   somehow transfer the other discs from MIDDLE to RIGHT. The same is true
   of any pile of discs on any one pole that you want on another pole:
   transfer all but the last disc to a spare pole, move the last one
   directly to your chosen target, and then transfer everything from the
   spare pole to your target.

   This is a classic candidate for recursion: figure out how to do one step,
   as described above, and then trust a recursive call to handle the rest.

   For example, to transfer 3 discs from LEFT to RIGHT, via MIDDLE, type:

      ?- hanoi(3).
      Move disc from LEFT to RIGHT pole
      Move disc from LEFT to MIDDLE pole
      Move disc from RIGHT to MIDDLE pole
      Move disc from LEFT to RIGHT pole
      Move disc from MIDDLE to LEFT pole
      Move disc from MIDDLE to RIGHT pole
      Move disc from LEFT to RIGHT pole
      yes
*/

% solve the towers of hanoi puzzle for the given number of discs

hanoi( Number ) :-
   hanoi( Number, 'LEFT', 'RIGHT', 'MIDDLE' ).

% if there is just one disc, simply move it across

hanoi( 1, Source, Target, _ ) :-
   move( Source, Target ),
   !.

% otherwise solve for one less disc than we have, using the spare pole

hanoi( Number, Source, Target, Spare ) :-
   Less is Number - 1,
   hanoi( Less, Source, Spare, Target ),
   move( Source, Target ),
   hanoi( Less, Spare, Target, Source ).

% move a single disc from one pole to another

move( Source, Target ) :-
   write( 'Move disc from ' ),
   write( Source ),
   write( ' to ' ),
   write( Target ),
   write( ' pole' ),
   nl.
