/*
    A Simple Graphics Demo - Dave Westwood and Brian D Steel - 09 Apr 97
    ====================================================================
    The gfx_eg/0 predicate runs a demonstration graphics example which
    displays a dialog containing a "Grafix" window filled with a rectangle
    and an ellipse. The example shows how a paint messages are handled so as
    to refresh only the portion of the window that needs repainting.
*/

% create the dialog, set its handler and then show the dialog

gfx_eg :-
   create_gfx_eg,
   window_handler( gfx_eg, gfx_eg_handler ),
   show_dialog( gfx_eg ).

% create the grafix example dialog windows

create_gfx_eg :-
  wdcreate( gfx_eg,
                     `Graphics Example`,
                              240,  83, 146, 197, [ws_sysmenu,
						   ws_caption] ),
  wccreate( (gfx_eg,900),
             grafix, `Grafix`,
                               16,  16, 112,  96, [ws_child,
						   ws_border,
						   ws_visible] ),
  wccreate( (gfx_eg,1),
             button, `Ok`,
                               32, 128,  80,  32, [ws_child,
						   ws_visible,
						   ws_tabstop,
						   bs_pushbutton] ).

% handle the close message by returning the atom "close"

gfx_eg_handler( _, msg_close, _, close ).

% handle the "ok" button by returning the atom "ok"

gfx_eg_handler( (gfx_eg,1), msg_button, _, ok ).

% handle paint messages by starting, drawing some graphics, and ending

gfx_eg_handler( Win, msg_paint, grafix, _ ) :-
   gfx_paint( Win ),
   gfx( (  rectangle( 10, 10, 100, 80 ),
           (  brush = stock(gray_brush)
           -> ellipse( 10, 10, 100, 80 )
           )
        )
      ),
   gfx_end( Win ).
