/*
   Finding Easter Sunday - Copyright (c) Brian D Steel - 06 Apr 94 / 10 Feb 99
   ===========================================================================

   Given a year number in the Gregorian calendar, this uses the following
   (official) algorithm for computing the date of Easter in that year.

   Divide                          by      Quotient        Remainder
   ------                          --      --------        ---------
   the year X                      19      -               A
   the year X                      100     B               C
   B                               4       D               E
   B + 8                           25      F               -
   B - F + 1                       3       G               -
   19A + B - D - G + 15            30      -               H
   C                               4       I               J
   32 + 2E + 2I - H - J            7       -               K
   A + 11H + 22K                   451     L               -
   H + K - 7L + 114                31      M               N

   Then M = number of the month (3 = March, 4 = April),
   N + 1 = day of that month upon which Easter Sunday falls.

   For example, to find the month and day of Easter Sunday 2000, type:

      ?- easter( 2000, M, D ).
      M = 4
      D = 23
*/

% this predicate is a simple translation of the above algorithm

easter( Year, Month, Day ) :-
   A is Year mod 19,
   B is Year // 100,
   C is Year mod 100,
   D is B // 4,
   E is B mod 4,
   F is (B + 8) // 25,
   G is (B - F + 1) // 3,
   H is (19*A + B - D - G + 15 ) mod 30,
   I is C // 4,
   J is C mod 4,
   K is (32 + 2*E + 2*I - H - J) mod 7,
   L is (A + 11*H + 22*K) // 451,
   M is (H + K - 7*L + 114) // 31,
   N is (H + K - 7*L + 114) mod 31,
   Month is M,
   Day is N + 1.
