/*
   Combobox Example - Alan Westwood & Brian D Steel - 12 Jan 99 / 10 Feb 99
   ========================================================================

   This example demonstrates the use of the windows messaging predicate
   sndmsg/5 to control a combobox. A list of strings is given to the
   program, and these are displayed in a combobox. When the user selects
   one, it is returned by the program.

   For example, type the command:

      ?- combo_select( [`the`,`quick`,`brown`,`fox`], S ).

   A combobox will be displayed showing the four given words. Choose,
   for example, "brown", and then click on "OK", and the program will return:

      S = `brown`
*/

combo_select( Items, Selected ) :-
   Dstyle = [ws_popup,ws_sysmenu,ws_caption,dlg_modalframe],
   Cstyle = [ws_child,ws_visible,ws_tabstop,cbs_dropdown],
   Bstyle = [ws_child,ws_visible,ws_tabstop,bs_defpushbutton],
   wdcreate(  combo,      `Combobox example`, 233, 41, 426, 100, Dstyle ),
   wccreate( (combo,500), combobox, `Combo`,   10, 10, 310, 150, Cstyle ),
   wccreate( (combo,1),   button,   `OK`,     330,  8,  80,  22, Bstyle ),
   wccreate( (combo,2),   button,   `Cancel`, 330, 38,  80,  22, Bstyle ),
   fcreate( combo, [], -2, 0 ),
   fill_combo( (combo,500), Items ),
   window_handler( combo, combo_handler ),
   call_dialog( combo, Selected ),
   fclose( combo ),
   Selected \= cancel .

% on a close message return "cancel"

combo_handler( _, msg_close, _, cancel ).

% on an "OK" button return the selection

combo_handler( (Window,1), msg_button, _, Result ) :-
   get_selected_item( (Window,500), Result ).

% on a cancel button return "cancel"

combo_handler( (Window,2), msg_button, _, cancel ).

% fill the named combobox with the list of items, preselecting the first item

fill_combo( Window, Items ) :-
   sndmsg( Window, cb_resetcontent, 0, 0, _ ),
   forall( member( Item, Items ),
           sndmsg( Window, cb_addstring, 0, Item, _ )
         ),
   sndmsg( Window, cb_setcursel, 0, 0, _ ).

% get the selected item

get_selected_item( Window, Item ) :-
   sndmsg( Window, cb_getcursel, 0, 0, R ),
   (  R = -1
   -> Item = ``
   ;  sndmsg( Window, cb_getlbtext, R, combo, _ ),
      wintxt( combo, 0, Item )
   ).
