'**********************************************************************************
'* Constant declaractions
'**********************************************************************************

Const IsOutlookInstalled = False

Const olFolderContacts = 10

const NoCmd            = 0
const CmdEnableISP     = 1
const CmdDisableISP    = 2

const KeyUp            = "[A"
const KeyDown          = "[B"
const KeyRight         = "[C"
const KeyLeft          = "[D"

'**********************************************************************************
'* Global variables
'**********************************************************************************

Dim Cmd
Dim Conn 

'**********************************************************************************
'* OnAppLoad - Called when the router monitor is loaded into memory.
'**********************************************************************************

Sub OnAppLoad

    ' Used in Run_EnableISP, Run_DisableISP and OnTtyChange
    Cmd = NoCmd

    ' Creates a ADO Connection object
    Set Conn = CreateObject("ADODB.Connection")

    ' Opens a ODBC database with the data source name of LOG
    Conn.Open "ZyXEL Router Monitor Log"

End Sub

'**********************************************************************************
'* OnAppLoad - Called when the router monitor is unloaded from memory
'**********************************************************************************

Sub OnAppUnload

    Set Conn = nothing       ' delete the ADO Connection object

End Sub

'**********************************************************************************
'* OnConnect - Called when the router monitor detects a connection on a line
'**********************************************************************************

Sub OnConnect( Line )

    ' Insert the event into the database
    Conn.Execute MakeSql( Line, "Connect" )

End Sub

'**********************************************************************************
'* OnDisonnect - Called when the router monitor detects a lost connection on a line
'**********************************************************************************

Sub OnDisconnect( Line )

    ' Insert the event into the database
    Conn.Execute MakeSql( Line, "Disconnect" )

End Sub

'**********************************************************************************
'* OnCLIDChange - Called when the router monitor detects change in the CLID field
'**********************************************************************************

Sub OnCLIDChange( Line )

    ' If a Caller Id is received from the router, outlook contact information is
    ' searched. If there is a contact with the CLID in the home or business 
    ' telephone number, that contact is shown.

    If IsOutlookInstalled = True Then

        Dim CLID

        CLID = Application.Lines( Line ).CLID

        If CLID <> "" Then

            Dim ol
            Dim olns
            Dim objFolder
            Dim objAllContacts
            Dim Contact

            ' Set the Application object.
            Set ol = CreateObject( "Outlook.Application" )
  
            ' Set the Namespace object.
            Set olns = ol.GetNamespace("MAPI")

            ' Set the default Contacts folder.
            Set objFolder = olns.GetDefaultFolder(olFolderContacts)

            ' Set objAllContacts equal to the collection of all contacts.
            Set objAllContacts = objFolder.Items

            ' Loop through each contact to find the person calling.
            For Each Contact In objAllContacts

                ' Is this contact the right one?
                if RemoveBlanks( Contact.HomeTelephoneNumber ) = CLID Or _
                   RemoveBlanks( Contact.MobileTelephoneNumber ) = CLID Or _
                   RemoveBlanks( Contact.BusinessTelephoneNumber ) = CLID Then

                    ' Display the contact
                    Contact.Display

                End If
            Next  
        End If
    End If
End Sub


'**********************************************************************************
'* OnSysLog - Called when the router monitor receives a syslog message from the 
'* router.
'**********************************************************************************

Sub OnSysLog( strSysLog )

    ' Insert the syslog message into the database
    Conn.Execute "INSERT INTO SYSLOG ( DateAndTime, SysLog ) " & _
                 "VALUES ( #" & Now() & "#, '" & CStr( strSysLog ) & "' )"

End Sub

'**********************************************************************************
'* OnTick - Called every time the router monitor receives a status screen from the
'* router. The content of the status screen may or maynot have changed.
'**********************************************************************************

Sub OnTick
End Sub

'**********************************************************************************
'* OnTtyChange - Called when the router screens changes
'**********************************************************************************

Sub OnTtyChange( strScreen )

    ' Is there a EnableISP or DisableISP command running?
    If Cmd = CmdEnableISP Or Cmd = CmdDisableISP Then

        ' Have we recieved the menu 11.1 screen?
        If Instr( strScreen, "Menu 11.1 " ) > 0 And Application.Tty.Row = 5 Then

            Dim SearchFor

            If Cmd = CmdEnableISP Then

                SearchFor = "No "

            Else

                SearchFor = "Yes"

            End If
 
            ' Does the remode node need to be changed
            If Application.Tty.GetBuffer( 6, 14, 3 ) = SearchFor Then

                ' Yes, toggle it!
                Application.Tty.SendKeys( chr(27) & KeyDown & _
                                          " " & _
                                          chr(27) & KeyUp & _
                                          chr(27) & KeyUp & _
                                          chr(13) & chr(10) )

            End If

            ' Pass the control back to the router monitor
            Application.RouterMonitorEnabled = True

            Cmd = NoCmd

        End If
   End If

End Sub

'**********************************************************************************
'* Run_EnableISP - A user define function that will appear in the Run dialog
'**********************************************************************************

Sub Run_EnableISP

    ' Take control of the telnet session. The router monitor will go to the main
    ' menu.
    Application.RouterMonitorEnabled = False

    ' Set the Cmd variable used in OnTtyChange
        Cmd = CmdEnableISP

    ' Goto menu 11.1
    Application.Tty.SendKeys( "11" & chr(13) & chr(10) & "1" & chr(13) & chr(10) )

End Sub

'**********************************************************************************
'* Run_DisableISP - A user define function that will appear in the Run dialog
'**********************************************************************************

Sub Run_DisableISP

    ' Take control of the telnet session. The router monitor will go to the main
    ' menu.
    Application.RouterMonitorEnabled = False

    ' Set the Cmd variable used in OnTtyChange
    Cmd = CmdDisableISP

    ' Goto menu 11.1
    Application.Tty.SendKeys( "11" & chr(13) & chr(10) & "1" & chr(13) & chr(10) )

End Sub

'**********************************************************************************
'* MakeSql - A helper function to OnConnect and OnDisconnect - Generates a SQL 
'* statement.
'**********************************************************************************

Function MakeSql( Line, strEventName )

    ' Create a SQL statement

    Dim Sql

    Sql = "INSERT INTO LOG ( DateAndTime, Event, Line, Channel, Link, " & _
          "PacketsSent, PacketsReceived, UpTime, IPAddress, TotalOutcallTime, " & _
          "LastCallLanPacket ) VALUES ( "
    Sql = Sql + "'" & CStr(FormatDateTime(Now(),0)) & "', "
    Sql = Sql + "'" & CStr(strEventName) & "', "
    Sql = Sql + CStr(Line) & ", " 
    Sql = Sql + CStr(Application.Lines(Line).Channel) & ", "
    Sql = Sql + "'" & CStr(Application.Lines(Line).Link) & "', "
    Sql = Sql + CStr(Application.Lines(Line).PacketsSent) & ", "
    Sql = Sql + CStr(Application.Lines(Line).PacketsReceived) & ", "
    Sql = Sql + "'" & CStr(Application.Lines(Line).UpTime) & "', "
    Sql = Sql + "'" & CStr(Application.Lines(Line).IpAddress) & "', "
    Sql = Sql + "'" & CStr(Application.TotalOutcallTime) & "', "
    Sql = Sql + "'" & CStr(Application.LastCallLanPacket) & "' )"

    MakeSql = Sql

End Function

'**********************************************************************************
'* RemoveBlanks - A helper function used by OnConnect
'**********************************************************************************

Function RemoveBlanks( strText )

    ' Pass back a copy of strText but without blanks

    Dim Temp
    Dim Count
    Dim i

    Count = len( strText )

    For i = 1 to Count 

        If mid( strText, i, 1 ) <> " " Then

            Temp = Temp & mid( strText, i, 1 )

        End If

    Next

    RemoveBlanks = Temp

End Function
