{*******************************************************}
{                                                       }
{   Copyright (c) 1996-1997 Classic Software            }
{   All Rights Reserved                                 }
{                                                       }
{*******************************************************}

unit CSXCombo;

{$B-,P+,W-,X+}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, DBCtrls;

type
  { TCustomComboBox (the ancestor of TComboBox and TDBComboBox)
    does not remember the current item's index when its handle is
    destroyed.
    TcsComboBox and TcsDBComboBox will remember the current item's
    index when the control's handle is destroyed, such as when using
    SaveResources = True on a TcsNotebook and changing pages or when
    destroying handles of controls on TNotebook or TTabbedNotebook
    pages using other means.
  }
  TcsComboBox = class(TComboBox)
  private
    FSaveItemIndex: Integer;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
  protected
    procedure CreateWnd; override;
    procedure DestroyWnd; override;
  public
    constructor Create(AOwner: TComponent); override;
  end;

  TcsDBComboBox = class(TDBComboBox)
  private
    FSaveItemIndex: Integer;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
  protected
    procedure CreateWnd; override;
    procedure DestroyWnd; override;
  public
    constructor Create(AOwner: TComponent); override;
  end;

implementation

{$IFDEF EVALUATION} uses CSEval; {$ENDIF}

{ TcsComboBox }

constructor TcsComboBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FSaveItemIndex := -1;
end;

procedure TcsComboBox.CreateWnd;
begin
  inherited CreateWnd;
  ItemIndex := FSaveItemIndex;
end;

procedure TcsComboBox.DestroyWnd;
begin
  FSaveItemIndex := ItemIndex;
  inherited DestroyWnd;
end;

procedure TcsComboBox.CMExit(var Message: TCMExit);
begin
  ItemIndex := Items.IndexOf(Text);
  inherited;
end;

{ TcsDBComboBox }

constructor TcsDBComboBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FSaveItemIndex := -1;
end;

procedure TcsDBComboBox.CreateWnd;
begin
  inherited CreateWnd;
  ItemIndex := FSaveItemIndex;
end;

procedure TcsDBComboBox.DestroyWnd;
begin
  FSaveItemIndex := ItemIndex;
  inherited DestroyWnd;
end;

procedure TcsDBComboBox.CMExit(var Message: TCMExit);
begin
  ItemIndex := Items.IndexOf(Text);
  inherited;
end;

end.
