{*******************************************************}
{                                                       }
{   Copyright (c) 1997, 1999 Classic Software           }
{   All Rights Reserved                                 }
{                                                       }
{*******************************************************}

unit CSTC32TE;

{$B-,P+,W-,X+}

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls, Forms,
  StdCtrls, Buttons, ExtCtrls, CSFrmPnl, CSTCBase, CSTC32, DsgnIntf,
  CSTCSubF;

type
  TcsTCTabEditorDlg = class(TForm)
    BtnOK: TBitBtn;
    BtnCancel: TBitBtn;
    PanelSubForm: TcsFormPanel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure BtnOKClick(Sender: TObject);
  private
{$IFDEF VER130}
    FFormDesigner: IFormDesigner;
{$ELSE}
{$IFDEF VER120}
    FFormDesigner: IFormDesigner;
{$ELSE}
    FFormDesigner: TFormDesigner;
{$ENDIF}
{$ENDIF}
    FModified: Boolean;
    FSubForm: TcsTabEditorSubForm;
    FTabControl: TcsCustomTabControl;
    FTabDataList: TcsTabDataList;
    procedure Load; { Load from TabControl.Tabs }
    procedure Save; { Save to TabControl.Tabs }
  public
{$IFDEF VER130}
    property FormDesigner: IFormDesigner read FFormDesigner write FFormDesigner;
{$ELSE}
{$IFDEF VER120}
    property FormDesigner: IFormDesigner read FFormDesigner write FFormDesigner;
{$ELSE}
    property FormDesigner: TFormDesigner read FFormDesigner write FFormDesigner;
{$ENDIF}
{$ENDIF}
    property Modified: Boolean read FModified write FModified;
    property TabControl: TcsCustomTabControl read FTabControl write FTabControl;
  end;

implementation

{$R *.DFM}

procedure TcsTCTabEditorDlg.FormCreate(Sender: TObject);
begin
  FSubForm := TcsTabEditorSubForm.Create(Self); { automatically freed by self }
  FTabDataList := TcsTabDataList.Create;
end;

procedure TcsTCTabEditorDlg.FormDestroy(Sender: TObject);
begin
  FTabDataList.Free;
end;

procedure TcsTCTabEditorDlg.FormShow(Sender: TObject);
begin
  FSubForm.FormDesigner := FormDesigner;
  Load;
  FModified := False;
  PanelSubForm.Form := FSubForm;
end;

procedure TcsTCTabEditorDlg.Load;
var
  I: Integer;
  TabData: TcsTabData;
  TabCollectionItem: TcsTabCollectionItem;
begin
  if (TabControl <> nil) then
  begin
    { copy data from TabControl.Tabs into FTabDataList and then assign to
      the sub-form's TabDataList property
    }
    FTabDataList.Clear;
    for I := 0 to TabControl.Tabs.Count - 1 do
    begin
      TabCollectionItem := TabControl.Tabs[I];
      TabData := TcsTabData.Create;
      TabData.Caption := TabCollectionItem.Caption;
      TabData.Bitmap := TabCollectionItem.Bitmap;
      TabData.NumGlyphs := TabCollectionItem.NumGlyphs;
      TabData.Color := TabCollectionItem.Color;
      TabData.Enabled := TabCollectionItem.Enabled;
      TabData.Visible := TabCollectionItem.Visible;
      TabData.Hint := TabCollectionItem.Hint;
      FTabDataList.Add(TabData);
    end;
    FSubForm.TabDataList := FTabDataList;
  end;
end;

procedure TcsTCTabEditorDlg.Save;
var
  I: Integer;
  TabData: TcsTabData;
  TabCollectionItem: TcsTabCollectionItem;
begin
  if (TabControl <> nil) then
  begin
    { now copy from internal tabdata list to Tabs property of control }
    TabControl.Tabs.Clear;
    for I := 0 to FTabDataList.Count - 1 do
    begin
      TabData := FTabDataList[I];
      TabCollectionItem := TabControl.Tabs.Add;
      TabCollectionItem.Caption := TabData.Caption;
      TabCollectionItem.Bitmap := TabData.Bitmap;
      TabCollectionItem.NumGlyphs := TabData.NumGlyphs;
      TabCollectionItem.Color := TabData.Color;
      TabCollectionItem.Enabled := TabData.Enabled;
      TabCollectionItem.Visible := TabData.Visible;
      TabCollectionItem.Hint := TabData.Hint;
    end;
  end;
end;

procedure TcsTCTabEditorDlg.BtnCancelClick(Sender: TObject);
begin
  Modified := False;
end;

procedure TcsTCTabEditorDlg.BtnOKClick(Sender: TObject);
begin
  PanelSubForm.Form.Close;
  Save;
  Modified := True;
end;

end.
