{*******************************************************}
{                                                       }
{   Copyright (c) 1997 Classic Software                 }
{   All Rights Reserved                                 }
{                                                       }
{*******************************************************}

unit CSTC32Pr;

{$B-,P+,W-,X+}

interface

uses
  DsgnIntf, Classes;

type
  TcsTabCollectionProperty = class(TPropertyEditor)
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
    procedure Edit; override;
  end;

  TSkipDirection = (sdNext, sdPrevious);

  TcsTabControlEditor = class(TDefaultEditor)
  private
    procedure Skip(Direction: TSkipDirection);
    procedure EditTabs;
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

implementation

uses SysUtils, Forms, CSTC32, CSTC32TE;

{ TcsPagesProperty }

function TcsTabCollectionProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

function TcsTabCollectionProperty.GetValue: string;
begin
  FmtStr(Result, '(%s)', [GetPropType^.Name]);
end;

procedure TcsTabCollectionProperty.Edit;
begin
  with TcsTCTabEditorDlg.Create(Application) do
    try
      FormDesigner := Self.Designer;
      TabControl := (GetComponent(0) as TcsCustomTabControl);
      ShowModal;
      if Modified then Self.Designer.Modified;
    finally
      Free;
    end;
end;

{ TcsTabControlEditor }

type
  TVerbList = Array[0..2] of String;
const
  Verbs: TVerbList = ('Next Tab', 'Previous Tab', 'Edit Tabs...');

procedure TcsTabControlEditor.ExecuteVerb(Index: Integer);
begin
  case Index of
    0:  Skip(sdNext);
    1:  Skip(sdPrevious);
    2:  EditTabs;
  end;
end;

function TcsTabControlEditor.GetVerb(Index: Integer): string;
begin
  Result := Verbs[Index];
end;

function TcsTabControlEditor.GetVerbCount: Integer;
begin
  Result := High(Verbs) + 1;
end;

procedure TcsTabControlEditor.Skip(Direction: TSkipDirection);
var
  NewTabIndex, InitialTabIndex: Integer;
begin
  with TcsCustomTabControl(Component) do
  begin
    if Tabs.Count = 0 then Exit;

    if TabIndex >= 0 then
      NewTabIndex := TabIndex
    else
      if (Direction = sdNext) then
        NewTabIndex := Tabs.Count - 1 { next tab will be first tab }
      else
        NewTabIndex := 0; { previous tab will be last tab }
    InitialTabIndex := NewTabIndex;

    { skip to the next visible tab in the specified direction }
    repeat
      if (Direction = sdNext) then
        if (NewTabIndex = Tabs.Count - 1) then
          NewTabIndex := 0
        else
          Inc(NewTabIndex)
      else
        if (NewTabIndex = 0) then
          NewTabIndex := Tabs.Count - 1
        else
          Dec(NewTabIndex);
    until Tabs[NewTabIndex].Visible or (NewTabIndex = InitialTabIndex);

    if NewTabIndex <> TabIndex then
    begin
      TabIndex := NewTabIndex;
      Designer.Modified;
    end;

  end;
end;

procedure TcsTabControlEditor.EditTabs;
begin
  with TcsTCTabEditorDlg.Create(Application) do
  begin
    FormDesigner := Self.Designer;
    TabControl := TcsCustomTabControl(Component);
    ShowModal;
    if Modified then Self.Designer.Modified;
    Free;
  end;
end;

end.
