{*******************************************************}
{                                                       }
{   Copyright (c) 1997, 1999 Classic Software           }
{   All Rights Reserved                                 }
{                                                       }
{*******************************************************}

unit CSTC16TE;

{$B-,P+,W-,X+}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, ExtCtrls, CSFrmPnl, StdCtrls, Buttons, DsgnIntf, CSTCBase, CSTC16;

type
  TcsTC16TabEditorDlg = class(TForm)
    BtnOK: TBitBtn;
    BtnCancel: TBitBtn;
    PanelSubForm: TcsFormPanel;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure BtnOKClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
{$IFDEF VER130}
    FFormDesigner: IFormDesigner;
{$ELSE}
{$IFDEF VER120}
    FFormDesigner: IFormDesigner;
{$ELSE}
    FFormDesigner: TFormDesigner;
{$ENDIF}
{$ENDIF}
    FModified: Boolean;
    FTabControl: TcsCustomTabControl16;
    FTabDataList: TcsTabDataList;
    procedure Load; { Load from TabControl.Tabs }
    procedure Save; { Save to TabControl.Tabs }
    procedure SetTabControl(Value: TcsCustomTabControl16);
  public
    { Public declarations }
    { Forms already have a Designer property, so call it FormDesigner.
      Used to pass form designer to sub-form.
    }
{$IFDEF VER130}
    property FormDesigner: IFormDesigner read FFormDesigner write FFormDesigner;
{$ELSE}
{$IFDEF VER120}
    property FormDesigner: IFormDesigner read FFormDesigner write FFormDesigner;
{$ELSE}
    property FormDesigner: TFormDesigner read FFormDesigner write FFormDesigner;
{$ENDIF}
{$ENDIF}
    property Modified: Boolean read FModified write FModified;
    property TabControl: TcsCustomTabControl16 read FTabControl write SetTabControl;
  end;

implementation

uses CSTCSubF;

{ The subform variable cannot be a field in the form class because in Delphi 1
  a single instance of the subform needs to be created and reused so as to
  prevent the resource losses associated with dynamically creating the
  subform over and over (due to problems in the VCL Forms and Grids units).
}
var
  SubForm: TcsTabEditorSubForm;

{$R *.DFM}

procedure TcsTC16TabEditorDlg.FormCreate(Sender: TObject);
begin
{$IFDEF WIN32}
  SubForm := TcsTabEditorSubForm.Create(Self); { Self will free subform }
{$ELSE}
  if SubForm = nil then { single instance of subform not created yet }
    SubForm := TcsTabEditorSubForm.Create(nil);
{$ENDIF}
  FTabDataList := TcsTabDataList.Create;
end;

procedure TcsTC16TabEditorDlg.FormDestroy(Sender: TObject);
begin
{$IFNDEF WIN32}
  { For Delphi1, prevent subform from being freed by removing it from its
    parent's Controls list; because the subform's Parent is set to the
    FormPanel, it would normally be destroyed when the FormPanel is destroyed.
  }
  SubForm.Parent := nil;
{$ENDIF}
  FTabDataList.Free;
end;

{ SetTabControl is not really needed -- could just assign directly to field --
  but makes debug tracing easier.
}
procedure TcsTC16TabEditorDlg.SetTabControl(Value: TcsCustomTabControl16);
begin
  FTabControl := Value;
end;

procedure TcsTC16TabEditorDlg.FormShow(Sender: TObject);
begin
  SubForm.FormDesigner := FormDesigner;
  Load;
  FModified := False;
  PanelSubForm.Form := SubForm;
end;

procedure TcsTC16TabEditorDlg.Load;
var
  I: Integer;
  TabData: TcsTabData;
  TabComponent: TcsTabComponent;
begin
  if (TabControl <> nil) then
  begin
    { copy data from TabControl.Tabs into FTabDataList and then assign to
      the sub-form's TabDataList property
    }
    FTabDataList.Clear;
    for I := 0 to TabControl.Tabs.Count - 1 do
    begin
      TabComponent := TabControl.Tabs[I];
      TabData := TcsTabData.Create;
      TabData.Caption := TabComponent.Caption;
      TabData.Bitmap := TabComponent.Bitmap;
      TabData.NumGlyphs := TabComponent.NumGlyphs;
      TabData.Color := TabComponent.Color;
      TabData.Enabled := TabComponent.Enabled;
      TabData.Visible := TabComponent.Visible;
      TabData.Hint := TabComponent.Hint;
      FTabDataList.Add(TabData);
    end;
    SubForm.TabDataList := FTabDataList;
  end;
end;

procedure TcsTC16TabEditorDlg.Save;
var
  I: Integer;
  TabData: TcsTabData;
  TabComponent: TcsTabComponent;
begin
  if (TabControl <> nil) then
  begin
    { now copy from internal tabdata list to Tabs property of control }
    TabControl.Tabs.Clear;
    for I := 0 to FTabDataList.Count - 1 do
    begin
      TabData := FTabDataList[I];
      TabComponent := TcsTabComponent.Create(TabControl);
      TabComponent.Caption := TabData.Caption;
      TabComponent.Bitmap := TabData.Bitmap;
      TabComponent.NumGlyphs := TabData.NumGlyphs;
      TabComponent.Color := TabData.Color;
      TabComponent.Enabled := TabData.Enabled;
      TabComponent.Visible := TabData.Visible;
      TabComponent.Hint := TabData.Hint;
      TabControl.Tabs.Add(TabComponent);
    end;
  end;
end;

procedure TcsTC16TabEditorDlg.BtnCancelClick(Sender: TObject);
begin
  Modified := False;
end;

procedure TcsTC16TabEditorDlg.BtnOKClick(Sender: TObject);
begin
  PanelSubForm.Form.Close;
  Save;
  Modified := True;
end;

{$IFNDEF WIN32}
procedure DestroySubForm; far;
begin
  if SubForm <> nil then
    SubForm.Free;
end;

initialization
  SubForm := nil;
  AddExitProc(DestroySubForm);
{$ENDIF}

end.
