{*******************************************************}
{                                                       }
{   Copyright (c) 1997 Classic Software                 }
{   All Rights Reserved                                 }
{                                                       }
{*******************************************************}

unit CSTC16Pr;

{$B-,P+,W-,X+}

interface

uses
  DsgnIntf, Classes;

type
  TcsTabComponentListProperty = class(TPropertyEditor)
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
    procedure Edit; override;
  end;

  TSkipDirection = (sdNext, sdPrevious);

  TcsTabControl16Editor = class(TDefaultEditor)
  private
    procedure Skip(Direction: TSkipDirection);
    procedure EditTabs;
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

implementation

uses SysUtils, Forms, CSTC16, CSTC16TE;

{ TcsTabComponentListProperty }

function TcsTabComponentListProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

function TcsTabComponentListProperty.GetValue: string;
begin
  FmtStr(Result, '(%s)', [GetPropType^.Name]);
end;

procedure TcsTabComponentListProperty.Edit;
begin
  with TcsTC16TabEditorDlg.Create(Application) do
    try
      FormDesigner := Self.Designer;
      TabControl := (GetComponent(0) as TcsCustomTabControl16);
      ShowModal;
      if Modified then Self.Designer.Modified;
    finally
      Free;
    end;
end;

{ TcsTabControl16Editor }

type
  TVerbList = Array[0..2] of String;
const
  Verbs: TVerbList = ('Next Tab', 'Previous Tab', 'Edit Tabs...');

procedure TcsTabControl16Editor.ExecuteVerb(Index: Integer);
begin
  case Index of
    0:  Skip(sdNext);
    1:  Skip(sdPrevious);
    2:  EditTabs;
  end;
end;

function TcsTabControl16Editor.GetVerb(Index: Integer): string;
begin
  Result := Verbs[Index];
end;

function TcsTabControl16Editor.GetVerbCount: Integer;
begin
  Result := High(Verbs) + 1;
end;

procedure TcsTabControl16Editor.Skip(Direction: TSkipDirection);
var
  NewTabIndex, InitialTabIndex: Integer;
begin
  with TcsCustomTabControl16(Component) do
  begin
    if Tabs.Count = 0 then Exit;

    if TabIndex >= 0 then
      NewTabIndex := TabIndex
    else
      if (Direction = sdNext) then
        NewTabIndex := Tabs.Count - 1 { next tab will be first tab }
      else
        NewTabIndex := 0; { previous tab will be last tab }
    InitialTabIndex := NewTabIndex;

    { skip to the next visible tab in the specified direction }
    repeat
      if (Direction = sdNext) then
        if (NewTabIndex = Tabs.Count - 1) then
          NewTabIndex := 0
        else
          Inc(NewTabIndex)
      else
        if (NewTabIndex = 0) then
          NewTabIndex := Tabs.Count - 1
        else
          Dec(NewTabIndex);
    until Tabs[NewTabIndex].Visible or (NewTabIndex = InitialTabIndex);

    if NewTabIndex <> TabIndex then
    begin
      TabIndex := NewTabIndex;
      Designer.Modified;
    end;

  end;
end;

procedure TcsTabControl16Editor.EditTabs;
begin
  with TcsTC16TabEditorDlg.Create(Application) do
  begin
    FormDesigner := Self.Designer;
    TabControl := TcsCustomTabControl16(Component);
    ShowModal;
    if Modified then Self.Designer.Modified;
    Free;
  end;
end;

end.
