{*******************************************************}
{                                                       }
{   Copyright (c) 1995-1996 Classic Software            }
{   All rights reserved                                 }
{                                                       }
{*******************************************************}

unit CSNBEdit;

{$B-,P+,W-,X+}

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, Grids, CSNoteBk;

type
  TcsNBEditDlg = class(TForm)
    OKBtn: TBitBtn;
    HelpBtn: TBitBtn;
    Bevel1: TBevel;
    AddBtn: TButton;
    EditBtn: TButton;
    DeleteBtn: TButton;
    ColumnHeadings: THeader;
    TabGrid: TDrawGrid;
    UpBtn: TBitBtn;
    DownBtn: TBitBtn;
    Bevel2: TBevel;
    Preview: TImage;
    procedure TabGridDrawCell(Sender: TObject; Col, Row: Longint;
      Rect: TRect; State: TGridDrawState);
    procedure EditBtnClick(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure DeleteBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ColumnHeadingsSized(Sender: TObject; ASection,
      AWidth: Integer);
    procedure TabGridSelectCell(Sender: TObject; Col, Row: Longint;
      var CanSelect: Boolean);
    procedure TabGridDblClick(Sender: TObject);
    procedure MoveClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    FNotebook: TcsNotebook;
    FOldHelpFile: String;
    procedure SetNotebook(Value: TcsNotebook);
    function GetPages: TStrings;
  protected
    property Pages: TStrings read GetPages; { shorthand for Notebook.Pages }
  public
    Modified: Boolean;
    property Notebook: TcsNotebook read FNotebook write SetNotebook;
  end;

implementation

{$R *.DFM}

uses SysUtils, Dialogs, CSNBInfo;

const
  hcNotebookTabsEditor = 1;
  hcEditTabDlgBox = 2;
  hcAddTabDlgBox = 3;

procedure TcsNBEditDlg.SetNotebook(Value: TcsNotebook);
begin
  FNotebook := Value;
  with TabGrid do
  begin
    RowCount := Pages.Count;
    Row := 0;
    Col := 0;
    if (RowCount > 0) then
      Preview.Picture.Bitmap := FNotebook.TabBitmap[0];
  end;
end;

function TcsNBEditDlg.GetPages: TStrings;
begin
  Result := FNotebook.Pages;
end;

procedure TcsNBEditDlg.TabGridDrawCell(Sender: TObject; Col, Row: Longint;
  Rect: TRect; State: TGridDrawState);
var DC: HDC;
    PText: array[0..255] of Char;
    W: TWinControl;
    BoolStr: String;
begin
  { draw cell for this row/col }
  if (Row < Pages.Count) then
  begin
    DC := TabGrid.Canvas.Handle;
    { Clip text to specified region }
    Rect.Right := Rect.Left + ColumnHeadings.SectionWidth[0];

    { Caption }
    ExtTextOut(DC, Rect.Left + 2, Rect.Top + 2, ETO_CLIPPED,
      @Rect, StrPCopy(PText, Pages[Row]), Length(Pages[Row]), nil);

    { Help Context }
    Rect.Left := Rect.Right + 1;
    Rect.Right := Rect.Left + ColumnHeadings.SectionWidth[1];
    W := Pages.Objects[Row] as TWinControl;
    ExtTextOut(DC, Rect.Left + 2, Rect.Top + 2, ETO_CLIPPED,
      @Rect, StrPCopy(PText, IntToStr(W.HelpContext)),
      Length(IntToStr(W.HelpContext)), nil);

    { PageEnabled? }
    Rect.Left := Rect.Right + 1;
    Rect.Right := Rect.Left + ColumnHeadings.SectionWidth[2];
    if TcsPage(Pages.Objects[Row]).PageEnabled then
      BoolStr := 'Yes'
    else
      BoolStr := 'No';
    ExtTextOut(DC, Rect.Left + 2, Rect.Top + 2, ETO_CLIPPED,
      @Rect, StrPCopy(PText, BoolStr), Length(BoolStr), nil);

    { PageVisible? }
    Rect.Left := Rect.Right + 1;
    Rect.Right := Rect.Left + ColumnHeadings.SectionWidth[3];
    if TcsPage(Pages.Objects[Row]).PageVisible then
      BoolStr := 'Yes'
    else
      BoolStr := 'No';
    ExtTextOut(DC, Rect.Left + 2, Rect.Top + 2, ETO_CLIPPED,
      @Rect, StrPCopy(PText, BoolStr), Length(BoolStr), nil);
  end;
end;

procedure TcsNBEditDlg.EditBtnClick(Sender: TObject);
var Dlg: TcsNBInfoDlg;
    W: TWinControl;
begin
  { edit the current entry }
  Dlg := TcsNBInfoDlg.Create(Application);
  Dlg.HelpContext := hcEditTabDlgBox;
  try
    W := Pages.Objects[TabGrid.Row] as TWinControl;
    Dlg.CaptionEdit.Text := Pages[TabGrid.Row];
    Dlg.HelpContextEdit.Text := IntToStr(W.HelpContext);
    Dlg.EnabledCheck.Checked := TcsPage(Pages.Objects[TabGrid.Row]).PageEnabled;
    Dlg.VisibleCheck.Checked := TcsPage(Pages.Objects[TabGrid.Row]).PageVisible;
    Dlg.ShowModal;
    if (Dlg.ModalResult = mrOK) then
    begin
      Pages[TabGrid.Row] := Dlg.CaptionEdit.Text;
      W.HelpContext := StrToInt(Dlg.HelpContextEdit.Text);
      TcsPage(Pages.Objects[TabGrid.Row]).PageEnabled := Dlg.EnabledCheck.Checked;
      TcsPage(Pages.Objects[TabGrid.Row]).PageVisible := Dlg.VisibleCheck.Checked;
      TabGrid.Invalidate;
      Modified := True;
    end;
  finally
    Dlg.Free;
  end;
  TabGrid.SetFocus;
end;

procedure TcsNBEditDlg.AddBtnClick(Sender: TObject);
var
  Dlg: TcsNBInfoDlg;
  W: TWinControl;
begin
  { add a new entry }
  Dlg := TcsNBInfoDlg.Create(Application);
  Dlg.HelpContext := hcAddTabDlgBox;
  try
    Dlg.Caption := 'Add Tab';
    Dlg.CaptionEdit.Text := '';
    Dlg.HelpContextEdit.Text := IntToStr(0);
    Dlg.EnabledCheck.Checked := True;
    Dlg.VisibleCheck.Checked := True;
    Dlg.ShowModal;
    if (Dlg.ModalResult = mrOK) then
    begin
      Pages.Add(Dlg.CaptionEdit.Text);
      W := Pages.Objects[Pages.Count - 1] as TWinControl;
      W.HelpContext := StrToInt(Dlg.HelpContextEdit.Text);
      Preview.Picture.Bitmap := nil;
      TcsPage(Pages.Objects[Pages.Count - 1]).PageEnabled := Dlg.EnabledCheck.Checked;
      TcsPage(Pages.Objects[Pages.Count - 1]).PageVisible := Dlg.VisibleCheck.Checked;
      TabGrid.RowCount := Pages.Count;
      TabGrid.Row := TabGrid.RowCount - 1; { make new row the current row }
      TabGrid.DefaultColWidth := TabGrid.ClientWidth; { in case scrollbar appears }
      TabGrid.Invalidate;
      Modified := True;
    end;
  finally
    Dlg.Free;
  end;
  TabGrid.SetFocus;
end;

procedure TcsNBEditDlg.DeleteBtnClick(Sender: TObject);
var Text: String;
begin
  { delete the current entry }
  if (TabGrid.RowCount = 1) then
  begin
    MessageDlg('You cannot delete this Tab. Notebooks must have at least one Tab.', mtInformation, [mbOK], 0);
    TabGrid.SetFocus;
    Exit;
  end;

  Text := 'Delete Tab for ''' + Pages[TabGrid.Row] + '''?';
  if (MessageDlg(Text, mtConfirmation, [mbYes, mbNo], 0) = mrYes) then
  begin
    Pages.Delete(TabGrid.Row);
    TabGrid.RowCount := Pages.Count;
    TabGrid.DefaultColWidth := TabGrid.ClientWidth; { in case scrollbar disappears }
    TabGrid.Invalidate;
    Preview.Picture.Bitmap := TcsPage(Pages.Objects[TabGrid.Row]).Bitmap;
    Modified := True;
  end;
  TabGrid.SetFocus;
end;

procedure TcsNBEditDlg.FormCreate(Sender: TObject);
begin
  FOldHelpFile := Application.HelpFile;  { must restore when done }
  Application.HelpFile := 'CSCCS.HLP';
  HelpContext := hcNotebookTabsEditor;
  with TabGrid do
  begin
    Col := 0;
    Row := 0;
    DefaultRowHeight := Canvas.TextHeight('W') {$IFDEF WIN32} + 4 {$ENDIF};
    DefaultColWidth := ClientWidth;
  end;
  UpBtn.Glyph := TBitmap.Create;
  UpBtn.Glyph.Handle := LoadBitmap(HInstance, 'UPGLYPH');
  DownBtn.Glyph := TBitmap.Create;
  DownBtn.Glyph.Handle := LoadBitmap(HInstance, 'DOWNGLYPH');
end;

procedure TcsNBEditDlg.ColumnHeadingsSized(Sender: TObject; ASection,
  AWidth: Integer);
begin
  TabGrid.Repaint;
end;

procedure TcsNBEditDlg.TabGridSelectCell(Sender: TObject; Col,
  Row: Longint; var CanSelect: Boolean);
begin
  Preview.Picture.Bitmap := TcsPage(Pages.Objects[Row]).Bitmap;
end;

procedure TcsNBEditDlg.TabGridDblClick(Sender: TObject);
begin
  EditBtnClick(Self);
end;

procedure TcsNBEditDlg.MoveClick(Sender: TObject);
var NewIndex: Integer;
begin
  NewIndex := TabGrid.Row;
  if (Sender = UpBtn) then Dec(NewIndex)
  else Inc(NewIndex);
  if (NewIndex >= 0) and (NewIndex < Pages.Count) then
  begin
    Pages.Exchange(TabGrid.Row, NewIndex);
    TabGrid.Row := NewIndex;
    TabGrid.Invalidate;
  end;
  TabGrid.SetFocus;
  Modified := True;
end;

procedure TcsNBEditDlg.FormDestroy(Sender: TObject);
begin
  Application.HelpFile := FOldHelpFile;
end;

end.
