{*******************************************************}
{                                                       }
{   Copyright (c) 1997 Classic Software                 }
{   All Rights Reserved                                 }
{                                                       }
{*******************************************************}

unit CSGfx;

{$B-,P+,W-,X+}

interface

uses
  WinTypes, WinProcs, Graphics;

function EmptyRect(ARect: TRect): Boolean;
procedure OrderRectCorners(var ARect: TRect);
function PointInRect(const ARect: TRect; const APoint: TPoint): Boolean;
function CreateMonoMask(ColorBmp: TBitmap; TransparentColor: TColor): TBitmap;

implementation

uses Classes, CSMaxMin;

function EmptyRect(ARect: TRect): Boolean;
begin
  Result := (ARect.Left = 0) and (ARect.Right = 0) and
            (ARect.Top = 0) and (ARect.Bottom = 0);
end;

procedure OrderRectCorners(var ARect: TRect);
var
  R: TRect;
begin
  { re-order the corner points so the origin is at top-left and
    the corner is at the bottom-right
  }
  R.Left := MinInt(ARect.Left, ARect.Right);
  R.Right := MaxInt(ARect.Left, ARect.Right);
  R.Top := MinInt(ARect.Top, ARect.Bottom);
  R.Bottom := MaxInt(ARect.Top, ARect.Bottom);
  ARect := R;
end;

function PointInRect(const ARect: TRect; const APoint: TPoint): Boolean;
var
  R: TRect;
begin
  R := ARect;
  { corners should already have been ordered but check anyway }
  OrderRectCorners(R); { necessary for PtInRect to work! }
  Result := PtInRect(R, APoint);
end;

{ Create a monochrome bitmap mask for use when overlaying images or
  when performing hit-testing.
}
function CreateMonoMask(ColorBmp: TBitmap; TransparentColor: TColor): TBitmap;
var
  R: TRect;
  OldBkColor: TColorRef;
begin
  Result := TBitmap.Create;
  try
    Result.Monochrome := True;
    Result.Width := ColorBmp.Width;
    Result.Height := ColorBmp.Height;
    { Set background color for source bitmap -- this will be used
      when copying to convert from a color bitmap to a mono bitmap
    }
    OldBkColor := SetBkColor(ColorBmp.Canvas.Handle, ColorToRGB(TransparentColor));
    R := Rect(0, 0, ColorBmp.Width, ColorBmp.Height);
    { Now copy to monochrome bitmap; all pixels in source bitmap that
      were the transparent color will be white in the destination bitmap,
      all other pixels will be black
    }
    Result.Canvas.CopyMode := cmSrcCopy;
    Result.Canvas.CopyRect(R, ColorBmp.Canvas, R);
    SetBkColor(ColorBmp.Canvas.Handle, OldBkColor);
  except
    Result.Free;
    Raise;
  end;
end;

end.
