#!/usr/bin/perl

#
### CONTROL PANEL SCRIPT FOR ULTIMATE BULLETIN BOARD ##
#
# Ultimate Bulletin Board is copyright Infopop Corporation (formerly Madrona Park, Inc.), 1997, 1998.
#
#       ------------ cpanel3.cgi -------------
#
#  This file contains some of the control panel functionality for
#  the UBB.  It is called from the controlpanel pages (cp.html).
#
#  NOTE: you MAY NOT redistribute this script under any
#  circumstance.  This means that you may not sell, trade, or in
#  any other way give this script to another user who is not
#  licensed to use it.  Infopop Corporation (formerly Madrona Park, Inc.) offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

print ("Content-type: text/html\n\n");
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file
require "cookie-lib.pl";
require "mods.file";
require "UltBB.setup";
require "ubb_library.pl";
require "ubb_library2.pl";
require "Date.pl";
};

if ($@) {
    print "Error including required files: $@\n";
    print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
 exit;
}


&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	if ($Name eq "ViewEntire") {
			$ViewEntire = $Value;
		}
	if ($Name eq "NN") {
			$SearchName = $Value;
			$SearchName =~tr/A-Z/a-z/; 
			}
	if ($Name eq "BBEmail") {
			$BBEmail = $Value;
			$BBEmail =~ s/@/\\@/;
			}
			
	if ($Name eq "Forum1") {
			$Forum1 = $Value;
			$Forum1 =~ s/"/&quot;/g;
		}
	
	if ($Name eq "BBRules") {
			$BBRules = $Value;
			$BBRules =~ s/"/&quot;/g;
			$BBRules =~ s/\@/\\@/g;
			$BBRules = &ConvertReturns($BBRules);
			}
		if ($Name eq "censorwords") {
			$censorwords = $Value;
			$censorwords = &EliminateReturns($censorwords);
			$censorwords =~ s/<BR>//ig;
			$censorwords =~ s/<P>//ig;
			$censorwords =~ s/"/&quot;/g;
			$censorwords =~ s/\@/\\@/g;
			}
		if ($Name eq "YourCopyrightNotice") {
			$YourCopyrightNotice = $Value;
			$YourCopyrightNotice = &EliminateReturns($YourCopyrightNotice);
			$YourCopyrightNotice =~ s/"/&quot;/g;
			$YourCopyrightNotice =~ s/<BR>//ig;
			$YourCopyrightNotice =~ s/<P>//ig;
			$YourCopyrightNotice =~ s/\@/\\@/g;
			}
		if ($Name eq "Header") {
			$Header = $Value;
			$Header =~ s/"/\\"/g;
			$Header =~ s/\@/\\@/g;
			}
		if ($Name eq "Footer") {
			$Footer = $Value;
			$Footer =~ s/"/\\"/g;
			$Footer =~ s/\@/\\@/g;
			}
	if ($Name eq "ForumStatus1") {
			$ForumStatus1 = $Value;
			}
	
	
	if ($Name eq "MyHomePage") {
			$MyHomePage = $Value;
			}
	
	if ($Name eq "HomePageURL") {
			$HomePageURL = $Value;
			}
	
	if ($Name eq "number") {
			$number = $Value;
			}

	if ($Name eq "UpdateType") {
			$UpdateType = $Value;
			}		
	if ($Name eq "TotalForums") {
			$TotalForums = $Value;
			}
	if ($Name eq "BBName") {
			$BBName = $Value;
			}
	if ($Name eq "ForumsPath") {
			$ForumsPath = $Value;
			}
			if ($Name eq "MembersPath") {
			$MembersPath = $Value;
			}
			if ($Name eq "CGIPath") {
			$CGIPath = $Value;
			}
				if ($Name eq "VariablesPath") {
			$VariablesPath = $Value;
			}
	if ($Name eq "MembersCGIPath") {
			$MembersCGIPath = $Value;
			}
			if ($Name eq "NonCGIPath") {
			$NonCGIPath = $Value;
			}
			if ($Name eq "CGIURL") {
			$CGIURL = $Value;
			}
			if ($Name eq "NonCGIURL") {
			$NonCGIURL = $Value;
			}
		
		if ($Name eq "UserNameCheck") {
			$UserNameCheck = $Value;
			$UserNameCheckFile = $UserNameCheck;
			$UserNameCheckFile =~ s/ /_/g; #remove spaces
			}

		if ($Name eq "UserName") {
			$UserName = $Value;
			$UserName = &UNHTMLIFY($UserName);
			$UserNameFile = $UserName;
			$UserNameFile =~ s/ /_/g; #remove spaces
		}
			if ($Name eq "Password") {
			$Password = $Value;
			$Password = &UNHTMLIFY($Password);
			}
			if ($Name eq "PasswordCheck") {
			$PasswordCheck = $Value;
			}
				if ($Name eq "action") {
			$action = $Value;
			}
			
} #end foreach loop

if ($VariablesPath eq "") {
	$VariablesPath = "$CGIPath";
}

if ($action eq "forums") {
&Forums;
}
if ($action eq "setforums") {
&SetForums;
}
if ($action eq "sendforum") {
&SendForum;
}
if ($action eq "addnewforum") {
&AddNewForum;
}
if ($action eq "cats") {
&Cats;
}
if ($action eq "ContinueLastTimes") {
&SetLastTimesCycle;
}
if ($action eq "ContinueThreadNums") {
&SetLastThreadNumsCycle;
}
if ($action eq "setcats") {
&SetCats;
}
if ($action eq "viewbanlist") {
&ViewBanList;
}
if ($action eq "submitbans") {
&SubmitBans;
}
if ($action eq "getforum") {
&GetForum;
}

sub GetForum {
&AssembleCats;

if (-e "$ForumsPath/Forum$in{'number'}/forumstyles.file") {
require "$ForumsPath/Forum$in{'number'}/forumstyles.file";
}  else {
require "$VariablesPath/Styles.file";
$ForumHeader = "";
$ForumFooter = "";
}

&get_cookie;  #retrieves all current cookies
if ($cookie{UserNameCP}) {
$CheckUserName = "$cookie{UserNameCP}";
$CheckPassword = "$cookie{PasswordCP}";
}
elsif ($in{'UserName'}) {
$CheckUserName = $in{'UserName'};
$CheckPassword = $in{'Password'};
}  else {
$PageTitle = "F O R U M &nbsp;&nbsp;&nbsp;&nbsp; S E T T I N G S";
$PageIntro = "In order to view this forum's settings, you must first identify yourself.  You will not have to do this each time if you allow cookies to be set from your browser.";
$HiddenFields = qq(<INPUT TYPE="HIDDEN" NAME="action" VALUE="getforum"><INPUT TYPE="HIDDEN" NAME="number" VALUE="$in{'number'}">
 );
&QueryForID;
exit;
}

#confirm permission to read forum data
&VerifyAdmin($CheckUserName, $CheckPassword);
if ($Proceed eq "true") {
$UserName = $CheckUserName;
$Password = $CheckPassword;

my @forums = &OpenForumsFile;
my @CATEGORIES = &OpenFile("$NonCGIPath/categories.file");

#print Forum File
$PageTitle = "F O R U M &nbsp;&nbsp;&nbsp;&nbsp; S E T T I N G S";
&HEADER2HTML;

print<<ForumHTML;
<FONT SIZE="1" FACE="Verdana, Arial">You can assign/change the settings for this forum below.</FONT> 
<FONT SIZE="2" FACE="Verdana, Arial">
<P>
<B>Go To: </B><A HREF="cpanel3.cgi?action=forums&StartPoint=0&inside=true">Forum Summary</A> | <A HREF="cpanel3.cgi?action=cats">Add/Review/Order Categories</A>
<P>
<table border=0 width=95%><TR><TD>
<B><FONT SIZE="2" FACE="Verdana, Arial">Update Forum Below</FONT></B></td><TD align=center><FONT SIZE="1" FACE="Verdana, Arial">[<A HREF="$NonCGIURL/forumterms.html" target=_new>forum variable terms</A>]</FONT></td></TR></table>

<P>
<TABLE BORDER=0 cellspacing=0 cellpadding=0 width=95%><TR><td bgcolor="#000000">

<FORM ACTION="cpanel3.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
ForumHTML

$ForumNumber = $in{'number'};
$ArrayLine = $ForumNumber - 1;
$ThisForum = $forums[$ArrayLine];

		@thisforum = split(/\|/, $ThisForum);
		
		chomp($thisforum[10]);
		chomp($thisforum[11]);
		chomp($thisforum[12]);
		chomp($thisforum[13]);
		chomp($thisforum[14]);

unless (-e "$ForumsPath/Forum$in{'number'}/forumstyles.file") {
if ($thisforum[9] ne "") {
$BBTitle = $thisforum[9];
}
}  

my $CategoryDropDown = qq(<SELECT NAME="Category">);
if ($thisforum[0] eq "") {
	$ThisSelection = "SELECTED";
}  else {
	$ThisSelection = "";
}

$CategoryDropDown .= qq(<OPTION VALUE="" $ThisSelection>No Category);
$Count = 0;
foreach $cat(@CATEGORIES) {
$Count++;
($Junk, $CatName, $CatNumber) = split(/\|\|\|/, $cat);
chomp($CatNumber);
if ($CatNumber == $thisforum[0]) {
	$Selection = "SELECTED";
} else {
	$Selection = "";
}
$CategoryDropDown .= qq(<OPTION VALUE="$CatNumber" $Selection>$CatName);
}


if ($Count == 0) {
$CategoryDropDown .= qq(<OPTION value="">No Categories Created Yet);
}
$CategoryDropDown .= "</SELECT>";
		
		if ($thisforum[3] eq "On") {
			$ForumActive = "CHECKED";
		}  else {
			$ForumInactive = "CHECKED";
		}
		if ($thisforum[13] eq "no") {
			$PrivateMaxNo = "CHECKED";
		}  else {
			$PrivateMaxYes = "CHECKED";
		}
		if ($thisforum[4] eq "is") {
			$HTMLOn = "CHECKED";
		}  else {
			$HTMLOff = "CHECKED";
		}
		if ($thisforum[5] eq "is") {
			$UBBOn = "CHECKED";
		}  else {
			$UBBOff = "CHECKED";
			}
if ($thisforum[10] eq "OFF") {
			$UBBImagesOff = "CHECKED";
		}  else {
			$UBBImagesOn = "CHECKED";
		}

if ($thisforum[11] eq "yes") {
			$ModNotifyOn = "CHECKED";
		}  else {
			$ModNotifyOff = "CHECKED";
		}
		
if ($thisforum[6] eq "yes") {
	$TRrestrictOn = "SELECTED";
	$RRrestrictOn = "SELECTED";
}
if ($thisforum[6] eq "private") {
	$PrivateOn = "CHECKED";
	$TRrestrictOn = "SELECTED";
	$RRrestrictOn = "SELECTED";
}
if ($thisforum[6] eq "partly") {
	$TRrestrictOn = "SELECTED";
	$RRallregOn = "SELECTED";
}
if ($thisforum[6] eq "includenonreg") {
	$TRallOn = "SELECTED";
	$RRallOn = "SELECTED";
}
if ($thisforum[6] eq "no") {
	$TRallregOn = "SELECTED";
	$RRallregOn = "SELECTED";
}
		
if (($thisforum[6] =~ /\&/) && ($thisforum[6] ne "private")){
		($TopicRestrict, $ReplyRestrict) = split(/\&/, $thisforum[6]);
		if ($TopicRestrict eq "restrict") {
			$TRrestrictOn = "SELECTED";
		}
		elsif ($TopicRestrict eq "allreg") {
			$TRallregOn = "SELECTED";
		} else  {
			$TRallOn = "SELECTED";
		}
		if ($ReplyRestrict eq "restrict") {
			$RRrestrictOn = "SELECTED";
		}
		elsif ($ReplyRestrict eq "allreg") {
			$RRallregOn = "SELECTED";
		}
		elsif ($ReplyRestrict eq "all") {
			$RRallOn = "SELECTED";
		}  else  {
			$RRnoneOn = "SELECTED";
		}
	}
			$TitleGraphic = "$thisforum[9]";


### If UBB Code is off, UBB Code for Images must also be off! ###
	if ($UBBOff eq "CHECKED") {
			$UBBImagesOn = "";
			$UBBImagesOff = "CHECKED";
		}

print<<ForumGuts;
<table border=0 width=100%>
<tr bgcolor="#D3CE87">
<td colspan=2 valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">
<B>Forum Number: $ForumNumber</B></td></tr>
<TR bgcolor="#c7c6ba">
<TD>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Name:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="Namer" VALUE="$thisforum[1]" SIZE=30 MAXLENGTH=100></td></tr>
<tr bgcolor="#d5d2bb"><td><FONT SIZE="1" FACE="Verdana, Arial"><B>
Category:</B></FONT></td>
<td>$CategoryDropDown</td></tr>

<TR bgcolor="#C7C6BA"><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Status:</B></FONT></td>
<td><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="Status" VALUE="On" $ForumActive> On &nbsp;&nbsp;&nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="Status" VALUE="Off" $ForumInactive> Off</B></FONT></td></tr>

<TR bgcolor="#D5D2BB"><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>HTML Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="HTML" VALUE="is" $HTMLOn> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="HTML" VALUE="is not" $HTMLOff> No</B></FONT></td></tr>

<TR bgcolor="#C7C6BA"><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>UBB Code Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="UBB" VALUE="is" $UBBOn> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="UBB" VALUE="is not" $UBBOff> No</B></FONT></td></tr>

<TR bgcolor="#D5D2BB"><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>UBB Code Images Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="UBBImages" VALUE="ON" $UBBImagesOn> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="UBBImages" VALUE="OFF" $UBBImagesOff> No</B></FONT></td></tr>

<TR bgcolor="#C7C6BA" ><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Moderator Notification? <BR></B><FONT SIZE="1" FACE="Verdana, Arial">If yes, an email will be sent to the moderator every time someone posts a note to the forum (not recommended!)</FONT></FONT></td><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="ModNotify" VALUE="yes" $ModNotifyOn> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="ModNotify" VALUE="no" $ModNotifyOff> No</B></FONT></td></tr>

<TR bgcolor="#D5D2BB"><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial" color="#800000"><B>Access Limits</B></font><BR><FONT SIZE="1" FACE="Verdana, Arial">You may make the forum completely private- which means that only admins, moderators and those that you grant permission to view (using the User Permissions area in this control panel) may view and post notes in the forum.  If you set a forum password, you can also grant access to private forums and other restricted access forums to those that know the forum password.
<P>
If you do not need to make the forum completely private, you may still restrict posting permissions in various ways. 
<P>
<BR><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">Forum Password:</font> <INPUT TYPE="TEXT" NAME="forumpw" VALUE="$thisforum[12]" SIZE=12 MAXLENGTH=12>
</FONT></td><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial"><B>
<CENTER>Completely Private - Read/Write</CENTER><P>
<INPUT TYPE="CHECKBOX" NAME="Private" VALUE="private" $PrivateOn>
Restrict Viewing and Writing of Posts To Admins, Moderators and other authorized<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">*</FONT> users
<P>
If private, you can select maximum privacy, which means that all topics are displayed dynamically, checking user identification before displaying any page, or minimum privacy, which means that topics are stored as HTML (not dynamcially created) for improved server performance, but at a security risk.
<blockquote>
<INPUT TYPE="RADIO" NAME="PrivateMax" VALUE="yes" $PrivateMaxYes>Maximum Security<BR>
<INPUT TYPE="RADIO" NAME="PrivateMax" VALUE="no" $PrivateMaxNo>Minimum Security
</blockquote>
<HR>
<BR>
<CENTER>Posting Restrictions (With Viewing of Posts Open to All)</CENTER>
<P>
If forum is not completely private, you can determine which users can post topics and replies within the forum.
<P>
Who Can Post Topics?
<BR>
<SELECT NAME="TopicRestrict">
<option value="restrict" $TRrestrictOn>Only admins, moderators and authorized users
<option value="allreg" $TRallregOn>Any registered users
<option value="all" $TRallOn>Any users (including unregistered)
</SELECT>
<P>

Who Can Post Replies?
<BR>
<SELECT NAME="ReplyRestrict">
<option value="restrict" $RRrestrictOn>Only admins, moderators and authorized users 
<option value="allreg" $RRallregOn>Any registered users
<option value="all" $RRallOn>Any users (including unregistered)
<option value="none" $RRnoneOn>No one can post replies
</SELECT>

</B></FONT>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">* An authorized user is someone who is not an administrator or moderator who has either been given specific authority to use a private forum or otherwise-restricted forum.  Administrators can give this permission to a user by either specifically assigning the permission to the user in the control panel User Permissions area or by giving the user the Forum Password to gain entrance.  You can set a forum password in the field to the left.</FONT>
</td></tr>

<TR bgcolor="#c7c6ba" ><TD valign=top><FONT SIZE="2" FACE="Verdana, Arial"><B>Forum Description:</B></FONT><BR><FONT SIZE="1" FACE="Verdana, Arial">This is displayed on your the intro page that summarizes all forums when users visit.  Be sure to set Forum Descriptions "on" in the General Variables section, if you want your visitors to see this description.</font></td><td valign=top><TEXTAREA NAME="Description" ROWS=3 COLS=30 wrap="VIRTUAL">$thisforum[2]</TEXTAREA></td></tr>
ForumGuts

&InputAreaRow("#d5d2bb", "Custom Header", "You can add your own customized header graphic, ad banner, text, etc. for this forum.  This header will appear at the top of each UBB forum page.  The Header you set in your Style settings will be used if you keep this field blank.  Thus, only complete this field is you want to replace the default Header that you set in your Style setttings.", "ForumHeader", "30", "5");

&InputAreaRow("#c7c6ba", "Custom Footer", "You can add your own customized header graphic, ad banner, text, etc. for this forum.  This header will appear at the bottom of each UBB forum page.  The Footer you set in your Style settings will be used if you keep this field blank.  Thus, only complete this field is you want to replace the default Footer that you set in your Style setttings.", "ForumFooter", "30", "5");

print<<MoreForumGuts;
<TR bgcolor="#D3CE87">
<td colspan=2 valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">
<B>Forum Display Options</B><P>Note: The default values are the values you declare in your overall Styles Settings.  You can change those values for this forum below.  You can also change the default Header and Footer variables for this forum below.  The values you place below will override the general style settings.If you are adding new graphics, be sure to upload them into your UBB NON CGI directory.  Simply place the file name in the graphic field (as in email.gif).</font></td></tr>
MoreForumGuts

&ColorRow("Page Background Color", "Format - #FFFFFF", "BGColor", "#D5D2BB");
&ColorRow("Text Color", "", "TextColor", "#C7C6BA");
&ColorRow("Link Color", "", "LinkColor", "#D5D2BB");
&ColorRow("Active Link Color", "", "ActiveLinkColor", "#C7C6BA");
&ColorRow("Visited Link Color", "", "VisitedLinkColor", "#D5D2BB");
&ColorRow("Table Border Color", "", "TableBorderColor", "#C7C6BA");
&ColorRow("Table Header Strip Text Color", "", "TableStripTextColor", "#D5D2BB");
&ColorRow("Table Header Strip Background Color", "", "TableColorStrip", "#C7C6BA");
&ColorRow("Time Color", "This color is used for the time field on the main forum summary page and the forum pages and for the \"posted by\" line for each post.", "TimeColor", "#D5D2BB");
&ColorRow("First Alternating Table Column Color", "", "AltColumnColor1", "#C7C6BA");
&ColorRow("Second Alternating Table Column Color", "", "AltColumnColor2", "#D5D2BB");
&ColorRow("Category Strip Background Color", "", "CategoryStripColor", "#C7C6BA");
&ColorRow("Category Strip Text Color", "", "CategoryStripTextColor", "#D5D2BB");
&ColorRow("Copyright Text Color", "", "CopyrightTextColor", "#C7C6BA");

print<<ForumGuts2;
<tr bgcolor="#d5d2bb">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Font Face (e.g., Verdana)</B></FONT><br><FONT SIZE="1" FACE="Verdana, Arial">We recommend you use a backup font as well.  For example: to use Verdana as your first choice, with Arial as a conditional font for those users that don't have Verdana as a font on their system, you would type "Verdana, Arial")</FONT><br>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="FontFace" VALUE="$FontFace" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#c7c6ba">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Table Width</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial">You may use either exact pixels (recommended: 600) or a percentage (recommended: 90%)</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="TableWidth" VALUE="$TableWidth" SIZE=5 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#d5d2bb">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Text Size</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial">We recommend using size 2... but depending on your font face, you may want to alter this.</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="TextSize" VALUE="$TextSize" SIZE=1 MAXLENGTH=1>
</td></tr>

<tr bgcolor="#c7c6ba">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Page Background Graphic</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial">Not recommended to be used, but you can add a background graphic to your pages.  If you do so, you should upload the graphic into your NON CGI directory and place the name of the background graphic in this field.  For example, background.gif.</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="PageBackground" VALUE="$PageBackground" SIZE=30 MAXLENGTH=200>
</td></tr>

<tr bgcolor="#d5d2bb">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Forum Title Graphic:</B></FONT></td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="BBTitle" VALUE="$BBTitle" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#c7c6ba">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Post New Topic Graphic:</B></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="BBTopic" VALUE="$BBTopic" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#d5d2bb">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Post Reply Graphic:</B></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="BBReply" VALUE="$BBReply" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#c7c6ba">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Thread Closed Graphic:</B></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="ThreadClosed" VALUE="$ThreadClosed" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#d5d2bb">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Profile Graphic:</B></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="profilegif" VALUE="$profilegif" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#c7c6ba">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Email Graphic:</B></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="mailgif" VALUE="$mailgif" SIZE=25 MAXLENGTH=50>
</td></tr>
</table>
ForumGuts2

print<<BottomForumHTML;
</td></tr></table>
<BR><INPUT TYPE="CHECKBOX" NAME="RestoreDefaultStyles" VALUE="yes">

<FONT SIZE="1" FACE="Verdana, Arial">Check here to restore style settings set in your overall Style Settings area.</FONT>
<INPUT TYPE="HIDDEN" NAME="ForumNumber" VALUE="$ForumNumber">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="sendforum">
<CENTER>
<P>
<HR>
<CENTER><FONT Size="2" FACE="Verdana, Arial" COLOR="#000080"><B>Enter Your UserName & Password:</font>
<p>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#000080">
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B>
<p><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Settings Now"></form>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000">Ultimate Bulletin Board, &copy; Infopop Corporation (formerly Madrona Park, Inc.), 1998 - 1999.</FONT>
</CENTER></font>
</BODY>
</HTML>
BottomForumHTML


} else {
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file
require "Styles.file";

};

&StandardHTML("Sorry, you are not authorized to view this forum's settings.");
exit;
}

} #end sr

sub SubmitBans {
&VerifyAdmin($UserNameCheck, $PasswordCheck);
if ($Proceed eq "true") {
$EmailBans = $in{'EmailBan'};
$EmailBans =~ s/\@/\\@/g;
@EmailBanList = split(/\s/, $EmailBans);

$IPBans = $in{'IPBan'};
$IPBans =~ s/\@/\\@/g;
@IPBanList = split(/\s/, $IPBans);

&Lock("lock.file");
open(EMAILBAN, ">$NonCGIPath/BanLists/EmailBan.cgi");
foreach $one(@EmailBanList) {
	chomp($one);
	if ($one ne "") {
	print EMAILBAN "$one\n";
	}
}
close(EMAILBAN);
&Unlock("lock.file");
chmod (0777, "$NonCGIPath/BanLists/EmailBan.cgi");

&Lock("lock.file");
open(IPBAN, ">$NonCGIPath/BanLists/IPBan.cgi");
foreach $uno(@IPBanList) {
	chomp($uno);
	if ($uno ne "") {
	print IPBAN "$uno\n";
	}
}
close(IPBAN);
&Unlock("lock.file");
chmod (0777, "$NonCGIPath/BanLists/IPBan.cgi");

&EndUpdate("B A N &nbsp;&nbsp;&nbsp;&nbsp; L I S T S &nbsp;&nbsp;&nbsp;&nbsp; U P D A T E D", "Your registration ban lists have been successully updated!");
}
} #end Submit Bans

sub ViewBanList {
&VerifyAdmin($UserName, $Password);
if ($Proceed eq "true") {
#get current ban lists

@emailbans = &OpenFile("$NonCGIPath/BanLists/EmailBan.cgi");
@IPbans = &OpenFile("$NonCGIPath/BanLists/IPBan.cgi");

$Count = 0;
foreach $one(@emailbans) {
	$emailbans[$Count] =~ s/\\@/@/sg;
	$Count++;
}

$EmailBan = join(/\n/, @emailbans);
$IPBan = join(/\n/, @IPbans);

$PageTitle = "B A N &nbsp;&nbsp;&nbsp;&nbsp; L I S T S";
&HEADER2HTML;

print<<BANNED;
<FONT SIZE="2" FACE="Verdana, Arial">You can prevent certain users from being registered, based on email addresses they attempt to register with or their IP numbers. </FONT> 
<P>

<FORM ACTION="cpanel3.cgi" METHOD="POST" NAME="THEFORM">

<CENTER>
<table border=0 cellpadding=0 cellspacing=0 width="95%"><TR><td bgcolor="#000000">
<table border=0 cellpadding=4 border=0 cellspacing=1 width=100%>
<TR bgcolor="#B0BB9D">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Email Ban Lists:  You may ban certain email addresses from registering on your forums.  To ban a specific email, type the full email address (as in, waldo\@whereiswaldo.com).  To ban all email addresses from certain domains, such as hotmail, simply type the domain name (as in hotmail.com)- that will prevent anyone using a hotmail address from registering.  Put each banned email on its own line (hit the carriage return after each email entry to be banned).</B></FONT>
</TD>
</tr>
BANNED

&InputAreaRow("#f7f7f7", "Email Ban List:", "", "EmailBan", "30", "5");

print<<NEXT;
<TR bgcolor="#B0BB9D">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>IP Number Ban Lists:  You may ban any IP numbers from registering and posting.  Type in the complete IP number (as in 243.21.31.7), or use a partial IP number (as in 243.21.31).  The UBB will do matches from the beginning of each IP number that you enter.  Thus, If you enter a partial IP of 243.21.31, someone attempting to register who has an IP number of 243.21.31.5 will not be able to register.  Similarly, if you have an IP ban on 243.21, someone registering who has an IP of 243.21.3.44 will not be able to register.  Thus, be careful when you add IPs to your ban list and be as specific as possible.  As with the email ban list, put each IP number on its own line (hit the carriage return after each entry).  The IP Ban prevents anyone with matching IP number from registering and posting.</B></FONT>
</TD>
</tr>
NEXT

&InputAreaRow("#f7f7f7", "IP Number Ban List:", "", "IPBan", "30", "5");

print<<BOTTOM;
<TR bgcolor="#C7C6BA">
<TD><FONT Size="2" FACE="Verdana, Arial">
UserName:</font></TD><TD><INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25></td></tr>
<TR bgcolor="#C7C6BA">
<TD><FONT Size="2" FACE="Verdana, Arial">Password</font></TD><TD><INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></TD></tr>
</table>
</td></tr></table>
<P>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="submitbans">

<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Ban Lists">
</FORM>
<P><BR>
<FONT SIZE="1" FACE="Verdana, Arial">&copy; Infopop Corporation (formerly Madrona Park, Inc.), 1998-1999.</FONT></CENTER>
</body></html>
BOTTOM


}  
}  #end ViewBanList

sub Forums {
#check to see if categories file has been created
&AssembleCats;

if ($in{'inside'} eq "true") {
#check cookies rather than an input form
&get_cookie;  #retrieves all current cookies

if ($cookie{UserNameCP}) {
$UserName = "$cookie{UserNameCP}";
$Password = "$cookie{PasswordCP}";
&VerifyAdmin($UserName, $Password);

if ($Proceed eq "true") {
	&DoForums;
} else {

eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file
require "Styles.file";

};
&StandardHTML("Sorry, you are not authorized to access the forum summary.");
exit;
}

} 
elsif ($in{'UserName'} ne "") {

$UserName = "$in{'UserName'}";
$Password = "$in{'Password'}";
&VerifyAdmin($UserName, $Password);

if ($Proceed eq "true") {
	&DoForums;
} else {
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file
require "Styles.file";

};
&StandardHTML("Sorry, you are not authorized to access the forum summary.");
exit;
}


}  else {
$PageTitle = "F O R U M &nbsp;&nbsp;&nbsp;&nbsp; S E T T I N G S";
$PageIntro = "In order to view the forum summary, you must first identify yourself.  You will not have to do this each time if you allow cookies to be set from your browser.";
$HiddenFields = qq(<INPUT TYPE="HIDDEN" NAME="action" VALUE="forums">
<INPUT TYPE="HIDDEN" NAME="inside" VALUE="true">
<INPUT TYPE="HIDDEN" NAME="StartPoint" VALUE="0">
<INPUT TYPE="HIDDEN" NAME="sortby" VALUE="$in{'sortby'}">
 );
&QueryForID;
exit;
}

}  else {

# Verify that user is ADMIN first!
&VerifyAdmin($UserName, $Password);
if ($Proceed eq "true") {
	&DoForums;
 }  else {
 eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file
require "Styles.file";

};
&StandardHTML("We could not confirm your identity.  Try accessing your forums by clicking on the Forum Settings link in your control panel");
exit;
}
}
} #end Forums sr

sub DoForums {

if ($UserNameCheck ne "") {
$UserNameFill = "$UserNameCheck";
}  else {
$UserNameFill = "$UserName";
}
$UserNameFill = &HTMLIFY($UserNameFill);

if ($PasswordCheck ne "") {
$PasswordFill = "$PasswordCheck";
}  else {
$PasswordFill = "$Password";
}
$PasswordFill = &HTMLIFY($PasswordFill);

# check to see how many forums are currently listed
@forums = &OpenForumsFile;
$ForumTotal = @forums;

$PageTitle = "S E T &nbsp;&nbsp;&nbsp;&nbsp; F O R U M &nbsp;&nbsp;&nbsp;&nbsp; V A R I A B L E S";
&HEADER2HTML;

if ($in{'sortby'} eq "Category") {
	$SortByCategory = "SELECTED";
	$SortIt = "Category";
}
elsif (($in{'sortby'} eq "") || ($in{'sortby'} eq "Number")) {
	$SortByNumber = "SELECTED";
		$SortIt = "Number";
	
}  else {
	$SortByAlpha = "SELECTED";
	$SortIt = "Alpha";
}
print<<ForumHTML;
<FONT SIZE="1" FACE="Verdana, Arial">You can easily assign/change forum names, descriptions, and properties through this control panel area.</FONT> 
<P><FONT SIZE="2" FACE="Verdana, Arial">
<B>To Add A New Forum,  <A HREF="cpanel.cgi?action=addforums">Click Here.</a></font></B>
<P>
<table border=0 width=95%><TR><TD>
<B><FONT SIZE="2" FACE="Verdana, Arial">Update Existing Forums Below</FONT></B></td><TD align=center><FONT SIZE="1" FACE="Verdana, Arial">[<A HREF="$NonCGIURL/forumterms.html" target=_new>forum variable terms</A>]</FONT></td></TR></table>
<P>
<FONT SIZE="2" FACE="Verdana, Arial">You currently have $ForumTotal total forums (either active or inactive).   To set forum permissions and assign other settings for a particular forum, click on the "Details" link for the forum.
<P>
The "Order" field determines the order that the forums are displayed.  You should only place numbers in the order fields.  For instance, to arrange 5 forums by order, place a number value of 1 through 5 in each of the forums.  The lower the number, the higher the forum will appear in your forum lists.  If you are displaying your forums in category groups, the category order takes precedence.  You may set the category order here.
<P>
<TABLE BORDER=0 width=100%>
<TR><TD align=left valign=bottom><FONT SIZE="2" FACE="Verdana, Arial">
<A HREF="cpanel.cgi?action=addforums">Add Forum</a> | <A HREF="cpanel3.cgi?action=cats">Add/Review Categories</A></font></TD>
<TD align=right valign=bottom>
<FORM ACTION="$CGIURL/cpanel3.cgi" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="forums">
<INPUT TYPE="HIDDEN" NAME="inside" VALUE="true">
<INPUT TYPE="HIDDEN" NAME="StartPoint" VALUE="0">
<SELECT NAME="sortby">
	<OPTION value="Category" $SortByCategory>Sort By Category/Order
	<OPTION value="Number" $SortByNumber>Sort By Forum Number
	<OPTION value="Alpha" $SortByAlpha>Sort Alphabetically 
</SELECT><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Sort">

</FORM>
</td></TR>
</TABLE>

</FONT>
ForumHTML

#retreive category list
@CATEGORIES = &OpenFile("$NonCGIPath/categories.file");

if ($SortIt eq "Alpha") {
foreach $check(@forums) {
@getalpha = split(/\|/, $check);
$AlphaUC = uc($getalpha[1]);
$AlphaLine = "$AlphaUC||**||$check";
push(@sortthis, $AlphaLine);
}
@sorted = sort(@sortthis);
foreach $uno(@sorted) {
($junk, $keep) = split(/\|\|\*\*\|\|/, $uno);
chomp($keep);
push(@final, $keep);
}

} 
elsif ($SortIt eq "Number") {
@final = @forums;
}  else {

@final = @blank;
@sortcat = sort(@CATEGORIES);
if (@sortcat) {

foreach $cattype(@sortcat) {

($junk, $ThisCatNam, $ThisCatNumb) = split(/\|\|\|/, $cattype);
chomp($ThisCatNumb);

@catgroup = @blank;
@sortthis = @blank;

foreach $check(@forums) {
if ($check =~ /^$ThisCatNumb\|/) {
push(@catgroup, $check);
}
}

#now sort the subset
	foreach $ion(@catgroup) {
		@sortrow = split(/\|/, $ion);
		chomp($sortrow[14]);
		$sortline = "$sortrow[14]||**||$ion";
		push(@sortthis, $sortline);
	}
	@presort = sort(@sortthis);
	@subtotal = (@subtotal, @presort);
}  #end cat loop

#check for forums witout cats

foreach $check(@forums) {
if ($check =~ /^\|/) {
	$Empties = "true";
	chomp($check);
		@thisrow = split(/\|/, $check);
		chomp($thisrow[14]);
		if ($thisrow[14]) {
			$OrdIt = $thisrow[14];
		} else {
			$OrdIt = $thisrow[8];
		}
		$sortline = "$OrdIt||**||$check";
		push(@nocat, $sortline);
}
}
if ($Empties eq "true") {
	@presort2 = sort(@nocat);
	@subtotal = (@subtotal, @presort2);
}
	
	foreach $uno(@subtotal) {
	($junk, $keep) = split(/\|\|\*\*\|\|/, $uno);
	chomp($keep);
	push(@final, $keep);
	}
	
}  else {

	foreach $ion(@forums) {
		@sortrow = split(/\|/, $ion);
		chomp($sortrow[14]);
		$sortline = "$sortrow[14]||**||$ion";
		push(@sortthis, $sortline);
	}
	@subtotal = sort(@sortthis);

	foreach $uno(@subtotal) {
	($junk, $keep) = split(/\|\|\*\*\|\|/, $uno);
	chomp($keep);
	push(@final, $keep);
	}
}
}

## BREAK UP INTO CHUNKS OF 30 ##
$TotalForums = @final;
$MaxForumDisplay = 30;
if ($TotalForums > $MaxForumDisplay) {
$TotalPages = $TotalForums / $MaxForumDisplay;

if ($TotalPages =~ /\./) {
	($Whole, $junk) = split(/\./, $TotalPages);
	$TotalPages = $Whole + 1;
}  else {
	$TotalPages = $TotalPages;
}

if (($in{'StartPoint'} eq "") || ($in{'StartPoint'} == 0)){
	$StartPoint = 0;
} else {
	$StartPoint = $in{'StartPoint'};
	$StartPoint = $StartPoint + 0;
}

	$Calibrate = $StartPoint + 1;
	$EndPoint = $StartPoint + ($MaxForumDisplay - 1);
	$CalibrateEnd = $EndPoint + 1;
	if ($TotalForums < $CalibrateEnd) {
		$CalibrateEnd = $TotalForums;
		$EndPoint = $CalibrateEnd - 1;
	}

$eachpage = 1;

$NextLine = "Forum Number Ranges: &nbsp;&nbsp;&nbsp;&nbsp;";
for ($eachpage == 1; $eachpage <= $TotalPages; $eachpage++) {
$EndHere = $eachpage * $MaxForumDisplay;
$StartHere = $EndHere - ($MaxForumDisplay - 1);
$ArrayStart = $StartHere - 1;
if ($TotalForums < $EndHere) {
	$EndHere = $TotalForums;
}
if ($Calibrate == $StartHere) {
$NextLine .= qq(&nbsp;$StartHere - $EndHere&nbsp;);
}  else {
$NextLine .= qq(&nbsp;<A HREF="$CGIURL/cpanel3.cgi?action=forums&StartPoint=$ArrayStart&sortby=$in{'sortby'}&inside=true">$StartHere - $EndHere</A>&nbsp;)
}

}

@final = @final[$StartPoint...$EndPoint];



} else {
$NextLine = "";

} #if/else more than 40 forums

################################

#display forum summary

print<<SummHead;
$NextLine
<center>
<FORM ACTION="cpanel3.cgi" METHOD="POST" NAME="THEFORM">
<table border=0 cellpadding=0 cellspacing=0 width="95%"><TR><td bgcolor="#000000">
<table border=0 cellpadding=4 border=0 cellspacing=1 width=100%>

<TR bgcolor="Olive"><TD COLSPAN=6 align=center>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="White"><B>Forum Summary</B></FONT>
</TR>
<TR bgcolor="#B8C6AE">
<TD><FONT SIZE="2" FACE="Verdana, Arial">Number</font></TD>
<TD><FONT SIZE="2" FACE="Verdana, Arial">Name</font></TD>
<TD><FONT SIZE="2" FACE="Verdana, Arial">Order</font></TD>
<TD><FONT SIZE="2" FACE="Verdana, Arial">Status</font></TD>
<TD><FONT SIZE="2" FACE="Verdana, Arial">Category</font></TD>
<TD>&nbsp;</TD>
</TR>
SummHead


foreach $one(@final) {
@thisfor = split(/\|/, $one);
$ThisNum = $thisfor[8];
$ThisCategory = $thisfor[0];
$OrderNum = $thisfor[14];
chomp($OrderNum);
$OrderNumber = $OrderNum + 0;

if ($thisfor[3] eq "On") {
	$StatusOn = "SELECTED";
	$StatusOff = "";
}  else {
	$StatusOff = "SELECTED";
	$StatusOn = "";
}

unless ($OrderNum) {
	$OrderNumber = $ThisNum;
}

$CategoryDropDown = qq(<SELECT NAME="ForumCategory|||$ThisNum">);
$Count = 0;
if ($ThisCategory eq "") {
	$ThisSelected = "SELECTED";
} else {
	$ThisSelected = "";
}
$CategoryDropDown .= qq(<OPTION VALUE="" $ThisSelected>No Category);
foreach $cat(@CATEGORIES) {
($Junk, $CatName, $CatNumber) = split(/\|\|\|/, $cat);
chomp($CatNumber);
$CatNumber = $CatNumber + 0;
$Count++;
if ($CatNumber == $ThisCategory) {
	$Selection = "SELECTED";
} else {
	$Selection = "";
}
$CategoryDropDown .= qq(<OPTION VALUE="$CatNumber" $Selection>$CatName);
}


if ($Count == 0) {
$CategoryDropDown .= qq(<OPTION value="">No Categories Created Yet);
}
$CategoryDropDown .= "</SELECT>";

print<<ROW;
<TR bgcolor="#FFFFFF">
<TD><FONT SIZE="2" FACE="Verdana, Arial">$ThisNum</font></TD>
<TD><INPUT TYPE="TEXT" NAME="ForumName|||$ThisNum" VALUE="$thisfor[1]" SIZE=20 MAXLENGTH=125></TD>
<TD><INPUT TYPE="TEXT" NAME="ForumOrder|||$ThisNum" VALUE="$OrderNumber" SIZE=5 MAXLENGTH=5></TD>
<TD><SELECT NAME="ForumStatus|||$ThisNum">
	<OPTION $StatusOn>On
	<OPTION $StatusOff>Off
</SELECT></TD>
<TD>$CategoryDropDown</TD>
<TD><FONT SIZE="2" FACE="Verdana, Arial"><A HREF="cpanel3.cgi?action=getforum&number=$ThisNum">Details</A></font></TD>
</TR>
ROW

}

print<<BottomForumHTML;
</table>
</td></tr></table>
<P>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="setforums">

<BR>

<P>
<HR>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#000080"><B>Enter Your UserName & Password:</font>
<p>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#000080">
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B>
<p><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Changes Now"></form>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000">Ultimate Bulletin Board, &copy; Infopop Corporation (formerly Madrona Park, Inc.), 1998 - 1999.</FONT>
</CENTER></font>
</BODY>
</HTML>
BottomForumHTML
}  ## END DoForums


sub HEADER2HTML {
&GetCookieInfo;
print<<HEADER2HTML;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";domain=$TheDomain;path=/$ThePath;";
		document.cookie = "PasswordCP=" + CookiePWCP + ";domain=$TheDomain;path=/$ThePath;";
	}

function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.THEFORM.UserNameCheck.value = getCookie("UserNameCP");
document.THEFORM.PasswordCheck.value = getCookie("PasswordCP");
	}  
}
function Check(form)  {
if ((form.PasswordCheck.value == "") || (form.UserNameCheck.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}
function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#000080" onLoad="SetCursor()">
<BR><center>
<FONT SIZE="2" FACE="Verdana, Arial">$PageTitle</FONT>
</center>
<p>
HEADER2HTML
} #end HEADERHTML2 sr


sub SetForums {
&VerifyAdmin($in{'UserNameCheck'}, $in{'PasswordCheck'});
if ($Proceed eq "true") {
	 &DoProcessForums;
}
}  ##END SendForums sr

sub DoProcessForums {
### write forum info to forums.cgi
foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	if ($Name =~ m/ForumName/) {
	($Trash, $ForumNumber) = split(/\|\|\|/, $Name);
	push (@AdjustForums, $ForumNumber);
	}
} # end foreach $row

# now we have list of forum numbers to adjust (e.g., 1 - 9)

#read current forum data
@forums = &OpenForumsFile;

#assemble new line for each revised forum
for $num(@AdjustForums) {
chomp($num);
	$Found = "false";
	$ThisPrivate = "";
foreach $row2(@in) {
	($Name, $Value) = split ("=", $row2);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	if ($Name eq "ForumName|||$num") {
		$ThisName = $Value;
		$ThisName =~ s/"/&quot;/g;
		$Found = "true";
	}
	if ($Name eq "ForumCategory|||$num") {
		$ThisCategory = $Value;
	}
	if ($Name eq "ForumStatus|||$num") {
		$ThisStatus = $Value;
	}
		if ($Name eq "ForumOrder|||$num") {
		$ThisOrder = $Value;
		$ThisOrderFormatted = &Do6Digit($ThisOrder);
	}
} # end foreach $row2

$arrayrow = ($num - 1);

$ThisForumLine = $forums[$arrayrow];
chomp($ThisForumLine);
@thisforum = split(/\|/, $ThisForumLine);

$forums[$arrayrow] = ("$ThisCategory|$ThisName|$thisforum[2]|$ThisStatus|$thisforum[4]|$thisforum[5]|$thisforum[6]|$thisforum[7]|$num|$thisforum[9]|$thisforum[10]|$thisforum[11]|$thisforum[12]|$thisforum[13]|$ThisOrderFormatted\n");

}  #end for each @AdjustForum

#write to forums file

&Lock("lock.file");
open (FORUMS, ">$VariablesPath/forums.cgi"); 
print FORUMS (@forums);
close (FORUMS);
&Unlock("lock.file");

$UserNameCoded = &HTMLIFY($UserNameCheck);
$PasswordCoded = &HTMLIFY($PasswordCheck);

&EndUpdate("F O R U M S &nbsp;&nbsp;&nbsp;&nbsp; S E T T I N G S  &nbsp;&nbsp;&nbsp;&nbsp; U P D A T E D", "Thank you!  Your UBB Forum Settings have now been updated as you requested.<P><P>Go To: <A HREF=\"$CGIURL/cpanel3.cgi?action=forums&StartPoint=0&inside=true\">Forum Summary</A> | <A HREF=\"$CGIURL/cpanel.cgi?action=addnewforum\">Add New Forum</A> | <A HREF=\"$CGIURL/cpanel3.cgi?action=cats\">Category Settings</A>");
exit;
} ## END DO PROCESS FORUMS SR

sub AddNewForum {
### CHECK USERNAME - must be an admin
##verify that this user is an administrator

$NameFound = "no";
$ProfileNumber = &GetUserNumber($in{'UserName'});

if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}


if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$ProfileNumber.cgi");			
	if ($Password eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoAddNewForum;
	   }  else {
	   eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file
require "Styles.file";

};
	    &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file
require "Styles.file";

};
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again. Use your Back button.");
	}
}  else {
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file
require "Styles.file";

};
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK

}  ##END AddNewForum sr

sub DoAddNewForum {
$ForumTotal = &GetTotalForums;
$ForumTotal++;

if ($in{'forumpw'} =~ /\|/) {
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file
require "Styles.file";

};
&StandardHTML("You may not use a pipestem- \"|\"- in a forum password. Please go back and try again.");
exit;
}
### write forum info to forums.cgi
	$Description = &decodeURL($in{'Description'});
		$Description =~ s/"/&quot;/g;
		$Description =~ s/\n\r\n//g;
		$Description =~ s/\n//g;
		$Description =~ s/\r//g;
		$Description =~ s/  / /g;
		
	$Name = &decodeURL($in{'Namer'});
	$Name =~ s/"/&quot;/g;
	$Category = $in{'Category'};
	
	
$ThisForumLine = $forums[$arrayrow];
@thisforum = split(/\|/, $ThisForumLine);

if ($in{'Private'} eq "private") {
#create HTML directory alternate to keep contents hidden
$DIRPW = &GeneratePassword;
$DescLength = length($Description);
$DIRPW .= "$DescLength";
}  else {
$DIRPW = "";
}

if ($in{'Private'} eq "private") {
	$ForumPermission = "private";
}  else {
	$ForumPermission = "$in{'TopicRestrict'}&$in{'ReplyRestrict'}";
}
$OrderNumber = &Do6Digit($ForumTotal);

$newforumline = ("$Category|$Name|$Description|$in{'Status'}|$in{'HTML'}|$in{'UBB'}|$ForumPermission|$DIRPW|$ForumTotal||$in{'UBBImages'}|$in{'ModNotify'}|$in{'forumpw'}|$in{'PrivateMax'}|$OrderNumber");

#write to forums file
&Lock("lock.file");
open (NEWFORUM, ">>$VariablesPath/forums.cgi"); 
print NEWFORUM ("$newforumline\n");
close (NEWFORUM);
&Unlock("lock.file");

#create new Forum Directory with permissions for UNIX servers
mkdir("$ForumsPath/Forum$in{'Number'}", 0777);
chmod (0777, "$ForumsPath/Forum$in{'Number'}");
mkdir("$ForumsPath/Forum$in{'Number'}/ANNC", 0777);
chmod (0777, "$ForumsPath/Forum$in{'Number'}/ANNC");
mkdir("$ForumsPath/Forum$in{'Number'}/HTML", 0777);
chmod (0777, "$ForumsPath/Forum$in{'Number'}/HTML");

#create index files to hide contents of directories
open (INDEX, ">$ForumsPath/Forum$in{'Number'}/ANNC/index.html"); 
print INDEX "";
close (INDEX);
open (INDEX, ">$ForumsPath/Forum$in{'Number'}/HTML/index.html"); 
print INDEX "";
close (INDEX);
open (INDEX, ">$ForumsPath/Forum$in{'Number'}/index.html"); 
print INDEX "";
close (INDEX);

#create private directories, if necessary
if ($DIRPW ne "") {
mkdir("$ForumsPath/Forum$in{'Number'}/private-$DIRPW", 0777);
chmod (0777, "$ForumsPath/Forum$in{'Number'}/private-$DIRPW");
mkdir("$ForumsPath/Forum$in{'Number'}/private-$DIRPW/ANNC", 0777);
chmod (0777, "$ForumsPath/Forum$in{'Number'}/private-$DIRPW/ANNC");
mkdir("$ForumsPath/Forum$in{'Number'}/private-$DIRPW/HTML", 0777);
chmod (0777, "$ForumsPath/Forum$in{'Number'}/private-$DIRPW/HTML");

open (INDEX, ">$ForumsPath/Forum$in{'Number'}/private-$DIRPW/ANNC/index.html"); 
print INDEX "";
close (INDEX);
open (INDEX, ">$ForumsPath/Forum$in{'Number'}/private-$DIRPW/HTML/index.html"); 
print INDEX "";
close (INDEX);
open (INDEX, ">$ForumsPath/Forum$in{'Number'}/private-$DIRPW/index.html"); 
print INDEX "";
close (INDEX);
}

#write other fields to forumstyles.file
foreach $row(@in) {
	$row =~ s/\@/\\@/g;
	$row =~ s/"/\\"/g;
}

$ForumHeader = &LimitReturns($in{'ForumHeader'});
$ForumFooter = &LimitReturns($in{'ForumFooter'});

open(FORSTYL, ">$ForumsPath/Forum$ForumNumber/forumstyles.file");
print FORSTYL ('$BGColor = "' . "$in{'BGColor'}" . '"' . ";\n");
print FORSTYL ('$TextColor = "' . "$in{'TextColor'}" . '"' . ";\n");
print FORSTYL ('$LinkColor = "' . "$in{'LinkColor'}" . '"' . ";\n");
print FORSTYL ('$ActiveLinkColor = "' . "$in{'ActiveLinkColor'}" . '"' . ";\n");
print FORSTYL ('$VisitedLinkColor = "' . "$in{'VisitedLinkColor'}" . '"' . ";\n");
print FORSTYL ('$TableBorderColor = "' . "$in{'TableBorderColor'}" . '"' . ";\n");
print FORSTYL ('$TableStripTextColor = "' . "$in{'TableStripTextColor'}" . '"' . ";\n");
print FORSTYL ('$TableColorStrip = "' . "$in{'TableColorStrip'}" . '"' . ";\n");
print FORSTYL ('$TimeColor = "' . "$in{'TimeColor'}" . '"' . ";\n");
print FORSTYL ('$AltColumnColor1 = "' . "$in{'AltColumnColor1'}" . '"' . ";\n");
print FORSTYL ('$AltColumnColor2 = "' . "$in{'AltColumnColor2'}" . '"' . ";\n");
print FORSTYL ('$CategoryStripColor = "' . "$in{'CategoryStripColor'}" . '"' . ";\n");
print FORSTYL ('$CategoryStripTextColor = "' . "$in{'CategoryStripTextColor'}" . '"' . ";\n");
print FORSTYL ('$CopyrightTextColor = "' . "$in{'CopyrightTextColor'}" . '"' . ";\n");
print FORSTYL ('$FontFace = "' . "$in{'FontFace'}" . '"' . ";\n");
print FORSTYL ('$TableWidth = "' . "$in{'TableWidth'}" . '"' . ";\n");
print FORSTYL ('$TextSize = "' . "$in{'TextSize'}" . '"' . ";\n");
print FORSTYL ('$PageBackground = "' . "$in{'PageBackground'}" . '"' . ";\n");
print FORSTYL ('$BBTitle = "' . "$in{'BBTitle'}" . '"' . ";\n");
print FORSTYL ('$BBTopic = "' . "$in{'BBTopic'}" . '"' . ";\n");
print FORSTYL ('$BBReply = "' . "$in{'BBReply'}" . '"' . ";\n");
print FORSTYL ('$ThreadClosed = "' . "$in{'ThreadClosed'}" . '"' . ";\n");
print FORSTYL ('$profilegif = "' . "$in{'profilegif'}" . '"' . ";\n");
print FORSTYL ('$mailgif = "' . "$in{'mailgif'}" . '"' . ";\n");
print FORSTYL ('$ForumHeader = "' . "$ForumHeader" . '"' . ";\n");
print FORSTYL ('$ForumFooter = "' . "$ForumFooter" . '"' . ";\n");
print FORSTYL "1;";
close(FORSTYL);
chmod(0666, "$ForumsPath/Forum$in{'Number'}/forumstyles.file");

$ConfirmLine = qq(New forum successfully added!<P>Go to: <A HREF="cpanel3.cgi?action=forums&StartPoint=0&inside=true">Forum Summary</A> | <A HREF="cpanel.cgi?action=addforums">Add New Forum</A> | <A HREF="cpanel3.cgi?action=cats">Add/Review/Order Categories</A>);
&ConfirmHTML2;
exit;
} ## END DO ADD NEW FORUM SR


sub InputAreaRow {
my $RowColor = shift;
my $FieldName = shift;
my $Notes = shift;
my $InputField = shift;
my $Cols = shift;
my $Rows = shift;

if ($Notes ne "") {
	$Notes = "<BR>$Notes";
}
print<<ROW;
<TR bgcolor="$RowColor">
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>$FieldName</B></FONT>
<FONT SIZE="1" FACE="Verdana, Arial">$Notes</FONT>
</td>
<td valign=top>
<TEXTAREA NAME="$InputField" COLS="$Cols" ROWS="$Rows" WRAP="VIRTUAL">$$InputField</TEXTAREA>
</td></tr>
ROW
}

sub SendForum {
&VerifyAdmin($in{'UserNameCheck'}, $in{'PasswordCheck'});
if ($Proceed eq "true") {
	 &DoSendForum;
}  else {
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file
require "Styles.file";

};
&StandardHTML("Sorry, but you are not authorized to perform this function.");
}
}

sub DoSendForum {
### write forum info to forums.cgi
$ForumNumber = $in{'ForumNumber'};
$ArrayNumber = $ForumNumber - 1;

#read current forum data
@forums = &OpenForumsFile;

	$Found = "false";
	$ThisPrivate = "";
	
foreach $row2(@in) {
	($Name, $Value) = split ("=", $row2);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	$Value =~ s/\@/\\@/g;
	$Value =~ s/\"/\\"/g;
	
	if ($Name eq "Namer") {
		$ThisName = $Value;
		$ThisName =~ s/"/&quot;/g;
		$Found = "true";
	}
	if ($Name eq "Category") {
		$ThisCategory = $Value;
	}
	if ($Name eq "Status") {
		$ThisStatus = $Value;
	}
	if ($Name eq "HTML") {
		$ThisHTML = $Value;
	}
	if ($Name eq "UBB") {
		$ThisUBB = $Value;
	}
	if ($Name eq "TextSize") {
		$TextSize = $Value;
	}
	if ($Name eq "PageBackground") {
		$PageBackground = $Value;
	}
	if ($Name eq "FontFace") {
		$FontFace = $Value;
	}
	if ($Name eq "TableWidth") {
		$TableWidth = $Value;
	}
	if ($Name eq "ModNotify") {
		$ThisModNotify = $Value;
	}
if ($Name eq "UBBImages") {
		$ThisUBBImages = $Value;
	}
		if ($Name eq "Private") {
		$ThisPrivate = $Value;
	}
	if ($Name eq "TopicRestrict") {
		$ThisTopic = $Value;
	}
	if ($Name eq "ReplyRestrict") {
		$ThisReply = $Value;
	}
	if ($Name eq "forumpw") {
		$ForumPW = $Value;
		if ($ForumPW =~ /\|/) {
		eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file
require "Styles.file";

};
			&StandardHTML("You can not use a pipestem- \"|\" - in a forum password.  Please try again.");
exit;
		}
	}
	if ($Name eq "PrivateMax") {
		$PrivateMax = $Value;
	}
	if ($Name eq "Description") {
		$ThisDescription = $Value;
		$ThisDescription =~ s/"/&quot;/g;
		$ThisDescription =~ s/\n\r\n//g;
		$ThisDescription =~ s/\n//g;
		$ThisDescription =~ s/\r//g;
		$ThisDescription =~ s/  / /g;
	}
} # end foreach $row2


$ThisForumLine = $forums[$ArrayNumber];
chomp($ThisForumLine);
@thisforum = split(/\|/, $ThisForumLine);

#create private directory alternate to keep contents hidden,
#if necessary

if (($ThisPrivate eq "private") && ($thisforum[7] eq "")) {
$DIRPW = &GeneratePassword;
$DescLength = length($ThisDescription);
$DIRPW .= "$DescLength";

mkdir("$ForumsPath/Forum$thisforum[8]/private-$DIRPW", 0777);
chmod (0777, "$ForumsPath/Forum$thisforum[8]/private-$DIRPW");
mkdir("$ForumsPath/Forum$thisforum[8]/private-$DIRPW/ANNC", 0777);
chmod (0777, "$ForumsPath/Forum$thisforum[8]/private-$DIRPW/ANNC");
mkdir("$ForumsPath/Forum$thisforum[8]/private-$DIRPW/HTML", 0777);
chmod (0777, "$ForumsPath/Forum$thisforum[8]/private-$DIRPW/HTML");

open (INDEX, ">$ForumsPath/Forum$thisforum[8]/index.html"); 
print INDEX "";
close (INDEX);

open (INDEX, ">$ForumsPath/Forum$thisforum[8]/private-$DIRPW/ANNC/index.html"); 
print INDEX "";
close (INDEX);
open (INDEX, ">$ForumsPath/Forum$thisforum[8]/private-$DIRPW/HTML/index.html"); 
print INDEX "";
close (INDEX);
open (INDEX, ">$ForumsPath/Forum$thisforum[8]/private-$DIRPW/index.html"); 
print INDEX "";
close (INDEX);

}
elsif (($ThisPrivate eq "private") && ($thisforum[7] ne "")) {

$DIRPW = "$thisforum[7]";

unless (-e "$ForumsPath/Forum$thisforum[8]/private-$DIRPW") {

mkdir("$ForumsPath/Forum$thisforum[8]/private-$DIRPW", 0777);
chmod (0777, "$ForumsPath/Forum$thisforum[8]/private-$DIRPW");
mkdir("$ForumsPath/Forum$thisforum[8]/private-$DIRPW/ANNC", 0777);
chmod (0777, "$ForumsPath/Forum$thisforum[8]/private-$DIRPW/ANNC");
mkdir("$ForumsPath/Forum$thisforum[8]/private-$DIRPW/HTML", 0777);
chmod (0777, "$ForumsPath/Forum$thisforum[8]/private-$DIRPW/HTML");

open (INDEX, ">$ForumsPath/Forum$thisforum[8]/index.html"); 
print INDEX "";
close (INDEX);

open (INDEX, ">$ForumsPath/Forum$thisforum[8]/private-$DIRPW/ANNC/index.html"); 
print INDEX "";
close (INDEX);
open (INDEX, ">$ForumsPath/Forum$thisforum[8]/private-$DIRPW/HTML/index.html"); 
print INDEX "";
close (INDEX);
open (INDEX, ">$ForumsPath/Forum$thisforum[8]/private-$DIRPW/index.html"); 
print INDEX "";
close (INDEX);
} # check if exists


}  else {
$DIRPW = "$thisforum[7]";


}

if ($Found eq "true") {
if ($ThisPrivate eq "private") {
	$ThisPermission = "private";
} else {
	$ThisPermission = "$ThisTopic\&$ThisReply";
}
chomp($thisforum[14]);

$forums[$ArrayNumber] = ("$ThisCategory|$ThisName|$ThisDescription|$ThisStatus|$ThisHTML|$ThisUBB|$ThisPermission|$DIRPW|$ForumNumber||$ThisUBBImages|$ThisModNotify|$ForumPW|$PrivateMax|$thisforum[14]\n");
}


#write to forums file

&Lock("lock.file");
open (FORUMS, ">$VariablesPath/forums.cgi"); 
print FORUMS (@forums);
close (FORUMS);
&Unlock("lock.file");

$UserNameCoded = &HTMLIFY($UserNameCheck);
$PasswordCoded = &HTMLIFY($PasswordCheck);

$ForumHeader = $in{'ForumHeader'};
$ForumFooter = $in{'ForumFooter'};
$ForumHeader =~ quotemeta($ForumHeader);
$ForumFooter =~ quotemeta($ForumFooter);
$ForumHeader =~ s/\"/\\"/g;
#$ForumFooter =~ s/\@/\\@/g;
$ForumFooter =~ s/\"/\\"/g;
$ForumHeader = &LimitReturns($ForumHeader);
$ForumFooter = &LimitReturns($ForumFooter);
	

#write other fields to forumstyles.file
open(FORSTYL, ">$ForumsPath/Forum$ForumNumber/forumstyles.file");
if ($in{'RestoreDefaultStyles'} ne "yes") {
print FORSTYL ('$BGColor = "' . "$in{'BGColor'}" . '"' . ";\n");
print FORSTYL ('$TextColor = "' . "$in{'TextColor'}" . '"' . ";\n");
print FORSTYL ('$LinkColor = "' . "$in{'LinkColor'}" . '"' . ";\n");
print FORSTYL ('$ActiveLinkColor = "' . "$in{'ActiveLinkColor'}" . '"' . ";\n");
print FORSTYL ('$VisitedLinkColor = "' . "$in{'VisitedLinkColor'}" . '"' . ";\n");
print FORSTYL ('$TableBorderColor = "' . "$in{'TableBorderColor'}" . '"' . ";\n");
print FORSTYL ('$TableStripTextColor = "' . "$in{'TableStripTextColor'}" . '"' . ";\n");
print FORSTYL ('$TableColorStrip = "' . "$in{'TableColorStrip'}" . '"' . ";\n");
print FORSTYL ('$TimeColor = "' . "$in{'TimeColor'}" . '"' . ";\n");
print FORSTYL ('$AltColumnColor1 = "' . "$in{'AltColumnColor1'}" . '"' . ";\n");
print FORSTYL ('$AltColumnColor2 = "' . "$in{'AltColumnColor2'}" . '"' . ";\n");
print FORSTYL ('$CategoryStripColor = "' . "$in{'CategoryStripColor'}" . '"' . ";\n");
print FORSTYL ('$CategoryStripTextColor = "' . "$in{'CategoryStripTextColor'}" . '"' . ";\n");
print FORSTYL ('$CopyrightTextColor = "' . "$in{'CopyrightTextColor'}" . '"' . ";\n");
print FORSTYL ('$FontFace = "' . "$FontFace" . '"' . ";\n");
print FORSTYL ('$TableWidth = "' . "$TableWidth" . '"' . ";\n");
print FORSTYL ('$TextSize = "' . "$TextSize" . '"' . ";\n");
print FORSTYL ('$PageBackground = "' . "$PageBackground" . '"' . ";\n");
print FORSTYL ('$BBTitle = "' . "$in{'BBTitle'}" . '"' . ";\n");
print FORSTYL ('$BBTopic = "' . "$in{'BBTopic'}" . '"' . ";\n");
print FORSTYL ('$BBReply = "' . "$in{'BBReply'}" . '"' . ";\n");
print FORSTYL ('$ThreadClosed = "' . "$in{'ThreadClosed'}" . '"' . ";\n");
print FORSTYL ('$profilegif = "' . "$in{'profilegif'}" . '"' . ";\n");
print FORSTYL ('$mailgif = "' . "$in{'mailgif'}" . '"' . ";\n");


}  else {

eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
require "Styles.file";

};

print FORSTYL ('$BGColor = "' . "$BGColor" . '"' . ";\n");
print FORSTYL ('$TextColor = "' . "$TextColor" . '"' . ";\n");
print FORSTYL ('$LinkColor = "' . "$LinkColor" . '"' . ";\n");
print FORSTYL ('$ActiveLinkColor = "' . "$ActiveLinkColor" . '"' . ";\n");
print FORSTYL ('$VisitedLinkColor = "' . "$VisitedLinkColor" . '"' . ";\n");
print FORSTYL ('$TableBorderColor = "' . "$TableBorderColor" . '"' . ";\n");
print FORSTYL ('$TableStripTextColor = "' . "$TableStripTextColor" . '"' . ";\n");
print FORSTYL ('$TableColorStrip = "' . "$TableColorStrip" . '"' . ";\n");
print FORSTYL ('$TimeColor = "' . "$TimeColor" . '"' . ";\n");
print FORSTYL ('$AltColumnColor1 = "' . "$AltColumnColor1" . '"' . ";\n");
print FORSTYL ('$AltColumnColor2 = "' . "$AltColumnColor2" . '"' . ";\n");
print FORSTYL ('$CategoryStripColor = "' . "$CategoryStripColor" . '"' . ";\n");
print FORSTYL ('$CategoryStripTextColor = "' . "$CategoryStripTextColor" . '"' . ";\n");
print FORSTYL ('$CopyrightTextColor = "' . "$CopyrightTextColor" . '"' . ";\n");
print FORSTYL ('$FontFace = "' . "$FontFace" . '"' . ";\n");
print FORSTYL ('$TableWidth = "' . "$TableWidth" . '"' . ";\n");
print FORSTYL ('$TextSize = "' . "$TextSize" . '"' . ";\n");
print FORSTYL ('$PageBackground = "' . "$PageBackground" . '"' . ";\n");
print FORSTYL ('$BBTitle = "' . "$BBTitle" . '"' . ";\n");
print FORSTYL ('$BBTopic = "' . "$BBTopic" . '"' . ";\n");
print FORSTYL ('$BBReply = "' . "$BBReply" . '"' . ";\n");
print FORSTYL ('$ThreadClosed = "' . "$ThreadClosed" . '"' . ";\n");
print FORSTYL ('$profilegif = "' . "$profilegif" . '"' . ";\n");
print FORSTYL ('$mailgif = "' . "$mailgif" . '"' . ";\n");

}
print FORSTYL ('$ForumHeader = "' . "$ForumHeader" . '"' . ";\n");
print FORSTYL ('$ForumFooter = "' . "$ForumFooter" . '"' . ";\n");
print FORSTYL "1;";
close(FORSTYL);
chmod(0666, "$ForumsPath/Forum$ForumNumber/forumstyles.file");


&EndUpdate("F O R U M S &nbsp;&nbsp;&nbsp;&nbsp; S E T T I N G S  &nbsp;&nbsp;&nbsp;&nbsp; U P D A T E D", "Thank you!  Your UBB Forum Settings have now been updated as you requested.<P><FONT COLOR=\"#800000\">Note: if you are changing any  private forums from Minimum to Maximum Security (or from Maximum to Minimum), you must Update Threads after you are finished making changes to all forum variables.  Otherwise, your topic pages will not display properly!</FONT><P>To return to your Forum Settings Summary, <A HREF=\"cpanel3.cgi?action=forums&StartPoint=0&inside=true\">click here</A>.");
exit;

}


sub Cats {
&get_cookie;  #retrieves all current cookies

if ($cookie{UserNameCP}) {
$UserName = "$cookie{UserNameCP}";
$Password = "$cookie{PasswordCP}";
&VerifyAdmin($UserName, $Password);

if ($Proceed eq "true") {
	&DoCats;
} else {
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file
require "Styles.file";

};
&StandardHTML("Sorry, you are not authorized to access the forum summary.");
exit;
}

} 
elsif ($in{'UserName'} ne "") {

$UserName = "$in{'UserName'}";
$Password = "$in{'Password'}";
&VerifyAdmin($UserName, $Password);

if ($Proceed eq "true") {
	&DoCats;
} else {
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file
require "Styles.file";

};
&StandardHTML("Sorry, you are not authorized to access the forum summary.");
exit;
}

}  else {
$PageTitle = "C A T E G O R Y &nbsp;&nbsp;&nbsp;&nbsp; S E T T I N G S";
$PageIntro = "In order to add, review, or organize your categories, you must first identify yourself.  You will not have to do this each time if you allow cookies to be set from your browser.";
$HiddenFields = qq(<INPUT TYPE="HIDDEN" NAME="action" VALUE="cats">);
&QueryForID;
exit;
}

} #end Cats sr

sub DoCats {
&AssembleCats;

if ($UserNameCheck ne "") {
$UserNameFill = "$UserNameCheck";
}  else {
$UserNameFill = "$UserName";
}
$UserNameFill = &HTMLIFY($UserNameFill);

if ($PasswordCheck ne "") {
$PasswordFill = "$PasswordCheck";
}  else {
$PasswordFill = "$Password";
}
$PasswordFill = &HTMLIFY($PasswordFill);

if ( ($in{'sortby'} eq "") || ($in{'sortby'} eq "Category")) {
	$SortByCategory = "SELECTED";
	$SortIt = "Category";
}
elsif ($in{'sortby'} eq "Number") {
	$SortByNumber = "SELECTED";
		$SortIt = "Number";
	
}  else {
	$SortByAlpha = "SELECTED";
	$SortIt = "Alpha";
}

$PageTitle = "S E T &nbsp;&nbsp;&nbsp;&nbsp; C A T E G O R I E S";
&HEADER2HTML;

print<<CatHTML;
<FONT SIZE="2" FACE="Verdana, Arial">In this section, you may create categories and change your preferred display order for all categories. 
<P>
The "Order" field below determines the order that the categories are displayed.  You should only place numbers in the order fields.  For instance, to arrange 5 categories by order, place a number value of 1 through 5 in each of the forums.  The lower the number, the higher the category will appear in your forum/category lists.  The category orders take precedence over the forum orders.  
<P>
To delete a category, simply erase its name from the field below.  The category number will remain- to be used in the future if you like, but the category will not appear in your forums.
<P>

<TABLE BORDER=0 width=100%>
<TR><TD align=left valign=bottom><FONT SIZE="2" FACE="Verdana, Arial">
<A HREF="cpanel.cgi?action=addforums">Add Forum</a> | <A HREF="cpanel3.cgi?action=forums&StartPoint=0&inside=true">Forum Summary</A></font></TD>
<TD align=right valign=bottom>
<FORM ACTION="$CGIURL/cpanel3.cgi" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="cats">
<SELECT NAME="sortby">
	<OPTION value="Category" $SortByCategory>Sort By Display Order
	<OPTION value="Number" $SortByNumber>Sort By Forum Number
	<OPTION value="Alpha" $SortByAlpha>Sort Alphabetically 
</SELECT><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Sort">
</FORM>
</td></TR>
</TABLE>
 </FONT>
<P>
<center>
<FORM ACTION="cpanel3.cgi" METHOD="POST" NAME="THEFORM">
<table border=0 cellpadding=0 cellspacing=0 width="95%"><TR><td bgcolor="#000000">
<table border=0 cellpadding=4 border=0 cellspacing=1 width=100%>

<TR bgcolor="Olive"><TD COLSPAN=3 align=center>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="White"><B>Category Summary</B></FONT>
</TR>
<TR bgcolor="#B8C6AE">
<TD><FONT SIZE="2" FACE="Verdana, Arial">Category Number</font></TD>
<TD><FONT SIZE="2" FACE="Verdana, Arial">Category Name</font></TD>
<TD><FONT SIZE="2" FACE="Verdana, Arial">Display Order</font></TD>
</TR>
CatHTML

#retreive category list
@CATEGORIES = &OpenFile("$NonCGIPath/categories.file");
####

if ($SortIt eq "Alpha") {
foreach $check(@CATEGORIES) {
@getalpha = split(/\|\|\|/, $check);
$AlphaUC = uc($getalpha[1]);
$AlphaLine = "$AlphaUC||**||$check";
push(@sortthis, $AlphaLine);
}
@sorted = sort(@sortthis);
foreach $uno(@sorted) {
($junk, $keep) = split(/\|\|\*\*\|\|/, $uno);
chomp($keep);
push(@catz, $keep);
}

} 
elsif ($SortIt eq "Number") {
@catz = @CATEGORIES;
}  else {
@catz = sort(@CATEGORIES);
}

foreach $one(@catz) {
($CatOrder, $CatName, $CatNumber) = split(/\|\|\|/, $one);
chomp($CatNumber);
if ($CatOrder eq "") {
	$CatOrder = $CatNumber;
}
$CatOrderSimp = $CatOrder + 0;

print<<ROW;
<TR bgcolor="#FFFFFF">
<TD><FONT SIZE="2" FACE="Verdana, Arial">$CatNumber</font></TD>
<TD><INPUT TYPE="TEXT" NAME="CatName|||$CatNumber" VALUE="$CatName" SIZE=30 MAXLENGTH=100></TD>
<TD><INPUT TYPE="TEXT" NAME="CatOrder|||$CatNumber" VALUE="$CatOrderSimp" SIZE=5 MAXLENGTH=5></TD>
</TR>
ROW

}

print<<BottomForumHTML;
<TR bgcolor="Olive"><TD COLSPAN=3>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="White"><B>Add New Categories?</B><BR>If you want to add additional categories, add them in the field below.  Place each new category in brackets, as in [Baseball Teams] [Hockey Teams] [Football Teams].  If you do not use the proper formatting, the categories will not be added!  Leave the field below blank if you are not adding new categories.<P><CENTER><INPUT TYPE="TEXT" NAME="NewCats" SIZE=50 MAXLENGTH=400></CENTER></FONT>
</TR>

</table>
</td></tr></table>
<P>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="setcats">

<BR>

<P>
<HR>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#000080"><B>Enter Your UserName & Password:</font>
<p>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#000080">
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B>
<p><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Category Changes Now"></form>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000">Ultimate Bulletin Board, &copy; Infopop Corporation (formerly Madrona Park, Inc.), 1998 - 1999.</FONT>
</CENTER></font>
</BODY>
</HTML>
BottomForumHTML
}  ## END DoCats

sub SetCats {
&VerifyAdmin($in{'UserNameCheck'}, $in{'PasswordCheck'});
if ($Proceed eq "true") {
	 &DoProcessCats;
}
}  ##END SendForums sr

sub DoProcessCats {
foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	if ($Name =~ m/CatName/) {
	($Trash, $CatNumber) = split(/\|\|\|/, $Name);
	push (@AdjustCats, $CatNumber);
	}
} # end foreach $row

# now we have list of cat numbers to adjust

#read current forum data
my @CATS = &OpenFile("$NonCGIPath/categories.file");

#assemble new line for each revised category
for $num(@AdjustCats) {
chomp($num);
foreach $row2(@in) {
	($Name, $Value) = split ("=", $row2);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	if ($Name eq "CatName|||$num") {
		$ThisName = $Value;
		$ThisName =~ s/"/&quot;/g;
	}
	if ($Name eq "CatOrder|||$num") {
		$ThisOrderPre = $Value;
		$ThisOrder = &Do6Digit($ThisOrderPre);
	}
} # end foreach $row2

$arrayrow = ($num - 1);

$ThisCatLine = $CATS[$arrayrow];
chomp($ThisForumLine);
@thiscat = split(/\|/, $ThisCatLine);

$CATS[$arrayrow] = ("$ThisOrder|||$ThisName|||$num\n");

}  #end for each @AdjustForum

$TotalCats = @CATS;
$NextCat = $TotalCats + 1;

#check for new cats
if ($in{'NewCats'} ne "") {
my $NewCats = $in{'NewCats'};
$_ = $NewCats;
while (m/(\[)(.*?)(\])/g) {
	push(@matches, $2);
}

foreach $one(@matches) {
if ($one !~ m/(\[|\])/) {
chomp($one);
$NewOrder = &Do6Digit($NextCat);
$CatLine = "$NewOrder|||$one|||$NextCat\n";
push(@CATS, $CatLine);
$NextCat++;
}
}
}

#write to cats file

&Lock("lock.file");
open (FORUMS, ">$NonCGIPath/categories.file"); 
print FORUMS (@CATS);
close (FORUMS);
&Unlock("lock.file");

$UserNameCoded = &HTMLIFY($UserNameCheck);
$PasswordCoded = &HTMLIFY($PasswordCheck);

&EndUpdate("C A T E G O R Y &nbsp;&nbsp;&nbsp;&nbsp; S E T T I N G S  &nbsp;&nbsp;&nbsp;&nbsp; U P D A T E D", "Thank you!  Your UBB Category Settings have now been updated as you requested.<P><P>Go To: <A HREF=\"$CGIURL/cpanel3.cgi?action=forums&StartPoint=0&inside=true\">Forum Summary</A> | <A HREF=\"$CGIURL/cpanel.cgi?action=addnewforum\">Add New Forum</A> | <A HREF=\"$CGIURL/cpanel3.cgi?action=cats\">Category Settings</A>");
exit;
} ## END DO PROCESS CATS


sub QueryForID {
print<<ForumLoginHTML;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.THEFORM.UserName.value = getCookie("UserNameCP");
document.THEFORM.Password.value = getCookie("PasswordCP");
	}  else {
	document.THEFORM.UserName.focus();
}
}

function Check(form)  {
if ((form.Password.value == "") || (form.UserName.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<BR><center>
<FONT SIZE="2" FACE="Verdana, Arial">$PageTitle</FONT>
</center><P><FONT SIZE="1" FACE="Verdana, Arial">
<center>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">You must be an administrator to change forum settings.</FONT>
<P><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#800000">
$PageIntro</font>
<P>
<FORM ACTION="cpanel3.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
ForumLoginHTML

&IDTable;

print<<ENDIT;
<P></font>
$HiddenFields
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Identification Now">
</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="Verdana, Arial">Copyright, Infopop Corporation (formerly Madrona Park, Inc.), 1998-1999.
</FONT>
</CENTER></BODY></HTML>
ENDIT
}