#!/usr/local/bin/perl

#
###                         PRIMARY UBB SCRIPT                ##
#
# Ultimate Bulletin Board is copyright Infopop Corporation (formerly Madrona Park, Inc.), 1998.
#
#       ------------ ubbmail.cgi -------------
#
#
#  Infopop Corporation (formerly Madrona Park, Inc.) offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

eval {

  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file

require "UltBB.setup";
require "Date.pl";
require "mail-lib.pl";
require "Styles.file";
require "ubb_library.pl";
require "ubb_library2.pl";
require "mods.file";
};

if ($@) {
	print ("Content-type: text/html\n\n");
    print "Error including required files: $@\n";
    print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
 exit;
}

use Socket;


&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
		if ($Name eq "forum") {
			$Forum = $Value;
			$Forum =~ s/\/\\//g;
			$ForumCoded = &HTMLIFY($Forum);
			$ForumCoded =~ tr/ /+/;
			$Forum = &UNHTMLIFY($Forum);
		}
		if ($Name eq "Subject") {
			$Subject = $Value;
			$Subject =~ s/<.+?>//g;
		}
		if ($Name eq "UserName") {
			$UserName = $Value;
			$UserName = &UNHTMLIFY($UserName);
			$UserNameCoded = &HTMLIFY($UserName);
			$UserNameCoded =~ tr/ /+/;
		}
		if ($Name eq "Password") {
			$Password = $Value;
			$Password = &UNHTMLIFY($Password);
			$PasswordCoded = &HTMLIFY($Password);
			$PasswordCoded =~ tr/ /+/;
			
		}
}  # end FOREACH $row

print ("Content-type: text/html\n\n");


if ($VariablesPath eq "") {
	$VariablesPath = $CGIPath;
}

#create random numbers for headers/footers
$RandomNumber = &MakeRandomNumber;
$RandomNumber2 = $RandomNumber + 100074;

if ($Header ne "") {
$Header =~ s/UBBrandomX/$RandomNumber/isg;
$Header =~ s/UBBrandomY/$RandomNumber2/isg;
}
if ($Footer ne "") {
$Footer =~ s/UBBrandomX/$RandomNumber/isg;
$Footer =~ s/UBBrandomY/$RandomNumber2/isg;
}


#adjust bgcolor variables
if ($BGColor ne ""){
$BGColor = qq(bgcolor="$BGColor");
}
if ($AltColumnColor1 ne ""){
$AltColumnColor1 = qq(bgcolor="$AltColumnColor1");
}
if ($AltColumnColor2 ne ""){
$AltColumnColor2 = qq(bgcolor="$AltColumnColor2");
}
if ($CategoryStripColor ne ""){
$CategoryStripColor = qq(bgcolor="$CategoryStripColor");
}
if ($TableColorStrip ne ""){
$TableColorStrip = qq(bgcolor="$TableColorStrip");
}
if ($PageBackground ne ""){
$PageBackground = qq(background="$NonCGIURL/$PageBackground");
}

if ($TableBorderColor ne ""){
$TableWidth2 = "100%";
$BorderTop = qq(<table border=0 cellpadding=0 cellspacing=0 width="$TableWidth"><TR><td bgcolor="$TableBorderColor">);
$BorderBottom = qq(</td></tr></table> );
}  else {
$TableWidth2 = $TableWidth;
$BorderTop = "";
$BorderBottom = "";
}

if ($in{'action'} eq "subscribesubmit") {
 &SubscribeSubmit;
 } 

if ($in{'action'} eq "unsubscribe") {
 &Unsubscribe;
 } 
if ($in{'action'} eq "adddigest") {
 &AddDigest;
 } 
if ($in{'action'} eq "mailusers") {
 &MailUsers;
 } 
 
if ($in{'action'} eq "subscribe") {
 &Subscribe;
 } 
 
if ($in{'action'} eq "sendthedigest") {
 &SendTheDigest;
 exit;
 } 
if ($in{'action'} eq "subscriberedit") {
 &SubscriberEdit;
 exit;
 } 
if ($in{'action'} eq "deletedigest") {
 &DeleteTheDigest;
 exit;
 } 
 
if ($in{'action'} eq "subscribelistemail") {
 &SubscribeListEmail;
 exit;
 } 
if ($in{'action'} eq "subscribelistintro") {
 &SubscribeListIntro;
 } 
if ($in{'action'} eq "digeststart") {
 &DigestStart;
 } 
 
sub MailUsers {

if ($in{'createlist'} eq "yes") {
&CreateList;
exit;
}

if ($in{'start'} eq "0") {

if ( ($in{'UserName'} eq "") || ($in{'Password'} eq "") || ($in{'Subject'} eq "") || ($in{'Message'} eq "") ) {
 &StandardHTML("You forgot to complete all required fields.  Please go back and try again.");
exit;
}

}  else {

if ( ($in{'UserName'} eq "") || ($in{'Password'} eq "")) {
 &StandardHTML("There seems to be a problem with your username.  We cannot continue processing this mass email.");
exit;
}
}

&VerifyAdmin($UserName, $Password);

if ($Proceed ne "true") {
	exit;
}

if ($UseEmail eq "ON") {
#then continue
	$subject = $Subject;
	$message = $in{'Message'};
	$message =~ s/<BR>/\n/ig;
	$message =~ s/<P>/\n\r\n/ig;
	$message =~ s/<.+?>//g;
	$Message = &ConvertReturns("$message");
	
if ($in{'start'} eq "0") {
	$subject = $Subject;
	$message = $in{'Message'};
	$message =~ s/<BR>/\n/ig;
	$message =~ s/<P>/\n\r\n/ig;
	$message =~ s/<.+?>//g;
	$Message = &ConvertReturns("$message");
	
#print to file for record-keeping
unless (-e "$NonCGIPath/emaillog") {
mkdir ("$NonCGIPath/emaillog", 0777);
chmod(0777, "$NonCGIPath/emaillog");
}

&GetDateTime;
$EmailNumber = "$RunonDate$JSTime$sec";

open (EMAILLOG, ">$NonCGIPath/emaillog/$EmailNumber.cgi"); 
print EMAILLOG "$subject\n";
print EMAILLOG "$Message\n";
close (EMAILLOG);
chmod(0666, "$NonCGIPath/emaillog/$EmailNumber.cgi");

#print emaillist to file
&GetEmails;
foreach $thisline(@EmailList) {
chomp($thisline);
	($sendto, $profnum) = split(/\?\?/, $thisline);
	@profilestats = &OpenProfile("$profnum.cgi");
	$AllowMassMail = $profilestats[14];
	chomp($AllowMassMail);
	
	if ($AllowMassMail ne "no") {
		push(@emaillist, $sendto);
	}
}
open (EMAIL, ">$NonCGIPath/emaillisttemp.cgi"); 
foreach $dos(@emaillist) {
chomp($dos);
print EMAIL "$dos\n";
}
close(EMAIL);
chmod(0666, "$NonCGIPath/emaillisttemp.cgi");

}  else {

#open exiting email log file
$EmailNumber = $in{'EmailNumber'};

open (EMAILLOG, "$NonCGIPath/emaillog/$EmailNumber.cgi"); 
@thisemail = <EMAILLOG>;
close (EMAILLOG);

$subject = $thisemail[0];
chomp($subject);
$message = $thisemail[1];
chomp($message);
	$message =~ s/<BR>/\n/ig;
	$message =~ s/<P>/\n\r\n/ig;
	$message =~ s/<.+?>//g;
}

#get registered users
open (GETEMAIL, "$NonCGIPath/emaillisttemp.cgi"); 
@themembers = <GETEMAIL>;
close(GETEMAIL);

$TotalMembers = @themembers;
$TotalMembers--; #adjust for array context

#limit processing to 70 emails at a time
$Start = $in{'start'} + 0;
$End = $Start + 70;

if ($TotalMembers <= $End) {
	$End = $TotalMembers;
	$EndLoop = "true";
}  else {
	$StartHere = $End + 1;
}

$StartDisplay = $Start +1;
$EndDisplay = $End +1;

	@thesemembers = @themembers[$Start... $End];
	$EmailLine = "";
foreach $sendto(@thesemembers) {
	chomp($sendto);
	if ($sendto =~ /\S+\@\S+\.\S+/) {

if ($SMTPEmail eq "On") {
&SendEmail;
}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
}
	$EmailLine .= "$sendto<BR>";
	}

}

if ($EndLoop eq "true") {
$FinishWording = "We have finished emailing all eligible registered users.";
&FinishMail;
unlink "$NonCGIPath/emaillisttemp.cgi";
}  else {
&ContinueMail;
}

}  else {
&StandardHTML("You have turned your email functions OFF in your control panel.  You cannot use this feature unless EMAIL is turned ON in the general variables section of your control panel.");
exit;
} #id use email is not on
 } #End Mail USers sr

sub ContinueMail {
print<<TheMail;
<HTML><HEAD>
<meta http-equiv="Refresh" content="2; URL=$CGIURL/ubbmail.cgi?action=mailusers&start=$StartHere&UserName=$UserNameCoded&Password=$PasswordCoded&EmailNumber=$EmailNumber">
</head>
<BODY bgcolor=#FFFFFF>
<center>
<FONT FACE="Verdana, Arial" SIZE="2"><B>
<FONT FACE="Courier New" SIZE="5" COLOR="Maroon"><B>Processing....Please Wait!</B></FONT>
<P>
We are emailing all registered users who allow such emails to be received.
<P>
We just emailed Members <FONT FACE="Verdana" SIZE="3" COLOR="Navy">$StartDisplay</font> to <FONT FACE="Verdana" SIZE="3" COLOR="Navy">$EndDisplay</font>...
<P></center>
Here's the list of emails just delivered:
<P>
$EmailLine
</FONT>
</BODY>
</HTML>
TheMail

exit;
}

sub FinishMail {
print<<TheMail;
<HTML><HEAD>
</head>
<BODY bgcolor=#FFFFFF>
<center>
<FONT FACE="Verdana, Arial" SIZE="2"><B>
<FONT FACE="Courier New" SIZE="5" COLOR="Maroon"><B>Processing Complete!</B></FONT>
<P>
<FONT SIZE="1" FACE="Verdana, Arial"><A HREF="cpanel.cgi?action=digest">Digest Center</A> | <A HREF="cpanel.cgi?action=mail">Mail Users</a> </FONT>
<BR>
$FinishWording
<P></center>
Here's the list of emails just delivered:
<P>
$EmailLine

</FONT>
</BODY>
</HTML>
TheMail
exit;
}

sub CreateList {
$NameFound = "no";
$ProfileNumber = &GetUserNumber($in{'UserName'});
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$ProfileNumber.cgi");
			
	if ($Password eq "$theprofile[1]") {
	$Permission = "$theprofile[4]";
	&CheckPermissions;
	  if ($AdminPermission ne "true") {
	    &StandardHTML("Sorry, but you are not an administrator.");
exit;
	}
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
exit;
	}
		
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
exit;
}  ##END IF/ELSE NAME CHECK BLOCK
&GetEmails;

foreach $thisline(@EmailList) {
chomp($thisline);
	($sendto, $profnum) = split(/\?\?/, $thisline);
	@profilestats = &OpenProfile("$profnum.cgi");
	$AllowMassMail = $profilestats[14];
	chomp($AllowMassMail);
	
	if ($AllowMassMail ne "no") {
		push(@emaillist, $sendto);
	}
}

if ($in{'delimit'} eq "comma") {
	$sep = ",";
}  else {
	$sep = "\n";
}

open(LIST, ">$NonCGIPath/emaillist.cgi");
foreach $uno(@emaillist) {
chomp($uno);
print LIST ("$uno" . "$sep");
}
close(LIST);

print<<Confirm;
<HTML><HEAD>
</head>
<BODY bgcolor=#FFFFFF>
<FONT FACE="Verdana, Arial" SIZE="2">
<FONT FACE="Courier New" SIZE="5" COLOR="Maroon"><B>Email List Compiled!</B></FONT>
<blockquote>
We have created a list of email addresses for all registered users.  This list has been delimited by $in{'delimit'} and placed in a file called emaillist.cgi in your UBB Non CGI directory.
<P>
<CENTER><B>path: $NonCGIPath/emaillist.cgi</B></CENTER>
<P>
You may download that file from your web server immediately. 
<P>
Note: registered users that requested not to be included in these mailings are not included in the list.
</blockquote>

</FONT>
</BODY>
</HTML>
Confirm
}  #end Create List sr

sub DigestStart {

if ( ($in{'UserName'} eq "") || ($in{'Password'} eq "") || ($in{'DigestOption'} eq "") ) {
 &StandardHTML("You forgot to complete all required fields.  Please go back and try again.");
exit;
}  

&VerifyAdminMod($UserName, $Password);

if ($Proceed ne "true") {
	exit;
}

#continue if get this far...
if ($in{'DigestOption'} eq "1") {
	&CreateNewDigest($Status);
}
elsif ($in{'DigestOption'} eq "2") {
	&DeleteDigest($Status);
}
elsif ($in{'DigestOption'} eq "3") {
	&AddDelSubscriber($Status);
} else {
	&SendDigest($Status);
}
}  #end DigestStart sr

sub CreateNewDigest {
$UserStatus = shift;

$PageTitle = "Create New Digest";
&DigestTopHTML;

print<<MIDDLE;
A digest is a summary of posts in a specific forum on your bulletin board.  A digest must first be created before you can add subscribers for it or send the digest to those subscribers.
<P>
Once a digest has been created for any of your forums, a "Subscribe to Digest" link will appear automatically on your UBB, allowing visitors to your UBB to subscribe to any available digests.  <B>Subscribers must be registered on your bulletin board.</B>  We do not recommend that you overuse this feature.  In many ways, digests can be counter-productive in terms of getting users to return to your web site, since users may wait until they receive an emailed digest before returning.
<P>
Once a digest has been created, you use the "Send Digest" option in the <A HREF="$CGIURL/cpanel.cgi?action=digest">Digest Center</A> to send a new digest email to that digest's subscribers.
<P>
<FORM ACTION="ubbmail.cgi" METHOD="POST" NAME="THEFORM">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="adddigest">
<table border=0 width=100%>
<TR bgcolor="#B0BB9D">
<TD colspan=2 align=center>
<FONT SIZE="2" FACE="Verdana, Arial">Add New Digest:</FONT>
</td></tr>
<TR bgcolor="#C7C6BA">
<TD>
<FONT SIZE="2" FACE="Verdana, Arial">Make Digest From Which Forum?</FONT><BR><FONT SIZE="1" FACE="Verdana, Arial">The forum list to the right contains only those forums that have not already had digests created and which you are permitted to create.</font>
</td><td valign=top><SELECT NAME="ForumChoice">
MIDDLE

&GetForums;

print<<BOTTOM;
</SELECT></td>
</tr>
</table>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">Note: If you are a moderator, you can only create a digest for a forum that you are a moderator.  Administrators may create digests for any forum.  You cannot make a digest for a private forum.</FONT>
<HR>
<CENTER><FONT Size="2" FACE="Verdana, Arial" COLOR="#000080"><B>Enter Your UserName & Password:</font>
<p>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#000080">
UserName: <INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13></FONT></B>
<P>
<CENTER><INPUT TYPE="SUBMIT" NAME="SUBMIT" VALUE="Add New Digest Now"></CENTER>
<P><BR>
</form>
</body></html>
BOTTOM
} #end CreateNewDigest

sub DigestTopHTML {
print<<HEADER;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if ((testUserNameCP == null) && (CookieUNCP != "")){
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	} 

function SetCursor() {
if (testUserNameCP != null) {  
	document.forms[0].UserName.value = getCookie("UserNameCP");
document.forms[0].Password.value = getCookie("PasswordCP");
	}  
}

function Check(form)  {
if ((form.Password.value == "") || (form.UserName.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<BR>
<center>
<FONT SIZE="5" FACE="Courier New"><B>$PageTitle</B></FONT>
</center>
<FONT SIZE="2" FACE="Verdana, Arial">
<p>
HEADER

}  #end DigestTopHTML

sub AddDelSubscriber {
$UserStatus = shift;

$PageTitle = "Add or Delete Subscribers From a Digest";
&DigestTopHTML;

print<<UPMIDDLE;
People can subscribe or unsubscribe to your digests from your <A HREF="$CGIURL/ubbmail.cgi?action=subscribe">Digest Subscription Center</A>.  As an administrator or moderator, however, you can also add or remove users from a digest subscription list here in your control panel.  Please provide the email address(es) you wish to add or delete and the name of the digest affected.  Note that all subscribers that you add must be registered users. We do not verify that each email you enter here is for a registered user, however.
<P>
<FORM ACTION="ubbmail.cgi" METHOD="POST" NAME="THEFORM">

<INPUT TYPE="HIDDEN" NAME="action" VALUE="subscriberedit">
Add/Remove Subscribers From This Digest: 
<SELECT NAME="ForumChoice">
<OPTION VALUE="" SELECTED>Select One:
UPMIDDLE

&GetForums2;

print<<BOTTOM;
</select>
<P>
<table border=0 width=100%>
<TR bgcolor="#B0BB9D">
<TD align=center>
<FONT SIZE="2" FACE="Verdana, Arial">Add To Digest:</FONT>
</td>
<TD align=center>
<FONT SIZE="2" FACE="Verdana, Arial">Delete From Digest:</FONT>
</td>
</tr>
<TR bgcolor="#C7C6BA">
<TD>
<FONT SIZE="1" FACE="Verdana, Arial">Type the email address you wish to add to this digest's subscription list.  If adding more than one email, separate email addresses with spaces only (as in, ted\@test.com bob\@youremail.com).</font><BR>
<TEXTAREA NAME="AddEmail" ROWS=4 COLS=20>
</TEXTAREA>
</td>
<TD>
<FONT SIZE="1" FACE="Verdana, Arial">Type the email address you wish to DELETE from this digest's subscription list.  If deleting more than one email, separate email addresses with spaces only (as in, ted\@test.com bob\@youremail.com).</font><BR>
<TEXTAREA NAME="DeleteEmail" ROWS=4 COLS=20>
</TEXTAREA>
</td>
</tr>
</table>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">Note: If you are a moderator, you can only add/delete subscribers from digests for which you a moderator.  Administrators may create digests for any forum.  You cannot make a digest for a private forum.</FONT>
<HR>
<CENTER><FONT Size="2" FACE="Verdana, Arial" COLOR="#000080"><B>Enter Your UserName & Password:</font>
<p>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#000080">
UserName: <INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13></FONT></B>
<P>
<CENTER><INPUT TYPE="SUBMIT" NAME="SUBMIT" VALUE="Amend Subscriber List Now"></CENTER>
<P><BR>
</form>
</body></html>
BOTTOM
} #end AddDelSubscriber

sub DigestTopHTMLnj {
print<<HEADER;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000">
<BR>
<center>
<FONT SIZE="5" FACE="Courier New"><B>$PageTitle</B></FONT>
</center>
<FONT SIZE="2" FACE="Verdana, Arial">
<p>
HEADER

}  #end DigestTopHTMLnj

sub GetForums {
@forumlist = &OpenForumsFile;
@digestsummary = &GetDigestSummary;
@semifinal = @blank;
@final = @blank;

foreach $uno(@forumlist) {
chomp($uno);
@thisforum = split(/\|/, $uno);
if (($thisforum[3] eq "On") && ($thisforum[6] ne "private")) {
if ($UserStatus eq "Administrator") {
$goodline = "$thisforum[8]|$thisforum[1]";
push(@semifinal, $goodline);
} else {
$Moderator = ("Forum" . "$thisforum[8]" . "Moderator");
$Moderator = $$Moderator;
@mods = split(/\|\|\^\|\|/, $Moderator);

$ModMatch = "";
foreach $unomod(@mods) {
if ($unomod eq "$UserName") {
	$ModMatch = "true";
}
}
	if ($ModMatch eq "true") {
		$goodline = "$thisforum[8]|$thisforum[1]";
		push(@semifinal, $goodline);
	}
}
}
}

#now compare list of eligible forums with list of existing digests

foreach $one(@semifinal) {
chomp($one);

if (@digestsummary) {
	($thisnumber, $junk) = split(/\|/, $one);
	$DeleteIt = "";
	foreach $check(@digestsummary) {
		@checkdigest = split(/\|/, $check);
		if ($checkdigest[0] eq "$thisnumber") {
			$DeleteIt = "true";
		}
	}
	if ($DeleteIt ne "true") {
		push(@final, $one);
	}
}  else {
push(@final, $one);
}
}

if ($final[0] eq "") {
	print qq(<OPTION value="">Sorry, No Forums Are Eligible To Be Added);
	
}  else {
foreach $thou(@final) {
chomp($thou);
($thenum, $thename) = split(/\|/, $thou);
print qq(<OPTION value="$thenum">$thename);
}
}
}  #end GetForums


sub GetForums2 {
@digestsummary = &GetDigestSummary;
@final = @blank;

foreach $uno(@digestsummary) {
chomp($uno);
@thisdigest = split(/\|/, $uno);
if ($UserStatus eq "Administrator") {
push(@final, $thisdigest[0]);
} else {
$Moderator = ("Forum" . "$thisdigest[1]" . "Moderator");
$Moderator = $$Moderator;
@mods = split(/\|\|\^\|\|/, $Moderator);

$ModMatch = "";
foreach $unomod(@mods) {
if ($unomod eq "$UserName") {
	$ModMatch = "true";
}
}
	if ($ModMatch eq "true") {
		push(@final, $thisdigest[0]);
	}
}
}

if ($final[0] eq "") {
	print qq(<OPTION value="">Sorry, No Forums Are Eligible);
	
}  else {
foreach $thou(@final) {
chomp($thou);
@thisfor = &GetForumRecord($thou);
my $ForumName = $thisfor[1];
print qq(<OPTION value="$thou">$ForumName);
}
}
}  #end GetForums2

sub Subscribe {
$PageTitle = "$BBName<BR>Digest Subscription Center";
&DigestTopHTML2;

print<<MIDDLE;
<FONT SIZE="1" FACE="$FontFace"><A HREF="$CGIURL/Ultimate.cgi?action=intro&BypassCookie=true">Back To Our Forums</A></FONT>
<blockquote>
Only registered members of our forums may subscribe to our forum digests.  If you subscribe to a forum digest, you will receive periodic emails detailing posts to that forum over a given period of time.  To subscribe or unsubscribe to a digest for our forums, you must provide your registered username and password.   Not all forums are necessarily available as digests.  There is no cost to subscribe.
<P>
For confidentiality reasons, we do not list which forum digests you have already subscribed to here.  If you would like to have a list of the digests you have already subscribed to emailed to you, <A HREF="$CGIURL/ubbmail.cgi?action=subscribelistintro">click here</A>.
<P>
We have compiled a list of all available digests below.  If you would like to subscribe to any of these digests, check the <B>Subscribe</B> button next to the digest.  To take your email address off of any digest subscription list, check the <B>Don't Subscribe</B> button next to the appropriate forum digest.
<P>
<FORM ACTION="ubbmail.cgi" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="subscribesubmit">
<center>

<TABLE border=0 width=100%>
<TR $TableColorStrip>
<TD>
<FONT SIZE="$TextSize" Color="$TableStripTextColor" FACE="$FontFace">Forum Digest</FONT>
</td>
<TD>
<FONT SIZE="$TextSize" Color="$TableStripTextColor" FACE="$FontFace">Subscription Choice</FONT>
</td>
</tr>
MIDDLE

@digsum = &GetDigestSummary;  

foreach $uno(@digsum) {
if ($Alternate eq "$AltColumnColor1") {
	$Alternate = "$AltColumnColor2";
}  else {
	$Alternate = "$AltColumnColor1";
}

@thisdig = split(/\|/, $uno);
@thisfor = &GetForumRecord($thisdig[0]);
my $ForumName = $thisfor[1];
print<<THIS;
<TR $Alternate><TD>
<FONT SIZE="$TextSize" FACE="$FontFace">$ForumName</FONT>
</td>
<TD>
<FONT SIZE="$TextSize" FACE="$FontFace">
<INPUT TYPE="RADIO" NAME="Subscribe$thisdig[0]" VALUE="yes"> Subscribe<BR>
<INPUT TYPE="RADIO" NAME="Subscribe$thisdig[0]" VALUE="null" CHECKED> Don't Subscribe

</FONT>
</td>
</tr>
THIS
}

print<<BOTTOM;
</table>
<TABLE BORDER=0>
<TR>
<TD><FONT SIZE="$TextSize" FACE="$FontFace">Your UserName:</FONT></td><TD><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=40></td></tr>
<TR>
<TD><FONT SIZE="$TextSize" FACE="$FontFace">Your Password:</FONT></td><TD><INPUT TYPE="PASSWORD" NAME="Password" SIZE=20 MAXLENGTH=40></td></tr>
</table></center>
</blockquote>
<CENTER><INPUT TYPE="SUBMIT" NAME="submit" VALUE="Submit Identification Now"></CENTER>

</FORM>
<center>
$Footer
</center>
</font>
</body></html>
BOTTOM

}  # end subscribe

sub DigestTopHTML2 {
print<<HEADER;
<HTML>
<HEAD>
	<TITLE>$BBName - Digest Subscription Center</TITLE>
$HeaderInsert
</HEAD>
 <BODY $BGColor $PageBackground  text="$TextColor" link="$LinkColor" alink="$ActiveLinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="2" FACE="$FontFace" COLOR="$TextColor">
$Header
</font>
<BR>
<center>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>$PageTitle</B></FONT>
</center>
<FONT SIZE="$TextSize" FACE="$FontFace">
<p>
HEADER
}  #end DigestTopHTML2

sub AddDigest {
#verify id

if ( ($in{'UserName'} eq "") || ($in{'Password'} eq "") || ($in{'ForumChoice'} eq "") ) {
 &StandardHTML("You forgot to complete all required fields.  Please go back and try again.");
exit;
}  

#verify Admin/Moderator
$NameFound = "no";
$ProfileNumber = &GetUserNumber($UserName);
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$ProfileNumber.cgi");
			
	if ($Password eq "$theprofile[1]") {
		$Status = "$theprofile[8]";
   if ($Status !~ /[Administrator|Moderator]/i)  {
	    &StandardHTML("Sorry, but you are not an administrator or moderator.  You may not perform this action.");
exit;
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
exit;
	}
		
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
exit;
}  ##END IF/ELSE NAME CHECK BLOCK

@thisforum = &GetForumRecord($in{'ForumChoice'});
$ForumName = $thisforum[1];

unless (-e "$NonCGIPath/digests/digestsummary.cgi") {
mkdir ("$NonCGIPath/digests", 0777);
chmod(0770, "$NonCGIPath/digests");
}

#add new digest to database
open(ADD, ">>$NonCGIPath/digests/digestsummary.cgi");
print ADD "$in{'ForumChoice'}||\n";
close(ADD);

chmod (0777, "$NonCGIPath/digests/digestsummary.cgi");

$PageTitle = "New Digest Added";
&DigestTopHTMLnj;

print<<THIS;
Thank you!  We have added the new Digest:
<P>
$ForumName
<P>
It is now listed in the <A HREF="$CGIURL/ubbmail.cgi?action=subscribe">Digest Subscription Center</A>, where new users can subscribe to all digests avaiable on your bulletin board.
<P>
<A HREF="cpanel.cgi?action=digest">Back to Digest Center...</A>
</font>
</body></html>
THIS

}  #end AddDigest

sub DeleteTheDigest {
#verify id

if ( ($in{'UserName'} eq "") || ($in{'Password'} eq "") || ($in{'ForumChoice'} eq "") ) {
 &StandardHTML("You forgot to complete all required fields.  Please go back and try again.");
exit;
}  

#verify Admin/Moderator
$NameFound = "no";
$ProfileNumber = &GetUserNumber($UserName);
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$ProfileNumber.cgi");
			
	if ($Password eq "$theprofile[1]") {
		$Status = "$theprofile[8]";
   if ($Status !~ /[Administrator|Moderator]/i)  {
	    &StandardHTML("Sorry, but you are not an administrator or moderator.  You may not perform this action.");
exit;
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
exit;
	}
		
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
exit;
}  ##END IF/ELSE NAME CHECK BLOCK

open(DIGESTS, "$NonCGIPath/digests/digestsummary.cgi");
@currentdigests = <DIGESTS>;
close(DIGESTS);
@revisedlist = @blank;

foreach $uno(@currentdigests) {
chomp($uno);
@thisone = split(/\|/, $uno);
unless ($thisone[0] eq "$in{'ForumChoice'}") {
	push (@revisedlist, $uno);
}  
}

#add new digest to database
&Lock("lock.file");
open(ADD, ">$NonCGIPath/digests/digestsummary.cgi");
foreach $digline(@revisedlist) {
	chomp($digline);
	print ADD "$digline\n";
}
close(ADD);
&Unlock("lock.file");

chmod (0777, "$NonCGIPath/digests/digestsummary.cgi");
#delete email list associated with this digest
unlink "$NonCGIPath/digests/emaillist$in{'ForumChoice'}.cgi";

$PageTitle = "Digest Deleted";
&DigestTopHTMLnj;

print<<THIS;
Thank you!  We have deleted the digest you requested.
<P>
<A HREF="cpanel.cgi?action=digest">Back to Digest Center...</A>
</font>
</body></html>
THIS
}  #end DeleteDigest

sub SubscribeSubmit {
#check registration
if (($in{'UserName'} eq "") || ($in{'Password'} eq "")) {
&StandardHTML("You did not complete all required form fields!  Please go back and re-enter.");
exit;
} 

$NameFound = "no";

$ProfileNumber = &GetUserNumber($UserName);
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {
#Check Password Now	
	@thisprofile = &OpenProfile("$ProfileNumber.cgi");
         if ($in{'Password'} eq "$thisprofile[1]") {
		    $Email = $thisprofile[2];
            $Proceed = "true";
         }
    } ## END IF MEMBER = Username.cgi condition

if ($NameFound ne "yes") {
   &StandardHTML("We have no one registered with that user name.  Use your back button to try again.");
exit;
}
if (($NameFound eq "yes") && ($Proceed ne "true")) {
   	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again. Use your Back button.");
exit;
}

if ($Email !~ /\S+\@\S+\.\S+/) {
	&StandardHTML("We cannot subsscribe you to anyof our digests because the email address you registered with is not in a valid format.  Note that spaces are not allowed in email addresses.  Please check your profile information and update your email address if necessary.");
exit;
}
$YourEmail = lc($Email);
@digsum = &GetDigestSummary;

foreach $one(@in) {
	($Name, $Value) = split ("=", $one);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	if ($Name =~ /Subscribe/) {
		if ($Value eq "yes") {
			push(@addlist, $Name);
		}
	}
}

foreach $uno(@digsum) {
$Dupe = "";
@revised = @blank;

@thisdigest = split(/\|/, $uno);

#check to see if they are subscribing or unsubscribing from this forum
$Add = "";
CHECKADD: foreach $checkadd(@addlist) {
	if ($checkadd eq "Subscribe$thisdigest[0]") {
		$Add = "true";
		last CHECKADD;
	}
}

open (DIGLIST, "$NonCGIPath/digests/emaillist$thisdigest[0].cgi");
@theseemail = <DIGLIST>;
close(DIGLIST);

if ($Add eq "true") {

CHECKER: foreach $check(@theseemail) {
chomp($check);
if ($check eq "$YourEmail") {
	$Dupe = "true";
	last CHECKER;
}
}

if ($Dupe ne "true") {
&Lock("lock.file");
open(EMAILS, ">>$NonCGIPath/digests/emaillist$thisdigest[0].cgi");
print EMAILS "$YourEmail\n";
close(EMAILS);
&Unlock("lock.file");
chmod(0777, "$NonCGIPath/digests/emaillist$thisdigest[0].cgi");
}

}  else {

@revised = @blank;
#else remove
foreach $check(@theseemail) {
chomp($check);
if ($check ne "$YourEmail") {
	push(@revised, $check);
}
}

&Lock("lock.file");
open(EMAILS, ">$NonCGIPath/digests/emaillist$thisdigest[0].cgi");
foreach $checked(@revised) {
chomp($checked);
print EMAILS "$checked\n";
}
close(EMAILS);
&Unlock("lock.file");
chmod (0777, "$NonCGIPath/digests/emaillist$thisdigest[0].cgi");
}
}
$PageTitle = "Digest Subscriptions Updated";
&DigestTopHTML2;

print<<BOTTOM;
<P>
Thank you.  We have updated your subscriptions to all available forums.
<P>
<A HREF="$CGIURL/Ultimate.cgi?action=intro&BypassCookie=true">Return to Forums...</A>
<P>
$Footer
</font>
</body></html>
BOTTOM

}  #end subscribe submit

sub GetDigestSummary {
open (DIG, "$NonCGIPath/digests/digestsummary.cgi");
@thedigsummary = <DIG>;
close(DIG);
return(@thedigsummary);
}

sub DeleteDigest {
$UserStatus = shift;

$PageTitle = "Delete A Digest";
&DigestTopHTML;

print<<MIDDLE;
You may delete any digest that has been previously created.  Deleting a digest does not affect the forum posts themselves.  It merely removes the digest from your list of digests that your visitors can subscribe to and deletes the subscription list associated with that digest.
<P>
<FORM ACTION="ubbmail.cgi" METHOD="POST" NAME="THEFORM">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="deletedigest">
<table border=0 width=100%>
<TR bgcolor="#B0BB9D">
<TD colspan=2 align=center>
<FONT SIZE="2" FACE="Verdana, Arial">Delete A Digest:</FONT>
</td></tr>
<TR bgcolor="#C7C6BA">
<TD>
<FONT SIZE="2" FACE="Verdana, Arial">Delete Which Digest?</FONT><BR><FONT SIZE="1" FACE="Verdana, Arial">The forum list to the right contains only those forums that have been previously created and which you are permitted to delete.</font>
</td><td valign=top><SELECT NAME="ForumChoice">
MIDDLE

&GetForums2;

print<<BOTTOM;
</SELECT></td>
</tr>
</table>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">Note: If you are a moderator, you can only delete a digest for a forum that you are a moderator.  Administrators may delete digests for any forum.  You cannot make a digest for a private forum.</FONT>
<HR>
<CENTER><FONT Size="2" FACE="Verdana, Arial" COLOR="#000080"><B>Enter Your UserName & Password:</font>
<p>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#000080">
UserName: <INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13></FONT></B>
<P>
<CENTER><INPUT TYPE="SUBMIT" NAME="SUBMIT" VALUE="Delete Digest Now"></CENTER>
<P><BR>
</form>
</body></html>
BOTTOM
}


sub SubscriberEdit {
#verify id

if ( ($in{'UserName'} eq "") || ($in{'Password'} eq "") || ($in{'ForumChoice'} eq "") ) {
 &StandardHTML("You forgot to complete all required fields.  Please go back and try again.");
exit;
}  

#verify Admin/Moderator
$NameFound = "no";
$ProfileNumber = &GetUserNumber($UserName);
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$ProfileNumber.cgi");
			
	if ($Password eq "$theprofile[1]") {
		$Status = "$theprofile[8]";
   if ($Status !~ /[Administrator|Moderator]/i)  {
	    &StandardHTML("Sorry, but you are not an administrator or moderator.  You may not perform this action.");
exit;
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
exit;
	}
		
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
exit;
}  ##END IF/ELSE NAME CHECK BLOCK

@thisforum = &GetForumRecord($in{'ForumChoice'});
$ForumName = $thisforum[1];

unless (-e "$NonCGIPath/digests/digestsummary.cgi") {
mkdir ("$NonCGIPath/digests", 0777);
chmod(0777, "$NonCGIPath/digests");
}

#open email list for this digest
open(EMAILLIST, "$NonCGIPath/digests/emaillist$in{'ForumChoice'}.cgi");
@thislist = <EMAILLIST>;
close(EMAILLIST);
$AddEmail = &decodeURL($in{'AddEmail'});
$DelEmail = &decodeURL($in{'DeleteEmail'});
	$AddEmail = &ConvertSpaces($AddEmail);
	$DelEmail = &ConvertSpaces($DelEmail);

@addfinal = @blank;
@delfinal = @blank;
$InvalidList = "";
$DupeList = "";
$AddList = "";
$DeleteList = "";
@revisedlist = @blank;

@addarray = split(/\s{1,}/, $AddEmail);
@delarray = split(/\s{1,}/, $DelEmail);

if ($addarray[0] ne "") {

	foreach $one(@addarray) {
		chomp(@one);
		$thisone = lc($one);
		$Invalid = "";
		$Dupe = "";
		#make sure it is a valid email-
		if ($thisone !~ /\S+\@\S+\.\S+/) {
			$InvalidList .= "$thisone<BR>";
			$Invalid = "true";
		}  else {
			CHECKER: foreach $check(@thislist) {
				chomp($check);
				if ($thisone eq "$check") {
					$DupeList .= "$thisone<BR>";
					$Dupe = "true";
					last CHECKER;
				}
			}
		
		}
		if (($Dupe ne "true") && ($Invalid ne "true")) {
			$AddList .= "$thisone<BR>";
			push(@thislist, $thisone);
		}
	}

} #end if add array exists

if ($delarray[0] ne "") {

	foreach $check(@thislist) {
	$Delete = "";
		chomp($check);
		CHECKER: foreach $delone(@delarray) {
		chomp(@delone);
		$thisdel = lc($delone);
			if ($thisdel eq "$check") {
				$DeleteList .= "$thisdel<BR>";
				$Delete = "true";
				last CHECKER;
			}
		}
		if ($Delete ne "true") {
			push(@revisedlist, $check);
		}
		
	}
		
} #end if del array exists

if ($DeleteList ne "") {
	@thislist = @revisedlist;
}

open(ADJ, ">$NonCGIPath/digests/emaillist$in{'ForumChoice'}.cgi");
foreach $good(@thislist) {
chomp($good);
print ADJ "$good\n";
}
close(ADJ);
chmod (0777, "$NonCGIPath/digests/emaillist$in{'ForumChoice'}.cgi");

$PageTitle = "Subscribers Updated for $ForumName Digest";
&DigestTopHTMLnj;

if ($AddList ne "") {
	$AddListWording = "<B>Subscribers Added:</B><P>$AddList<P>";
}
if ($DeleteList ne "") {
	$DeleteListWording = "<B>Subscribers Deleted:</B><P>$DeleteList<P>";
}
if ($InvalidList ne "") {
	$InvalidListWording = "<B>The following addresses were not in a valid format and thus could not be added/deleted:</B><P>$InvalidList<P>";
}
if ($DupeList ne "") {
	$DupeListWording = "<B>The following addresses were already on the subscription list and thus did not need to be added:</B><P>$DupeList<P>";
}
print<<THIS;
Thank you!  We have updated the subscription list for the $ForumName digest in the following manner:
<P>
$AddListWording $DeleteListWording $InvalidListWording
$DupeListWording
<HR>
<A HREF="cpanel.cgi?action=digest">Back to Digest Center...</A>
</font>
</body></html>
THIS

}  #end SubscriberEdit

sub ConvertSpaces {
$Converter = shift;
$Converter =~ s/\n\r\n/ /g;
$Converter =~ s/\n/ /g;
$Converter =~ s/\r/ /g;
return($Converter);
}

sub SendDigest {
$UserStatus = shift;

$PageTitle = "Send A Digest";
&DigestTopHTML;

print<<MIDDLE;
You may send a digest to your digest subscribers by completing the form below.  Pressing the SUBMIT button will start the distribution process.  Thus, do not press the submit button unless you are sure all information below is accurate.
<P>
<FORM ACTION="ubbmail.cgi" METHOD="POST" NAME="THEFORM">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="sendthedigest">
<table border=0 width=100%>
<TR bgcolor="#B0BB9D">
<TD valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">Select Digest:</FONT>
</td>
<td valign=top><SELECT NAME="ForumChoice">
MIDDLE

&GetForums2;

print<<BOTTOM;
</SELECT></td>
</tr>
<TR bgcolor="#C7C6BA">
<TD>
<FONT SIZE="2" FACE="Verdana, Arial">Time Frame:</FONT><BR><FONT SIZE="1" FACE="Verdana, Arial">You may choose the time span the digest will cover.  You may want to include only topics from the last week, or from the last two weeks, or since the last digest was sent (maximum of 31 days), for example.</font>
</td>
<TD valign=top>
<SELECT NAME="TimeSpan">
	<OPTION value="last">Since Last Digest Sent (Max: 31 days)
	<OPTION value="1">Since Yesterday
	<OPTION value="7">Last 7 Days
	<OPTION value="14">Last 14 Days
	<OPTION value="21">Last 21 Days
	<OPTION value="31">Last 31 Days
</SELECT></td>
</tr>

<TR bgcolor="#B0BB9D">
<TD valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">Topics Only/Topics and Replies</FONT><BR><FONT SIZE="1" FACE="Verdana, Arial">You may include the topics only (complete original topic posts) or the topics with the replies.</font>
</td><TD valign=top>
<SELECT NAME="Type">
	<OPTION value="topics">Topics Only
	<OPTION value="all">Topics and All Replies
</SELECT></td>
</tr>

<TR bgcolor="#C7C6BA">
<TD valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">Intro Message</FONT><BR><FONT SIZE="1" FACE="Verdana, Arial">You may include an introductory message to your digest, if you like.  Do not use any HTML in your message.</font>
</td><TD valign=top>
<TEXTAREA NAME="IntroMessage" ROWS=5 COLS=25>
</TEXTAREA>
</td>
</tr>
</table>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">Note: If you are a moderator, you can only create a digest for a forum that you are a moderator.  Administrators may create digests for any forum.  You cannot make a digest for a private forum.</FONT>
<HR>
<CENTER><FONT Size="2" FACE="Verdana, Arial" COLOR="#000080"><B>Enter Your UserName & Password:</font>
<p>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#000080">
UserName: <INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13></FONT></B>
<P>
<CENTER><INPUT TYPE="SUBMIT" NAME="SUBMIT" VALUE="Send Digest Now"></CENTER>
<P><BR>
</form>
</body></html>
BOTTOM
} #end SendDigest


sub SendTheDigest {
#verify id

if ( ($in{'UserName'} eq "") || ($in{'Password'} eq "") || ($in{'ForumChoice'} eq "") ||  ($in{'Type'} eq "") || ($in{'TimeSpan'} eq "")) {
 &StandardHTML("You forgot to complete all required fields.  Please go back and try again.");
exit;
}  

#verify Admin/Moderator
$NameFound = "no";
$ProfileNumber = &GetUserNumber($UserName);
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$ProfileNumber.cgi");
			
	if ($Password eq "$theprofile[1]") {
		$Status = "$theprofile[8]";
   if ($Status !~ /[Administrator|Moderator]/i)  {
	    &StandardHTML("Sorry, but you are not an administrator or moderator.  You may not perform this action.");
exit;
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
exit;
	}
		
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
exit;
}  ##END IF/ELSE NAME CHECK BLOCK

@thisforum = &GetForumRecord($in{'ForumChoice'});
$ForumName = $thisforum[1];
my $DigestNumber = $in{'ForumChoice'};
my $TimeSpan = $in{'TimeSpan'};
$number = $DigestNumber;
$ExactPath = "Forum$number";

#open email list for this digest
open(EMAILLIST, "$NonCGIPath/digests/emaillist$in{'ForumChoice'}.cgi");
	@thislist = <EMAILLIST>;
close(EMAILLIST);
$TotalEmails = @thislist;

#open digest summary
@digestsummary = &GetDigestSummary;
foreach $one(@digestsummary) {
@thisdigest = split(/\|/, $one);
if ($DigestNumber eq "$thisdigest[0]") {
	$LastJDate = $thisdigest[2];
	chomp($LastJDate);
}
}

&GetDateTime;
@months = ("blank" , "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
$ThisMonth = $months[$mon];
($TodayJules, $junk) = split(/\./, $LastLoginJulian);
$subject = "$ForumName Digest: $mday $ThisMonth $JSYear";

if ($in{'start'} eq "") {
$Body = "You are receiving this email because you subscribed to this forum digest.\n*************\n\r\n";
$ThisBody = $in{'IntroMessage'};
$ThisBody = &decodeURL($ThisBody);
$ThisBody =~ s/<.+?>//g;
$Body .= "$ThisBody\n\r\n";

if ($TimeSpan eq "last") {
$RealSpan = $TodayJules - $LastJDate;
if ($RealSpan >= 31) {
	$TimeSpan = 31;
}  else {
	$TimeSpan = $RealSpan;
}
}

$JulesCutOff = $TodayJules - $TimeSpan;

#open threads file for this forum
open(THREADS, "$ForumsPath/Forum$DigestNumber/forum$DigestNumber.threads");
	@threadsarray = <THREADS>;
close(THREADS);
$TotalTopics = @threadsarray;

#open last number file
open (FORSUMM, "$ForumsPath/Forum$DigestNumber/lastnumber.file");
@foruminfo = <FORSUMM>;
close (FORSUMM);

chomp($foruminfo[1]);
$LastNumberVerify = $foruminfo[1] + 0;

if ($TotalTopics != $LastNumberVerify) {
&SetThreadInfo;
&ForumSummary($number);
} else {
@sortfinalarray = sort(@threadsarray);
@finalarray = reverse(@sortfinalarray);
}
#now we have final array

CHECKEACH: for $eachone(@finalarray) {
	chomp($eachone);
	@threadinfo2 = split(/\|\^\|/, $eachone);
	$PostDateJulian2 = $threadinfo2[0];
	($PostDateJulian, $junk) = split(/\./, $PostDateJulian2);
	
	#do date compare on post julian

	if ($PostDateJulian >= $JulesCutOff) {
	push(@goodarray2, $eachone);
	}  else {
	last CHECKEACH;
	}
}  #foreach eachone

foreach $uno(@goodarray2) {
@thistopic = split(/\|\^\|/, $uno);
my $TopicNumber = $thistopic[1];
my $ThisTopic = $thistopic[2];

		$Body .= "\n******************\nTOPIC: $ThisTopic\n";
		
#open the ubb file

my @threadinformation = &OpenThread("$TopicNumber.cgi");
CYCLE: foreach $line(@threadinformation) {
@thisline = split(/\|\|/, $line);
	if ($thisline[0] eq "Z") {
		$ThisUserName = $thisline[2];
		$theDate = "$thisline[3]";
		$theTime = $thisline[4];
		$Message = $thisline[6];
		$Message = &ConvertMessage($Message);
		$Message =~ s/<.+?>//g;
		$reg = $thisline[8];
		chomp($reg);
		if ($thisline[1] eq "000000") {
			$Body .= "by $ThisUserName on $theDate $theTime\n\r\n";
			$Body .= "$Message\n------------\n";
		}  else {
			if ($in{'Type'} eq "topics") {
				last CYCLE;
			} else {
			$Body .= "REPLY by $ThisUserName on $theDate $theTime:\n";
			$Body .= "$Message\n------------\n";
			}
		}
		
}
}		

}

}  else {
$DigestFile = $in{'DigestFile'};
open (TEMP, "$NonCGIPath/digests/$DigestFile");
@BodyArray = <TEMP>;
close(TEMP);

foreach $row(@BodyArray) {
chomp($row);
$Body .= &ConvertMessage($row);
}
} #end if/else start eq 0

#do emails in batches of 50
$TotalArray = $TotalEmails - 1; #adjust for array context
#limit processing to 50 emails at a time
$Start = $in{'start'} + 0;
$End = $Start + 50;

if ($TotalArray <= $End) {
	$End = $TotalArray;
	$EndLoop = "true";
}  else {
	$StartHere = $End + 1;
}

$StartDisplay = $Start +1;
$EndDisplay = $End +1;

	@thislist = @thislist[$Start... $End];
	
if (($in{'start'} eq "") && ($EndLoop ne "true")) {
## store the body in a text file temporarily until all emails are sent
$DigestFile = "temp-$number-$JSYear$mon$mday.cgi";
$ThisBody = &ConvertReturns($Body);
open (TEMP, ">$NonCGIPath/digests/$DigestFile");
print TEMP "$ThisBody";
close(TEMP);
chmod (0666, "$NonCGIPath/digests/$DigestFile");
}

$message = $Body;

#process emails
foreach $sendto(@thislist) {
chomp($sendto);

$message .= "\n\rTo take yourself off of the distribution list for this digest, please go to: $CGIURL/ubbmail.cgi?action=subscribe";

if ($SMTPEmail eq "On") {
&SendEmail;
}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
}
	$EmailLine .= "$sendto<BR>";
}

if ($EndLoop eq "true") {
&RecordDigestDate;
unlink ("$NonCGIPath/digests/$DigestFile");
$FinishWording = "We have finished sending the digest to all subscribers.";
&FinishMail;
}  else {
&ContinueMail2;
}
}  #end SendTheDigest

sub RecordDigestDate {

@digestsummary = &GetDigestSummary;
@updated = @blank;

foreach $digester(@digestsummary) {
chomp($digester);
@digest = split(/\|/, $digester);
if ($digest[0] eq "$number") {
$LongDate = "$mday $ThisMonth $JSYear";
$revisedline = "$digest[0]|$LongDate|$TodayJules";
push(@updated, $revisedline);
}  else {
push(@updated, $digester);
}
}

&Lock("lock.file");
open(UPDATE, ">$NonCGIPath/digests/digestsummary.cgi");
foreach $iota(@updated) {
chomp($iota);
print UPDATE "$iota\n";
}
close(UPDATE);
&Unlock("lock.file");
}

sub ConvertMessage {
$message = shift;
$message =~ s/<p>/\n\r\n/isg;
$message =~ s/<br>/\n/isg;
$message =~ s/<IMG SRC="$NonCGIURL\/smile.gif">/:\)/isg;
$message =~ s/<IMG SRC="$NonCGIURL\/frown.gif">/:\(/isg;
$message =~ s/<IMG SRC="$NonCGIURL\/biggrin.gif">/\:D/isg;
$message =~ s/<IMG SRC="$NonCGIURL\/wink.gif">/\;\)/isg;
$message =~ s/<IMG SRC="$NonCGIURL\/redface.gif">/\:o/isg;
return($message);
}

sub ContinueMail2 {
print<<TheMail;
<HTML><HEAD>
<meta http-equiv="Refresh" content="2; URL=$CGIURL/ubbmail.cgi?action=sendthedigest&start=$StartHere&UserName=$UserNameCoded&Password=$PasswordCoded&Type=$in{'Type'}&TimeSpan=$in{'TimeSpan'}&ForumChoice=$number&DigestFile=$DigestFile">
</head>
<BODY bgcolor=#FFFFFF>
<center>
<FONT FACE="Verdana, Arial" SIZE="2"><B>
<FONT FACE="Courier New" SIZE="5" COLOR="Maroon"><B>Processing....Please Wait!</B></FONT>
<P>
We are emailing all subscribers to this digest.
<P>
We just emailed Members <FONT FACE="Verdana" SIZE="3" COLOR="Navy">$StartDisplay</font> to <FONT FACE="Verdana" SIZE="3" COLOR="Navy">$EndDisplay</font>...
<P></center>
Here's the list of emails just delivered:
<P>
$EmailLine
</FONT>
</BODY>
</HTML>
TheMail

exit;
}

sub Unsubscribe {
my $number = $in{'digest'};
my $thisemail = $in{'email'};

@digestsummary = &GetDigestSummary;

DIGESTCHECK: foreach $digester(@digestsummary) {
@digest = split(/\|/, $digester);
if ($digest[1] eq "$number") {
	$DigestTitle = "$digest[0]";
	last DIGESTCHECK;
}

}
$thisemail = lc($thisemail);

open (EMAILLIST, "$NonCGIPath/digests/emaillist$number.cgi");
@theseemail = <EMAILLIST>;
close(EMAILLIST);

foreach $uno(@theseemail) {
	chomp($uno);
	unless ($uno eq "$thisemail") {
		push(@revised, $uno);
	}
}

&Lock("lock.file");
open (REVISED, ">$NonCGIPath/digests/emaillist$number.cgi");
foreach $one(@revised) {
print REVISED "$one\n";
}
close(REVISED);
&Unlock("lock.file");
&StandardHTML("Thank you.  We have removed your email address from our subscription list for the digest: $DigestTitle.<P>  To visit our Subscription Center, visit: <A HREF=\"http://$CGIURL/ubbmail.cgi?action=subscribe\">$CGIURL/ubbmail.cgi?action=subscribe</a>");
}

sub SubscribeListEmail {
@digsum = &GetDigestSummary;
$UserEmail = lc($in{'YourEmail'});
$MatchList = "";

foreach $one(@digsum) {
@thisdigest = split(/\|/, $one);
$digestnumber = $thisdigest[0];
@thisfor = &GetForumRecord($digestnumber);
$ForumName = $thisfor[1];
open(EMAIL, "$NonCGIPath/digests/emaillist$digestnumber.cgi");
@thismail = <EMAIL>;
close(EMAIL);

CHECKLIST: foreach $uno(@thismail) {
chomp($uno);
	if ($uno eq "$UserEmail") {

		$MatchList .= "$ForumName\n";
		last CHECKLIST;
	}
}
}

if ($MatchList eq "") {
	$MatchList = "You are not subscribed to any of our digests currently.";
}

#send email--
$sendto = $UserEmail;
$subject = "Current Subscription List at $BBName";
$message = "You requested a listing of all digests you are subscribed to at $BBName ($CGIURL/Ultimate.cgi). \n\r\nOur records indicate that you are subscribed to the following digests:\n\r\n$MatchList";

if ($SMTPEmail eq "On") {
&SendEmail;
}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
}  

&StandardHTML("We just emailed you a list of all digests you are currently subscribed to for our forums.  Thank you!<P><A HREF=\"$CGIURL/Ultimate.cgi?action=intro&BypassCookie=true\">Please return to our forums now.</A>");
}

sub SubscribeListIntro {
$PageTitle = "Digest Subscription Center";
&DigestTopHTML2;

print<<MIDDLE;
<blockquote>
To have a list of all digests you are currently subscribed to in our forums emailed to you, provide your registered email address below.  
</blockquote>
<FORM ACTION="ubbmail.cgi" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="subscribelistemail">
<center>
Your Email Address: <INPUT TYPE="TEXT" NAME="YourEmail" SIZE=20 MAXLENGTH=90>
<P>
<INPUT TYPE="SUBMIT" NAME="Submit Now">
</FORM>
</center>$Footer
</font>
</body></html>
MIDDLE

}  # end subscribelistntro