; cracked by vReal/SLT
;
; copy this file over the original in the install directory
;
; SPURGEUI.LSP
;
; ***  SuperPurge   [Version 2.06] June 14, 1999  ***
;
;Copyright 1999 ManuSoft
;
; ***************************************
; ****  ManuSoft                     ****
; ****  POB 260                      ****
; ****  Fredericksburg, OH  44627    ****
; ****  330-695-5903                 ****
; ****  http://www.manusoft.com      ****
; ****  superpurge@manusoft.com      ****
; ***************************************
;
;
;  Define the SPURGE command to allow more
;  control over what gets purged by using a 
;  dialog box based interface along with
;  the ability to select items by using
;  wildcards.




(defun SPURGE (arglist / 

; ** Local Variable Declarations **

acadver
cadlockStat
cnt
dcl_id
dcl_name
def_list
echolog
err
exclude
inp
logfile
lowres
max_slider
ol_desc
oldvars
olderr_spurge
olist
olist_sel
ospec
ospec_list
otype
otype_list
p_only
page
page_increment
page_slider
pagelen
patt_alias
pfile
platform
pselect
purge_enabled
purgef
purgetype
reflist
ret
sel_list
sel_method
spec
spec_list
slistbox
tlist
uctl
uselog
win
wvxname
x_file
x_load
x_unload
xname

; ** Local Function Declarations **

build_olist
build_purge_set
clear_err
conv_ol
conv_patt
dxf
errexit_spurge
get_sel
get_spec
GetCadlockStat
hardpurge_warning
list_allbut
list_isect
list_union
list_wcmatch
listcar_wcmatch
load_pfile
lowres_prompt
olist_formatolist_init
parse_list_idx
parse_ospeclist
parse_param
print_log
purge_sym
purge_warning
reorder_rlist
repaint_olist
save_pfile
save_sel
select_sym
set_err
set_slider
setup_logfile
setup_ptype
sp_callbacks
sp_help
spurgex
strip_path
update_counts
update_log
update_sel
write_profile
)


;*** Global Function Definitions ***

(if (not (and *spurge_fpath (member (type *spurge_fpath) '(LIST SUBR EXSUBR EXRXSUBR))))
	(defun *spurge_fpath (filename) (findfile filename))
)


;*** Local Function Definitions ***

(defun build_olist (/ pattern l_make cnt lmax)
	(defun l_make (ot pre / cnt tstr ol)
		(foreach s ((if p_only (if purgetype cadddr caddr) cadr) (nth ot reflist))
			(if (wcmatch (strcase (car s)) pattern)
				(progn
					(if
						(member
							(1- (length (member s (reverse (cadr (nth ot reflist))))))
							(cadr (nth ot sel_list)))
						(setq olist_sel (cons (length olist) olist_sel)))
					(setq olist
						(append
							olist
							(list
								(list
									(car s)
									(cadr s)									(if pre
										(strcat
											(if
												(wcmatch
													(strcase (car s))
													(conv_ol (nth (dxf (1+ ot) spec_list) ospec_list)))
												"+"
												" ")
											(if (setq tstr (cadr (nth ot def_list))) tstr "   ")))))))))))
	(setq pattern (strcase (conv_ol (nth ospec ospec_list)))
				olist nil
				olist_sel nil)
	(cond
		( (zerop otype)
			(setq cnt -1 lmax (length def_list))
			(while (< (setq cnt (1+ cnt)) lmax)
				(l_make cnt 1))
			(set_tile "pattern" pattern))
		( (l_make (1- otype) nil)
			(set_tile "pattern" pattern)))
	(if max_slider
		(setq page_inc
			(if (> (setq cnt (length olist)) 1)
				(/ (+ max_slider 0.01) (1- cnt))
				max_slider)))
	(mode_tile "page" (if (<= cnt 1) 1 0))
	(setq page 0)
)

(defun build_purge_set (/ pset cnt tlist)
	(setq pset nil
				cnt -1)
	(foreach sym def_list
		(setq cnt (1+ cnt))
		(setq pset
			(cons
				(list
					(car sym)
					(listcar_wcmatch
						(if sel_method
							(cadr (nth cnt reflist))
							(mapcar '(lambda (x) (nth x (cadr (nth cnt reflist))))
								(cadr (nth cnt sel_list))))
						(conv_ol (nth (dxf (1+ cnt) spec_list) ospec_list))))
				pset)))
	(reverse pset)
)

(defun clear_err () (set_err nil))

(defun conv_ol (ol)
	(if (assoc ol patt_alias) (dxf ol patt_alias) ol)
)

(defun conv_patt (p / rl)
	(if (assoc p (setq rl (mapcar '(lambda (x) (cons (cdr x) (car x))) patt_alias)))
		(dxf p rl)
		p)
)

(defun dxf (g l) (cdr (assoc g l)))

(defun errexit_spurge (s)
	(if (/= olderr_spurge -1)
		(progn
			(if (and uctl (= 8 (logand 8 (getvar "UNDOCTL"))))
				(command "_.UNDO" "_END" "_.UNDO" 1))
			(spurgex)
			(if (and *error* (listp *error*))
				(*error* s)
				(if (not (member s '("console break" "Function cancelled" "quit / exit abort")))
					(princ (strcat "\nError:  " s))))))
	(princ)
)

(defun get_spec (name otype / inp tlist slist spec cnt obj purgef)
	(setq spec (nth (dxf otype spec_list) ospec_list))
	(if
		(=
			""
			(setq inp
				(getstring 1
					(strcat "Enter " name " spec (or . for none) <" (if spec spec "") ">: "))))
		(setq inp spec)
		(if
			(/=
				(setq inp (if (= inp ".") "<None>" (conv_patt (setq inp (strcase inp)))))
				(nth (dxf otype spec_list) ospec_list))
			(progn
				(if (setq spec (member inp (reverse ospec_list)))
					(setq spec_list (subst (cons otype (1- (length spec))) (assoc otype spec_list) spec_list))
					(progn
						(setq spec_list
							(mapcar '(lambda (x) (cons (car x) (if (> (cdr x) 1) (1+ (cdr x)) (cdr x)))) spec_list))
						(setq spec_list (subst (cons otype 2) (assoc otype spec_list) spec_list))
						(setq ospec_list
							(append
								(list
									(car ospec_list)
									(cadr ospec_list)
									inp)
								(if (> (length ospec_list) (1+ (length def_list)))
									(reverse (cdr (reverse (cddr ospec_list))))
									(cddr ospec_list)))))))))
	(build_olist)
	(if (and olist (not sel_method))
		(while (not purgef)
			(initget "All None Individual eXit ?")
			(cond
				( (not (setq inp (getkword "\nSelect [All/None/Individual/<eXit>/?]: ")))
					(setq purgef 1))
				( (= inp "?")
					(sp_help "PurgeSet" nil))
				( (= inp "eXit")
					(setq purgef 1))
				( (= inp "All")
					(setq olist_sel nil
								cnt (length olist))
					(while (>= (setq cnt (1- cnt)) 0) (setq olist_sel (cons cnt olist_sel)))
					(save_sel)
					(setq purgef 1))
				( (= inp "None")
					(setq olist_sel nil)
					(save_sel)
					(setq purgef 1))
				( (= inp "Individual")
					(setq cnt -1)
					(while (< (setq cnt (1+ cnt)) (length olist))
						(initget "Yes No eXit")
						(setq inp
							(getkword
								(strcat "\n  Select "
												name
												" "
												(car (nth cnt olist))
												"? ["
												(if (member cnt olist_sel) "<Yes>/No" "Yes/<No>")
												"/eXit]: ")))
						(cond
							( (= inp "eXit")
								(setq cnt -1))
							( (= inp "Yes")
								(if (not (member cnt olist_sel)) (setq olist_sel (cons cnt olist_sel))))							( (= inp "No")
								(if (member cnt olist_sel)
									(setq olist_sel
										(append
											(cdr (member cnt olist_sel))
											(cdr (member cnt (reverse olist_sel)))))))))
					(save_sel)
					(setq purgef 1)))))
)

(defun GetCadlockStat (/ sig stat)
	(if
		(and
			(member (type clSignature) '(SUBR EXSUBR EXRXSUBR))
			(setq sig (clSignature))
			(= (type sig) 'STR)
			(wcmatch sig "*CADLock*")
			(member (type clStat) '(SUBR EXSUBR EXRXSUBR))
			(setq stat (clStat))
			(listp stat))
		stat)
)


(defun hardpurge_warning (/ disable ret)
  (or
		(and
			(= 'STR (type *Spurge_DisableHardPurgeWarning))
			(member (strcase *Spurge_DisableHardPurgeWarning) '("YES" "ON" "TRUE" "1")))
		(progn
			(if (new_dialog "WARNING2" dcl_id)
				(progn
					(action_tile "help" "(sp_help \"IDH_HardPurgeWarning\" nil)")
					(action_tile "disable" "(setq disable (= \"1\" $value))")
					(setq ret (= 1 (start_dialog)))
					(if disable
						(progn
							(write_profile "Modes" "DisableHardPurgeWarning" "Yes")
							(setq *Spurge_DisableHardPurgeWarning "Yes")))))
			ret))
)

(defun list_allbut (list1 list2 / tlist)
	(foreach a list1 (if (not (member a list2)) (setq tlist (cons a tlist))))
	(reverse tlist)
)

(defun list_isect (list1 list2 / tlist)
	(if (> (length list1) (length list2)) (setq tlist list1 list1 list2 list2 tlist tlist nil))
	(foreach a list1 (if (member a list2) (setq tlist (cons a tlist))))
	(reverse tlist)
)

(defun list_union (list1 list2 / tlist)
	(if (> (length list1) (length list2)) (setq tlist list1 list1 list2 list2 tlist tlist nil))
	(foreach a list1 (if (not (member a list2)) (setq list2 (append list2 (list a)))))
	list2
)

(defun list_wcmatch (inlist wc / tlist)
	(foreach a inlist (if (wcmatch (strcase a) wc) (setq tlist (cons a tlist))))
	(reverse tlist)
)

(defun listcar_wcmatch (inlist wc / tlist)
	(foreach a inlist (if (and a (wcmatch (strcase (car a)) wc)) (setq tlist (cons a tlist))))
	(reverse tlist)
)

(defun load_pfile (fname / fh fh1 pv inp tlist nlist i sl idx endb cnt flag plist)
	(if (and fname (= 'STR (type fname)) (setq fh (open fname "r")))
		(progn
			(setq inp (read-line fh))
			(while inp
				(cond
					( (wcmatch inp "`[Spurge`]*")
						(setq flag 1)
						(while (and flag (setq inp (strcase (read-line fh))))
							(cond
								( (wcmatch inp "LOGFILE=*")
									(and
										(setq pv (parse_param inp))
										(setq logfile pv)
										(setup_logfile)))
								( (wcmatch inp "LOGTOFILE=*")
									(setq uselog (member (parse_param inp) '("YES" "ON" "TRUE" "1"))))
								( (wcmatch inp "LOGTOSCREEN=*")
									(setq echolog (member (parse_param inp) '("YES" "ON" "TRUE" "1"))))
								( (wcmatch inp "PURGETYPE=*")
									(setq purgetype (cdr (assoc (parse_param inp) '(("HARD" . 1))))))
								( (wcmatch inp "SHOWONLYPURGEABLE=*")
									(setq p_only (member (parse_param inp) '("YES" "ON" "TRUE" "1"))))
								( (wcmatch inp "DISPOSITION=*")
									(if (member (setq pv (parse_param inp)) '("EXCLUDE" "PURGE"))
										(setq exclude (= pv "EXCLUDE"))))
								( (wcmatch inp "SELECTMETHOD=*")
									(if (member (setq pv (parse_param inp)) '("PATTERN" "INDIVIDUAL"))
										(setq sel_method (= pv "PATTERN"))))
								( (wcmatch inp "OBJECTTYPE=*")
									(cond
										( (assoc (setq pv (parse_param inp)) def_list)
											(setq otype (length (member (assoc pv def_list) (reverse def_list)))))
										( (setq otype 0))))
								( (wcmatch inp "SPECLIST=*")
									(cond
										(if (setq pv (parse_ospeclist (parse_param inp)))
											(setq ospec_list (append '("<All>" "<None>") pv)))))
								( (wcmatch inp "`[*`]*")
									(setq flag nil)))))
					( (wcmatch inp "`[*`]*")
						(setq cnt 0
									flag nil)
						(while (and (<= (setq cnt (1+ cnt)) (strlen inp)) (/= (substr inp cnt 1) "[")))
						(if (<= cnt (strlen inp))
							(progn
								(setq endb cnt)
								(while (and (<= (setq endb (1+ endb)) (strlen inp)) (/= (substr inp endb 1) "]")))
								(if
									(setq idx
										(if (= (setq inp (substr inp (1+ cnt) (- endb cnt 1))) "<All>")
											0
											(length
												(member
													(assoc inp def_list)
													(reverse def_list)))))
									(progn
										(setq flag 1 tlist nil nlist nil)
										(while (and flag (setq inp (read-line fh)))
											(cond
												( (wcmatch inp "`[*`]*")
													(setq flag nil))
												( (wcmatch (strcase inp) "NAME=*")
													(setq nlist (cons (strcase (parse_param inp)) nlist)))
												( (wcmatch (strcase inp) "PATTERN=*")
													(setq plist (cons (cons idx (conv_patt (parse_param inp))) plist)))))
										(if (> idx 0)
											(progn
												(setq sl (reverse (mapcar 'strcase (mapcar 'car (cadr (nth (1- idx) reflist))))))
												(foreach x nlist
													(if (> (setq i (length (member x sl))) 0) (setq tlist (cons (1- i) tlist))))
												(setq sel_list
													(subst
														(list (car (nth (1- idx) reflist)) tlist)
														(assoc (car (nth (1- idx) reflist)) sel_list)
														sel_list)))))
									(setq inp (read-line fh))))
							(setq inp (read-line fh))))
					( (setq inp (read-line fh)))))
			(close fh)
			(foreach p plist
				(setq spec_list
					(subst
						(cons
							(car p)
							(progn
								(setq pv (- (length ospec_list) (length (member (cdr p) ospec_list))))
								(if (= pv (length ospec_list))
									(progn
										(setq ospec_list
											(append
												(list
													(car ospec_list)
													(cadr ospec_list)
													(cdr p))
												(if (> (length ospec_list) (1+ (length def_list)))
													(reverse (cdr (reverse (cddr ospec_list))))
													(cddr ospec_list))))
										2)
									pv)))
						(assoc (car p) spec_list)
						spec_list)))
			1))
)

(defun lowres_prompt (/ permanent ret)
	(if (new_dialog "LOWRES" dcl_id)
		(progn
			(action_tile "help" "(sp_help \"IDH_LowResolutionPrompt\" nil)")
			(action_tile "permanent" "(setq permanent (= \"1\" $value))")
			(setq ret (= 1 (start_dialog)))
			(if permanent
				(progn
					(write_profile "Modes" "LowResolution" "Yes")
					(setq *Spurge_LowResolution "Yes")))))
	ret
)

(defun olist_init ()
	(mode_tile "olist" 0)
	(mode_tile "pattern" 0)
	(if (> (length ospec_list) 2)
		(progn
			(start_list "ospec")
			(mapcar 'add_list ospec_list)
			(end_list)))
	(set_tile "olist" "")
)

(defun parse_list_idx (lval / cnt ret)
	(setq cnt (strlen lval))
	(while (> (setq cnt (1- cnt)) 0)
		(if (= (substr lval cnt 1) " ")
			(setq ret (cons (atoi (substr lval cnt)) ret))))
	(cons (atoi lval) ret)
)

(defun parse_ospeclist (inp / cnt endq)
	(if (/= inp "")
		(progn
			(setq cnt 0
						inp (strcat " " inp))
			(while (and (<= (setq cnt (1+ cnt)) (strlen inp)) (not (wcmatch (substr inp cnt 2) "[~\\]\""))))
			(if (<= cnt (strlen inp))
				(progn
					(setq endq (1+ cnt))
					(while (and (<= (setq endq (1+ endq)) (strlen inp)) (not (wcmatch (substr inp endq 2) "[~\\]\""))))
					(if (<= endq (strlen inp))
						(cons (strcase (substr inp (+ cnt 2) (- endq cnt 1))) (parse_ospeclist (substr inp (+ endq 2)))))))))
)

(defun parse_param (p / cnt)
	(setq cnt (1+ (strlen p)))
	(while (and (> cnt 0) (/= (substr p (setq cnt (1- cnt)) 1) "=")))	(if (> cnt 0)
		(substr p (1+ cnt)))
)

(defun print_log (purged fh / logit cnt ol ll)
	(defun logit (out)
		(if fh (princ out fh))
		(if echolog (princ out)))
	(logit "\n============================================================")
	(logit (strcat "\n ~~~~~~~~~~~~~~~~~~  " (menucmd "M=$(edtime, $(getvar, date), DDDD\",\" DD MON YYYY  @ H:MMam/pm)")))
	(logit (strcat "\n   SuperPurge Log     Drawing:  " (getvar "DWGNAME")))
	(logit (strcat "\n ~~~~~~~~~~~~~~~~~~      User:  " (getvar "LOGINNAME")))
	(logit "\n------------------------------------------------------------\n")
	(setq cnt -1)
	(while (< (setq cnt (1+ cnt)) (length def_list))
		(setq ol (cadr (nth cnt purged))
					ll (if ol (apply '+ (mapcar 'cadr ol)) 0))
		(logit
			(strcat
				"  "
				(nth (1+ cnt) otype_list)
				":  "
				(if (zerop ll)
					"<None>"
					(strcat
						"["
						(itoa ll)
						"]"))
				"\n"))		(foreach obj ol
		  (if (> (cadr obj) 0)
				(logit
					(strcat
						"          "
						(car obj)
						(if (> (cadr obj) 1) (strcat " (" (itoa (cadr obj)) ")") "")
						"\n")))))
)

(defun purge_sym (/ tlist purgecnt)
	(if (= purgetype 1) (or (hardpurge_warning) (exit)))
	(if
		(setq tlist
			(dopurge
				exclude
				(mapcar '(lambda (s) (list (car s) (mapcar 'car (cadr s))))
					(build_purge_set))
				purgetype))
		(progn			(setq tlist
						(reorder_rlist tlist)
						purgecnt
						(apply '+
							(mapcar '(lambda (x) (apply '+ (mapcar 'cadr x))) (mapcar 'cadr tlist))))
			(update_log tlist)
			(princ
				(strcat "\n  SuperPurge:  Purged "
								(itoa purgecnt)
								" object"
								(if (= 1 purgecnt) "" "s")
								".\n"))
			(if (or (cadr (assoc "DICTIONARY" tlist)) (cadr (assoc "ENTITY" tlist)))
				(purge_warning))
			(if echolog (textscr)))
		(exit))
)

(defun purge_warning (/ disable ret)
  (or
		(and
			(= 'STR (type *Spurge_DisableCorruptionWarning))
			(member (strcase *Spurge_DisableCorruptionWarning) '("YES" "ON" "TRUE" "1")))
		(progn
			(if (new_dialog "WARNING1" dcl_id)
				(progn
					(action_tile "help" "(sp_help \"IDH_CorruptionWarning\" nil)")
					(action_tile "disable" "(setq disable (= \"1\" $value))")
					(setq ret (= 1 (start_dialog)))
					(if disable
						(progn
							(write_profile "Modes" "DisableCorruptionWarning" "Yes")
							(setq *Spurge_DisableCorruptionWarning "Yes")))))
			ret))
)

(defun reorder_rlist (rlist / cnt tlist titem)
	(setq cnt -1)
	(while (< (setq cnt (1+ cnt)) (length def_list))
		(setq tlist
			(cons
				(if (setq titem (assoc (car (nth cnt def_list)) rlist))
					(list
						(car titem)
						(cond
							( (= "BLOCK" (car titem))
								(listcar_wcmatch (cadr titem) "~`*[MP][OA][DP]E[LR]_SPACE"))
							( (cadr titem))
						)
						(caddr titem)
						(cadddr titem))
					(list (car (nth cnt def_list)) nil nil))
				tlist)))
	(reverse tlist)
)

(defun repaint_olist (/ cnt idx lval li)
	(set_tile "olist" (setq lval ""))
	(start_list "olist")
	(setq cnt (setq idx page))
	(if olist
		(progn
			(while (and (setq li (nth cnt olist)) (< cnt (+ idx pagelen)))
				(add_list
					(strcat
						(if (caddr li) (caddr li) "")
						(car li)
						(if (> (cadr li) 1) (strcat " (" (itoa (cadr li)) ")") "")))
				(if (member cnt olist_sel)
					(setq lval (strcat lval " " (itoa (- cnt idx)))))
				(setq cnt (1+ cnt)))))
	(end_list)
	(set_tile "olist" lval)
	(if (and (>= acadver "14") (> (length olist) pagelen))
		(alert
			(strcat
				"The number of objects to display exceeds the\n"
				"list box capacity! The list will be truncated so\n"
				"that only the first " (itoa pagelen) " items of " (itoa (length olist)) "\n"
				"are displayed.")))
	(set_slider)
	(update_counts)
)

(defun save_pfile (fname / fh cnt pset)
	(if (and fname (= 'STR (type fname)) (setq fh (open fname "w")))
		(progn
			(princ "[Spurge]\n" fh)
			(princ (strcat "LogToScreen=" (if echolog "Yes" "No") "\n") fh)
			(princ (strcat "LogToFile=" (if uselog "Yes" "No") "\n") fh)
			(princ (strcat "LogFile=" (if logfile logfile "") "\n") fh)
			(princ (strcat "PurgeType=" (if (= purgetype 1) "Hard" "Normal") "\n") fh)
			(princ (strcat "ShowOnlyPurgeable=" (if p_only "Yes" "No") "\n") fh)
			(princ (strcat "Disposition=" (if exclude "Exclude" "Purge") "\n") fh)
			(princ (strcat "SelectMethod=" (if sel_method "Pattern" "Individual") "\n") fh)
			(princ (strcat "ObjectType=" (if (zerop otype) "" (car (nth (1- otype) def_list))) "\n") fh)
			(princ (strcat "SpecList=\"" (if (caddr ospec_list) (caddr ospec_list) "") "\"") fh)
			(mapcar '(lambda (x) (princ (strcat ",\"" x "\"") fh)) (cdddr ospec_list))
			(princ "\n" fh)
			(setq cnt -1
						pset (build_purge_set))
			(while (<= (setq cnt (1+ cnt)) (length def_list))
				(princ (strcat "\n[" (if (zerop cnt) "<All>" (car (nth (1- cnt) def_list))) "]\n") fh)
				(princ (strcat "Pattern=" (nth (dxf cnt spec_list) ospec_list) "\n") fh)
				(if (/= 0 cnt)
					(mapcar '(lambda (x) (princ (strcat "Name=" (car x) "\n") fh)) (cadr (nth (1- cnt) pset)))))
			(close fh)
			1))
)

(defun save_sel (/ ot idx idxob ob qty symdef tlist slist)
	(setq
		idx -1
		symdef (mapcar '(lambda (x) (setq idx (1+ idx))(cons (cadr x) idx)) def_list)
		idx (length olist))
	(while (>= (setq idx (1- idx)) 0)
		(setq idxob (nth idx olist)
					qty (cadr idxob)
					ob (car idxob)
					ot (if (zerop otype) (dxf (substr (caddr idxob) 2) symdef) (1- otype))
					tlist (nth ot sel_list)
					slist (cadr tlist)
					idxob (1- (length (member (list ob qty) (reverse (cadr (nth ot reflist)))))))
		(if (member idx olist_sel)
			(if (not (member idxob slist))
				(setq sel_list
					(subst
						(list (car tlist) (cons idxob slist))
						tlist
						sel_list)))
			(if (member idxob slist)
				(setq sel_list
					(subst
						(list
							(car tlist)
							(append (cdr (member idxob slist)) (cdr (member idxob (reverse slist)))))
						tlist
						sel_list)))))
	(setq spec_list (subst (cons otype ospec) (assoc otype spec_list) spec_list))
)

(defun select_sym (inp)
	(cond
		( (= inp "Block")
			(get_spec "Block" 1))
		( (= inp "LAyer")
			(get_spec "Layer" 2))
		( (= inp "LType")
			(get_spec "Linetype" 3))
		( (= inp "Style")
			(get_spec "Text Style" 4))
		( (= inp "vPort")
			(get_spec "Viewport" 5))
		( (= inp "Appid")
			(get_spec "Application ID" 6))
		( (= inp "VIew")
			(get_spec "Named View" 7))
		( (= inp "Ucs")
			(get_spec "UCS" 8))
		( (= inp "Dimstyle")
			(get_spec "Dimension Style" 9))
		( (= inp "Group")
			(get_spec "Named Group" 10))
		( (= inp "Mlinestyle")
			(get_spec "Multiline Style" 11))
		( (= inp "Shapefile")
			(get_spec "Shape File" 12))
		( (>= (substr acadver 1 2) "15")
			(cond
				( (= inp "laYout")
					(get_spec "Layout" 13))
				( (= inp "PLotstyle")
					(get_spec "Plot Style" 13))
				( (= inp "DICtionary")
					(get_spec "Dictionary Entries" 14))
				( (= inp "ENtities")
					(get_spec "Drawing Entities" 15))))
		( 1
			(cond
				( (= inp "DICtionary")
					(get_spec "Dictionary Entries" 13))
				( (= inp "ENtities")
					(get_spec "Drawing Entities" 14)))))
)

(defun set_err (msg) (set_tile "error" (if (setq err msg) msg "")))

(defun set_slider (/ inc)
	(cond
		( (= (length olist) 1)
			(set_tile "page" (itoa max_slider))
			(setq page_slider max_slider))
		( (zerop page)
			(set_tile "page" (itoa max_slider))
			(setq page_slider max_slider))
		( (>= page (1- (length olist)))
			(set_tile "page" "1")
			(setq page_slider 1))
		( (set_tile "page"
				(itoa
					(setq page_slider
						(fix (* (- (length olist) page 1) page_inc)))))))
)

(defun setup_logfile ()
	(set_tile "logfilename" (if logfile logfile "spurge.log"))
	(set_tile "uselog" (if uselog "1" "0"))
	(set_tile "echolog" (if echolog "1" "0"))
	(mode_tile "logfilename" (if uselog 0 1))
	(mode_tile "logfile" (if uselog 0 1))
)

(defun setup_ptype (/ pf)
	(set_tile "purgetype" (if (= purgetype 1) "pt_hard" "pt_normal"))
)

(defun sp_callbacks (key why value / cnt sl i)
	(clear_err)
	(cond		( (= key "olist")
			(update_sel)
			(save_sel)
			(update_counts))
		( (= key "otype")
			(if (/= otype (setq value (fix (distof value))))
				(progn
					(setq i otype
								otype value
					)
					(setq ospec (dxf otype spec_list))
					(build_olist)
					(set_tile "ospec" (itoa ospec))
					(set_tile "pattern" (conv_ol (nth ospec ospec_list)))
					(repaint_olist))))
		( (= key "ospec")
			(if (/= ospec (setq value (fix (distof value))))
				(progn
					(setq ospec value
								spec_list (subst (cons otype ospec) (assoc otype spec_list) spec_list))
					(build_olist)
					(set_tile "pattern" (conv_ol (nth ospec ospec_list)))
					(repaint_olist))))
		( (= key "pattern")
			(if (/= (setq value (conv_patt (strcase value))) (nth ospec ospec_list))
				(progn
					(if (setq ospec (member value (reverse ospec_list)))
						(set_tile "ospec" (itoa (setq ospec (1- (length ospec)))))
						(progn
							(setq spec_list
								(mapcar '(lambda (x) (cons (car x) (if (> (cdr x) 1) (1+ (cdr x)) (cdr x)))) spec_list))
							(setq spec_list (subst (cons otype 2) (assoc otype spec_list) spec_list))
							(setq ospec_list
								(append
									(list
										(car ospec_list)
										(cadr ospec_list)
										value)
									(if (> (length ospec_list) (1+ (length def_list)))
										(reverse (cdr (reverse (cddr ospec_list))))
										(cddr ospec_list))))
							(start_list "ospec")
							(mapcar 'add_list ospec_list)
							(end_list)
							(set_tile "ospec" "2")
							(setq ospec 2)))
					(build_olist)
					(repaint_olist))))
		( (= key "p_only")
			(setq i (= value "1"))
			(if (/= i p_only)
				(progn
					(setq p_only i)
					(build_olist)
					(repaint_olist))))
		( (member key '("pdisp" "xdisp"))
			(setq exclude (= key "xdisp")))
		( (member key '("pt_normal" "pt_hard"))
			(setq i (dxf key '(("pt_hard" . 1))))
			(if (/= i purgetype)
				(progn
					(setq purgetype i)
					(build_olist)
					(repaint_olist))))
		( (member key '("sind" "spat"))
			(foreach k '("all" "none")
				(mode_tile k
					(if (setq sel_method (= key "spat"))
						1
						0)))
			(update_counts))
		( (= key "page")
			(if (/= (setq i (atoi value)) page_slider)
				(if (> i page_slider)
					(if (> page 0)
						(progn
							(setq page
								(fix
									(cond
										( (= (- i page_slider) 1)
											(1- page))
										( (= (- i page_slider) 2)											(if (> page pagelen) (- page pagelen) 0))
										( 1
											(/ (+ (/ page_inc 2.0) (- max_slider i)) page_inc 1.0)))))
							(repaint_olist))
						(set_slider))
					(if (< page (1- (length olist)))
						(progn
							(setq page
								(fix
									(cond
										( (= (- page_slider i) 1)
											(1+ page))
										( (= (- page_slider i) 2)
											(if (< page (- (length olist) pagelen 1)) (+ page pagelen) (1- (length olist))))
										( 1
											(/ (+ (/ page_inc 2.0) (- max_slider i)) page_inc 1.0)))))
							(repaint_olist))
						(set_slider)))))
		( (= key "all")
			(setq olist_sel nil
						cnt (length olist))
			(while (>= (setq cnt (1- cnt)) 0) (setq olist_sel (cons cnt olist_sel)))
			(save_sel)
			(repaint_olist))
		( (= key "none")
			(setq olist_sel nil)
			(save_sel)
			(repaint_olist))
		( (= key "uselog")
			(setq uselog (= value "1"))
			(setup_logfile))
		( (= key "echolog")
			(setq echolog (= value "1")))
		( (= key "logfile")
			(if (setq sl (getfiled "SuperPurge Log File" (if logfile logfile "spurge.log") "log" 39))
				(progn
					(setq logfile sl)
					(setup_logfile))))
		( (= key "pload")
			(if
				(setq sl
					(getfiled "Load SuperPurge settings" (if pfile pfile "spurge.spp") "spp" 6))
				(if (load_pfile sl)
					(progn
						(setq pfile sl)
						(setup_ptype)
						(set_tile "disposition" (if exclude "xdisp" "pdisp"))
						(set_tile "sel_method" (if sel_method "spat" "sind"))
						(set_tile "p_only" (if p_only "1" "0"))
						(setup_logfile)
						(setq page 0)
						(set_tile "otype" (itoa otype))
						(set_tile "ospec" (itoa (setq ospec (cdr (nth otype spec_list)))))
						(build_olist)
						(olist_init)
						(set_tile "ospec" (itoa ospec))
						(set_slider)
						(repaint_olist)
						(if err (set_err err))
						(foreach k '("all" "none")
							(mode_tile k (if sel_method 1 0)))))))
		( (= key "psave")
			(if
				(setq sl
					(getfiled "Create SuperPurge settings file" (if pfile pfile "spurge.spp") "spp" 7))
				(if (save_pfile sl) (setq pfile sl))))
		( (= key "cancel")
			(done_dialog 0))
		( (= key "accept")
			(done_dialog 1))
		( (= key "help")
			(sp_help "" nil))
		( (= key "pt_normal_help")
			(sp_help "NormalPurgeType" 51))
		( (= key "pt_hard_help")
			(sp_help "HardPurgeType" 52))
		( (= key "pdisp_help")
			(sp_help "PurgeSelected" 31))
		( (= key "xdisp_help")
			(sp_help "ExcludeSelected" 32))
		( (= key "sind_help")
			(sp_help "IndividualSelect" 41))
		( (= key "spat_help")
			(sp_help "PatternSelect" 42))
		( (= key "load_settings_help")
			(sp_help "LoadSettings" 61))
		( (= key "save_settings_help")
			(sp_help "SaveSettings" 62))
		( (= key "p_only_help")
			(sp_help "OnlyPurgeable" 21)))
)

(defun sp_help (topic popup / hf win)
	(if
		(or
			(and
				(wcmatch platform "*Windows*")
				(setq hf (setq win (*spurge_fpath "SPURGE.HLP"))))
			(setq hf (*spurge_fpath "SPURGE.AHP")))
		(if (and popup win)
			(helppopup hf popup)
			(if (= topic "") (help hf topic "HELP_CONTENTS") (help hf topic)))
		(alert
			(strcat
				"Cannot find help file 'Spurge."
				(if win "hlp" "ahp")
				"'\n   check SuperPurge installation!")))
)

(defun spurgex ()
	(if xname (x_unload xname nil))
	(if wvxname (xunload wvxname nil))
	(if dcl_id (unload_dialog dcl_id))
	(setvar "CMDECHO" (car oldvars))
	(setq *error* olderr_spurge
				olderr_spurge  -1)
	(princ)
)

(defun strip_path (path / cnt)
	(if (and path (= 'STR (type path)))
		(progn
			(setq cnt (strlen path))
			(while (and (> cnt 0) (wcmatch (substr path cnt 1) "[~\\`/`:]"))
				(setq cnt (1- cnt)))
			(substr path (1+ cnt))))
)

(defun update_counts ()
	(set_tile "dispqty" (itoa (length olist)))
	(set_tile "selqty" (itoa (length (if sel_method olist olist_sel))))
	(set_tile "psetqty"
		(itoa
			(apply '+
				(mapcar '(lambda (x) (apply '+ (mapcar 'cadr (cadr x)))) (build_purge_set)))))
)

(defun update_log (purged / fh)
	(if (and uselog logfile (= 'STR (type logfile)) (setq fh (open logfile "a")))
		(progn
			(print_log purged fh)
			(close fh))
		(progn
			(print_log purged nil)
			(if uselog
				(princ
					(strcat
						"\nLog file "
						(if (and (= 'STR (type logfile)) (/= "" logfile)) (strcat logfile " ") "")
						"could not be opened for writing--no file logging performed")))))
)

(defun update_sel (/ cnt idx sel)
	(if olist
		(progn
			(setq cnt (setq idx page)
						sel (mapcar '(lambda (x) (+ x idx)) (parse_list_idx (get_tile "olist"))))
			(while (< cnt (+ idx pagelen))
				(if (member cnt sel)
					(if (not (member cnt olist_sel)) (setq olist_sel (cons cnt olist_sel)))
					(if (member cnt olist_sel)
						(setq olist_sel
							(append
								(cdr (member cnt olist_sel))
								(cdr (member cnt (reverse olist_sel)))))))
				(setq cnt (1+ cnt)))))
)

(defun write_profile (section key value / fh inp contents new fname cnt found)
	(setq fname (*spurge_fpath "SPURGE.INI"))
	(if fname
		(progn
			(if (setq fh (open fname "r"))
				(progn
					(while (setq inp (read-line fh)) (setq contents (cons inp contents)))
					(close fh))
				(setq fname nil) ;signal an error
			))
		(progn
			(if (/= (type *Spurge_Path) 'STR) (setq *Spurge_Path ""))
			(if (and (/= *Spurge_Path "") (wcmatch *Spurge_Path "~*[\\/:]"))
  			(setq *Spurge_Path (strcat *Spurge_Path "\\")))
			(setq fname (strcat *Spurge_Path "SPURGE.INI"))))
	(if fname
		(progn
			(setq cnt (length contents))
			(while
				(and
					(>= (setq cnt (1- cnt)) 0)
					(wcmatch (nth cnt contents) (strcat "~`[" section "`]*")))
				(setq new (cons (nth cnt contents) new)))
			(if (< cnt 0)
				(setq new (cons (strcat key "=" value) (cons (strcat "[" section "]") contents))
							found 1)
				(progn
					(setq new (cons (nth cnt contents) new))
					(while
						(and
							(>= (setq cnt (1- cnt)) 0)
							(wcmatch (nth cnt contents) "~`[*`]*")
							(or
								(wcmatch (nth cnt contents) (strcat "~" key "=*"))
								(not (setq found 1))))
						(setq new (cons (nth cnt contents) new)))
					(setq new (cons (strcat key "=" value) new))
					(if (not found) (setq cnt (1+ cnt)))
					(while (>= (setq cnt (1- cnt)) 0) (setq new (cons (nth cnt contents) new)))))
			(if (setq fh (open fname "w"))
				(progn
					(foreach line (reverse new) (write-line line fh))
					(close fh)
					fname))))
)


;************************  
;***** MAIN PROGRAM *****  
;************************  
	
	(setq olderr_spurge *error*
				oldvars       (list (getvar "CMDECHO"))
				acadver       (getvar "ACADVER")
				platform      (getvar "PLATFORM"))
	(if (not *Spurge_Debug)
		(setq *error* errexit_spurge))

	(if
		(or
			(< (substr acadver 1 2) "13")
			(and (= "13" (substr acadver 1 2)) (< (atoi (substr acadver 5)) 4)))
		(progn
			(princ "\nYou can only use this version of SuperPurge in AutoCAD Release 13c4 or later!\n")
			(exit)))

	(setq lowres
		(or
			(and
				(= 'STR (type *Spurge_LowResolution))
				(member (strcase *Spurge_LowResolution) '("ON", "1", "TRUE", "YES")))
			(and
				(wcmatch platform "*DOS*")
				(if (> (getvar "SCREENBOXES") 0)
					(< (getvar "SCREENBOXES") 39)
					(< (read (menucmd "M=$(linelen)")) 90)))))
	(setq x_load arxload
				x_unload arxunload
				x_file (cond
								((= "15" (substr acadver 1 2)) "SPURGE15.ARX")
								((= "14" (substr acadver 1 2)) "SPURGE14.ARX")
								(1 "SPURGE13.ARX")))

	;Check for CADLock(tm) secured drawing
	(setq purge_enabled 1)
	(and
		(setq cadlockStat (GetCadlockStat))
		(= (type (car cadlockStat)) 'INT)
		(cond
			( (/= 18 (logand (car cadlockStat) 18))
				(if (zerop (getvar "CMDDIA"))
					(princ "\nDatabase access is restricted by CADLock(tm).\n    * SuperPurge cannot continue! *\n")
					(alert "Database access is restricted by CADLock(tm).\n    SuperPurge cannot continue!\n"))
				(exit))))

	(or
		(member (type getrefs) '(EXSUBR EXRXSUBR))
		(and
			(setq xname (*spurge_fpath x_file))
			(setq xname (x_load xname nil))
			(member (type getrefs) '(EXSUBR EXRXSUBR)))
		(if (zerop (getvar "CMDDIA"))
			(progn (princ (strcat "\nCannot load " x_file " :  The file may be corrupt or missing")) (exit))
			(progn
				(alert (strcat "Cannot load "												x_file
												" :  The file may be corrupt or missing"
												"\n "
												"\n          SuperPurge will abort......"))
				(exit))))
	(setq slistbox (wcmatch platform "*DOS*"))

	
	(setvar "CMDECHO" (if *Spurge_Debug 1 0))

	(setq def_list		(cond
			( (>= (substr acadver 1 2) "15")
			  '(("BLOCK"      "\tBlk\t") ;Blocks
					("LAYER"      "\tLay\t") ;Layers
					("LTYPE"      "\tLin\t") ;Linetypes
					("STYLE"      "\tSty\t") ;Text Styles
					("VPORT"      "\tVp \t") ;Viewports
					("APPID"      "\tApp\t") ;Appids
					("VIEW"       "\tVi \t") ;Views
					("UCS"        "\tUcs\t") ;UCS
					("DIMSTYLE"   "\tDim\t") ;Dimstyles
					("GROUP"      "\tGrp\t") ;Groups
					("MLINESTYLE" "\tMls\t") ;MLine Styles
					("SHAPE"      "\tShp\t") ;Shape files
					("LAYOUT"     "\tLyt\t") ;Layouts
					("PLOTSTYLE"  "\tPlt\t") ;Plot Styles
					("DICTIONARY" "\tDic\t") ;Dictionary entries
					("ENTITY"     "\tEnt\t") ;Drawing entities
				))
			( 1
			  '(("BLOCK"      "\tBlk\t") ;Blocks
					("LAYER"      "\tLay\t") ;Layers
					("LTYPE"      "\tLin\t") ;Linetypes
					("STYLE"      "\tSty\t") ;Text Styles
					("VPORT"      "\tVp \t") ;Viewports
					("APPID"      "\tApp\t") ;Appids
					("VIEW"       "\tVi \t") ;Views
					("UCS"        "\tUcs\t") ;UCS
					("DIMSTYLE"   "\tDim\t") ;Dimstyles
					("GROUP"      "\tGrp\t") ;Groups
					("MLINESTYLE" "\tMls\t") ;MLine Styles
					("SHAPE"      "\tShp\t") ;Shape files
					("DICTIONARY" "\tDic\t") ;Dictionary entries
					("ENTITY"     "\tEnt\t") ;Drawing entities
				))))
	
	(if (setq reflist (getrefs))
		(setq reflist (reorder_rlist reflist))
		(exit))

	(if (not (setq dcl_name (*spurge_fpath "SPURGE.DCL")))
		(progn
			(alert "Dialog definition file (SPURGE.DCL) not found!")
			(exit)))
	(if (not (setq dcl_id (load_dialog dcl_name)))
		(progn
			(alert "Error loading dialog definitions:  SPURGE.DCL may be corrupt.")
			(exit)))

	(setq exclude nil
				p_only 1
				sel_method nil
				purgetype nil
				echolog nil
				pfile (if (and *Spurge_ParamFile (= 'STR (type *Spurge_ParamFile)))
								(*spurge_fpath *Spurge_ParamFile)
							)
				sel_list (mapcar 'list (mapcar 'car reflist))
				otype 0
				otype_list
					(cond
						( (>= (substr acadver 1 2) "15")
							'("<All>" "Blocks" "Layers" "Linetypes" "Text Styles" "Viewports"
								"App IDs" "Named Views" "UCS" "Dimension Styles" "Groups"
								"Multiline Styles" "Shape Files" "Layouts" "Plot Styles"
								"Dictionary Entries" "Drawing Entities"
							))
						( 1
							'("<All>" "Blocks" "Layers" "Linetypes" "Text Styles" "Viewports"
								"App IDs" "Named Views" "UCS" "Dimension Styles" "Groups"
								"Multiline Styles" "Shape Files" "Dictionary Entries" "Drawing Entities"
							)))
				ospec 0
				ospec_list '("<All>" "<None>")
				patt_alias '(("<All>" . "*") ("<None>" . "") ("<None>" . "~*"))
				spec_list
					(cond
						( (>= (substr acadver 1 2) "15")
							'((0 . 0) (1 . 0) (2 . 0) (3 . 0) (4 . 0) (5 . 0) (6 . 0) (7 . 0)
								(8 . 0) (9 . 0) (10 . 0) (11 . 0) (12 . 0) (13 . 0) (14 . 0)
								(15 . 0) (16 . 0)
							))
						( 1
							'((0 . 0) (1 . 0) (2 . 0) (3 . 0) (4 . 0) (5 . 0) (6 . 0) (7 . 0)
								(8 . 0) (9 . 0) (10 . 0) (11 . 0) (12 . 0) (13 . 0) (14 . 0)
							)))
				ol_desc (mapcar '(lambda (x) (cons (cadr x) (car x))) def_list))
	(if (and *Spurge_LogFile (= 'STR (type *Spurge_LogFile)))
		(setq logfile (if (setq tlist (*spurge_fpath *Spurge_LogFile)) tlist *Spurge_LogFile)
					uselog 1)
		(setq logfile "spurge.log"
					uselog nil))

	(cond
		( arglist
			(cond
				( (and (listp arglist) (> (length arglist) 1))
					(setq exclude (car arglist)
								purgetype (if (= (type (cadr arglist)) 'INT) (cadr arglist))
								sel_method 1
								cnt 1)
					(foreach default def_list
						(setq spec
							(cond
								( (not (setq spec (nth (1+ cnt) arglist)))
									(setq spec_list (subst (cons cnt 1) (assoc cnt spec_list) spec_list)))
								( (= 'STR (type spec))
									(setq ospec_list (append ospec_list (list (strcase spec)))
												spec_list (subst
																		(cons cnt (1- (length ospec_list)))
																		(assoc cnt spec_list)
																		spec_list)))
								( (listp spec)
									(setq sel_method nil)
									(if (= 'STR (type (car spec)))
										(setq ospec_list (append ospec_list (list (strcase (car spec))))
													spec_list (subst
																			(cons cnt (1- (length ospec_list)))
																			(assoc cnt spec_list)
																			spec_list)))
									(setq olist (cadr (assoc (car default) reflist))
												tlist nil)
									(if (mapcar 'and (mapcar '(lambda (x) (= 'STR (type x))) (cdr spec)))
										(foreach x (cdr spec)
										  (if (assoc x olist)
												(setq tlist
													(cons
														(1- (length (member (assoc x olist) (reverse olist))))
														tlist)))))
									(setq sel_list
										(subst
											(cons
												(car default)
												(list (reverse tlist)))
											(nth (1- cnt) sel_list)
											sel_list)))))
						(setq cnt (1+ cnt)))
					(purge_sym))
				( (= 'STR (type arglist))
					(if (load_pfile (setq pfile (*spurge_fpath arglist)))
						(purge_sym)
						(princ (strcat "\nSuperPurge could not find settings file " arglist " -- nothing was purged!"))))
				( (progn
						(princ "\nInvalid argument -- (spurge) function cancelled")
						(exit)))))
		( (and
				(/= 0 (getvar "CMDDIA"))
				(zerop (logand 4 (getvar "CMDACTIVE"))))
			(load_pfile pfile)
			(while
				(and
					(not purgef)
					(or
						(new_dialog
							(strcat (if (>= acadver "14") "SPURGE14" "SPURGE13") (if lowres "_" ""))
							dcl_id
							"(sp_callbacks $key $reason $value)")
						(and
							(not lowres)
							(setq lowres (lowres_prompt))
							(new_dialog
								(strcat (if (>= acadver "14") "SPURGE14" "SPURGE13") (if lowres "_" ""))
								dcl_id
								"(sp_callbacks $key $reason $value)"))))
				(setq pagelen
					(if (>= acadver "14")
						528
						(+
							(if (setq pagelen (get_attr "olist" "height"))
								(atoi pagelen)
								(if lowres 11 15))
							(if slistbox 0 1))))
				(setq max_slider
					(if (setq max_slider (get_attr "page" "max_value"))
						(atoi max_slider)
						0))
				(setq ospec (dxf otype spec_list))
				(if (> (length ospec_list) 2)
					(progn
						(start_list "ospec")
						(mapcar 'add_list ospec_list)
						(end_list)))
				(mode_tile "accept" (if purge_enabled 0 1))
				(set_tile "pattern" (conv_ol (nth ospec ospec_list)))
				(start_list "otype")
				(mapcar 'add_list otype_list)
				(end_list)
				(set_tile "otype" (itoa otype))
				(set_tile "disposition" (if exclude "xdisp" "pdisp"))
				(set_tile "sel_method" (if sel_method "spat" "sind"))
				(set_tile "p_only" (if p_only "1" "0"))
				(setup_logfile)
				(setup_ptype)
				(build_olist)
				(olist_init)
				(set_tile "ospec" (itoa ospec))
				(set_slider)
				(repaint_olist)
				(foreach k '("all" "none")
					(mode_tile k (if sel_method 1 0)))
				(if err (set_err err))
				(setq ret (start_dialog))
				(cond
					( (zerop ret)
						(setq purgef 1))
					( (= 1 ret)
						(purge_sym)
						(setq purgef 1)))))
		( 1
			(while (not purgef)
				(initget
					(cond
						( (>= (substr acadver 1 2) "15")
							(strcat "Log File Exclude MEthod purgeType Select Purge eXit ?"
											" Block LAyer LType STyle vPort Appid VIew Ucs"
											" Dimstyle Group Mlinestyle Shapefile laYout"
											" PLotstyle DICtionary ENtities"))
						( 1
							(strcat "Log File Exclude MEthod purgeType Select Purge eXit ?"
											" Block LAyer LType STyle vPort Appid VIew Ucs"
											" Dimstyle Group Mlinestyle Shapefile DICtionary"
											" ENtities"))))
				(cond
					( (not
							(setq inp
								(getkword
									(strcat "\nSuperPurge\n  [Log/File/Exclude("
													(if exclude "yes" "no")
													")/MEthod("
													(if sel_method "P" "I")
													")/purgeType("
													(if (= purgetype 1) "hard" "normal")
													")\n  /Select("
													(substr
														(cond
															( (>= (substr acadver 1 2) "15")
																(strcat
																	(if (/= 1 (dxf 1 spec_list)) ",BL" "")
																	(if (/= 1 (dxf 2 spec_list)) ",LA" "")
																	(if (/= 1 (dxf 3 spec_list)) ",LT" "")
																	(if (/= 1 (dxf 4 spec_list)) ",ST" "")
																	(if (/= 1 (dxf 5 spec_list)) ",VP" "")
																	(if (/= 1 (dxf 6 spec_list)) ",AP" "")
																	(if (/= 1 (dxf 7 spec_list)) ",VI" "")
																	(if (/= 1 (dxf 8 spec_list)) ",U" "")
																	(if (/= 1 (dxf 9 spec_list)) ",D" "")
																	(if (/= 1 (dxf 10 spec_list)) ",G" "")
																	(if (/= 1 (dxf 11 spec_list)) ",ML" "")
																	(if (/= 1 (dxf 12 spec_list)) ",SH" "")
																	(if (/= 1 (dxf 13 spec_list)) ",LYT" "")
																	(if (/= 1 (dxf 14 spec_list)) ",PL" "")
																	(if (/= 1 (dxf 15 spec_list)) ",DIC" "")
																	(if (/= 1 (dxf 16 spec_list)) ",ENT" "")))
															( 1
																(strcat
																	(if (/= 1 (dxf 1 spec_list)) ",BL" "")
																	(if (/= 1 (dxf 2 spec_list)) ",LA" "")
																	(if (/= 1 (dxf 3 spec_list)) ",LT" "")
																	(if (/= 1 (dxf 4 spec_list)) ",ST" "")
																	(if (/= 1 (dxf 5 spec_list)) ",VP" "")
																	(if (/= 1 (dxf 6 spec_list)) ",AP" "")
																	(if (/= 1 (dxf 7 spec_list)) ",VI" "")
																	(if (/= 1 (dxf 8 spec_list)) ",U" "")
																	(if (/= 1 (dxf 9 spec_list)) ",D" "")
																	(if (/= 1 (dxf 10 spec_list)) ",G" "")
																	(if (/= 1 (dxf 11 spec_list)) ",ML" "")
																	(if (/= 1 (dxf 12 spec_list)) ",SH" "")
																	(if (/= 1 (dxf 13 spec_list)) ",DIC" "")
																	(if (/= 1 (dxf 14 spec_list)) ",ENT" ""))))
														2)
													")/Purge/<eXit>/?]: "))))
						(setq purgef 1))
					( (= inp "?")
						(sp_help "CommandLineOptions" nil))
					( (= inp "eXit")
						(setq purgef 1))
					( (= inp "Log")
						(while (not purgef)
							(if uselog
								(initget "Displaylog Uselogfile Filename eXit ?")
								(initget "Displaylog Uselogfile eXit ?"))
							(cond
								( (not
										(setq inp
											(getkword
												(strcat "\nLog options [Displaylog("
																(if echolog "yes" "no")
																")/Uselogfile("
																(if uselog "yes" "no")
																")"
																(if uselog
																	(strcat
																		"/Filename("
																		(if logfile logfile "<None>")
																		")")
																	"")
																"/<eXit>/?]: "))))
									(setq purgef 1))
								( (= inp "?")
									(sp_help "LogFile" 71))
								( (= inp "eXit")
									(setq purgef 1))
								( (= inp "Displaylog")
									(setq echolog (not echolog)))
								( (= inp "Uselogfile")
									(setq uselog (not uselog)))
								( (= inp "Filename")
									(if (zerop (getvar "FILEDIA"))
										(progn
											(setq inp
												(getstring
													(strcat
														"\nLog file name <"
														(if logfile logfile "")
														">: ")))
											(cond
												( (= inp "")
													(setq inp nil))
												( (= inp "~")
													(setq inp
														(getfiled
															"SuperPurge log file"
															(if logfile logfile "spurge.log")
															"log"
															39)))))
										(setq inp
											(getfiled
												"SuperPurge log file"
												(if logfile logfile "spurge.log")
												"log"
												39)))
									(if inp
										(setq logfile (strcat inp (if (wcmatch inp "*`.*") "" ".log")))))))
						(setq purgef nil))
					( (= inp "File")
						(while (not purgef)
							(initget "Load Create eXit ?")
							(cond
								( (not
										(setq inp
											(getkword
												(strcat "\nSuperPurge settings file("
																(if pfile pfile "<None>")
																") [Load/Create/<eXit>/?]: "))))
									(setq purgef 1))
								( (= inp "?")
									(sp_help "ParameterFile" 81))
								( (= inp "eXit")
									(setq purgef 1))
								( (= inp "Load")
									(if (zerop (getvar "FILEDIA"))
										(progn
											(setq inp (getstring "\nFile to load: "))
											(cond
												( (= inp "")
													(setq inp nil))
												( (= inp "~")
													(setq inp
														(getfiled "Load SuperPurge settings" (if pfile pfile "spurge.spp") "spp" 6)))))
										(setq inp
											(getfiled "Load SuperPurge settings" (if pfile pfile "spurge.spp") "spp" 6)))
									(if inp
										(if (setq pfile (*spurge_fpath (strcat inp (if (wcmatch inp "*`.*") "" ".spp"))))
											(if (not (load_pfile pfile))
												(progn
													(setq pfile nil)
													(princ "\nError loading SuperPurge settings")))
											(princ "\nFile not found"))))
								( (= inp "Create")
									(if (zerop (getvar "FILEDIA"))
										(progn
											(setq inp (getstring "\nFile to create: "))
											(cond
												( (= inp "")
													(setq inp nil))
												( (= inp "~")
													(setq inp
														(getfiled "Create settings file" (if pfile pfile "spurge.spp") "spp" 7)))))
										(setq inp
											(getfiled "Create settings file" (if pfile pfile "spurge.spp") "spp" 7)))
									(if inp
										(progn
											(setq pfile (*spurge_fpath (strcat inp (if (wcmatch inp "*`.*") "" ".spp"))))
											(if (not (save_pfile pfile))
												(progn
													(setq pfile nil)
													(princ "\nError creating settings file"))))))))
						(setq purgef nil))
					( (= inp "Select")
						(while (not purgef)
							(initget
								(cond
									( (>= (substr acadver 1 2) "15")
										(strcat "eXit ?"
														" Block LAyer LType STyle vPort Appid VIew Ucs"
														" Dimstyle Group Mlinestyle Shapefile laYout"
														" PLotstyle DICtionary ENtities"))
									( 1
										(strcat "eXit ?"
														" Block LAyer LType STyle vPort Appid VIew Ucs"
														" Dimstyle Group Mlinestyle Shapefile DICtionary"
														" ENtities"))))
							(cond
								( (not
										(setq inp
											(getkword
												(cond
													( (>= (substr acadver 1 2) "15")
														(strcat "[Block/LAyer/LType/STyle/vPort/Appid/View/Ucs/Dimstyle/Mlinestyle\n"
																		" /Group/Shapefile/laYout/PLotstyle/DICtionary/ENtities/<eXit>/?]: "))
													( 1
														(strcat "[Block/LAyer/LType/STyle/vPort/Appid/View/Ucs/Dimstyle/Mlinestyle\n"
																		" /Group/Shapefile/DICtionary/ENtities/<eXit>/?]: "))))))
									(setq purgef 1))
								( (= inp "?")
									(sp_help "PurgeSet" nil))
								( (= inp "eXit")
									(setq purgef 1))
								( (select_sym inp))))
						(setq purgef nil))
					( (= inp "Exclude")
						(setq exclude (not exclude)))
					( (= inp "purgeType")
						(while (not purgef)
							(initget "Normal Hard ?")
							(setq inp
								(getkword
									(strcat "Purge type ["
													(if (= purgetype 1) "Normal purge/<Hard purge>" "<Normal purge>/Hard purge")
													"/?]: ")))
							(cond
								( (= inp "?")
									(sp_help "PurgeType" nil))
								( (= inp "Hard")
									(setq purgetype 1
												purgef 1))
								( (= inp "Normal")
									(setq purgetype nil
												purgef 1))
								( (setq purgef 1))))
						(setq purgef nil))
					( (= inp "MEthod")
						(initget "Pattern Individual")
						(setq inp
							(getkword
								(strcat "Purge set selection method ["
												(if sel_method "Individual objects/<Pattern match>" "<Individual objects>/Pattern match")
												"]: ")))
						(if inp (setq sel_method (= inp "Pattern"))))
					( (= inp "Purge")
						(purge_sym)
						(setq purgef 1))
					( (select_sym inp))))))
	(if uctl (command "_.UNDO" "_END"))
	(spurgex)
)

(princ)
;End of File
