package mapexample;

import java.applet.*;
import java.awt.*;
import com.ibm.eou.swingimageregionselector.*;
import java.awt.event.*;
import com.sun.java.swing.*;

/**
 * This type was created in VisualAge.
 */
public class Mapexample extends com.sun.java.swing.JApplet implements ItemListener  
{
		private String[] regionNames = {	
			"Lincolnshire",
			"Lincoln",
			"Boston",
			"Leicestershire",
			"Loughborough",
			"Leicester",
			"Norfolk",
			"King's Lynn",
			"Norwich",
			"Great Yarmouth",
			"Northamptonshire",
			"Northampton",
			"Cambridgeshire",
			"Peterborough",
			"Cambridge",
			"Suffolk",
			"Bury St. Edmunds",
			"Ipswich",
			"Bedfordshire",
			"Bedford",
			"Leighton Buzzard",
			"Luton",
			"Buckinghamshire",
			"Buckingham",
			"Milton Keynes",
			"Hertfordshire",
			"St. Albans",
			"Hertford",
			"Essex",
			"Chelmsford",
			"Colchester"};
											
	private String[] tooltips = {
		"Click here for the county of Lincolnshire",
		"Click here for the city of Lincoln",
		"Click here for the town of Boston",
		"Click here for the county of Leicestershire",
		"Click here for the town of Loughborough",
		"Click here for the city of Leicester",
		"Click here for the county of Norfolk",
		"Click here for the town of King's Lynn",
		"Click here for the city of Norwich",
		"Click here for the town of Great Yarmouth",
		"Click here for the county of Northamptonshire",
		"Click here for the town of Northampton",
		"Click here for the county of Cambridgeshire",
		"Click here for the town of Peterborough",
		"Click here for the city of Cambridge",
		"Click here for the county of Suffolk",
		"Click here for the town of Bury St. Edmunds",
		"Click here for the town of Ipswich",
		"Click here for the county of Bedfordshire",
		"Click here for the town of Bedford",
		"Click here for the town of Leighton Buzzard",
		"Click here for the town of Luton",
		"Click here for the county of Buckinghamshire",
		"Click here for the city of Buckingham",
		"Click here for the city of Milton Keynes",
		"Click here for the county of Hertfordshire",
		"Click here for the town of St. Albans",
		"Click here for the town of Hertford",
		"Click here for the county of Essex",
		"Click here for the town of Chelmsford",
		"Click here for the town of Colchester"};
											

	private ImageRegionSelector angliaSelector;
	private JLabel selectionLabel;
		
/**
 * Initializes the applet.
 * 
 * @see #start
 * @see #stop
 * @see #destroy
 */
public void init() {
	super.init();

	final int selectorX = 20;
	final int selectorY = 20;

	getContentPane().setLayout(null);
	setSize(400,420);

	/* Set up the ImageRegionSelector */
	angliaSelector = new ImageRegionSelector();
	angliaSelector.setLocation(selectorX, selectorY);
	angliaSelector.setDisplayImage("/com/ibm/eou/swingimageregionselectorsamples/anglia.gif");
	angliaSelector.setColorMapImage("/com/ibm/eou/swingimageregionselectorsamples/anglia_map.gif");
	angliaSelector.setCutawayImage("/com/ibm/eou/swingimageregionselectorsamples/anglia_cutaway.gif");
	angliaSelector.setSelectionEmphasisStyle(ImageRegionSelector.CUTAWAY);
	angliaSelector.setRolloverEmphasisStyle(ImageRegionSelector.LIGHTEN);
	angliaSelector.setRegionNames(regionNames);
	angliaSelector.setTooltips(tooltips);

	getContentPane().add(angliaSelector);
	angliaSelector.addItemListener(this);

	/* Set up the label */
	selectionLabel = new JLabel("No region selected");
	selectionLabel.setBounds(selectorX, selectorY + angliaSelector.getHeight(), 350, 20);
	getContentPane().add(selectionLabel);

}
/**
 * This method was created in VisualAge.
 * @param e java.awt.event.ItemEvent
 */
public void itemStateChanged(ItemEvent e) 
{
	if(e.getStateChange() == ItemEvent.SELECTED)
	{
		selectionLabel.setText("Region selected: "+angliaSelector.getSelectedItem());
	}
	else
	{
		selectionLabel.setText("No region selected");
	}
}
}