package irsexample;

import java.applet.*;
import java.awt.*;
import com.ibm.eou.swingimageregionselector.*;
import com.sun.java.swing.*;
import java.awt.event.*;

/**
 * Sample ImageRegionSelectors applet
 */
public class Irsexample extends com.sun.java.swing.JApplet implements ItemListener
{
	/* Region names for map ImageRegionSelector */
	String[] mapRegionNames = {	
		"Lincolnshire",
		"Lincoln",
		"Boston",
		"Leicestershire",
		"Loughborough",
		"Leicester",
		"Norfolk",
		"King's Lynn",
		"Norwich",
		"Great Yarmouth",
		"Northamptonshire",
		"Northampton",
		"Cambridgeshire",
		"Peterborough",
		"Cambridge",
		"Suffolk",
		"Bury St. Edmunds",
		"Ipswich",
		"Bedfordshire",
		"Bedford",
		"Leighton Buzzard",
		"Luton",
		"Buckinghamshire",
		"Buckingham",
		"Milton Keynes",
		"Hertfordshire",
		"St. Albans",
		"Hertford",
		"Essex",
		"Chelmsford",
		"Colchester"};
								
	/* Tooltips for map ImageRegionSelector */	
	String[] mapTooltips = {
		"Click here for the county of Lincolnshire",
		"Click here for the city of Lincoln",
		"Click here for the town of Boston",
		"Click here for the county of Leicestershire",
		"Click here for the town of Loughborough",
		"Click here for the city of Leicester",
		"Click here for the county of Norfolk",
		"Click here for the town of King's Lynn",
		"Click here for the city of Norwich",
		"Click here for the town of Great Yarmouth",
		"Click here for the county of Northamptonshire",
		"Click here for the town of Northampton",
		"Click here for the county of Cambridgeshire",
		"Click here for the town of Peterborough",
		"Click here for the city of Cambridge",
		"Click here for the county of Suffolk",
		"Click here for the town of Bury St. Edmunds",
		"Click here for the town of Ipswich",
		"Click here for the county of Bedfordshire",
		"Click here for the town of Bedford",
		"Click here for the town of Leighton Buzzard",
		"Click here for the town of Luton",
		"Click here for the county of Buckinghamshire",
		"Click here for the city of Buckingham",
		"Click here for the city of Milton Keynes",
		"Click here for the county of Hertfordshire",
		"Click here for the town of St. Albans",
		"Click here for the town of Hertford",
		"Click here for the county of Essex",
		"Click here for the town of Chelmsford",
		"Click here for the town of Colchester"};
											
	/* Region names for house ImageRegionSelector */
	String[] houseRegionNames = {	"Terraced", "Semi", "Flat",	"Detached"};

	/* Tooltips for house ImageRegionSelector */
	String[] houseTooltips = {
		"Click here to select terraced housing",
		"Click here to select semi-detached housing",
		"Click here to select flats",
		"Click here to select detached housing"		};

	/* House Data -  Address, Town, County, type, price, contact no. */
	private final String[][] houses  = {
		/* Lincolnshire */
		{"21 Glade Drive",				"Lincoln",					"Lincolnshire",			"Detached",	"123,995",	"345727"},
		{"8 Fork Lane",					"Lincoln",					"Lincolnshire",			"Semi",			"105,500",	"876407"},
		{"98 Lamp Street",			"Lincoln",					"Lincolnshire",			"Semi",			"94,562",	"653987"},
		{"1 Lincoln Road",				"Boston",					"Lincolnshire",			"Semi",			"104,050",	"349265"},
		{"35 Window Street",		"Boston", 					"Lincolnshire",			"Flat",			"65,324",	"865088"},
		{"14 Oak Hill",					"Boston",					"Lincolnshire",			"Detached",	"98,345",	"345896"},
		/* Leicestershire */
		{"32 London Road",			"Loughborough",		"Leicestershire",		"Semi",			"74,673",	"156345"},
		{"23a High Street",			"Loughborough",		"Leicestershire",		"Flat",			"45,300",	"546992"},
		{"98 Teapot Place",			"Loughborough",		"Leicestershire",		"Terraced",	"55,600",	"543847"},
		{"324 Staple Street",		"Loughborough",		"Leicestershire",		"Detached",	"95,025",	"763514"},
		{"3 Leaf Lane",					"Leicester",				"Leicestershire",		"Semi",			"78,045",	"560777"},
		{"76 Plum Tree Park",		"Leicester",				"Leicestershire",		"Flat",			"36,765",	"345672"},
		/* Norfolk */
		{"45 Ipswich Road",			"King's Lynn",			"Norfolk",				"Detached",	"176,400",	"762987"},
		{"12 America Avenue",		"King's Lynn",			"Norfolk",				"Semi",			"120,340",	"443365"},
		{"65 Oxford Street",		"Norwich",				"Norfolk",				"Terraced",	"67,050",	"786543"},
		{"23 Chicken Crescent",	"Norwich"	,				"Norfolk",				"Semi",			"75,000",	"349256"},
		{"97 Winn Road",				"Norwich",				"Norfolk",				"Semi",			"86,500",	"654387"},
		{"127 Jupiter Street",		"Norwich", 				"Norfolk",				"Detached",	"99, 950", 	"456234"},
		{"2 Seafront View",			"Great Yarmouth",		"Norfolk",				"Detached",	"235,500",	"983476"},
		/* Northants */
		{"1 Bell Close",					"Northampton",			"Northamptonshire",	"Semi",			"78,400",	"700987"},
		{"56 Pop Lane",					"Northampton",			"Northamptonshire",	"Detached",	"125,000",	"455534"},
		{"2a Can Road",				"Northampton", 		"Northamptonshire",	"Flat",			"38,200",	"358176"},
		/* Cambs */
		{"35 Garden Road",			"Peterborough",		"Cambridgeshire",		"Semi",			"86,500",	"453323"},
		{"87 Poles Lane",				"Peterborough",		"Cambridgeshire",		"Flat",			"56,456",	"549737"},
		{"67 West Street",			"Peterborough",		"Cambridgeshire",		"Semi",			"94,700",	"936528"},
		{"21 University Place",		"Cambridge",			"Cambridgeshire",		"Terraced",	"75,500",	"945723"},
		{"35 Bridge Street",			"Cambridge",			"Cambridgeshire",		"Semi",			"95,670",	"673465"},
		{"90 Acorn Green",			"Cambridge",			"Cambridgeshire",		"Detached",	"156,000",	"396723"},
		/* Suffolk */
		{"23 Charlton Road",			"Ipswich",				"Suffolk",				"Detached",	"105,500",	"654987"},
		{"294 Heeley Road",			"Ipswich",				"Suffolk",				"Terraced",	"67,230",	"762634"},
		{"24 Paper Lane",				"Ipswich",				"Suffolk",				"Semi",			"54,200",	"983452"},
		{"1 Pepper Street",			"Ipswich",				"Suffolk",				"Semi",			"75,200",	"456425"},
		{"45 Church Lane",			"Bury St. Edmunds",	"Suffolk",				"Flat",			"65,345",	"451234"},
		{"79 Brittania Gardens",	"Bury St. Edmunds",	"Suffolk",				"Detached",	"185,300",	"457825"},
		{"55 Spring Close",			"Bury St. Edmunds",	"Suffolk",				"Semi",			"98,500",	"388725"},
		/* Beds */
		{"19 Shearer Street",		"Bedford",				"Bedfordshire",		"Detached",	"94,500",	"659654"},
		{"89 Meadow Place",			"Bedford",				"Bedfordshire",		"Semi",			"72,000",	"765349"},
		{"106 Croft Lane",			"Bedford,",				"Bedfordshire",		"Semi",			"67,300",	"549080"},
		{"97 Bedford Road",			"Leighton Buzzard",	"Bedfordshire",		"Semi",			"78,150",	"654098"},
		{"57 Orchard Way",			"Leighton Buzzard",	"Bedfordshire",		"Flat",			"54,700",	"297652"},
		{"29 Kenilworth Rd",			"Leighton Buzzard",	"Bedfordshire",		"Semi",			"87,300",	"532787"},
		{"40 Battery Park",			"Leighton Buzzard",	"Bedfordshire",		"Semi",			"98,050",	"456230"},
		{"12 Venus Way",				"Luton",					"Bedfordshire",		"Detached",	"96,200",	"346123"},
		{"35 Hatters Lane",			"Luton",					"Bedfordshire",		"Detached",	"135,800",	"653876"},
		/* Bucks */
		{"16 Tree Lane",				"Buckingham",			"Buckinghamshire",	"Semi",			"83,500",	"234786"},
		{"56 Book Street",			"Buckingham",			"Buckinghamshire",	"Flat",			"63,500",	"579812"},
		{"8 Gold Road",					"Milton Keynes",		"Buckinghamshire",	"Detached",	"89,400",	"654009"},
		{"32 Bird Lane",				"Milton Keynes",		"Buckinghamshire",	"Semi",			"88,200",	"299654"},
		{"19 Park View",				"Milton Keynes",		"Buckinghamshire",	"Detached",	"126,100",	"294524"},
		/* Herts */
		{"34 Jack Street",			"St. Albans",				"Hertfordshire",		"Semi",			"103,400",	"346711"},
		{"132 Star Road",				"St. Albans",				"Hertfordshire",		"Detached",	"134,560",	"542225"},
		{"17 Radcliffe Lane",		"St. Albans",				"Hertfordshire",		"Semi",			"89,300",	"544545"},
		{"23 Shakespeare Road",	"Hertford",				"Hertfordshire",		"Detached",	"145,600",	"548724"},
		{"98 Water Street",			"Hertford",				"Hertfordshire",		"Semi",			"104,500",	"435671"},
		/* Essex */
		{"23 Alexander Place",		"Chelmsford",			"Essex",					"Detached",	"142,700",	"567554"},
		{"34 Owen Lane",				"Chelmsford",			"Essex",					"Semi",			"92,400",	"786298"},
		{"90 Sandy Lane",				"Chelmsford",			"Essex",					"Semi",			"97,300",	"667333"},
		{"45 George Street",			"Colchester",			"Essex",					"Detached",	"104,000",	"345321"},
		{"65 Mountain Lane",		"Colchester",			"Essex",					"Semi",			"84,234",	"456745"},
		{"96 North Street",			"Colchester",			"Essex",					"Terraced",	"54,350",	"345671"}
			
	};

	String[] houseTypes = { "Terraced housing", "Semi-detached housing", "Flats", "Detached housing", "Accomodation"};

	final int startx = 380;
	final int starty = 150;
	final int yspacing = 20;

	JLabel header;
	
	JLabel[][] labels = new JLabel[10][5];
	ImageRegionSelector iMapSelector;
	ImageRegionSelector iHouseSelector;

	String regionSelected = null;
	String houseType = null;
/**
 * Displays the houses relevant to the selections on the ImageRegionSelectors
 */
private void displayHouses() 
{

	if(regionSelected != null)
	{
		if(houseType != null)
		{
			header.setText(houseTypes[iHouseSelector.getSelectedIndex()]+" available in "+iMapSelector.getSelectedItem());
		}
		else
		{
			header.setText(houseTypes[4]+" available in "+iMapSelector.getSelectedItem());
		}
	}
	else
	{
		header.setText("Select a region to display its available accommodation");
	}		

	
	int index = 0;
	
	for(int i=0; i<houses.length; i++)
	{
		if((houses[i][1].equals(regionSelected) || houses[i][2].equals(regionSelected)) &&
			(houses[i][3].equals(houseType) || houseType == null))
		{
			/* Address */
			labels[index][0].setText(houses[i][0]+", "+houses[i][1]+", "+houses[i][2]);
			labels[index][0].setBounds(startx, starty + index * yspacing, 280, yspacing-5);
			getContentPane().add(labels[index][0]);

			/* Type */
			labels[index][1].setText(houses[i][3]);
			labels[index][1].setBounds(startx+285, starty + index * yspacing, 60, yspacing-5);
			getContentPane().add(labels[index][1]);

			/* Cost */
			labels[index][2].setText(houses[i][4]);
			labels[index][2].setBounds(startx+350, starty + index * yspacing, 60, yspacing-5);
			getContentPane().add(labels[index][2]);

			/* Phone */
			labels[index][3].setText(houses[i][5]);
			labels[index][3].setBounds(startx+415, starty + index * yspacing, 60, yspacing-5);
			getContentPane().add(labels[index][3]);

			index++;
		}
	}

	for(int i=index; i<10; i++)
	{
		for(int j=0; j<5; j++)
		{
			getContentPane().remove(labels[i][j]);
		}
	}
	
	repaint();
	
}
/**
 * Initializes the applet.
 * 
 * @see #start
 * @see #stop
 * @see #destroy
 */
public void init() {
	super.init();

	setSize(850, 400);
	getContentPane().setLayout(null);

	/* Map selector */
	iMapSelector = new ImageRegionSelector();
	iMapSelector.setLocation(0, 20);
	iMapSelector.setDisplayImage("/com/ibm/eou/swingimageregionselectorsamples/anglia.gif");
	iMapSelector.setColorMapImage("/com/ibm/eou/swingimageregionselectorsamples/anglia_map.gif");
	iMapSelector.setCutawayImage("/com/ibm/eou/swingimageregionselectorsamples/anglia_cutaway.gif");
	iMapSelector.setSelectionEmphasisStyle(ImageRegionSelector.CUTAWAY);
	iMapSelector.setRolloverEmphasisStyle(ImageRegionSelector.LIGHTEN);
	iMapSelector.setRegionNames(mapRegionNames);
	iMapSelector.setTooltips(mapTooltips);
	iMapSelector.addItemListener(this);
	getContentPane().add(iMapSelector);

	/* House Selector */
	iHouseSelector = new ImageRegionSelector();
	iHouseSelector.setLocation(iMapSelector.getWidth()+20, 20);
	iHouseSelector.setDisplayImage("/com/ibm/eou/swingimageregionselectorsamples/houses.gif");
	iHouseSelector.setColorMapImage("/com/ibm/eou/swingimageregionselectorsamples/houses_map.gif");
	iHouseSelector.setCutawayImage("/com/ibm/eou/swingimageregionselectorsamples/houses_cutaway.gif");
	iHouseSelector.setSelectionEmphasisStyle(ImageRegionSelector.CUTAWAY);
	iHouseSelector.setRolloverEmphasisStyle(ImageRegionSelector.LIGHTEN);
	iHouseSelector.setRegionNames(houseRegionNames);
	iHouseSelector.setTooltips(houseTooltips);
	iHouseSelector.addItemListener(this);
	getContentPane().add(iHouseSelector);
	
	/* Labels */

	header = new JLabel("Select a region to display its available accommodation");
	header.setBounds(startx, starty - 2 * yspacing, 400, yspacing -5);
	getContentPane().add(header);

	JLabel addHead = new JLabel("Address");
	addHead.setBounds(startx, starty - yspacing, 100, yspacing -5);
	getContentPane().add(addHead);
	
	JLabel typeHead = new JLabel("Type");
	typeHead.setBounds(startx+285, starty - yspacing, 60, yspacing -5);
	getContentPane().add(typeHead);
	
	JLabel costHead = new JLabel("Cost");
	costHead.setBounds(startx+350, starty - yspacing, 60, yspacing -5);
	getContentPane().add(costHead);
	
	JLabel phoneHead = new JLabel("Phone");
	phoneHead.setBounds(startx+415, starty - yspacing, 60, yspacing -5);
	getContentPane().add(phoneHead);
	

	Font labelFont = new Font("sansserif", Font.PLAIN, 10);
	
	for(int i=0; i<10; i++)
	{
		for(int j=0; j<5; j++)
		{
			labels[i][j] = new JLabel();
			labels[i][j].setForeground(Color.black);
			labels[i][j].setBackground(Color.white);
			labels[i][j].setFont(labelFont);
		}
	}
	
	displayHouses();
}
/**
 * Captures ItemEvents from both ImageRegionSelectors
 * @param e java.awt.event.ItemEvent
 */
public void itemStateChanged(ItemEvent e) 
{
	if(e.getItem() == iMapSelector)
	{
		if(e.getStateChange() == ItemEvent.SELECTED)
		{
			regionSelected = (String)iMapSelector.getSelectedItem();
		}
		else
		{
			regionSelected = null;
		}
	}

	if(e.getItem() == iHouseSelector)
	{
		if(e.getStateChange() == ItemEvent.SELECTED)
		{
			houseType = (String)iHouseSelector.getSelectedItem();
		}
		else
		{
			houseType = null;
		}
	}

	displayHouses();
}
}