TCL(1)                     NAT32 Programmer's Manual              TCL(1)

NAME
        tcl - Tcl 6.7+ command language interpreter

SYNOPSIS
        tcl [filename]
        tclsh

DESCRIPTION
        This NAT32 adaptation of John Ousterhout's Tool Command Language
        supports many features of TCL as described in "Tcl and the Tk 
        Toolkit" (Addison-Wesley 1994).
        Tcl can be invoked from the shell with an argument specifying
        the name of a Tcl Script. If a Tcl script contains #!tcl in its
        first line, the filename can be typed directly to the shell, and
        the Tcl interpreter is invoked automatically. Arguments are passed
        as expected.

NOTES
        Not all of the exec and open options have been ported.
        
SNMP EXTENSIONS

        SNMP Tcl commands are:

             snmp agent <name>
             snmp next
             snmp <objectnames ...>
             
        An agent must first be specified. The agent name can be a domain
        name or an IP address. A list of object names (or object IDs) can
        be specified.
        
        Example: snmp agent csc.canberra.edu.au
                 snmp system.sysUpTime
                 snmp next

TCP EXTENSIONS

        TCP support consists of a 'socket' command for creating a socket 
        object. Two variants exist, the first for creating a passive socket,
        the second for creating an active socket:
        
                socket -p service [qlen]
                socket host port
                
        Each variant returns a socket descriptor which can be used as 
        follows:
        
                set s [socket -p 8080 1]
                
        The above command creates a socket object 's' which listens at port
        8080 and uses a listen queue of length 1.
        
        To open a TCP connection to a remote host, the second variant of the
        socket command is used:
        
                set s [socket fir.canberra.edu.au 3680]
                
        The above command creates a socket object 's' which is a TCP
        connection to Port 3680 at Host fir.canberra.edu.au.
        
        In both cases, once a socket object has been created, the following
        methods are supported for that object:
        
                {object} accept         # accept an incoming connection

                {object} getf fname     # copy incoming data to file 'fname'
                {object} gets len       # read 'len' incoming bytes
                  
                {object} putf fname     # copy file 'fname' to connection 
                {object} puts var       # write 'var' to connection
                
        To close a socket, one deletes the socket object using the standard
        Tcl 'rename' command:
        
                rename $s {}
                
        A complete example is shown in file 'httpd', a very simple HTTP
        server.
                             
SEE ALSO
        httpd(1), sh(1), snmp(1)
