STARTUP(1)                NAT32 Programmer's Manual              STARTUP(1)

NAME
        startup - user defined startup file

SYNOPSIS
        startup

DESCRIPTION

        File 'startup' is executed when NAT32 starts. It must be located in 
        the NAT32 directory and can contain any sequence of valid NAT32 shell
        commands. The default startup file contains the following commands:
        # Packet Multiplexing
        mux on

        # Automatic Address and Port Mapping
        ipmapa

        # DNS Mapping
        dnsmap on

        # Display the console
        show
        #hide noicon

        # Maximum number of dial attempts, redial interval 60 seconds
        redial 5 60

        # AutoDial on or off
        autodial on

        # AutoDisconnect time in minutes
        #autodisc 5

        # Send a packet at 5-minute intervals to keep the DUN Connection up
        #alive 5

        # Start the CRON Daemon
        #cron on

        # Start a Telnet Daemon. Requires password list in current directory.    
        #telnetd on

        #
        # Add anything else you need here e.g. port mappings
        #

        # Start a shell in the Console
        shell
            
        If the shell command is omitted, then no shell will be run in the 
        CONSOLE. To start a shell, press Ctrl-F4.
        
NOTES
        Because file 'startup' is always open while NAT32 is running, you
        must shutdown NAT32 before attempting to modify it. 

        NAT32 can execute any file located in the NAT32 directory.
        
        In particular, if that file contains the sequence #!tcl in its
        first line, a Tcl interpreter is invoked to execute the remainder
        of the file.
        
SEE ALSO
        hide(1), nat32(1), sh(1), shell(1), tcl(1)
