PPP(1)                   NAT32 Programmer's Manual                    PPP(1)

NAME
        ppp - interact with the NAT32 PPP interface

SYNOPSIS
        ppp [close | {open connection} | {dial connection}]
        
        
DESCRIPTION
        The ppp command is used to interact with the NAT32 PPP software.
        When invoked with no arguments, the command will print the current
        PPP settings:

            Current connection [] IP [0.0.0.0] 
            Default connection [no connection]
            Server Mode 0 Autodial 0 Redial 5
            Keepalive 0 Autodisconnect 0
        
        Current connection is the name of the connection currently in place.

        IP is the current IP address of the connection.
        
        Default connection is the connection name which will be used on the
        next redial.
        
        Server Mode indicates whether NAT32 is in Server Mode.

        Autodial indicates whether NAT32 will auto dial 'connection'.

        Redial indicates the maximum number of dial attempts which will be
        made. Do not set this value too high or large telephone bills may
        result. A value of -1 disables this feature.
        
        Keepalive is the interval at which keep-alive packets will be sent.
        
        Autodisconnect is the period of the incativity timer. 


        When invoked with the 'close' argument, the ppp command will 
        immediately hangup the current connection. Autodial is turned off,
        as is IP mapping and Port Mapping.
        
        When invoked with the 'open' 'connection' arguments, the specified
        connection will become the default connection. Autodial is turned on
        so that the connection will be dialed when the next packet is sent
        via the PPP interface.
        
        When invoked with the 'dial' 'connection' arguments, the specified
        connection will be dialed immediately, but only if no connection is
        currently in place and if the redial counter is > 0.
        Note that an 'ipmapa' command should subsequently be executed in 
        order to turn on IP Address Mapping and Port Mapping.
         
        The 'connection' argument must be a valid Windows Dial-Up Networking
        connection name. It is case-sensitive.

NOTES
        NAT32 supports demand dialing. To use this feature, NAT32 is started
        with the name of the connection to be dialed as the first argument.
        As soon as ANY IP packet needs to be sent via the PPP interface, the 
        connection will be established if AutoDial is enabled.
        
        If the Connection does not use a Dial-Up Networking script file, the
        user will be prompted for user details. This is done only once per
        connection and the settings are saved in the registry.

        NAT32 also supports auto-disconnect. See autodial(1) for details.

        Builds 1080 and higher will excute the file 'connect' when a new
        connection is noticed. File 'connect' can contain any desired
        sequence of commands to be executed after a new connection is
        established.
        
SEE ALSO
        autodial(1), dun(1), hangup(1), ipmapa(1), pbk(1)
