PPMAP(1)                 NAT32 Programmer's Manual               PPMAP(1)

NAME
        ppmap - specify permanent port mappings

SYNOPSIS
        ppmap
        ppmap apm
        ppmap add <tcp | udp> <port_range> <address> <new_port>
        ppmap delete <tcp | udp> <port> 
        
DESCRIPTION
        Ppmap controls permanent port mapping. Permanent port mapping is
        used to make servers running at designated private IP addresses
        accessible from the Internet. Per default, NO servers other than
        those running under the host Operating System are accessible from 
        the Internet.  
        
        If no argument is specified, the current state of the permanent 
        port mapping table is printed as follows:
        
        Index       - the table index
        Proto       - the protocol type (UDP or TCP)
        Port range  - the port number to be mapped
        IPdst       - the destination address of the mapping
        Ndp         - the target port number

        If the add argument is specified, four further arguments are 
        required:
        
        tcp or udp  - add an entry for the specified protocol
        port_range  - the port number range which a remote machine uses
                      to reach a specified private host
        address     - the private IP address of the target machine
        new_port    - the port number at which the private machine listens
        
        Example: ppmap add tcp 30023 192.168.1.10 23
        
            The above command will make a Telnet daemon at port 23 on host
            192.168.1.10 accessible from the Internet using the IP address
            of the NAT32 Primary Interface and special port 30023.
            
        Example: ppmap add udp 2000:2100 192.168.1.20 1000
        
            The above command will map incoming UDP packets with port 
            numbers in the range 2000 - 2100 to ports 1000 - 1100 on 
            machine 192.168.1.20. 
            
        If the delete argument is specified, the entry for the specified
        protocol and special port number is deleted from the table. Hosts
        on the Internet then no longer have access to that server.
        
        If the apm argument is specified, the state of the auxilliary port
        mapping table is printed. This table contains details of connections
        currently in use. This option is used for diagnostic purposes only.    

NOTES
        Use Permanent Port Mapping with care because it gives external hosts
        access to servers on your local LAN. Be SURE you have set strong
        passwords on all services which you present to the Internet.
        
SEE ALSO
        icmphost(1), ipmap(1), pmap(1)
