PMAP(1)                 NAT32 Programmer's Manual               PMAP(1)

NAME
        pmap - specify port mapping

SYNOPSIS
        pmap [ON | OFF]
        
DESCRIPTION
        Pmap turns port mapping on or off. If no argument is specified,
        the current state of the port mapping table is printed as follows:
        
        Index   - the table index
        IPsrc   - the source address being mapped
        IPdst   - the destination address of the mapping
        Prot    - the protocol type (UDP or TCP)
        Sp      - the source port being mapped
        Nsp     - the mapped port number
        TTL     - the time-to-live (secs) for this entry
        
        Port mapping is used to map multiple private IP addresses to a
        single registered IP address. IP mapping must be ON.
        
        Outgoing packets are port-mapped only if their source port numbers
        are greater than 1024. This allows replys from servers running on
        the address-mapped host to be transmitted correctly. 

        Incoming packets are port-mapped as needed to allow forwarding of
        replies to the original host.
        
        Incoming packets with a port number contained in the Permanent Port
        Mapping Table are forwarded to the host and port number specified
        in that table.
        
NOTES
        Private hosts other than the host on which NAT32 runs can use the
        PING and TRACEROUTE utilities if their address is nominated using
        the icmphost command. 
        
SEE ALSO
        icmphost(1), ipmap(1), ppmap(1)
