IDENTD(1)                 NAT32 Programmer's Manual                 IDENTD(1)

NAME
        identd - start or stop the IDENT daemon

SYNOPSIS
        identd user | off [-u]
        
DESCRIPTION
        Identd starts or stops the IDENTD daemon. Argument 'user' must 
        specify a user name or the special string "off". In the latter
        case, the IDENT daemon will be terminated.
        
        If argument -u is specified, a digit in the range 0..9 will be 
        appended to the user name returned in each response.

NOTES
        Identd sends a postive response to ALL requests it receives from a
        client. The name 'user' has no special significance, as Identd is
        usually used to protect against IP spoofing.
        
DETAILS
        Some Sys Admins configure Mail Servers, Telnet Servers and others to
        send an Ident Request to the Client. The Client should respond with 
        an Ident Response, but most Windows systems simply respond with a 
        TCP RESET, and the Server continues normally.
        
        However, when NDIS3PKT is installed, it supresses that RESET because
        other apps (such as NAT32) may well be running an Ident Daemon. The
        Server therefore waits for 20-30 secs before continuing.
        To inhibit the supression of this RESET, NDIS3PKT now defaults to 
        MSTCP MUX = off, and NAT32 turns it on when it starts and off when it
        exits (via menu item File/Exit, not File/Terminate).
        
        On NT, NDIS3PKT.SYS settings can only be obtained from the Registry,
        therefore, NAT32 must be run at least once in order to set TCP MUX
        "off" in the Registry. Thereafter, each time NT boots, all TCP 
        multiplexing will be off until NAT32 is started.   

SEE ALSO
