DHCPD(1)                 NAT32 Programmer's Manual                  DHCPD(1)

NAME
        dhcpd - supplies network configuration details on a specified 
                interface via the Dynamic Host Configuration Protocol

SYNOPSIS
        dhcpd ifn [on | off | d]
        
DESCRIPTION
        The NAT32 DHCP Daemon can be used to configure machines on a 
        private LAN.

        Dhcpd with option 'on' starts a DHCP daemon on the specified 
        interface. Option 'off' terminates the Daemon.
        
        Dhcpd allocates IP addresses starting with the value following the
        NAT32 IP address on the specified interface. The default NAT32 IP 
        address on a private LAN is x.y.z.100.  
         
        Dhcpd without option 'on' or 'off' prints the DHCPD Table entries
        for all assignments on the specified interface.
        
NOTES
        Dhcpd will assign a maximum of 64 IP addresses in this release.
        Two hour leases are assigned.

        If ifn is specified as 's', the SECONDARY interface will be used.
        
        Cable Modem Users:  If you are using a single Ethernet Adapter to 
                            connect to your Cable Modem and your private 
                            LAN, dhcpd will only respond to machines with
                            an entry in file dhcpd.ini. 
                
        Dhcpd saves no state information in this release.  IP addresses are
        assigned in the order that machines are booted. The first IP address 
        (x.y.z.101) is assigned to the first machine to boot, x.y.z.102 to
        the second machine to boot and so on. As a result, dhcpd may assign
        a different IP address to a machine each time it boots.
        
        To reserve an IP address slot for a particular machine, a file 
        dhcpd.ini containing Ethernet Addresses in the following format
        should be generated:
        
            00:e0:98:18:11:45 
            00:00:21:c4:24:da
            00:40:05:4e:8b:ad

            ........
            
        The first IP address slot (x.y.z.101) will then be reserved for the
        machine with the Ethernet Address 00:e0:98:18:11:45, the second slot
        for machine 00:00:21:c4:24:da and so on. A machine name may also be 
        specified.
        
        If you ever need to replace a particular Ethernet Adapter, be sure 
        to update the relevant dhcpd.ini entry.
        
        To stop a particular IP address from ever being assigned, simply
        place the entry 00:00:00:00:00:01 in the required position in the
        dhcpd.ini file.
        
        DHCPD debug output can be toggled with command 'dhcpd ifn d'.

SEE ALSO
        dhcp(1), netcfg(1)
