unit Halcn6DB;
{$I gs6_flag.pas}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Db, DBCommon, gs6_glbl, gs6_dbsy, gs6_dbf, gs6_indx, gs6_tool,
  gs6_sql, gs6_cnst;


const
   HalcyonDefaultDirectory = 'Default Directory';

   HStatusStart     = -1;
   HStatusStop      = 0;
   HStatusIndexTo   = 1;
   HStatusIndexWr   = 2;
   HStatusSort      = 5;
   HStatusCopy      = 6;
   HStatusPack      = 11;
   HStatusSearch    = 21;

type
   THalcyonDataSet = class;

   TgsLokProtocol = (Default, DB4Lock, ClipLock, FoxLock);
   TgsDBFActivity = (aNormal, aIndexing, aCopying);

   TgsFormulaMake  = procedure(who, st, rsl : PChar; var Typ: char;
                             var Chg, tf: boolean) of object;
   TgsStatusReport = procedure(stat1,stat2,stat3 : longint) of object;

   {--object DBFObject--}
   DBFObject = class(GSO_dBHandler)
   protected
      LinkTab     : THalcyonDataSet;
   public
      constructor Attach(const FName, APassword: string; ReadWrite, Shared: boolean; TTab: THalcyonDataSet);
      Function    gsFormula(who,st,rsl: PChar;var Typ: char;var Chg: boolean):
                                                           integer; override;
      Function    gsTestFilter : boolean; override;
      Procedure   gsStatusUpdate(stat1,stat2,stat3 : longint); override;
   end;
   {--End object DBFObject--}

   TgsSortStatus = (Ascending, Descending, SortUp, SortDown,
                    SortDictUp, SortDictDown, NoSort,
                    AscendingGeneral, DescendingGeneral);

   TgsIndexUnique = (Unique, Duplicates);

  THalcyonDataSet = class(TDataSet)
  private
    { Private declarations }
    FDatabaseName: string;
    FDBFHandle: DBFObject;
    FBeforeBOF: boolean;
    FAfterEOF: boolean;
    FExclusive  : boolean;
    FRecordSize: Word;
    FBookmarkOfs: Word;
    FRecInfoOfs: Word;
    FRecBufSize: Word;
    FIndexDefs: TIndexDefs;
    FIndexFiles: TStringList;
    FIndexName: string;
    FReadOnly: Boolean;
    FTableName: AnsiString;
    FUseDeleted: boolean;
    FOnFormula: TgsFormulaMake;
    FOnStatus: TgsStatusReport;
    FEncryption: string;
    FUseDBFCache: boolean;
    FLokProtocol: TgsLokProtocol;
    FExactCount: boolean;
    FActivity: TgsDBFActivity;
    FTempDir: array[0..259] of char;
    FUserID: longint;
    FDoingEdit: boolean;                    {!!RFG 100197}
    FTranslateASCII: boolean;              {!!RFG 032798}
    FMasterLink: TMasterDataLink;
    FRenaming: boolean;
    FUpdatingIndexDesc: boolean;

    procedure CheckMasterRange;
    procedure  DoOnFormula(who, st, rsl : PChar; var Typ: char;
                           var Chg, tf: boolean);
    procedure  DoOnFilter(var tf: boolean);
    procedure DoOnStatus(stat1, stat2, stat3: longint);
    function GetActiveRecBuf(var RecBuf: PChar): Boolean;
    function GetIndexName: string;
    function GetVersion: string;
    function GetMasterKey: string;
    procedure MasterChanged(Sender: TObject);
    procedure MasterDisabled(Sender: TObject);
    procedure SetVersion(const st: string);
    procedure InitBufferPointers;
    procedure OpenDBFFile(ReadWrite, Shared: boolean);
    procedure RestoreCurRecord;
    function SetCurRecord(CurRec: PChar): PChar;
    procedure SetDatabaseName(const Value: string);
    procedure SetIndexDefs(Value: TIndexDefs);
    procedure SetIndexName(const Value: string);
    procedure SetReadOnly(Value: Boolean);
    procedure SetTableName(const Value: AnsiString);
    procedure SetUseDeleted(tf: boolean);
    procedure SetEncrypted(Value: string);
    function  SearchForIndexExp(const IExp: string): integer;
    procedure DoOnIndexFilesChange(Sender: TObject);
    function  ConvertDatabaseNameAlias: string;
    function SetPrimaryTag(const TName: String; SameRec: boolean): integer;{!!RFG 043098}
  protected
    { Protected declarations }
    procedure AddFieldDesc(FieldNo: Word);
    function AllocRecordBuffer: PChar; override;
    procedure AssignUserID(id: longint);
    procedure CheckActive; override;
    procedure CheckActiveSet;
    procedure ClearCalcFields(Buffer: PChar); override;
    function ConfirmEdit: boolean;
    procedure FreeRecordBuffer(var Buffer: PChar); override;
    procedure GetBookmarkData(Buffer: PChar; Data: Pointer); override;
    function GetBookmarkFlag(Buffer: PChar): TBookmarkFlag; override;
    function GetCanModify: Boolean; override;                 {!!RFG 100197}
    function GetDataSource: TDataSource; override;
    function GetMasterFields: string;
    function GetRecord(Buffer: PChar; GetMode: TGetMode; DoCheck: Boolean): TGetResult; override;
    function GetRecordCount: Integer; override;
    function GetRecNo: Integer; override;
    function GetRecordSize: Word; override;
    procedure InternalAddRecord(Buffer: Pointer; Append: Boolean); override;
    procedure InternalCancel; override;
    procedure InternalClose; override;
    procedure InternalDelete; override;
    procedure InternalRecall; virtual;
    procedure InternalFirst; override;
    procedure InternalGotoBookmark(Bookmark: Pointer); override;
    procedure InternalHandleException; override;
    procedure InternalInitFieldDefs; override;
    procedure InternalInitRecord(Buffer: PChar); override;
    procedure DoAfterInsert; override;
    procedure InternalEdit; override;
    procedure InternalLast; override;
    procedure InternalOpen; override;
    procedure InternalPost; override;
    procedure InternalRefresh; override;
    procedure InternalSetToRecord(Buffer: PChar); override;
    function IsCursorOpen: Boolean; override;
    procedure SetBookmarkFlag(Buffer: PChar; Value: TBookmarkFlag); override;
    procedure SetBookmarkData(Buffer: PChar; Data: Pointer); override;
    procedure SetDataSource(Value: TDataSource);
    procedure SetFieldData(Field: TField; Buffer: Pointer); override;
    procedure SetMasterFields(const Value: string);
    procedure SetRecNo(Value: Integer); override;
    procedure SetFilterData(const Text: string; Options: TFilterOptions);
    procedure SetFiltered(Value: Boolean); override;
    procedure SetFilterOptions(Value: TFilterOptions); override;
    procedure SetFilterText(const Value: string); override;
    procedure UpdateIndexDefs; override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function CompareBookmarks(Bookmark1, Bookmark2: TBookmark): Integer; override; {!!RFG 100197}
      procedure  CopyRecordTo(area: THalcyonDataSet);
      procedure  CopyStructure(const filname, apassword: string);
      procedure  CopyTo(const filname, apassword: string);
    function  CreateDBF(const fname, apassword: string; ftype: char;
                       fproc: dbInsertFieldProc): boolean;
    function CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream; override;
    Function  ExternalChange : integer;
    function  Find(const ss : string; IsExact, IsNear: boolean): boolean;
    function  FLock : boolean;
    procedure FlushDBF;
    function  GetCurrentRecord(Buffer: PChar): Boolean; override;
    function GetFieldData(Field: TField; Buffer: Pointer): Boolean; override;
    function  GetIndexList: TStrings;
    procedure GetIndexNames(List: TStrings);
    procedure GetIndexTagList(List: TStrings);
    procedure GetDatabaseNames(List: TStrings);
    procedure GetTableNames(List: TStrings);
    function   HuntDuplicate(const st, ky: String): longint;
    procedure  Index(const IName, Tag: string);
    Procedure  IndexFileInclude(const IName: string);
    Procedure  IndexFileRemove(const IName: string);
    Procedure  IndexTagRemove(const IName, Tag: string);
    Function   IndexCount: integer;
    Function   IndexCurrent: string;
    Function   IndexCurrentOrder: integer;
    Function   IndexExpression(Value: integer): string;
    Function   IndexFilter(Value: integer): string;
    Function   IndexKeyLength(Value: integer): integer;
    Function   IndexUnique(Value: integer): boolean;
    Function   IndexAscending(Value: integer): boolean;
    Function   IndexFileName(Value: integer): string;
    Procedure  IndexIsProduction(tf: boolean);
    Function   IndexKeyValue(Value: integer): string;
    Procedure  IndexOn(const IName, tag, keyexp, forexp : string;
                       uniq: TgsIndexUnique; ascnd: TgsSortStatus);
    Function   IndexTagName(Value: integer): string;
    function  IsDeleted: boolean;
    function IsSequenced: Boolean; override;
    function Locate(const KeyFields: string; const KeyValues: Variant;
      Options: TLocateOptions): Boolean; override;
    function Lookup(const KeyFields: string; const KeyValues: Variant;
      const ResultFields: string): Variant; override;
    Function MemoryIndexAdd(const tag, keyexpr, forexpr: String;
            uniq: TgsIndexUnique; ascnd: TgsSortStatus): boolean;
    procedure  Pack;
    procedure Recall;
    procedure Reindex;
    procedure  RenameTable(const NewTableName: string);
    function   RLock : boolean;
    procedure  ReturnDateTimeUser(var dt, tm, us: longint);
    procedure  SetDBFCache(tf: boolean);
    procedure  SetLockProtocol(LokProtocol: TgsLokProtocol);
    procedure  SetTagTo(TName: string);
    procedure  SetTempDirectory(const Value: String);
    procedure  SortTo(const filname, apassword, formla: string; sortseq: TgsSortStatus);
    procedure  Unlock;
    procedure  Zap;
    procedure SetIndexList(Items: TStrings);
    procedure SetRange(const RLo, RHi: string);
    procedure SetRangeEx(const RLo, RHi: string; LoIn, HiIn, Partial: boolean);
    procedure SetRangeEmpty;
    {$IFDEF VER120}
    function Translate(Src, Dest: PChar; ToOem: Boolean): Integer; override;
    {$ELSE}
    procedure Translate(Src, Dest: PChar; ToOem: Boolean);  override;
    {$ENDIF}
    procedure EncryptFile(const APassword: string);
     {dBase file search routine}
    function   SearchDBF(const s : string; var FNum : word;
                           var fromrec: longint; toRec: longint): word;

     {dBase field handling routines}

      Function   MemoSize(fnam: string): longint;
      Function   MemoSizeN(fnum: integer): longint;
      Procedure  MemoLoad(fnam: string;buf: pointer; var cb: longint);
      Function   MemoSave(fnam: string;buf: pointer; var cb: longint): longint;
      Procedure  MemoLoadN(fnum: integer;buf: pointer; var cb: longint);
      Function   MemoSaveN(fnum: integer;buf: pointer; var cb: longint): longint;
      function   DateGet(st : string) : longint;
      function   DateGetN(n : integer) : longint;
      procedure  DatePut(st : string; jdte : longint);
      procedure  DatePutN(n : integer; jdte : longint);
      function   FieldGet(fnam : string) : string;
      function   FieldGetN(fnum : integer) : string;
      procedure  FieldPut(fnam, st : string);
      procedure  FieldPutN(fnum : integer; st : string);
      function   FloatGet(st : string) : FloatNum;
      function   FloatGetN(n : integer) : FloatNum;
      procedure  FloatPut(st : string; r : FloatNum);
      procedure  FloatPutN(n : integer; r : FloatNum);
      function   LogicGet(st : string) : boolean;
      function   LogicGetN(n : integer) : boolean;
      procedure  LogicPut(st : string; b : boolean);
      procedure  LogicPutN(n : integer; b : boolean);
      function   IntegerGet(st : string) : LongInt;
      function   IntegerGetN(n : integer) : LongInt;
      procedure  IntegerPut(st : string; i : LongInt);
      procedure  IntegerPutN(n : integer; i : LongInt);
      function   StringGet(fnam : string) : string;
      function   StringGetN(fnum : integer) : string;
      procedure  StringPut(fnam, st : string);
      procedure  StringPutN(fnum : integer; st : string);
      property  DBFHandle: DBFObject read FDBFHandle;
   published
    { Published declarations }
    property About: string read GetVersion write SetVersion;
    property Active;
    property AutoCalcFields;
    property DatabaseName: string read FDatabaseName write SetDatabaseName;
    property EncryptionKey: string read FEncryption write SetEncrypted;
    property ExactCount: boolean read FExactCount write FExactCount default false;
    property Exclusive: boolean read FExclusive write FExclusive;
    property Filter;
    property Filtered;
    property FilterOptions;
    property IndexDefs: TIndexDefs read FIndexDefs write SetIndexDefs;
    property IndexFiles: TStrings read GetIndexList write SetIndexList;
    property IndexName: string read GetIndexName write SetIndexName;
    property LockProtocol: TgsLokProtocol read FLokProtocol write SetLockProtocol;
    property MasterFields: string read GetMasterFields write SetMasterFields;
    property MasterSource: TDataSource read GetDataSource write SetDataSource;
    property ReadOnly: Boolean read FReadOnly write SetReadOnly default False;
    property TableName: AnsiString read FTableName write SetTableName;
    property TranslateASCII: boolean read FTranslateASCII write FTranslateASCII;
    property UseDeleted: boolean read FUseDeleted write SetUseDeleted;
    property UserID: longint read FUserid write AssignUserID;
    property BeforeOpen;
    property AfterOpen;
    property BeforeClose;
    property AfterClose;
    property BeforeInsert;
    property AfterInsert;
    property BeforeEdit;
    property AfterEdit;
    property BeforePost;
    property AfterPost;
    property BeforeCancel;
    property AfterCancel;
    property BeforeDelete;
    property AfterDelete;
    property BeforeScroll;
    property AfterScroll;
    property OnCalcFields;
    property OnDeleteError;
    property OnEditError;
    property OnFilterRecord;
    property OnNewRecord;
    property OnPostError;
    property OnFormula: TgsFormulaMake read FOnFormula write FOnFormula;
    property OnStatus: TgsStatusReport read FOnStatus write FOnStatus;
 end;

  TgsDBFTypes = (Clipper,DBaseIII,DBaseIV,FoxPro2);

  TCreateHalcyonDataSet = class(TComponent)
  private
     FFieldList: TStringList;
     FAutoOver: boolean;
     FTable: THalcyonDataSet;
     FType: TgsDBFTypes;
     procedure SetFieldList(Value: TStringList);
  public
     constructor Create(AOwner: TComponent); override;
     destructor  Destroy; override;
     function Execute: boolean;
  published
     property AutoOverwrite: boolean read FAutoOver write FAutoOver;
     property CreateFields: TStringList read FFieldList write SetFieldList;
     property DBFTable: THalcyonDataSet read FTable write FTable;
     property DBFType: TgsDBFTypes read FType write FType;
  end;

implementation
uses DBConsts, {DsgnIntf,} IniFiles;

var
   AliasList: TStringList;

type
  PRecInfo = ^TRecInfo;
  TRecInfo = record
    RecordNumber: Longint;
    UpdateStatus: TUpdateStatus;
    BookmarkFlag: TBookmarkFlag;
  end;



{ THCBlobStream }
type
  THCBlobStream = class(TStream)
  private
    FField: TBlobField;
    FDataSet: THalcyonDataSet;
    FBuffer: PChar;
    FFieldNo: Integer;
    FModified: Boolean;
    FMemory: pchar;
    FMemorySize: integer;
    FPosition: integer;
    procedure ReadBlobData;
  public
    constructor Create(Field: TBlobField; Mode: TBlobStreamMode);
    destructor Destroy; override;
    function Read(var Buffer; Count: Longint): Longint; override;
    function Write(const Buffer; Count: Longint): Longint; override;
    function Seek(Offset: Longint; Origin: Word): Longint; override;
    procedure Truncate;
  end;

{ THCBlobStream }


constructor THCBlobStream.Create(Field: TBlobField; Mode: TBlobStreamMode);
begin
  FMemory := nil;
  FField := Field;
  FFieldNo := FField.FieldNo;
  FDataSet := FField.DataSet as THalcyonDataSet;
  if not FDataSet.GetActiveRecBuf(FBuffer) then exit;   {!!RFG 010798}
  if Mode <> bmRead then
  begin
    if FField.ReadOnly then
       DatabaseErrorFmt(SFieldReadOnly, [FField.DisplayName]);
    if not (FDataSet.State in [dsEdit, dsInsert]) then
       DatabaseError(gsErrNotEditing);
  end;
  if Mode = bmWrite then Truncate
  else ReadBlobData;
end;

destructor THCBlobStream.Destroy;
var
   msiz: longint;
begin
  if FModified and (FDataset.State in [dsEdit, dsInsert]) then
  try
    FDataset.SetCurRecord(FDataSet.ActiveBuffer);
    if FMemory = nil then
    begin
       GetMem(FMemory,4);    {!!RFG 021498}
       FMemory[0] := #0;     {!!RFG 021498}
       FMemorySize := 3;     {!!RFG 051299}
       FPosition := 0;       {!!RFG 021498}
       msiz := 0;            {!!RFG 021498}
    end
    else
    begin
       msiz := Size;
       if FField.Transliterate then
       begin
           FDataSet.Translate(FMemory, FMemory, True);
       end;
    end;
    FDataSet.DBFHandle.gsMemoSaveN(FFieldNo, FMemory, msiz);
    FDataSet.RestoreCurRecord;
    FField.Modified := True;
    FDataSet.DataEvent(deFieldChange, Longint(FField));
  except
    Application.HandleException(Self);
  end;
  if FMemory <> nil then
  begin
     FreeMem(FMemory,FMemorySize+1);
     FMemorySize := 0;
     FPosition := 0;
     FMemory := nil;
  end;
end;

procedure THCBlobStream.ReadBlobData;
var
  BlobLen: Integer;
begin
  FDataSet.SetCurRecord(FBuffer{FDataSet.ActiveBuffer});
  BlobLen := FDataSet.DBFHandle.gsMemoSizeN(FFieldNo);
  if BlobLen > 0 then
  begin
    if FMemory <> nil then
       FreeMem(FMemory,FMemorySize+1);
    GetMem(FMemory,BlobLen+1);
    FMemory[BlobLen] := #0;
    FMemorySize := BlobLen;
    FPosition := 0;
    FDataSet.DBFHandle.gsMemoLoadN(FFieldNo, FMemory, BlobLen);
    if FField.Transliterate then
    begin
        FDataSet.Translate(FMemory, FMemory, False);
    end;
  end;
  FDataSet.RestoreCurRecord;
end;

function THCBlobStream.Read(var Buffer; Count: Longint): Longint;
begin
   if FMemory = nil then
   begin
      Result := 0;
      exit;
   end;
   if FPosition+Count > FMemorySize then
      Count := (FMemorySize-FPosition)+1;
   Move(FMemory[FPosition],Buffer,Count);
   FPosition := FPosition+Count;              {!!RFG 041298}
   Result := Count;
end;

function THCBlobStream.Write(const Buffer; Count: Longint): Longint;
var
   pmem: pchar;
begin
  if Count = 0 then
  begin
     Result := 0;
     exit;
  end;
  if FMemory = nil then
  begin
     GetMem(FMemory,Count+1);
     FMemory[Count] := #0;
     FMemorySize := Count;
     FPosition := 0;
  end
  else
  begin
     GetMem(pmem,FPosition+Count+1);
     pmem[FPosition+Count] := #0;
     Move(FMemory[0],pmem[0],FPosition);
     FreeMem(FMemory,FMemorySize+1);
     FMemory := pmem;
     FMemorySize := FPosition+Count;
  end;
  Move(Buffer, FMemory[FPosition], Count);
  FPosition := FPosition+Count;
  Result := Count;
  FModified := True;
end;

function THCBlobStream.Seek(Offset: Longint; Origin: Word): Longint;
begin
  case Origin of
    0: FPosition := Offset;
    1: Inc(FPosition, Offset);
    2: FPosition := FMemorySize + Offset;
  end;
  Result := FPosition;
end;


procedure THCBlobStream.Truncate;
begin
  if FMemory <> nil then
  begin
     FreeMem(FMemory,FMemorySize+1);
     FMemorySize := 0;
     FPosition := 0;
     FMemory := nil;
  end;
  FModified := True;
end;


(*----------------------------------------------------------------------------
                                     DBFObject
------------------------------------------------------------------------------*)

Constructor DBFObject.Attach(const FName, APassword: string; ReadWrite, Shared: boolean; TTab: THalcyonDataSet);
begin
   LinkTab := TTab;
   inherited Create(FName,APassword,ReadWrite,Shared);
   LinkTab := TTab;   {just for safety}
end;

Function DBFObject.gsFormula(who, st, rsl : PChar;
                           var Typ: char; var Chg: boolean): integer;
var
   chk: boolean;
begin
   chk := false;
   if LinkTab <> nil then
      LinkTab.DoOnFormula(who, st, rsl, Typ, Chg, chk);
   if chk then
      gsFormula := 0
   else
      gsFormula := -1;
end;

Function DBFObject.gsTestFilter : boolean;
var
   chk: boolean;
begin
   chk := true;
   if LinkTab <> nil then
      LinkTab.DoOnFilter(chk);
   if chk then
      gsTestFilter := inherited gsTestFilter
   else
      gsTestFilter := false;
end;

Procedure DBFObject.gsStatusUpdate(stat1,stat2,stat3 : longint);
begin
   if LinkTab <> nil then
      LinkTab.DoOnStatus(stat1,stat2,stat3)
   else
      inherited gsStatusUpdate(stat1,stat2,stat3);
end;

{-----------------------------------------------------------------------------
                              Begin TCreateHalcyonDataSet
-----------------------------------------------------------------------------}

constructor TCreateHalcyonDataSet.Create(AOwner: TComponent);
begin
   inherited Create(AOwner);
   FFieldList := TStringList.Create;
end;

destructor TCreateHalcyonDataSet.Destroy;
begin
   FFieldList.Free;
   inherited Destroy;
end;

function TCreateHalcyonDataSet.Execute: boolean;
var
   f: GSO_DBFBuild;
   fil: string;
   s: string;
   v: boolean;
   i: integer;
   p: integer;
   fs: string[10];
   ft: string[1];
   fl: integer;
   fd: integer;
   sl: TStringList;
   sv: integer;

   procedure LoadField;
   begin
      p := pos(';',s);
      fs := '';
      if p > 0 then
      begin
         fs := system.copy(s,1,pred(p));
         system.delete(s,1,p);
      end
      else v := false;

      p := pos(';',s);
      ft := ' ';
      if p = 2 then
      begin
         ft := system.copy(s,1,1);
         system.delete(s,1,p);
      end
      else v := false;

      p := pos(';',s);
      fl := 0;
      if p > 0 then
      begin
         try
            fl := StrToInt(system.copy(s,1,pred(p)));
            system.delete(s,1,p);
         except
            on Exception do v := false;
         end;
      end
      else v := false;

      fd := 0;
      try
         fd := StrToInt(system.copy(s,1,3));
      except
         on Exception do v := false;
      end;

   end;

begin
   Result := false;
   if not Assigned(FTable) then
   begin
      DatabaseError(gsErrTableIsNil);
   end;
   if FTable.Active then
   begin
      DatabaseError(gsErrTableIsActive);
      exit;
   end;
   fil := FTable.ConvertDatabaseNameAlias;
   fil := fil + FTable.TableName;
   if FileExists(fil) and not FAutoOver then
   begin
      if Application.MessageBox(PChar(gsErrOverwriteTable), 'Warning', MB_OKCANCEL) = IDCANCEL then
         exit;
   end;
   if FFieldList.Count = 0 then
   begin
      DatabaseError(gsErrInvalidFieldList);
      exit;
   end;
   sl := TStringList.Create;
   for i := 0 to pred(FFieldList.Count) do
   begin
      v := true;
      s := FFieldlist.Strings[i];
      While (length(s) > 0) and (s[length(s)] in [' ',';']) do
         system.Delete(s,length(s),1);
      if s <> '' then
         LoadField;
      if v then
      begin
         fs := AnsiUpperCase(fs);
         v := not sl.Find(fs, sv);
      end;
      if not v then
      begin
         sl.Free;
         DatabaseError(gsErrInvalidFieldList);
         exit;
      end;
      sl.Add(fs);
   end;
   sl.Free;

   case FType of
      Clipper,
      DBaseIII : f := GSO_DB3Build.Create(fil);
      DBaseIV  : f := GSO_DB4Build.Create(fil);
      FoxPro2  : f := GSO_DBFoxBuild.Create(fil);
      else       f := GSO_DB3Build.Create(fil);
   end;
   for i := 0 to pred(FFieldList.Count) do
   begin
      s := FFieldlist.Strings[i];
      While (length(s) > 0) and (s[length(s)] in [' ',';']) do
         system.Delete(s,length(s),1);
      if s <> '' then
         LoadField;
      f.InsertField(fs,ft[1],fl,fd);
   end;
   f.Complete;
   Result :=  (f.dFile <> nil);
   f.Free;
   if Result then FTable.Open;
end;

procedure TCreateHalcyonDataSet.SetFieldList(Value: TStringList);
begin
   FFieldList.Assign(Value);
end;



(*---------------------------------------------------------------------------
                               THalcyonDataSet
------------------------------------------------------------------------------*)

constructor THalcyonDataSet.Create(AOwner: TComponent);
begin
   inherited Create(AOwner);
   FMasterLink := TMasterDataLink.Create(Self);
   FMasterLink.OnMasterChange := MasterChanged;
   FMasterLink.OnMasterDisable := MasterDisabled;
   FIndexDefs := TIndexDefs.Create(Self);
   FIndexFiles := TStringList.Create;
   FIndexFiles.OnChange := DoOnIndexFilesChange;
   FActivity := aNormal;
   FTranslateASCII := true;
   FLokProtocol := Default;
   FRenaming := false;
   FUpdatingIndexDesc := false;
   FEncryption := '';
end;

destructor THalcyonDataSet.Destroy;
begin
   FIndexFiles.Free;
   FIndexDefs.Free;
   FMasterLink.Free;
   inherited Destroy;
end;

function THalcyonDataSet.GetVersion: string;
begin
   Result := gs6_Version;
end;

procedure THalcyonDataSet.SetVersion(const st: string);
begin
end;


procedure THalcyonDataSet.AddFieldDesc(FieldNo: Word);
var
  iFldType: TFieldType;
  Size: Word;
  Name: string;
  typ: char;
begin
   Name := FDBFHandle.gsFieldName(FieldNo);
   Size := 0;
   Typ := FDBFHandle.gsFieldType(FieldNo);
   case Typ of
     'C' : begin
              iFldType := ftString;      { Char string }
              Size := FDBFHandle.gsFieldLength(FieldNo); {!!RFG 031498}
            end;
      'F',
      'N' : begin
               if (FDBFHandle.gsFieldDecimals(FieldNo) > 0) then
               begin
                  iFldType := ftFloat;        { Number }
               end
               else
                  if (FDBFHandle.gsFieldLength(FieldNo) > 4) then
                  begin
                     iFldType := ftInteger;
                  end
                  else
                  begin
                     iFldType := ftSmallInt;
                  end;
            end;
      'M' : begin
               iFldType := ftMemo;
            end;
      'G',
      'B' : begin
               iFldType := ftBlob;
            end;
      'L' : begin
               iFldType := ftBoolean;          { Logical }
            end;
      'D' : begin
               iFldType := ftDate;          { Date }
            end;
      'I' : begin
               iFldType := ftInteger;        {VFP integer}
            end;
      'T' : begin
               iFldType := ftDateTime;       {VFP datetime}
            end;
      else  iFldType := ftUnknown;
   end;
   if iFldType <> ftUnknown then
      FieldDefs.Add(Name, iFldType, Size, false);
end;

procedure THalcyonDataSet.ClearCalcFields(Buffer: PChar);
begin
  FillChar(Buffer[RecordSize], CalcFieldsSize, 0); { ! Remove later}
end;

function THalcyonDataSet.ConfirmEdit: boolean;
begin
    Result := State in dsEditModes;
    if not Result then DatabaseError(gsErrNotEditing);
end;

function THalcyonDataSet.CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream;
begin
  Result := THCBlobStream.Create(Field as TBlobField, Mode);
end;

function THalcyonDataSet.GetCurrentRecord(Buffer: PChar): Boolean;
begin
  if not IsEmpty and (GetBookmarkFlag(ActiveBuffer) = bfCurrent) then
  begin
    UpdateCursorPos;
    Move(FDBFHandle.CurRecord^,Buffer[0],FDBFHandle.RecLen);
    Result := true;
  end else
    Result := False;
end;

function THalcyonDataSet.GetIndexList: TStrings;
begin
   if FIndexFiles = nil then
      FIndexFiles := TStringList.Create;
   Result := FIndexFiles;
end;

function THalcyonDataSet.GetIndexName: string;
begin
  Result := FIndexName;
end;

procedure THalcyonDataSet.GetIndexNames(List: TStrings);
const
   IDXExtns : array[0..3] of string[4] = ('.CDX','.MDX','.NDX','.NTX');
var
   f    : TSearchRec;
   i    : integer;
   j    : integer;
begin
   for j := 0 to 3 do
   begin
      i := Sysutils.FindFirst(ConvertDatabaseNameAlias+'*'+ IDXExtns[j], faAnyFile, F);
      while i = 0 do
      begin
         List.Add(F.Name);
         i := Sysutils.FindNext(F);
      end;
      SysUtils.FindClose(F);
   end;
end;

function THalcyonDataSet.GetRecordCount: Integer;
var
   rn: integer;
begin
  if FDBFHandle <> nil then
  begin
     if FExactCount then
     begin
        Result := 0;
        rn := GetRecNo;
        FDBFHandle.gsGetRec(Top_Record);
        while not FDBFHandle.File_EOF do
        begin
           inc(Result);
           FDBFHandle.gsGetRec(Next_Record);
        end;
        FDBFHandle.gsGetRec(rn);
     end
     else
        Result := FDBFHandle.NumRecs;
  end
  else
  begin
     Result := 0;
     DatabaseErrorFmt(SDataSetClosed,[FTableName]);
  end;
end;

function THalcyonDataSet.GetRecNo: Integer;
var
  BufPtr: PChar;
begin
  BufPtr := nil;
  case State of
    dsInactive: DatabaseErrorFmt(SDataSetClosed,[FTableName]);
    dsCalcFields: BufPtr := CalcBuffer
  else
    BufPtr := ActiveBuffer;
  end;
  if BufPtr <> nil then
     Result := PRecInfo(BufPtr + FRecInfoOfs).RecordNumber
  else
     Result := 0;
end;

procedure THalcyonDataSet.SetRecNo(Value: Integer);
begin
  CheckBrowseMode;
  FDBFHandle.CurRecord := FDBFHandle.CurRecHold;
  FDBFHandle.gsGetRec(Value);
  Resync([]);
  DoAfterScroll;
end;

function THalcyonDataSet.GetActiveRecBuf(var RecBuf: PChar): Boolean;
begin
  case State of
    dsBrowse: if IsEmpty then RecBuf := nil else RecBuf := ActiveBuffer;
    dsEdit, dsInsert: RecBuf := ActiveBuffer;
{   dsSetKey: RecBuf := PChar(FKeyBuffer) + SizeOf(TKeyBuffer);}
    dsCalcFields: RecBuf := CalcBuffer;
    dsFilter: RecBuf := PChar(FDBFHandle.CurRecord);
    dsNewValue: RecBuf := ActiveBuffer;              {!!RFG 100197}
    dsOldValue: if FDoingEdit then                   {!!RFG 100197}
                   RecBuf := PChar(FDBFHandle.OrigRec) {!!RFG 100197}
                else
                   RecBuf := ActiveBuffer;           {!!RFG 100197}
  else
    RecBuf := nil;
  end;
  Result := RecBuf <> nil;
end;

procedure THalcyonDataSet.GetTableNames(List: TStrings);
var
  F: TSearchRec;
  I: Integer;
  ts: TStringList;
begin
   ts := TStringList.Create;
   ts.Sorted := true;
   i := SysUtils.FindFirst(ConvertDatabaseNameAlias+'*.DBF', faAnyFile, F);
   while i = 0 do
   begin
      ts.Add(F.Name);
      i := SysUtils.FindNext(F);
   end;
   SysUtils.FindClose(F);
   List.Clear;
   for i := 0 to pred(ts.Count) do
      List.Add(ts[i]);
   ts.Free;
end;

procedure THalcyonDataSet.OpenDBFFile(ReadWrite, Shared: boolean);
const
   ext : String  = '.DBF';
var
   TPath: string;
begin
   FDBFHandle := nil;
   if FTableName = '' then
      DatabaseError(gsErrNoTableName);
   FTableName := ChangeFileExtEmpty(FTableName,ext);
   TPath := ConvertDatabaseNameAlias;
   if not FileExists(TPath + FTableName) then
      DatabaseErrorFmt(gsErrCannotFindFile,[TPath + FTableName]);
   FDBFHandle := DBFObject.Attach(TPath + FTableName, FEncryption, ReadWrite, Shared, Self);
end;

procedure THalcyonDataSet.InitBufferPointers;
begin
   BookmarkSize := 11;                          {!!RFG 100297}
   FRecordSize := FDBFHandle.RecLen;
   FRecInfoOfs := FRecordSize + CalcFieldsSize;
   FBookmarkOfs := FRecInfoOfs + SizeOf(TRecInfo);
   FRecBufSize := FBookmarkOfs + BookmarkSize;
end;

procedure THalcyonDataSet.SetDatabaseName(const Value: string);
var
   s: string;
begin
  if FDatabaseName <> Value then
  begin
    s := UpperCase(Value);
    if s = Uppercase(HalcyonDefaultDirectory) then
       s := Value
    else
    begin
       if length(s) > 0 then
          if s[length(s)] = '\' then
             system.delete(s,length(s),1);
       if AliasList.Values[s] = '' then
          AliasList.Add(s+'='+s);
    end;
    CheckInactive;
    FDatabaseName := s;              {%FIX0007}
    DataEvent(dePropertyChange, 0);
  end;
end;

procedure THalcyonDataSet.SetIndexName(const Value: string);
begin
   FIndexName := Value;
   if FDBFHandle <> nil then
    begin
      SetPrimaryTag(Value, True);
      CheckMasterRange;
      if not (DBFHandle.File_TOF and DBFHandle.File_EOF) then
      try                                   {!!RFG 100297}
         Resync([rmExact, rmCenter]);       {!!RFG 100297}
      except                                {!!RFG 100297}
      end;                                  {!!RFG 100297}
      DoAfterScroll;
   end;

end;

procedure THalcyonDataSet.SetIndexList(Items: TStrings);
var
   i: integer;
   iname: string;
   TPath: string;
begin
   IndexDefs.Updated := False;
   IndexDefs.Clear;
   if FIndexFiles <> Items then
      FIndexFiles.Assign(Items);
   if (FIndexFiles.Count > 0) and (FDBFHandle <> nil) then
   begin
      FDBFHandle.gsIndex('','');
      for i := 0 to pred(FIndexFiles.Count) do
      begin
         iname := FIndexFiles.Strings[i];
         iname := ChangeFileExtEmpty(iname,'.NDX');
         TPath := ExtractFilePath(iname);
         iname := ExtractFileName(iname);
         if TPath = '' then
            TPath := ConvertDatabaseNameAlias;
         if not FileExists(TPath + iname) then
            DatabaseErrorFmt(gsErrCannotFindFile,[TPath + iname])  {!!RFG 102097}
         else
            if FDBFHandle.gsIndexRoute(TPath+iname) > 0 then
               DatabaseErrorFmt(gsErrErrorGettingFile,[TPath + iname]); {!!RFG 102097}
      end;
      UpdateIndexDefs;
      SetPrimaryTag(FIndexName,false);
   end;
end;

function THalcyonDataSet.ConvertDatabaseNameAlias: string;
var
   s: string;
   t: string;
begin
   t := UpperCase(FDatabaseName);
   if t = UpperCase(HalcyonDefaultDirectory) then
      Result := ExtractFilePath(Application.ExeName)
   else
   begin
      s := AliasList.Values[t];
      if s <> '' then
         Result := s
      else
         Result := FDatabaseName;
   end;
   if length(Result) > 0 then
      if Result[length(Result)] <> '\' then
         Result := Result + '\';
end;

procedure THalcyonDataSet.DoOnIndexFilesChange(Sender: TObject); {!!RFG 031398}
var
   i: integer;
   iname: string;
   TPath: string;
   dbactive: boolean;
begin
   if FRenaming then exit;
   if (csReading in ComponentState) then exit;        {!!RFG 041398}
   dbactive := FDBFHandle <> nil;
   if not dbactive then
   begin
      try
         Active := true;
      except
      end;
   end;
   if FDBFHandle = nil then exit;
   FDBFHandle.gsIndex('','');                     {!!RFG 043098}
   if (FIndexFiles.Count > 0) then
   begin
      for i := 0 to pred(FIndexFiles.Count) do
      begin
         iname := FIndexFiles.Strings[i];
         iname := ChangeFileExtEmpty(iname,'.NDX');
         TPath := ExtractFilePath(iname);
         iname := ExtractFileName(iname);
         if TPath = '' then
            TPath := ConvertDatabaseNameAlias;
         if not FileExists(TPath + iname) then
            DatabaseErrorFmt(gsErrCannotFindFile,[TPath + iname])
         else
            case FDBFHandle.gsIndexRoute(TPath+iname) of
               0    : begin
                      end;
               -1   : DatabaseErrorFmt(gsErrIndexAlreadyOpen,[TPath + iname]);
               else   DatabaseErrorFmt(gsErrErrorGettingFile,[TPath + iname]);
            end;
      end;
      if dbactive then
         SetPrimaryTag(FIndexName,true);
   end
   else
      FIndexName := '';
   Active := dbactive;
end;

procedure THalcyonDataSet.SetReadOnly(Value: boolean);
begin
   if Active then
      FReadOnly := Value or (not FDBFHandle.FileReadWrite)
   else
      FReadOnly := Value;
end;

procedure THalcyonDataSet.SetTableName(const Value: AnsiString);
begin
  CheckInactive;
  if not (csDesigning in ComponentState) and
     not(csReading in ComponentState) and
     (FTableName <> Value) then IndexFiles.Clear;
  FTableName := Value;
  DataEvent(dePropertyChange, 0);
end;

Procedure THalcyonDataSet.SetUseDeleted(tf: boolean);
begin
   FUseDeleted := tf;
   if FDBFHandle <> nil then
      FDBFHandle.UseDeletedRec := tf;
end;

procedure THalcyonDataset.SetEncrypted(Value: string);
begin
   CheckInactive;
   FEncryption := Value;
end;

procedure THalcyonDataset.EncryptFile(const APassword: string);
begin
   CheckActive;
   FEncryption := APassword;
   FDBFHandle.gsSetPassword(APassword);
end;

(*                Abstract overrides from TDataSet                   *)

function THalcyonDataSet.AllocRecordBuffer: PChar;
begin
  Result := StrAlloc(FRecBufSize);
end;

procedure THalcyonDataSet.FreeRecordBuffer(var Buffer: PChar);
begin
  StrDispose(Buffer);
end;

procedure THalcyonDataSet.GetBookmarkData(Buffer: PChar; Data: Pointer);
begin
  Move(Buffer[FBookmarkOfs], Data^, BookmarkSize);
end;

function THalcyonDataSet.GetBookmarkFlag(Buffer: PChar): TBookmarkFlag;
begin
  Result := PRecInfo(Buffer + FRecInfoOfs).BookmarkFlag;
end;

function THalcyonDataSet.GetFieldData(Field: TField; Buffer: Pointer): Boolean;
var
  IsBlank: boolean;
  RecBuf: PChar;
  s: string;
  l: boolean;
  d: longint;
  f: double;
  i: longint;
  yy,mm,dd: word;
  td: TDateTime;
  ts: TTimeStamp;
begin
  Result := false;
  if (State = dsBrowse) and IsEmpty then Exit;
  IsBlank := false;                              {!!RFG 090697}
  if (State = dsInactive) or (GetActiveRecBuf(RecBuf)) then
  begin
     with Field do
     begin
        if FieldNo > 0 then
        begin
           SetCurRecord(RecBuf);
           if Buffer <> nil then           {!!RFG 090697}
              FillChar(Buffer^,DataSize,#0);
           try
              case DataType of
                 ftString  : begin
                                s := FDBFHandle.gsStringGetN(FieldNo);
                                IsBlank := length(s) = 0;
                                if not IsBlank then
                                begin
                                   if Buffer <> nil then {!!RFG 090697}
                                      move(s[1],Buffer^,length(s));
                                end;
                             end;
                 ftBoolean : begin
                                if Buffer <> nil then {!!RFG 090697}
                                begin
                                   l := FDBFHandle.gsLogicGetN(FieldNo);
                                   if Buffer <> nil then {!!RFG 090697}
                                   move(l,Buffer^,DataSize);
                                end;
                             end;
{!!RFG 090697}    ftDate   : begin
                                IsBlank := true;
                                d := 0;
                                s := FDBFHandle.gsFieldGetN(FieldNo);
                                s := TrimRight(s);                {!!RFG 120897}
                                if (length(s) = 8) and (s <> '00000000') then
                                try
                                   yy := StrToInt(system.copy(s,1,4));
                                   mm := StrToInt(system.Copy(s,5,2));
                                   dd := StrToInt(system.Copy(s,7,2));
                                   td := EncodeDate(yy,mm,dd);
                                   ts := DateTimeToTimeStamp(td);
                                   d := ts.Date;
                                   IsBlank := false;
                                except
                                   d := 0;
                                end;
                                if Buffer <> nil then {!!RFG 090697}
                                   move(d,Buffer^,DataSize);
                             end;
{!!RFG 011898}    ftDateTime: begin
                                 if Buffer <> nil then {!!RFG 090697}
                                 begin
                                    td := FDBFHandle.gsNumberGetN(FieldNo);
                                    move(td,Buffer^,DataSize);
                                 end;
                             end;
                  ftFloat  : begin
                                if Buffer <> nil then {!!RFG 090697}
                                begin
                                   f := FDBFHandle.gsNumberGetN(FieldNo);
                                   move(f,Buffer^,DataSize);
                                end;
                             end;
                  ftSmallInt,
                  ftInteger: begin
                                if Buffer <> nil then {!!RFG 090697}
                                begin
                                   f := FDBFHandle.gsNumberGetN(FieldNo);
                                   i := round(f);
                                   move(i,Buffer^,DataSize);
                                end;
                             end;
                  ftMemo,
                  ftBlob   : begin      {!!RFG 040898}
                                f := FDBFHandle.gsNumberGetN(FieldNo);
                                i := round(f);
                                IsBlank := i = 0;
                             end;
              end;
           finally
              RestoreCurRecord;
           end;
        end else
        if State in [dsBrowse, dsEdit, dsInsert, dsCalcFields] then
        begin
           Inc(RecBuf, FRecordSize + Offset);
           Result := Boolean(RecBuf[0]);
           if Result and (Buffer <> nil) then
             Move(RecBuf[1], Buffer^, DataSize);
            exit;                                {!!RFG 090697}
        end;
     end;
  end;
  Result := not IsBlank;            {!!RFG 090697}
end;

function THalcyonDataSet.GetRecord(Buffer: PChar; GetMode: TGetMode; DoCheck: Boolean): TGetResult;
var
   Status: boolean;
   RN: longint;
   SRN: array[0..10] of char;
begin
   Result := grOk;
   SetCurRecord(Buffer);
   Status := true;
   try
      case GetMode of
         gmCurrent: begin
                       if FBeforeBOF or FAfterEOF then
                          Status := false
                       else
                          FDBFHandle.gsGetRec(Same_Record);
                    end;
         gmNext:    begin
                       if FBeforeBOF then
                          FDBFHandle.gsGetRec(Top_Record)
                       else
                          FDBFHandle.gsGetRec(Next_Record);
                       FBeforeBOF := false;
                    end;
         gmPrior:   begin
                       if FAfterEOF then
                          FDBFHandle.gsGetRec(Bttm_Record)
                       else
                          FDBFHandle.gsGetRec(Prev_Record);
                       FAfterEOF := false;
                    end;
       end;
    except
       Status := false;
    end;
    RestoreCurRecord;
    if FDBFHandle.File_EOF then
       Result := grEOF
    else
       if FDBFHandle.File_TOF then
          Result := grBOF;
    if Status and (Result = grOk) then
    begin
       with PRecInfo(Buffer + FRecInfoOfs)^ do
       begin
          BookmarkFlag := bfCurrent;
          RecordNumber := FDBFHandle.RecNumber;
       end;
       GetCalcFields(Buffer);
       RN := FDBFHandle.RecNumber;
       Str(RN:10,SRN);                            {!!RFG 100297}
       Move(SRN[0], Buffer[FBookmarkOfs], 11);    {!!RFG 100297}
       if Result = grError then Result := grOK;
    end
    else
    begin
      if not Status then
      begin
         Result := grError;
         if DoCheck then
           raise EDatabaseError.Create(gsErrRecordOutOfRange);  {!!RFG 102097}
      end;
    end;
 end;

function THalcyonDataSet.GetRecordSize: Word;
begin
  Result := FRecordSize;
end;

procedure THalcyonDataSet.InternalAddRecord(Buffer: Pointer; Append: Boolean);
begin
   SetCurRecord(PChar(Buffer));
   FDBFHandle.gsAppend;
   FDBFHandle.gsUnlock;
   FDoingEdit := false;
   RestoreCurRecord;
end;

procedure THalcyonDataSet.InternalCancel;
begin
   FDBFHandle.gsUnlock;
   FDoingEdit := false;           {!!RFG 100197}
end;

procedure THalcyonDataSet.InternalClose;
begin
   BindFields(False);
   if DefaultFields then DestroyFields;
   if FDBFHandle <> nil then
      FDBFHandle.Free;
   FDBFHandle := nil;
end;

procedure THalcyonDataSet.InternalDelete;
begin
   SetCurRecord(ActiveBuffer);
   FDBFHandle.UseDeletedRec := true;
   try
      FDBFHandle.gsDeleteRec;
   except
      DatabaseError(gsErrDeleteRecord);
   end;
   RestoreCurRecord;
   FDBFHandle.UseDeletedRec := FUseDeleted;
   FDBFHandle.gsGetRec(Same_Record);
   if FDBFHandle.File_EOF then              {%FIX0011}
      FDBFHandle.gsGetRec(Prev_Record);
end;

procedure THalcyonDataSet.InternalFirst;
begin
   FBeforeBOF := true;
end;

procedure THalcyonDataSet.InternalGotoBookmark(Bookmark: Pointer);
var
   RN: integer;
begin
   SetCurRecord(PChar(DBFHandle.CurRecHold));
   try
      RN := StrToInt(PChar(BookMark));
      FDBFHandle.gsGetRec(RN);
   except
      DataBaseError(gsErrInvalidBookmark+FTableName);
   end;
   RestoreCurRecord;
end;

procedure THalcyonDataSet.InternalHandleException;
begin
end;

procedure THalcyonDataSet.InternalInitFieldDefs;
var
   I: Integer;
   IsClosed: boolean;
begin
   FieldDefs.Clear;
   IsClosed := FDBFHandle = nil;
   if IsClosed then
   begin
      OpenDBFFile(false,true);
   end;
   if FDBFHandle <> nil then
      for I := 0 to pred(FDBFHandle.NumFields) do
         AddFieldDesc(I + 1);
   if IsClosed then
   begin
      if FDBFHandle <> nil then
         FDBFHandle.Free;
      FDBFHandle := nil;
   end;
end;

procedure THalcyonDataSet.InternalInitRecord(Buffer: PChar);   {!!RFG 042198}
begin
   SetCurRecord(Buffer);
   FDBFHandle.gsBlank;
   if (State <> dsEdit) then
      Move(FDBFHandle.CurRecord^[0],FDBFHandle.OrigRec^[0],FDBFHandle.RecLen); {!!RFG 100197}
   RestoreCurRecord;
end;

procedure THalcyonDataSet.InternalLast;
begin
   SetCurRecord(PChar(DBFHandle.CurRecHold));
   FDBFHandle.gsGetRec(Bttm_Record);
   FAfterEOF := true;
   RestoreCurRecord;
end;

procedure THalcyonDataSet.InternalOpen;
begin
   OpenDBFFile(not FReadOnly, not FExclusive);
   FDBFHandle.UseDeletedRec := FUseDeleted;
   FDBFHandle.gsSetDBFCache(FUseDBFCache);    {!!RFG 011898}
   FDBFHandle.gsSetLockProtocol(GSsetLokProtocol(FLokProtocol));
   FDBFHandle.gsAssignUserID(FUserID);

   InternalInitFieldDefs;

{   GetIndexInfo;}

   if DefaultFields then CreateFields;
   BindFields(True);
   InitBufferPointers;
   InternalFirst;
   SetIndexList(FIndexFiles);
   FDoingEdit := false;          {!!RFG 100197}
   CheckMasterRange;
end;

procedure THalcyonDataSet.DoAfterInsert;
begin
   FDBFHandle.File_TOF := false;
   FDBFHandle.File_EOF := true;
   inherited DoAfterInsert;
end;

procedure THalcyonDataSet.InternalEdit;
begin
   SetCurRecord(ActiveBuffer);
   FDBFHandle.gsGetRec(PRecInfo(ActiveBuffer + FRecInfoOfs).RecordNumber);
   if not FDBFHandle.gsRLock then
      DatabaseError(gsErrRecordLockAlready);
   FDoingEdit := true;          {!!RFG 100197}
   RestoreCurRecord;
end;

procedure THalcyonDataSet.InternalPost;
begin
   SetCurRecord(ActiveBuffer);
   try
      if State = dsEdit then
         FDBFHandle.gsPutRec(FDBFHandle.RecNumber)
      else
         FDBFHandle.gsAppend;
   finally
      RestoreCurRecord;
   end;
   FDBFHandle.gsUnlock;
   FDoingEdit := false;        {!!RFG 100197}
   FAfterEOF := false;         {!!RFG 102097}
   FBeforeBOF := false;        {!!RFG 102097}
 end;

procedure THalcyonDataSet.InternalRefresh;
begin
   SetCurRecord(ActiveBuffer);
   FDBFHandle.gsGetRec(PRecInfo(ActiveBuffer + FRecInfoOfs).RecordNumber);
   RestoreCurRecord;
   FDBFHandle.gsRefreshFilter;
end;

procedure THalcyonDataSet.InternalSetToRecord(Buffer: PChar);
begin
  InternalGotoBookmark(Buffer + FBookmarkOfs);
end;

function THalcyonDataSet.IsCursorOpen: Boolean;
begin
  Result := FDBFHandle <> nil;
end;

procedure THalcyonDataSet.SetBookmarkFlag(Buffer: PChar; Value: TBookmarkFlag);
begin
  PRecInfo(Buffer + FRecInfoOfs).BookmarkFlag := Value;
end;

procedure THalcyonDataSet.SetBookmarkData(Buffer: PChar; Data: Pointer);
begin
  Move(Data^, ActiveBuffer[FBookmarkOfs], BookmarkSize);
end;

procedure THalcyonDataSet.SetFieldData(Field: TField; Buffer: Pointer);
var
   RecBuf: PChar;
   td: TDateTime;
   ts: TTimeStamp;
   s: string;
   i: longint;
   f: double;
   b: boolean;
begin
   with Field do
   begin
      if not (State in dsWriteModes) then DatabaseError(gsErrNotEditing);
      if (State = dsSetKey) and
         ((FieldNo < 0) or (FDBFHandle.NumFields > 0) and
         not IsIndexField) then
            DatabaseErrorFmt(SNotIndexField, [DisplayName]);
      GetActiveRecBuf(RecBuf);
      if FieldNo > 0 then
      begin
         if State = dsCalcFields then DatabaseError(gsErrNotEditing);
         if ReadOnly and not (State in [dsSetKey, dsFilter]) then
            DatabaseErrorFmt(SFieldReadOnly, [DisplayName]);
         Validate(Buffer);
         if FieldKind <> fkInternalCalc then
         begin
            SetCurRecord(RecBuf);
            try
               case DataType of
                  ftString  : begin
                                 s := '';
                                 if Buffer <> nil then          {!!RFG 020398}
                                    s := StrPas(PChar(Buffer));
                                 FDBFHandle.gsStringPutN(FieldNo,s);
                              end;
                  ftBoolean : begin
                                 b := false;
                                 if Buffer <> nil then
                                    b := boolean(Buffer^);       {!!RFG 020398}
                                 FDBFHandle.gsLogicPutN(FieldNo, b);
                              end;
                  ftDate    : begin                 {!!RFG 090997}
                                 ts.Time := 0;
                                 if Buffer <> nil then
                                 begin
                                    try
                                       ts.Date := LongInt(Buffer^);
                                       td := TimeStampToDateTime(ts);
                                       s := FormatDateTime('yyyymmdd',td);
                                    except
                                       s := '        ';
                                    end;
                                 end
                                 else
                                    s := '        ';
                                 FDBFHandle.gsFieldPutN(FieldNo,s);
                              end;
                  ftDateTime: begin
                                 f := 0.0;
                                 if Buffer <> nil then          {!!RFG 020398}
                                    move(Buffer^,f,DataSize);
                                 FDBFHandle.gsNumberPutN(FieldNo, f);
                              end;
                  ftFloat   : begin
                                 f := 0.0;
                                 if Buffer <> nil then          {!!RFG 020398}
                                    move(Buffer^,f,DataSize);
                                 FDBFHandle.gsNumberPutN(FieldNo, f);
                              end;
                  ftSmallInt: begin
                                 i := 0;                        {!!RFG 021998}
                                 if Buffer <> nil then          {!!RFG 021998}
                                    i := smallint(Buffer^);     {!!RFG 040298}
                                 f := i;
                                 FDBFHandle.gsNumberPutN(FieldNo,f);
                              end;
                  ftInteger : begin
                                 i := 0;
                                 if Buffer <> nil then          {!!RFG 020398}
                                    i := longint(Buffer^);      {!!RFG 021998}
                                 f := i;
                                 FDBFHandle.gsNumberPutN(FieldNo,f);
                              end;
               end;
            finally
               RestoreCurRecord;
            end;
         end;
      end else {fkCalculated, fkLookup}
      begin
         Inc(RecBuf, FRecordSize + Offset);
         Boolean(RecBuf[0]) := LongBool(Buffer);
         if Boolean(RecBuf[0]) then Move(Buffer^, RecBuf[1], DataSize);
      end;
      if not (State in [dsCalcFields, dsFilter, dsNewValue]) then
         DataEvent(deFieldChange, Longint(Field));
   end;
end;

procedure THalcyonDataSet.DoOnFilter(var tf: boolean);
var
   ts: TDataSetState;
begin
   if FRenaming then exit;
   if State = dsInactive then exit;
   if not Filtered then exit;
   if Assigned(OnFilterRecord) then
   begin
      ts := SetTempState(dsFilter);
      try                              {!!RFG 050898}
         OnFilterRecord(Self,tf);
      finally
         RestoreState(ts);
      end;
   end;
end;

procedure THalcyonDataset.DoOnStatus(stat1, stat2, stat3: longint);
begin
   if FRenaming then exit;
   if assigned(FOnStatus) then FOnStatus(stat1,stat2,stat3);
end;


{$IFDEF VER120}
function THalcyonDataSet.Translate(Src, Dest: PChar; ToOem: Boolean): integer;
{$ELSE}
procedure THalcyonDataSet.Translate(Src, Dest: PChar; ToOem: Boolean);
{$ENDIF}
var
  Len: Integer;
begin
  {$IFDEF VER120}
  Result := StrLen(Src);
  {$ENDIF}
  if Src = nil then                       {!!RFG 111897}
  begin                                   {!!RFG 111897}
     if Dest <> nil then Dest[0] := #0;   {!!RFG 111897}
  end                                     {!!RFG 111897}
  else                                    {!!RFG 111897}
  begin
     if FTranslateASCII then              {!!RFG 032798}
     begin
        Len := StrLen(Src);
        if ToOem then
          CharToOEMBuff(Src, Dest, Len)
        else
          OEMToCharBuff(Src, Dest, Len);
     end
     else
     begin
        if Src <> Dest then
           Move(Src[0], Dest[0], StrLen(Src));
     end;
  end;                                    {!!RFG 111897}
end;

Function THalcyonDataSet.IsDeleted : boolean;
begin
   Result := false;
   if ActiveBuffer = nil then exit;
   Result := ActiveBuffer[0] = '*';
end;

procedure THalcyonDataSet.InternalRecall;
begin
   SetCurRecord(ActiveBuffer);
   FDBFHandle.UseDeletedRec := true;
   try
      FDBFHandle.gsUnDelete;
   except
      RestoreCurRecord;
      DatabaseError(gsErrUndeleteRecord);
   end;
   RestoreCurRecord;
   FDBFHandle.UseDeletedRec := FUseDeleted;
end;

procedure THalcyonDataSet.Recall;
begin
  CheckActive;
  if State in [dsInsert, dsSetKey] then Cancel else
  begin
    if RecordCount = 0 then DatabaseError(SDataSetEmpty);
    DataEvent(deCheckBrowseMode, 0);
    DoBeforeScroll;
    UpdateCursorPos;
    InternalRecall;
    FreeFieldBuffers;
    SetState(dsBrowse);
    Resync([]);
    DoAfterScroll;
  end;
end;

procedure THalcyonDataSet.RestoreCurRecord;
begin
   if State = dsFilter then exit;            {!!RFG 050898}
   FDBFHandle.CurRecord := FDBFHandle.CurRecHold;
end;

function THalcyonDataSet.SetCurRecord(CurRec: PChar): PChar;
begin
   Result := PChar(FDBFHandle.CurRecord);
   if State = dsFilter then exit;            {!!RFG 050898}
   if CurRec <> nil then
   begin
      FDBFHandle.CurRecord := pointer(CurRec);
   end
   else
      Result := nil;
end;

Function THalcyonDataSet.Find(const ss : string; IsExact, IsNear: boolean): boolean;
var
   ps: array[0..255] of char;
   rn: longint;
begin
   CheckBrowseMode;
   rn := GetRecNo;
   if (FDBFHandle.NumRecs = 0) or (rn=0) or (ActiveBuffer = nil) then    {!!RFG 04261999}
   begin
      Result := false;
      exit;
   end;
   DoBeforeScroll;
   CursorPosChanged;
   FDBFHandle.gsvExactMatch := IsExact;
   FDBFHandle.gsvFindNear := IsNear;
   StrPCopy(ps,ss);
   Translate(ps,ps,true);
   Result := FDBFHandle.gsFind(StrPas(ps));
   if Result or (IsNear and (not FDBFHandle.File_EOF)) then
   begin
      FAfterEOF := false;
      Resync([rmExact, rmCenter]);
   end   
   else
   begin
      FAfterEOF := true;
      ClearBuffers;
      DataEvent(deDataSetChange, 0);
      exit;
   end;
   DoAfterScroll;
end;

procedure THalcyonDataSet.GetIndexTagList(List: TStrings);
var
   i: integer;
   j: integer;
   k: integer;
   t: GSobjIndexTag;
   dbactive: boolean;
begin
   List.Clear;
   dbactive := FDBFHandle <> nil;
   if not dbactive then
      try
         Active := true;
      except
      end;
   if FDBFHandle = nil then exit;
   for i := 1 to IndexesAvail do
   begin
      if FDBFHandle.IndexStack[i] <> nil then
      begin
         k := FDBFHandle.IndexStack[i].TagCount;
         for j := 0 to pred(k) do
         begin
            t := FDBFHandle.IndexStack[i].TagByNumber(j);
            List.Add(StrPas(t.TagName));
         end;
      end;
   end;
   Active := dbactive;
end;

procedure THalcyonDataSet.GetDatabaseNames(List: TStrings);
var
   i: integer;
   s: string;
begin
   List.Clear;
   for i := 0 to AliasList.Count-1 do
   begin
      s  := AliasList[i];
      system.delete(s,pos('=',s),255);
      List.Add(s);
   end;
end;

procedure THalcyonDataSet.SetRange(const RLo, RHi: string);
var
   pLo: array[0..255] of char;
   pHi: array[0..255] of char;
begin
   CheckBrowseMode;
   StrPCopy(pLo,RLo);
   StrPCopy(pHi,RHi);
   Translate(pLo,pLo,true);
   Translate(pHi,pHi,true);
   FDBFHandle.gsSetRange(StrPas(pLo),StrPas(pHi),true,true,false);
   First;
end;

procedure THalcyonDataSet.SetRangeEx(const RLo, RHi: string; LoIn, HiIn, Partial: boolean);
var
   pLo: array[0..255] of char;
   pHi: array[0..255] of char;
begin
   CheckBrowseMode;
   StrPCopy(pLo,RLo);
   StrPCopy(pHi,RHi);
   Translate(pLo,pLo,true);
   Translate(pHi,pHi,true);
   FDBFHandle.gsSetRange(StrPas(pLo),StrPas(pHi),LoIn,HiIn,Partial);
   First;
end;

procedure THalcyonDataSet.SetRangeEmpty;
begin
   CheckBrowseMode;
   FDBFHandle.gsSetRangeEmpty;
   First;
end;

Procedure THalcyonDataSet.Reindex;
begin
   CheckBrowseMode;
   FDBFHandle.gsReindex;
end;

Function THalcyonDataSet.CreateDBF(const fname, apassword: string; ftype: char;
                                fproc: dbInsertFieldProc): boolean;
begin
   CreateDBF := gsCreateDBF(fname,ftype,fproc);
end;

Procedure THalcyonDataSet.FlushDBF;
begin
   CheckBrowseMode;
   FDBFHandle.dStatus := gs6_DBF.Updated;
   FDBFHandle.gsFlush;
end;

Procedure THalcyonDataSet.Index(const IName, Tag: string);
var
   sl: TStringList;
   s: string;
   i: integer;
   lm: integer;
   nq: boolean;
begin
   CheckBrowseMode;
   IndexDefs.Updated := False;
   sl := TStringList.Create;
   lm := length(IName);
   nq := true;
   i := 1;
   s := '';
   while (i <=lm) and (IName[i] in [' ',',',';']) do inc(i);
   while i <= lm do
   begin
      if (IName[i] in [' ',',',';']) and nq then
      begin
         if length(s) > 0 then
            sl.Add(s);
         s := '';
         while (i <=lm) and (IName[i] in [' ',',',';']) do inc(i);
      end
      else
      begin
         if IName[i] = '"' then
            nq := not nq
         else
            s := s + IName[i];
         inc(i);
      end;
   end;
   if length(s) > 0 then
      sl.Add(s);
   FIndexFiles.Assign(sl);
   sl.Free;
   IndexName := Tag;
end;

Procedure  THalcyonDataSet.IndexFileInclude(const IName: string);
begin
   CheckActive;
   IndexDefs.Updated := False;
   FDBFHandle.gsIndexRoute(IName);
end;

Procedure  THalcyonDataSet.IndexFileRemove(const IName: string);
begin
   CheckActive;
   IndexDefs.Updated := False;
   FDBFHandle.gsIndexFileRemove(IName);
end;

Procedure THalcyonDataSet.IndexTagRemove(const IName, Tag: string);
begin
   CheckActive;
   IndexDefs.Updated := False;
   FDBFHandle.gsIndexTagRemove(IName, Tag);
end;

Procedure THalcyonDataSet.IndexOn(const IName, tag, keyexp, forexp: String;
                         uniq: TgsIndexUnique; ascnd: TgsSortStatus);
begin
   CheckBrowseMode;
   IndexDefs.Updated := False;
   FActivity := aIndexing;
   DisableControls;
   try
      FDBFHandle.gsIndexTo(IName, tag, keyexp, forexp,
                      GSsetIndexUnique(uniq), GSsetSortStatus(ascnd));
   finally
      FActivity := aNormal;
      EnableControls;
      First;
   end;
end;

function THalcyonDataSet.IndexExpression(Value: integer): string;
var
   p: GSobjIndexTag;
begin
   Result := '';
   CheckActive;
   p := FDBFHandle.gsIndexPointer(Value);
   if p <> nil then
      Result := p.IndexExpression;
end;

function THalcyonDataSet.IndexFilter(Value: integer): string;
var
   p: GSobjIndexTag;
begin
   Result := '';
   CheckActive;
   p := FDBFHandle.gsIndexPointer(Value);
   if (p <> nil) and (p.ForExpr <> nil) then
      Result := StrPas(p.ForExpr);
end;

function THalcyonDataSet.IndexKeyLength(Value: integer): integer;
var
   p: GSobjIndexTag;
begin
   IndexKeyLength := 0;
   CheckActive;
   p := FDBFHandle.gsIndexPointer(Value);
   if (p <> nil) then
      Result := p.KeyLength;
end;

function THalcyonDataSet.IndexUnique(Value: integer): boolean;
var
   p: GSobjIndexTag;
begin
   Result := false;
   CheckActive;
   p := FDBFHandle.gsIndexPointer(Value);
   if p <> nil then
      Result := p.UniqueKey;
end;

function THalcyonDataSet.IndexAscending(Value: integer): boolean;
var
   p: GSobjIndexTag;
begin
   Result := true;
   CheckActive;
   p := FDBFHandle.gsIndexPointer(Value);
   if p <> nil then
      Result := p.AscendKey;
end;

function THalcyonDataSet.IndexFileName(Value: integer): string;
var
   p: GSobjIndexTag;
begin
   Result := '';
   CheckActive;
   p := FDBFHandle.gsIndexPointer(Value);
   if p <> nil then
      Result := StrPas(p.Owner.IndexName);
end;

function THalcyonDataSet.IndexTagName(Value: integer): string;
var
   p: GSobjIndexTag;
begin
   Result := '';
   CheckActive;
   p := FDBFHandle.gsIndexPointer(Value);
   if p <> nil then
      Result := StrPas(p.TagName);
end;

function THalcyonDataSet.IndexCount: integer;
var
   i: integer;
   n: integer;
begin
   n := 0;
   CheckActive;
   i := 1;
   while (i <= IndexesAvail) do
   begin
      if FDBFHandle.IndexStack[i] <> nil then
         n := n + FDBFHandle.IndexStack[i].TagCount;
      inc(i);
   end;
   Result := n;
end;

function THalcyonDataSet.IndexCurrent: string;
begin
   Result := '';
   CheckActive;
   if FDBFHandle.IndexMaster <> nil then
      Result := StrPas(FDBFHandle.IndexMaster.TagName);
end;

function THalcyonDataset.IndexKeyValue(Value: integer): string;
var
   expvar: TgsVariant;
begin
   Result := '';
   CheckActiveSet;
   expvar := TgsVariant.Create(256);
   if FDBFHandle.gsIndexKeyValue(Value,expvar) then
      Result := expvar.GetString;
   expvar.Free;
   if not FUpdatingIndexDesc then
      RestoreCurRecord;
end;

function THalcyonDataSet.IndexCurrentOrder: integer;
var
   p: GSobjIndexTag;
   i: integer;
   n: integer;
   ni: integer;
begin
   Result := 0;
   CheckActive;
   with FDBFHandle do
   begin
      p := nil;
      n := 0;
      if IndexMaster <> nil then
      begin
         ni := 0;
         i := 1;
         while (p = nil) and (i <= IndexesAvail) do
         begin
            if IndexStack[i] <> nil then
            begin
               p := IndexStack[i].TagByNumber(ni);
               inc(ni);
               if p <> nil then
               begin
                  inc(n);
                  if ComparePChar(p.TagName,PrimaryTagName) <> 0 then
                     p := nil;
               end
               else
               begin
                  inc(i);
                  ni := 0;
               end;
            end;
         end;
      end;
   end;
   if p <> nil then
      Result := n;
end;

procedure THalcyonDataSet.IndexIsProduction(tf: boolean);
begin
   CheckActive;
   if tf then
      FDBFHandle.IndexFlag := $01
   else
      FDBFHandle.IndexFlag := $00;
   FDBFHandle.WithIndex := tf;
   FDBFHandle.dStatus := gs6_dbf.Updated;
   FDBFHandle.gsHdrWrite;          {!!RFG 081897}
end;

function THalcyonDataSet.Locate(const KeyFields: string;
                                const KeyValues: Variant;
                                Options: TLocateOptions): Boolean;
var                                        {!!RFG 100997}
   s: string;
   cs: string;
   i: integer;
   fnum: word;
   rnum: longint;
   posn: word;
begin
   CheckActive;
   if (FDBFHandle.NumRecs = 0) or (GetRecNo = 0) then    {!!RFG 04261999}
   begin
      Result := false;
      exit;
   end;
   CheckBrowseMode;
   SetCurRecord(PChar(DBFHandle.CurRecHold));
   cs := IndexCurrent;
   s := KeyValues;
   if (loCaseInsensitive in Options) then
      i := 0
   else
      i := SearchForIndexExp(KeyFields);
   if i > 0 then
   begin
      SetTagTo(IndexTagName(i));
      DoBeforeScroll;
      CursorPosChanged;
      FDBFHandle.gsvExactMatch := not (loPartialKey in Options);
      FDBFHandle.gsvFindNear := false;
      rnum := GetRecNo;
      Result := FDBFHandle.gsFind(s);
      if Result then
      begin
         FAfterEOF := false;
         Resync([rmExact, rmCenter]);
         DoAfterScroll;
      end
      else
         FDBFHandle.gsGetRec(rnum);
      SetTagTo(cs);
   end
   else
   begin
      DBFHandle.SearchMode := 32;
      if (loPartialKey in Options) then
      begin
         DBFHandle.SearchMode := DBFHandle.SearchMode + 4;
         s := s+'*';
      end
      else
      begin                                           {!!RFG 022798}
         DBFHandle.SearchMode := DBFHandle.SearchMode + 2;
      end;
      if (loCaseInsensitive in Options) then
         DBFHandle.SearchMode := DBFHandle.SearchMode + 1;
      fnum := DBFHandle.gsFieldNo(KeyFields);
      rnum := 0;
      posn := SearchDBF(s,fnum,rnum,0);
      Result := posn > 0;
   end;
   RestoreCurRecord;
end;

function THalcyonDataSet.Lookup(const KeyFields: string; const KeyValues: Variant;
  const ResultFields: string): Variant;
var                                            {!!RFG 100997}
   s: string;
   cs: string;
   i: integer;
   fnum: word;
   rnum: longint;
   posn: word;
   RN: longint;
   rsl: boolean;
begin
   if (FDBFHandle.NumRecs = 0) or (GetRecNo = 0) then    {!!RFG 04261999}
   begin
      Result := null;
      exit;
   end;
   RN := GetRecNo;
   cs := IndexCurrent;
   if KeyValues = null then             {!!RFG 111897}
      s := ''
   else
      s := KeyValues;
   i := SearchForIndexExp(KeyFields);
   if i > 0 then
   begin
      SetPrimaryTag(IndexTagName(i),false);
      FDBFHandle.gsvExactMatch := false;
      FDBFHandle.gsvFindNear := false;
      rsl := FDBFHandle.gsFind(s);
      if rsl then
         Result := FDBFHandle.gsStringGet(ResultFields);
      SetPrimaryTag(cs,false);
   end
   else
   begin
      DBFHandle.SearchMode := 36;
      fnum := DBFHandle.gsFieldNo(KeyFields);
      rnum := 0;
      posn := FDBFHandle.gsSearchDBF(s,fnum,rnum,0);
      rsl := posn > 0;
      if rsl then
         Result := FDBFHandle.gsStringGet(ResultFields);
   end;
   if rsl then
      FDBFHandle.gsGetRec(RN)
   else
      Result := null;
end;


procedure THalcyonDataSet.DoOnFormula(who, st, rsl : PChar; var Typ: char;
                                      var Chg, tf: boolean);
var
   ts: TDataSetState;
begin
   if FRenaming then exit;
   if assigned(FOnFormula) then
   begin
      ts := SetTempState(dsFilter);
      try                              {!!RFG 050898}
         FOnFormula(who,st,rsl,Typ,Chg,tf);
      finally
         RestoreState(ts);
      end;
   end;
end;

function THalcyonDataSet.IsSequenced: Boolean;
begin
  Result := (FDBFHandle.IndexMaster = nil) and (not Filtered);
end;

Procedure THalcyonDataSet.CopyRecordTo(area: THalcyonDataSet);
begin
   CheckBrowseMode;
   if area.FDBFHandle = nil then
   begin
      DatabaseError(SDataSetClosed);
      exit;
   end;
   SetCurRecord(ActiveBuffer);
   FDBFHandle.gsCopyRecord(Area.FDBFHandle);
   RestoreCurRecord;
   Refresh;
end;

Procedure THalcyonDataSet.CopyStructure(const filname, apassword: string);
var
   FCopy  : GSO_dBHandler;
begin
   CheckActive;
   FDBFHandle.gsCopyStructure(filname);
   FCopy := GSO_dBHandler.Create(filname, '',true,false);
   FCopy.gsSetPassword(apassword);
   FCopy.Free;
end;

Procedure THalcyonDataSet.CopyTo(const filname, apassword: string);
begin
   CheckBrowseMode;
   FActivity := aCopying;
   DisableControls;
   try
      FDBFHandle.gsCopyFile(filname, apassword);
   finally
      FActivity := aNormal;
      EnableControls;
      First;
   end;
end;

Function THalcyonDataSet.FLock : boolean;
begin
   CheckActive;
   FLock := FDBFHandle.gsFLock;
end;

Procedure THalcyonDataSet.Pack;
begin
   CheckBrowseMode;
   FDBFHandle.gsSetDBFCacheAllowed(false);  {!!RFG 040698}
   FDBFHandle.gsPack;
   First;
end;

Function THalcyonDataSet.RLock : boolean;
var
   rn: longint;
begin
   CheckActive;
   rn := FDBFHandle.RecNumber;            {!!FIX0022}
   FDBFHandle.RecNumber := GetRecNo;
   RLock := FDBFHandle.gsRLock;
   FDBFHandle.RecNumber := rn;
end;

Procedure THalcyonDataSet.SetDBFCache(tf: boolean);
begin
   FUseDBFCache := tf;
   if FDBFHandle = nil then exit;
   FDBFHandle.gsSetDBFCache(tf);
end;

Procedure THalcyonDataSet.SetLockProtocol(LokProtocol: TgsLokProtocol);
begin
   FLokProtocol := LokProtocol;
   if FDBFHandle = nil then exit;
   FDBFHandle.gsSetLockProtocol(GSsetLokProtocol(LokProtocol))
end;

Procedure THalcyonDataSet.SetTagTo(TName: string);
begin
   CheckActive;
   IndexName := TName;
end;

Procedure THalcyonDataSet.SetTempDirectory(const Value: String);
begin
   FillChar(FTempDir[0],SizeOf(FTempDir),#0);
   if length(Value) > 0 then
   begin
      StrPCopy(FTempDir,Value);
      if Value[length(Value)] <> '\' then
         FTempDir[StrLen(FTempDir)] := '\';
   end;
   if FDBFHandle = nil then exit;
   StrDispose(FDBFHandle.gsvTempDir);
   FDBFHandle.gsvTempDir := StrNew(FTempDir);
end;

Procedure THalcyonDataSet.SortTo(const filname, apassword, formla: string; sortseq : TgsSortStatus);
begin
   CheckBrowseMode;
   FActivity := aCopying;
   DisableControls;
   try
      FDBFHandle.gsSortFile(filname, apassword, formla, GSsetSortStatus(sortseq));
   finally
      FActivity := aNormal;
      EnableControls;
      First;
   end;
   CheckBrowseMode;
end;

Procedure THalcyonDataSet.Unlock;
begin
   CheckActive;
   FDBFHandle.gsLockOff;
end;

Procedure THalcyonDataSet.Zap;
begin
   CheckBrowseMode;
   FDBFHandle.gsZap;
   First;
end;





{------------------------------------------------------------------------------
                           Database Search Routine
------------------------------------------------------------------------------}

Function THalcyonDataSet.SearchDBF(const s : string; var FNum : word;
                          var fromrec: longint; toRec: longint): word;
begin
   CheckBrowseMode;
   DisableControls;
   try
      DoBeforeScroll;
      Result := FDBFHandle.gsSearchDBF(s,FNum,fromrec,torec);
      if Result > 0 then
      begin
         Resync([rmExact, rmCenter]);
         DoAfterScroll;
      end;
   finally
      EnableControls;
   end;
end;
{------------------------------------------------------------------------------
                           Field Access Routines
------------------------------------------------------------------------------}



Function THalcyonDataSet.MemoSize(fnam: string): longint;
begin
   CheckActiveSet;
   MemoSize := FDBFHandle.gsMemoSize(fnam);
   RestoreCurRecord;
end;

Function THalcyonDataSet.MemoSizeN(fnum: integer): longint;
begin
   CheckActiveSet;
   MemoSizeN := FDBFHandle.gsMemoSizeN(fnum);
   RestoreCurRecord;
end;

Procedure THalcyonDataSet.MemoLoad(fnam: string;buf: pointer; var cb: longint);
begin
   CheckActiveSet;
   FDBFHandle.gsMemoLoad(fnam,buf,cb);
   RestoreCurRecord;
end;

Procedure THalcyonDataSet.MemoLoadN(fnum: integer;buf: pointer; var cb: longint);
begin
   CheckActiveSet;
   FDBFHandle.gsMemoLoadN(fnum,buf,cb);
   RestoreCurRecord;
end;

Function THalcyonDataSet.MemoSave(fnam: string;buf: pointer; var cb: longint): longint;
begin
   MemoSave := 0;
   CheckActiveSet;
   if ConfirmEdit then
      MemoSave := FDBFHandle.gsMemoSave(fnam,buf,cb);
   RestoreCurRecord;
end;

Function THalcyonDataSet.MemoSaveN(fnum: integer;buf: pointer; var cb: longint): longint;
begin
   MemoSaveN := 0;
   CheckActiveSet;
   if ConfirmEdit then
      MemoSaveN := FDBFHandle.gsMemoSaveN(fnum,buf,cb);
   RestoreCurRecord;
end;


Function THalcyonDataSet.DateGet(st : string) : longint;
begin
   CheckActiveSet;
   DateGet := FDBFHandle.gsDateGet(st);
   RestoreCurRecord;
end;

Function THalcyonDataSet.DateGetN(n : integer) : longint;
begin
   CheckActiveSet;
   DateGetN := FDBFHandle.gsDateGetN(n);
   RestoreCurRecord;
end;

Procedure THalcyonDataSet.DatePut(st : string; jdte : longint);
begin
   CheckActiveSet;
   if ConfirmEdit then
      FDBFHandle.gsDatePut(st, jdte);
   RestoreCurRecord;
end;

Procedure THalcyonDataSet.DatePutN(n : integer; jdte : longint);
begin
   CheckActiveSet;
   if ConfirmEdit then
      FDBFHandle.gsDatePutN(n, jdte);
   RestoreCurRecord;
end;

Function THalcyonDataSet.FieldGet(fnam : string) : string;
begin
   CheckActiveSet;
   FieldGet := FDBFHandle.gsFieldGet(fnam);
   RestoreCurRecord;
end;

Function THalcyonDataSet.FieldGetN(fnum : integer) : string;
begin
   CheckActiveSet;
   FieldGetN := FDBFHandle.gsFieldGetN(fnum);
   RestoreCurRecord;
end;

Procedure THalcyonDataSet.FieldPut(fnam, st : string);
begin
   CheckActiveSet;
   FDBFHandle.gsFieldPut(fnam, st);
   RestoreCurRecord;
end;

Procedure THalcyonDataSet.FieldPutN(fnum : integer; st : string);
begin
   CheckActiveSet;
   FDBFHandle.gsFieldPutN(fnum, st);
   RestoreCurRecord;
end;

Function THalcyonDataSet.FloatGet(st : string) : FloatNum;
begin
   CheckActiveSet;
   FloatGet := FDBFHandle.gsNumberGet(st);
   RestoreCurRecord;
end;

Function THalcyonDataSet.FloatGetN(n : integer) : FloatNum;
begin
   CheckActiveSet;
   FloatGetN := FDBFHandle.gsNumberGetN(n);
   RestoreCurRecord;
end;

Procedure THalcyonDataSet.FloatPut(st : string; r : FloatNum);
begin
   CheckActiveSet;
   FDBFHandle.gsNumberPut(st, r);
   RestoreCurRecord;
end;

Procedure THalcyonDataSet.FloatPutN(n : integer; r : FloatNum);
begin
   CheckActiveSet;
   FDBFHandle.gsNumberPutN(n, r);
   RestoreCurRecord;
end;

Function THalcyonDataSet.LogicGet(st : string) : boolean;
begin
   CheckActiveSet;
   LogicGet := FDBFHandle.gsLogicGet(st);
   RestoreCurRecord;
end;

Function THalcyonDataSet.LogicGetN(n : integer) : boolean;
begin
   CheckActiveSet;
   LogicGetN := FDBFHandle.gsLogicGetN(n);
   RestoreCurRecord;
end;

Procedure THalcyonDataSet.LogicPut(st : string; b : boolean);
begin
   CheckActiveSet;
   if ConfirmEdit then
      FDBFHandle.gsLogicPut(st, b);
   RestoreCurRecord;
end;

Procedure THalcyonDataSet.LogicPutN(n : integer; b : boolean);
begin
   CheckActiveSet;
   if ConfirmEdit then
      FDBFHandle.gsLogicPutN(n, b);
   RestoreCurRecord;
end;

Function THalcyonDataSet.IntegerGet(st : string) : LongInt;
var
   r : FloatNum;
begin
   CheckActiveSet;
   r := FDBFHandle.gsNumberGet(st);
   IntegerGet := Trunc(r);
   RestoreCurRecord;
end;

Function THalcyonDataSet.IntegerGetN(n : integer) : LongInt;
var
   r : FloatNum;
begin
   CheckActiveSet;
   r := FDBFHandle.gsNumberGetN(n);
   IntegerGetN := Trunc(r);
   RestoreCurRecord;
end;

Procedure THalcyonDataSet.IntegerPut(st : string; i : LongInt);
var
   r : FloatNum;
begin
   CheckActiveSet;
   r := i;
   FDBFHandle.gsNumberPut(st, r);
   RestoreCurRecord;
end;

Procedure THalcyonDataSet.IntegerPutN(n : integer; i : LongInt);
var
   r : FloatNum;
begin
   CheckActiveSet;
   r := i;
   FDBFHandle.gsNumberPutN(n, r);
   RestoreCurRecord;
end;

Function THalcyonDataSet.StringGet(fnam : string) : string;
var
   st: string[255];
begin
   CheckActiveSet;
   st := FDBFHandle.gsStringGet(fnam);
   Result := st;
   RestoreCurRecord;
end;

Function THalcyonDataSet.StringGetN(fnum : integer) : string;
var
   st: string[255];
begin
   CheckActiveSet;
   st := FDBFHandle.gsStringGetN(fnum);
   Result := st;
   RestoreCurRecord;
end;

Procedure THalcyonDataSet.StringPut(fnam, st : string);
begin
   CheckActiveSet;
   if ConfirmEdit then
      FDBFHandle.gsStringPut(fnam, st);
   RestoreCurRecord;
end;

Procedure THalcyonDataSet.StringPutN(fnum : integer; st : string);
begin
   CheckActiveSet;
   if ConfirmEdit then
      FDBFHandle.gsStringPutN(fnum, st);
   RestoreCurRecord;
end;

Function THalcyonDataSet.MemoryIndexAdd(const tag, keyexpr, forexpr: String;
            uniq: TgsIndexUnique; ascnd: TgsSortStatus): boolean;
begin
   CheckBrowseMode;
   FActivity := aIndexing;
   DisableControls;
   try
      Result := FDBFHandle.gsMemoryIndexAdd(Tag, keyexpr, forexpr,
                      GSsetIndexUnique(uniq), GSsetSortStatus(ascnd));
      if Result then
         FIndexName := StrPas(FDBFHandle.PrimaryTagName);
   finally
      FActivity := aNormal;
      EnableControls;
      First;
   end;
end;

procedure THalcyonDataSet.CheckActive;
begin
   if FUpdatingIndexDesc then exit;
   inherited CheckActive;
   case FActivity of
      aIndexing : DatabaseError(gsErrBusyIndexing);
      aCopying  : DatabaseError(gsErrBusyCopying);
   end;
end;

procedure THalcyonDataSet.CheckActiveSet;
begin
   CheckActive;
   if not FUpdatingIndexDesc then
      SetCurRecord(ActiveBuffer);
end;

Procedure THalcyonDataset.ReturnDateTimeUser(var dt, tm, us: longint);
begin
   dt := 0;
   tm := 0;
   us := 0;
   CheckActive;
   FDBFHandle.gsReturnDateTimeUser(dt,tm,us);
end;

Function THalcyonDataset.ExternalChange : integer;
begin
   CheckActive;
   ExternalChange := FDBFHandle.gsExternalChange;
end;

procedure THalcyonDataset.AssignUserID(id: longint);
begin
   FUserID := id;
   if FDBFHandle <> nil then
      FDBFHandle.gsAssignUserID(id);
end;

function THalcyonDataSet.GetCanModify: Boolean;   {!!RFG 100197}
begin
  Result := not FReadOnly;
end;

function THalcyonDataSet.CompareBookmarks(Bookmark1, Bookmark2: TBookmark): Integer;
begin                                                     {!!RFG 100197}
   Result := 9;
   if Bookmark1 = nil then
   begin
      if Bookmark2 <> nil then
         Result := -1
      else
         Result := 0;
   end
   else
      if Bookmark2 = nil then
         Result := 1;
   if Result = 9 then
   begin
      Result := ComparePChar(PChar(BookMark1),PChar(Bookmark2));
      if Result < 0 then
         Result := -1
      else
         if Result > 0 then
            Result := 1;
   end;
end;

function THalcyonDataSet.SearchForIndexExp(const IExp: string): integer;
var
   i: integer;
   j: integer;
   s: string;
begin
   Result := 0;
   j := IndexCount;
   i := 1;
   while (i <= j) and (Result = 0) do
   begin
      s := IndexFilter(i);    {Make sure it is not filtered}
      if Length(s) = 0 then
      begin
         s := IndexExpression(i);
         if AnsiCompareText(s, IExp) = 0 then
            Result := i;
      end;
      inc(i);
    end;
end;

function THalcyonDataSet.HuntDuplicate(const st, ky: String): longint;
begin                                                       {!!RFG 082097}
   HuntDuplicate := -1;
   if FDBFHandle = nil then exit;
   HuntDuplicate := FDBFHandle.gsHuntDuplicate(st,ky);
end;

function THalcyonDataSet.SetPrimaryTag(const TName: String; SameRec: boolean): integer; {!!RFG 043098}
var
   rn: longint;
begin
   if FDBFHandle = nil then
   begin
      Result := 0;
      exit;
   end;
   Result := FDBFHandle.gsSetTagTo(TName, false);
   if SameRec and Active then     {%FIX 0002 Keep same record when changing tags}
   begin
      rn := GetRecNo;
      if rn > 0 then
         DBFHandle.gsGetRec(rn);
   end;
end;

function THalcyonDataSet.GetDataSource: TDataSource;
begin
  Result := FMasterLink.DataSource;
end;

procedure THalcyonDataSet.SetDataSource(Value: TDataSource);
begin
  if IsLinkedTo(Value) then DatabaseError(SCircularDataLink);
  FMasterLink.DataSource := Value;

end;


function THalcyonDataset.GetMasterKey: string;
var
   ds: TDataSet;
   Psn: integer;
   Ctr: integer;
   mfc: integer;
   mf: string;
   il: string;
   cf: string;
   exa: string;
   exm: string;
   cv: Variant;
   tsl: TStringList;
   buf: PChar;
   expvar: TgsVariant;
   icc: integer;
   icp: integer;
   nip: integer;
   niq: boolean;
   nic: char;
begin
   if DBFHandle.IndexMaster = nil then
   begin
      DataBaseErrorFmt(gsErrRelationIndex,[FTableName]);
   end;
   ds := MasterSource.Dataset;
   if ds.State = dsInsert then
   begin
      Result := #1;
      exit;
   end;   
   mf := MasterFields;
   if length(mf) > 0 then
   begin
      GetMem(buf,DBFHandle.RecLen);
      tsl := TStringList.Create;
    try
      Psn := 1;
      while Psn < length(mf) do
      begin
         cf := gsExtractFieldName(mf,Psn);
         tsl.Add(cf);
      end;
      mfc := tsl.Count;
      if mfc = 1 then
      begin
         cv := ds.FieldByName(tsl[0]).Value;
      end
      else
      begin
         cv := VarArrayCreate([0, tsl.Count-1], varVariant);
         for Ctr := 0 to mfc-1 do
         begin
            cv[Ctr] := ds.FieldByName(tsl[Ctr]).Value;
         end;
      end;
      tsl.Clear;
      il := FDBFHandle.IndexMaster.ExprHandlr.EnumerateType(gsSQLTypeVarDBF);
      if length(il) > 0 then
      begin
         Psn := 1;
         while Psn < length(il) do
         begin
            cf := gsExtractFieldName(il,Psn);
            tsl.Add(cf);
         end;
      end;
      if mfc > tsl.Count then
      begin
         DataBaseErrorFmt(gsErrRelationFields,[FTableName]);
      end;
      il := '';
      for Ctr := 0 to mfc-1 do
         il := il+tsl[Ctr]+';';
      DBFHandle.gsStuffABuffer(buf,il,cv);
      DBFHandle.CurRecord := pointer(buf);

      expvar := TgsVariant.Create(256);
      try
         if mfc < tsl.Count then
         begin
            exa := FDBFHandle.IndexMaster.ExprHandlr.Expression;
            exm := exa;
            while exm[1] = '(' do System.Delete(exm,1,1);
            icp := 1;
            icc := 0;
            nip := 0;
            niq := true;
            nic := ' ';
            while icc <> mfc do
            begin
               case exm[icp] of
                  '(' : if niq then inc(nip);
                  ')' : if niq then dec(nip);
                  '+',
                  '-' : if niq and (nip = 0) then inc(icc);
                  #39,
                  '[',
                  '"' : if niq then
                           begin
                              niq := false;
                              nic := exm[icp];
                              if nic = '[' then nic := ']';
                           end
                           else
                           begin
                              if nic = exm[icp] then
                              begin
                                 niq := true;
                                 nic := ' ';
                              end;
                           end;
               end;
               if icc < mfc then inc(icp);
            end;
            System.Delete(exm,icp,255);
            FDBFHandle.IndexMaster.ExprHandlr.Expression := exm;
            FDBFHandle.IndexMaster.ExprHandlr.ExpressionAsVariant(expvar);
            FDBFHandle.IndexMaster.ExprHandlr.Expression := exa;
         end
         else
            FDBFHandle.IndexMaster.ExprHandlr.ExpressionAsVariant(expvar);
         Result := expvar.GetString;
      finally
         expvar.Free;
      end;
      DBFHandle.CurRecord := DBFHandle.CurRecHold;
    finally
      tsl.Free;
      FreeMem(buf,DBFHandle.RecLen);
    end;
   end;
end;


function THalcyonDataSet.GetMasterFields: string;
begin
  Result := FMasterLink.FieldNames;
end;

procedure THalcyonDataSet.SetMasterFields(const Value: string);
begin
  FMasterLink.FieldNames := Value;
end;

procedure THalcyonDataSet.MasterChanged(Sender: TObject);
var
   mf: string;
begin
   if Assigned(MasterSource) and Assigned(MasterSource.DataSet) and
      MasterSource.Dataset.Active and (not MasterSource.Dataset.IsEmpty) then
   begin
      CheckBrowseMode;
      mf := GetMasterKey;
      SetRangeEx(mf,mf,true,true,true);
   end;
end;

procedure THalcyonDataSet.MasterDisabled(Sender: TObject);
begin
   SetRange('','');
end;

procedure THalcyonDataSet.CheckMasterRange;
var
   mf: string;
begin
   if Assigned(DBFHandle) and Assigned(MasterSource) and
      Assigned(MasterSource.DataSet) and
      MasterSource.Dataset.Active and (not MasterSource.Dataset.IsEmpty) then
   begin
      mf := GetMasterKey;
      DBFHandle.gsSetRange(mf,mf,true,true,true);             {%FIX0008}
   end;
end;

procedure THalcyonDataSet.SetFilterData(const Text: string; Options: TFilterOptions);
begin
   if Active and Filtered then
   begin
      CheckBrowseMode;
      DBFHandle.gsSetFilterActive(true);  {%FIX0002}
      DBFHandle.gsSetFilterExpr(Text, foCaseInsensitive in Options, not (foNoPartialCompare in Options));
      First;
   end;
   inherited SetFilterText(Text);
   inherited SetFilterOptions(Options);
end;

procedure THalcyonDataSet.SetFilterText(const Value: string);
begin
  SetFilterData(Value, FilterOptions);
end;

procedure THalcyonDataSet.SetFilterOptions(Value: TFilterOptions);
begin
  SetFilterData(Filter, Value);
end;

procedure THalcyonDataSet.SetFiltered(Value: Boolean);
begin
   if Active then
   begin
      CheckBrowseMode;
      if Filtered <> Value then
      begin
         inherited SetFiltered(Value);
         DBFHandle.gsSetFilterActive(Value);
         if Value then
            SetFilterData(Filter,FilterOptions);
      end;
      First;
   end
   else
    inherited SetFiltered(Value);
end;

procedure THalcyonDataSet.RenameTable(const NewTableName: string);
var
   i: integer;
   dbnamestring: string;
   ixnamestring: string;
   exnamestring: string;
   exclu: boolean;
   filtr: boolean;
begin
   CheckInactive;
   exclu := FExclusive;
   FExclusive := true;
   filtr := Filtered;
   Filtered := false;
   FRenaming := true;
   try
      Open;
      dbnamestring := UpperCase(ExtractFileNameOnly(StrPas(FDBFHandle.FileName)));
      DBFHandle.gsRename(NewTableName);
      if FIndexFiles.Count > 0 then
      begin
         for i := 0 to pred(FIndexFiles.Count) do
         begin
            ixnamestring := UpperCase(ExtractFileNameOnly(FIndexFiles[i]));
            if dbnamestring = ixnamestring then
            begin
               exnamestring := ExtractFileExt(FIndexFiles[i]);
               FIndexFiles[i] := ChangeFileExt(NewTableName,exnamestring);
            end;
         end;
      end;
      Close;
      DatabaseName := ExtractFilePath(NewTableName);
      TableName := ExtractFileName(NewTableName);
   finally
      Filtered := filtr;
      FExclusive := exclu;
      FRenaming := false;
   end;
end;

procedure THalcyonDataSet.SetIndexDefs(Value: TIndexDefs);
begin
  IndexDefs.Assign(Value);
end;

procedure THalcyonDataSet.UpdateIndexDefs;
var
  AExpr: string;
  AName: string;
  AField: string;
  Opts: TIndexOptions;
  I, J, K: integer;
begin
   if DBFHandle = nil then exit;
 try
   FUpdatingIndexDesc := true;
   IndexDefs.Clear;
   with DBFHandle do
   begin
      J := IndexCount;
      for I := 1 to J do
      begin
         Opts := [];
         AName := IndexTagName(I);
         AExpr := IndexExpression(I);
         if (Pos('(',AExpr)<>0) then
         begin
            Include(Opts,ixExpression);
            AField := AExpr;
         end
         else
         begin
            AField := '';
            for K := 1 to length(AExpr) do
               if (AExpr[K] in ['+','-']) then
                  AField := AField + ';'
               else
                  if AExpr[K] <> ' ' then
                     AField := AField + AExpr[K];
         end;            
         IndexDefs.Add(AName,AField,Opts);
      end;
   end;
  finally
   FUpdatingIndexDesc := false;
  end;
end;



procedure LoadConfiguration;
var
   cfgFile: TIniFile;
   WindowDirectory: array[0..MAX_PATH] of char;
   FileString: string;
   i: integer;
begin
   GetWindowsDirectory(WindowDirectory, MAX_PATH);
   FileString := StrPas(WindowDirectory);
   if length(FileString) > 0 then
      if FileString[length(FileString)] <> '\' then
         FileString := FileString + '\';
   FileString := FileString + 'halcyon.cfg';
   cfgFile := TIniFile.Create(FileString);
   cfgFile.ReadSectionValues('Alias',AliasList);
   cfgFile.Free;
   for i := 1 to AliasList.Count-1 do
   begin
      AliasList[i] := UpperCase(AliasList[i]);
   end;
end;


Initialization
   AliasList := TStringList.Create;
   AliasList.Add(HalcyonDefaultDirectory);
   LoadConfiguration;

Finalization
begin
   AliasList.Free;
end;



end.

