<%

  rem **********************************************************************
  rem *
  rem * Simple chart creation that demos using BinaryWrite to write
  rem *  the image directly to the client
  rem *
  rem **********************************************************************


  rem **********************************************************************
  rem * Set the ContentType
  rem **********************************************************************
  Response.ContentType = "image/JPEG"

  Dim Chart

  rem **********************************************************************
  rem * Instantiate the Chart component
  rem **********************************************************************
  Set Chart = Server.CreateObject ("ASPChart.Chart")

  rem **********************************************************************
  rem * Add a Bar series with 3 points
  rem **********************************************************************
  Chart.AddSeries (2)
  Chart.AddValue 200, "Regular", vbBlue
  Chart.AddValue 233, "Enhanced ", vbRed
  Chart.AddValue 260, "Free", vbGreen

  rem **********************************************************************
  rem * Add and format the title
  rem **********************************************************************
  Chart.ChartTitleAdd ("Simple Bar Chart")
  Chart.ChartTitleFont.Size = 20
  Chart.ChartTitleFont.Name = "Times New Roman"
  Chart.ChartTitleFont.Italic = true
  Chart.ChartTitleFont.Bold = true

  rem **********************************************************************
  rem * Remove the OuterBevel, add a gradient fill to chart panel
  rem **********************************************************************
  Chart.BevelOuter = 0
  Chart.GradientVisible = true
  Chart.GradientStartColor = vbWhite
  Chart.GradientEndColor = vbYellow

  rem **********************************************************************
  rem * Set the Width and Height of the image
  rem **********************************************************************
  Chart.Height = 300
  Chart.Width = 500

  Response.BinaryWrite Chart.Image

  rem **********************************************************************
  rem * Destroy the object
  rem **********************************************************************
  Set Chart = nothing

%>
