//******************************************************************
//* Copyright and Permission Notice                                *
//*                                                                *
//* Permission is granted to copy, use, modify, and merge this     *
//* software into your applications and to permit others to do any *
//* of the foregoing for non-commercial use only. You must include *
//* this permission and copyright notice in all copies and         *
//* modified versions of this software, and include attribution    *
//* to IBM in all splash screens included in any application       *
//* using this software. You must require others to whom you       *
//* distribute this software to do likewise.                       *
//*                                                                *
//* THE SOFTWARE IS PROVIDED IN ITS 'AS IS' CONDITION FOR          *
//* NON-COMMERCIAL USE ONLY. IBM DISCLAIMS ANY LIABILITY OF ANY    *
//* KIND FOR DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS     *
//* SOFTWARE.                                                      *
//*                                                                *
//* (C) Copyright IBM Corporation 1999.  All Rights Reserved.      *
//******************************************************************/

import  java.awt.*;
import  java.awt.event.*;
import  java.net.*;
import  java.util.*;
import  com.sun.java.swing.*;
import  com.ibm.eou.toolkit.graphics.*;
import  com.ibm.eou.toolkit.gauge.bean.*;
import  com.ibm.eou.toolkit.gauge.*;
import  com.ibm.eou.toolkit.widget.*;
import  com.ibm.eou.toolkit.gauge.BaseGauge;
import  com.ibm.eou.toolkit.gauge.InertialSynchronization;

public  class      GaugeBeansApplet
        extends    com.sun.java.swing.JApplet
        implements java.awt.LayoutManager
{
  // Gauges minimum, maximum and initial values.
  private final int          fMinimum     =     0;
  private final int          fMaximum     =   100;
  private final int          fInitial     =    22;
  private int                fValue       = fInitial;
  // Colors for applet and gauge background/foreground.
  private final Color        fAppletColor = Color.black;
  // Several members are package scope to avoid
  // illegal access errors.
          final Color        fBackground  = new Color(51,51,51);
  private final Color        fForeground  = new Color(0,204,204);
  // Calculated boundaries for gauges and slider within applet.
          Rectangle[]        fCompBounds;
          Rectangle          fImageSliderBox = new Rectangle();

  // Shared GaugeModel for all gauges in this sample applet.
  private GaugeModel         fGaugeModel;

  // Gauge references.
  private com.ibm.eou.toolkit.gauge.bean.Thermometer        fThermometer;
  private com.ibm.eou.toolkit.gauge.bean.Needle             fNeedle;
  private com.ibm.eou.toolkit.gauge.bean.Oscilloscope       fOscilloscope;
  private com.ibm.eou.toolkit.gauge.bean.RollingCounter     fRollingCounter;
  private com.ibm.eou.toolkit.gauge.bean.LEDCounter         fLEDCounter;
  private com.ibm.eou.toolkit.gauge.bean.BarIndicator       fBarIndicator;
  private com.ibm.eou.toolkit.gauge.bean.BlockIndicator     fBlockIndicator;
  private com.ibm.eou.toolkit.gauge.bean.StackCoinIndicator fStackCoinIndicator;

  // Slider reference and image for pointing at slider.
  private ImageSlider        fImageSlider;
          Image              fTryit;
  private URL                fResourceBase;

  // Applets ContentPane.
  private ContentPane        fContentPane;

  //*******************************************************************
  // Initialise gauges and add them to applet.                        *
  //*******************************************************************
  public void init()
  {
    // Supress browser error message in Java Console. May be able
    // to remove in future browser versions.
    getRootPane().putClientProperty(
      "defeatSystemEventQueueCheck", Boolean.TRUE);

    // Get the document location and use it to load the "tryit" image.
    fResourceBase = getDocumentBase();
    fTryit = ImageUtils.getImageFromJar(
      "images/tryit.gif", GaugeBeansApplet.class);
    prepareImage(fTryit, null);

    // Initialise the shared gauge model.
    gaugeModel();

    // Initialise the gauges.
    thermometer();
    needle();
    oscilloscope();
    rollingCounter();
    ledCounter();
    barIndicator();
    blockIndicator();
    stackCoinIndicator();
    imageSlider();

    // Construct an instance of our ContentPane and set it as the
    // applets content pane.
    fContentPane = new ContentPane();
    setContentPane(fContentPane);

    // Set applet colors and make ourself the layout manager.
    fContentPane.setBackground(fAppletColor);
    fContentPane.setForeground(fAppletColor);
    fContentPane.setLayout(this);

    // Add the gauges to our content pane.
    fContentPane.add(fThermometer);
    fContentPane.add(fNeedle);
    fContentPane.add(fOscilloscope);
    fContentPane.add(fRollingCounter);
    fContentPane.add(fLEDCounter);
    fContentPane.add(fBarIndicator);
    fContentPane.add(fBlockIndicator);
    fContentPane.add(fStackCoinIndicator);
    fContentPane.add(fImageSlider);
  }

  //*******************************************************************
  // Initialise Gauge Model                                           *
  //*******************************************************************
  private void gaugeModel()
  {
    fGaugeModel = new DefaultGaugeModel(
      fInitial, 0, fMinimum, fMaximum);
  }

  //*******************************************************************
  // Initialise Stack Coin Indicator                                  *
  //*******************************************************************
  private void stackCoinIndicator()
  {
    fStackCoinIndicator =
      new com.ibm.eou.toolkit.gauge.bean.StackCoinIndicator();
    fStackCoinIndicator.setModel(fGaugeModel);
    fStackCoinIndicator.setImageDeviation(20);
    fStackCoinIndicator.setBackground(fBackground);
    fStackCoinIndicator.setForeground(fForeground);
  }

  //*******************************************************************
  // Initialise thermometer.                                          *
  //*******************************************************************
  private void thermometer()
  {
    fThermometer =
      new com.ibm.eou.toolkit.gauge.bean.Thermometer();
    fThermometer.setModel(fGaugeModel);
    fThermometer.setBackground(fBackground);
    fThermometer.setForeground(fForeground);
  }


  //*******************************************************************
  // Initialise needle gauge.                                         *
  //*******************************************************************
  private void needle()
  {
    fNeedle =
      new com.ibm.eou.toolkit.gauge.bean.Needle();
    fNeedle.setModel(fGaugeModel);
    fNeedle.setScaleColorGradient(ColorGradient.rainbow);
    fNeedle.setGradientOutside(false);
    fNeedle.setBackground(fBackground);
    fNeedle.setForeground(fForeground);
    fNeedle.setGaugeSynchronization(
      new InertialSynchronization(25, 0.3));
  }

  //*******************************************************************
  // Initialise oscilloscope.                                         *
  //*******************************************************************
  private void oscilloscope()
  {
    fOscilloscope =
      new com.ibm.eou.toolkit.gauge.bean.Oscilloscope();
    fOscilloscope.setModel(fGaugeModel);
    fOscilloscope.setBackground(fBackground);
    fOscilloscope.setForeground(fForeground);
  }

  //*******************************************************************
  // Initialise rolling counter.                                      *
  //*******************************************************************
  private void rollingCounter()
  {
    fRollingCounter =
      new com.ibm.eou.toolkit.gauge.bean.RollingCounter();
    fRollingCounter.setModel(fGaugeModel);
    fRollingCounter.setBackground(fBackground);
    fRollingCounter.setForeground(fForeground);
  }


  //*******************************************************************
  // Initialise LED counter.                                          *
  //*******************************************************************
  private void ledCounter()
  {
    fLEDCounter =
      new com.ibm.eou.toolkit.gauge.bean.LEDCounter();
    fLEDCounter.setModel(fGaugeModel);
    fLEDCounter.setBackground(fBackground);
    fLEDCounter.setForeground(fForeground);
  }


  //*******************************************************************
  // Initialise bar indicator.                                        *
  //*******************************************************************
  private void barIndicator()
  {
    fBarIndicator =
      new com.ibm.eou.toolkit.gauge.bean.BarIndicator();
    fBarIndicator.setModel(fGaugeModel);
    fBarIndicator.setOrientation(Adjustable.HORIZONTAL);
    fBarIndicator.setFill(ColorGradient.rainbow);
    fBarIndicator.setBackground(fBackground);
    fBarIndicator.setForeground(fForeground);
  }


  //*******************************************************************
  // Initialise block indicator.                                      *
  //*******************************************************************
  private synchronized void blockIndicator()
  {
    // Get rainbow colors for the block indicator.
    final int blocks  = 40;
    Color[]      colors      = new Color[blocks];
    AlphaColor[] alphaColors =
      ColorGradient.rainbow.getColorArray(blocks);
    for (int color = 0; color < blocks; color++)
    {
      colors[color] = new Color(alphaColors[color].getRGBA());
    }

    fBlockIndicator =
      new com.ibm.eou.toolkit.gauge.bean.BlockIndicator();
    fBlockIndicator.setModel(fGaugeModel);
    fBlockIndicator.setNumberOfBlocks(blocks);
    fBlockIndicator.setBlockSpace(1);
    fBlockIndicator.setBlockSize(new Dimension(3, 30));
    fBlockIndicator.setOrientation(Adjustable.HORIZONTAL);
    fBlockIndicator.setBlockColors(colors);
    fBlockIndicator.setBackground(fBackground);
    fBlockIndicator.setForeground(fForeground);
  }


  //*******************************************************************
  // Initialise image slider.                                         *
  //*******************************************************************
  private void imageSlider()
  {
    fImageSlider = new ImageSlider(
      fValue,
      fMinimum,
      fMaximum,
      true,
      false,
      ImageUtils.getImageFromJar(
        "images/bar.gif", GaugeBeansApplet.class),
      ImageUtils.getImageFromJar(
        "images/thumb.gif", GaugeBeansApplet.class),
      20);

    fImageSlider.setModel(fGaugeModel);
    fImageSlider.setBackground(fBackground);
    fImageSlider.setForeground(fForeground);
    fImageSlider.setRangeAdjustmentMethod(GaugeModel.CLIP);
  }


  //*******************************************************************
  // LayoutManager                                                    *
  //*******************************************************************
  public void addLayoutComponent(String name, Component component)
  {
  }
  public void layoutContainer(Container container)
  {
    fThermometer.setBounds(10, 10, 110, 340);
    fNeedle.setBounds(130, 10, 160, 100);
    fOscilloscope.setBounds(130, 120, 160, 100);
    fRollingCounter.setBounds(150, 240, 42, 22);
    fLEDCounter.setBounds(225, 240, 45, 22);
    fBarIndicator.setBounds(130, 280, 160, 30);
    fBlockIndicator.setBounds(130, 320, 160, 30);
    fStackCoinIndicator.setBounds(300, 10, 110, 340);
    fImageSliderBox = new Rectangle( 9, 365, 400, 45);
    fImageSlider.setBounds(
      fImageSliderBox.x + 69,
      fImageSliderBox.y +  1,
      fImageSliderBox.width  - 69,
      fImageSliderBox.height -  2);

    // Calculate coordinates for drawing component borders.
    Component[] components = container.getComponents();
    fCompBounds = new Rectangle[components.length];
    for (int component = 0; component < components.length; component++)
    {
      Rectangle rectangle = components[component].getBounds();
      rectangle.setBounds(
        rectangle.x - 1,     rectangle.y - 1,
        rectangle.width + 1, rectangle.height + 1);
      fCompBounds[component] = rectangle;
    }

    repaint();
  }
  public Dimension minimumLayoutSize(Container container)
  {
    return new Dimension(420, 420);
  }
  public Dimension preferredLayoutSize(Container container)
  {
    return minimumLayoutSize(container);
  }
  public void removeLayoutComponent(Component component)
  {
  }


  //*******************************************************************
  // We have to have a class to act as the applet content pane so     *
  // that we can paint our background. The class is made public to    *
  // avoid access errors in browsers.                                 *
  //*******************************************************************
  public  class   ContentPane
          extends com.sun.java.swing.JPanel
  {
    //*****************************************************************
    // Paint the applet background including borders around gauges.   *
    //*****************************************************************
    public void paintComponent(Graphics g)
    {
      super.paintComponent(g);

      // Paint border around gauges.
      g.setColor(new Color(102,102,102));
      for (int component = 0; component < fCompBounds.length; component++)
      {
        g.drawRect(
          fCompBounds[component].x,     fCompBounds[component].y,
          fCompBounds[component].width, fCompBounds[component].height);
      }

      // Paint slider background.
      g.setColor(fBackground);
      g.fillRect(
        fImageSliderBox.x,     fImageSliderBox.y,
        fImageSliderBox.width, fImageSliderBox.height);

      // Paint "tryit" image.
      g.drawImage(
        fTryit,
        fImageSliderBox.x + 1,
        fImageSliderBox.y + 2,
        null);

      // Paint border around slider.
      g.setColor(new Color(102, 102, 102));
      g.drawRect(
        fImageSliderBox.x,     fImageSliderBox.y,
        fImageSliderBox.width, fImageSliderBox.height);
    }
  }
}
