{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  ::                                                         ::
  ::   SMTP Relay Demo                                       ::
  ::                                                         ::
  ::   Copyright (C) 1999, Legitima Software                 ::
  ::   All Rights Reserved.                                  ::
  ::                                                         ::
  ::   Demonstration Program of TSmtpRelayServer Component   ::
  ::                                                         ::
  ::   This program is a real bulk e-mailer application      ::
  ::                                                         ::
  ::   Delphi 3 & 4                                          ::
  :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

unit Unit1;

interface

uses
{$ifdef VER120}
  ImgList,
{$endif}
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, USmtpRelayServer;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    ImageList1: TImageList;
    Label3: TLabel;
    Label6: TLabel;
    edConnections: TEdit;
    udConnections: TUpDown;
    udTimeOut: TUpDown;
    edTimeOut: TEdit;
    Panel3: TPanel;
    Panel2: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    edFrom: TEdit;
    edSubject: TEdit;
    ListView1: TListView;
    Memo1: TMemo;
    Splitter1: TSplitter;
    Label4: TLabel;
    edSenderMail: TEdit;
    SmtpRelayServer1: TSmtpRelayServer;
    procedure ClearFieldTip(Sender: TObject);
    procedure ShowFieldTip(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure SmtpRelayServer1Finished(Sender: TObject; ok: Boolean);
    procedure Button3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SmtpRelayServer1GetData(Sender: TObject;
      recipientIndex: Integer; var headerTo, subject: String;
      var body: TStrings);
    procedure SmtpRelayServer1EMailProcessed(Sender: TObject;
      RecipientIndex, Err: Integer);
    procedure Panel2Resize(Sender: TObject);
  private
    { Private declarations }
    TotalWaiting: Integer;
    TotalGood: Integer;
    TotalBad: Integer;
    StartedTick: Longint;
    procedure UpdateStatusBar;
		function Replace(Tag,Text,Dest: String): String;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses Unit2;

{$R *.DFM}

{ ========================================================================== }
{ Private procedures and funcions }
{ ========================================================================== }

procedure TMainForm.UpdateStatusBar;
const
	OneSecond = 1/24/60/60;
var
	T: TDateTime;
begin
	T := ((GetTickCount-StartedTick) div 1000) * OneSecond;
	StatusBar1.Panels[0].Text := Format('Elapsed: %s',[TimeToStr(T)]);
	StatusBar1.Panels[1].Text := Format('Total: %d',[ListView1.Items.Count]);
	StatusBar1.Panels[2].Text := Format('Waiting: %d',[TotalWaiting]);
	StatusBar1.Panels[3].Text := Format('Good: %d',[TotalGood]);
	StatusBar1.Panels[4].Text := Format('Bad: %d',[TotalBad]);
end;

function TMainForm.Replace(Tag,Text,Dest: String): String;
var
	P: Integer;
begin
	Result := Text;
	P := Pos(Tag,AnsiLowercase(Result));
	while P > 0 do
  	begin
    	Delete(Result,P,Length(Tag));
      Insert(Dest,Result,P);
			P := Pos(Tag,AnsiLowercase(Result));
    end;
end;

{ ========================================================================== }
{ Events }
{ ========================================================================== }

procedure TMainForm.ClearFieldTip(Sender: TObject);
begin
	(Sender as TCustomEdit).Clear;
  if sender is TEdit then
  	begin
		  (Sender as TEdit).Font.Color := clWindowText;
		  (Sender as TEdit).OnEnter := nil;
		end
  else
  	begin
		  (Sender as TMemo).Font.Color := clWindowText;
		  (Sender as TMemo).OnEnter := nil;
		end
end;

procedure TMainForm.ShowFieldTip(Sender: TObject);
begin
  if sender is TEdit then
  	begin
    	if (Sender as TEdit).Text <> '' then Exit;
		  (Sender as TEdit).Font.Color := clGrayText;
		  (Sender as TEdit).OnEnter := ClearFieldTip;
      (Sender as TEdit).Text := (Sender as TEdit).Hint;
		end
  else
  	begin
    	if (Sender as TMemo).Text <> '' then Exit;
		  (Sender as TMemo).Font.Color := clGrayText;
		  (Sender as TMemo).OnEnter := ClearFieldTip;
      (Sender as TMemo).Text := (Sender as TMemo).Hint;
		end
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
	Memo1.Hint := Memo1.Text;
	ShowFieldTip(edFrom);
	ShowFieldTip(edSubject);
	ShowFieldTip(edSenderMail);
	ShowFieldTip(Memo1);
end;

procedure TMainForm.Button2Click(Sender: TObject);
var
	I: Integer;
begin
	if ListView1.Items.Count = 0 then
  	raise Exception.Create('Please fill the recipient list');
  if Assigned(edFrom.OnEnter) then
    edFrom.text := '';
  if Assigned(edSenderMail.OnEnter) then begin
  	raise Exception.Create('Please fill the "Sender''s email" field');
  end;
  Screen.Cursor := crAppStart;
	StartedTick := GetTickCount;
	TotalWaiting := 0;
  TotalGood := 0;
  TotalBad := 0;
  UpdateStatusBar;
	Button1.Enabled := false;
	Button2.Enabled := false;
	Button3.Enabled := true;
  SmtpRelayServer1.Connections := udConnections.Position;
  SmtpRelayServer1.TimeOut := udTimeOut.Position;
  SmtpRelayServer1.From := edSenderMail.text;
  if edFrom.text = '' then begin
    SmtpRelayServer1.HeaderFrom := format('<%s>',[edSenderMail.text]);
  end else begin
    SmtpRelayServer1.HeaderFrom := format('"%s" <%s>',[edFrom.text,edSenderMail.text]);
  end;
  SmtpRelayServer1.Subject := edSubject.Text;
  SmtpRelayServer1.Recipients.Clear;
  for I := 0 to ListView1.Items.Count-1 do
  	SmtpRelayServer1.Recipients.Add(ListView1.Items[I].Caption);
  try
    SmtpRelayServer1.Send;
  except
    on e:exception do begin
      showMessage(e.message);
      SmtpRelayServer1Finished(self,true);
    end;
    //raise;
  end;
end;

procedure TMainForm.Button3Click(Sender: TObject);
begin
	SmtpRelayServer1.Abort;
end;

procedure TMainForm.Button1Click(Sender: TObject);
var
	I: Integer;
  P: Integer;
  Str: String;
begin
	with TFormRecipients.Create(Self) do
  	try
    	for I := 0 to ListView1.Items.Count-1 do
      	begin
        	Str := ListView1.Items[I].Caption;
        	if ListView1.Items[I].SubItems[0] <> '' then
          	Str := Str + ', '+ListView1.Items[I].SubItems[0];
	      	Memo1.Lines.Add(Str);
        end;
			if ShowModal = mrOK then
      	begin
        	ListView1.Items.BeginUpdate;
        	ListView1.Items.Clear;
					for I := 0 to Memo1.Lines.Count-1 do
          	with ListView1.Items.Add do
            	begin
                ImageIndex := -1;
	            	P := Pos(',',Memo1.Lines[I]);
  		            if P > 0 then
                  	begin
			              	Caption := Trim(Copy(Memo1.Lines[I],1,P-1));
                    	SubItems.Add(Trim(Copy(Memo1.Lines[I],P+1,255)));
                    	SubItems.Add('');
                    end
                  else
                  	begin
			              	Caption := Trim(Memo1.Lines[I]);
                    	SubItems.Add('');
                    	SubItems.Add('');
                    end;
              end;
        	ListView1.Items.EndUpdate;
        end;
  	finally
    	Free;
    end;
end;

{ ========================================================================== }
{ TSmtpRelayServer Events Start here }
{ ========================================================================== }


procedure TMainForm.SmtpRelayServer1Finished(Sender: TObject; ok: Boolean);
{ This event is used to release buttons and to update the status bar }
begin
	Button1.Enabled := true;
	Button2.Enabled := true;
	Button3.Enabled := false;
  Screen.Cursor := crDefault;
  UpdateStatusBar;
  MessageDlg('Finished', mtInformation,[mbOk], 0);
end;

procedure TMainForm.SmtpRelayServer1GetData(Sender: TObject;
  RecipientIndex: Integer; var HeaderTo, Subject: String;
  var Body: TStrings);
{ This event is used to customize the message body and to update
  the status bar }
begin

{ The Lines below demonstrate how the TSmtpRelayServer
  customizes the message body.
}

	Body.Text := Replace('<email>',Memo1.Text,ListView1.Items[recipientIndex].Caption);
	Body.Text := Replace('<name>',Body.Text,ListView1.Items[recipientIndex].SubItems[0]);

  if ListView1.Items[recipientIndex].SubItems[0] <> '' then begin
    HeaderTo := Format('"%s" <%s>',[ListView1.Items[recipientIndex].SubItems[0], ListView1.Items[RecipientIndex].caption]);
  end else begin
    HeaderTo := Format('<%s>',[ListView1.Items[recipientIndex].Caption]);
  end;
 	ListView1.Items[RecipientIndex].ImageIndex := 2;
 	ListView1.Items[RecipientIndex].SubItems[1] := 'Sending... (waiting acknoledgement)';
  ListView1.Items[RecipientIndex].MakeVisible(True);
	Inc(TotalWaiting);
	UpdateStatusBar;
end;

procedure TMainForm.SmtpRelayServer1EMailProcessed(Sender: TObject;
  RecipientIndex, Err: Integer);
{ This event is used to show the error code (if any) and
  to update the status bar }
begin
	if Err = 0 then
  	begin
    	ListView1.Items[RecipientIndex].ImageIndex := 0;
    	ListView1.Items[RecipientIndex].SubItems[1] := 'Delivered and available to the recipient!';
	  	Inc(TotalGood);
    end
  else
  	begin
    	ListView1.Items[RecipientIndex].ImageIndex := 1;
      case Err of
    		-9: ListView1.Items[RecipientIndex].SubItems[1] := 'Failed: DNS Server not responding';
    		-8: ListView1.Items[RecipientIndex].SubItems[1] := 'Failed: Aborted by user';
    		-7: ListView1.Items[RecipientIndex].SubItems[1] := 'Failed: Could not perform the DATA command';
    		-6: ListView1.Items[RecipientIndex].SubItems[1] := 'Failed: Could not perform the QUIT command';
    		-5: ListView1.Items[RecipientIndex].SubItems[1] := 'Failed: Could not perform the MAILFROM command';
    		-4: ListView1.Items[RecipientIndex].SubItems[1] := 'Failed: Could not perform the RCPT command';
    		-3: ListView1.Items[RecipientIndex].SubItems[1] := 'Failed: Could not perform the OPEN command';
    		-2: ListView1.Items[RecipientIndex].SubItems[1] := 'Failed: Time Out - Recipient''s SMTP Server didn''t respond';
    		-1: ListView1.Items[RecipientIndex].SubItems[1] := 'Failed: Invalid DNS';
      else
      if Err > 0 then
      	begin
	      	case Err of
	        	550: ListView1.Items[RecipientIndex].SubItems[1] := 'Failed: Mailbox unavailable';
	        	551: ListView1.Items[RecipientIndex].SubItems[1] := 'Failed: User not local';
	        	552: ListView1.Items[RecipientIndex].SubItems[1] := 'Failed: Exceeded storage allocation';
	        	554: ListView1.Items[RecipientIndex].SubItems[1] := 'Failed: Transaction failed';
	        else
		      	ListView1.Items[RecipientIndex].SubItems[1] := Format('Failed: Recipient''s  SMTP server returned error %d',[Err])
	        end;
        end
      else
      	ListView1.Items[RecipientIndex].SubItems[1] := Format('Failed: Error %d',[Err])
			end;

	  	Inc(TotalBad);
    end;
  ListView1.Items[RecipientIndex].MakeVisible(True);
  Dec(TotalWaiting);
	UpdateStatusBar;
end;

procedure TMainForm.Panel2Resize(Sender: TObject);
begin
  edSubject.Width := Panel2.Width - edSubject.Left;
  edSenderMail.Width := Panel2.Width - edSenderMail.Left;
  edFrom.Width := Panel2.Width - edFrom.Left;
end;


end.
