#include <sys/param.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <sys/stat.h>


/* 

	Dupecheck for glftpd by 187
	Remixed by Axl Corp
        Web : http://members.xoom.com/dupechecker/
	E-mail: dupechecker@xoommail.com 

*/


char *strupr( char *string ){
	char *s;

	if ( string ){
		for ( s = string; *s; ++s )
			*s = toupper( *s );
	}
	return string;
}                        

main (int argc, char **argv) {

	FILE *fp;
	char dupebuff[255];
	char *buf;
	int i;
	int counter = 0;
	int found = 0;
	int total = 0;
	
	if(argc == 1)
		show_help();
		
	
	for(i=1; i<argc; i++){
		strupr(argv[i]);
	}	
		
	if ((fp = fopen("dupechecker/log/dupelog.today", "r")) == NULL) {
		printf("couldn't open file\n");
		return;
        }

	printf("\n          Matches found in the online dupe database:\n");
	printf(".---------------------------------------------------------------.\n");
	printf("| DATE: | Name of zip/rar:  | # Of FILE | Size: |  Rls NAME:    |\n");
	printf("`-------+-------------------+-----------+-------+---------------'\n");

        while (!feof(fp)) 
        {

		if (fgets(dupebuff, 127, fp) == NULL && !feof(fp)) 
			break;

		if (feof(fp)) 
	       		break;

		buf = strdup(dupebuff);
		strupr(buf);

		counter = 0;

		for(i=1; i<argc; i++){
			if(strstr(buf,argv[i]) != NULL)
				counter++;
		}	

		free(buf);

		 if(counter == argc-1){
			print_text(dupebuff);
			found++;
			
		 }
		total++;
  

        }
	fclose(fp);
	if(found == 0)
		printf("\nNo matches found in dupelist!!\n\n");
	else if(found == 1)
		printf("\n%d dupe listed (%d total)\n\n",found,total);
	else
		printf("\n%d dupes listed (%d total)\n\n",found,total);
	return;
}


print_text (char *row) {
	
	char string[255];
	const char delimiters[8]= "";
	char *running;
	char *token;

	bzero(string, sizeof(string));	
	running = NULL;
	token = NULL;
	
	running = string;
	strcpy(string, row);
	token = strsep (&running, delimiters);    
	printf("  %s",token);
	token = strsep (&running, delimiters);    
	printf("   %s",token);

}

show_help() {
	printf("\n.--------------------------------------------------.\n");
	printf("| Dupechecker Remixed By Axl Corp's                |\n");
	printf("|                                                  |\n");
	printf("| Usage: site dupe arg1 arg2 arg3 ...              |\n");
	printf("`--------------------------------------------------'");
	printf("\n");
	exit(0);
	
}
