unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, AdCalc;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Edit1: TEdit;
    AdCalc1: TAdCalc;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AdCalc1GetBooleanVar(Sender: TObject; VarName: String;
      var Found, Value: Boolean);
    procedure AdCalc1GetExtendedVar(Sender: TObject; VarName: String;
      var Found: Boolean; var Value: Extended);
    procedure AdCalc1Error(Sender: TObject; ErrorCode, ErrorPosition: Word;
      ErrorStr: String);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
  n:Extended;
begin
  AdCalc1.Formula:=Edit1.Text;
  if AdCalc1.calculate(n) then begin
    Label1.Caption:='Result= '+FloatToStr(n);
    Edit1.SelectAll;
  end;
  ActiveControl:=Edit1;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ActiveControl:=Edit1;
end;

procedure TForm1.AdCalc1GetBooleanVar(Sender: TObject; VarName: String;
  var Found, Value: Boolean);
begin
  if VarName=AnsiLowerCase('MyBooleanVar') then begin
    Value:=true;
    Found:=true;
  end;
end;

procedure TForm1.AdCalc1GetExtendedVar(Sender: TObject; VarName: String;
  var Found: Boolean; var Value: Extended);
begin
  if VarName=AnsiLowerCase('MyExtendedVar') then begin
    Value:=100;
    Found:=true;
  end;
end;

procedure TForm1.AdCalc1Error(Sender: TObject; ErrorCode,
  ErrorPosition: Word; ErrorStr: String);
begin
  Label1.Caption:='Error '+IntToStr(ErrorCode)+
    ' - '+ErrorStr;
  Edit1.SelStart:=ErrorPosition;
  Edit1.SelLength:=0;
end;

end.
