unit Demo1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, SmoothText, ExtCtrls;

type
  TForm1 = class(TForm)
    SmoothLabel1: TSmoothLabel;
    SmoothLabel2: TSmoothLabel;
    Label1: TLabel;
    SmoothLabel3: TSmoothLabel;
    Label2: TLabel;
    SmoothLabel4: TSmoothLabel;
    Label3: TLabel;
    SmoothLabel5: TSmoothLabel;
    Label4: TLabel;
    SmoothLabel6: TSmoothLabel;
    Label5: TLabel;
    SmoothLabel7: TSmoothLabel;
    Label6: TLabel;
    SmoothLabel8: TSmoothLabel;
    Timer1: TTimer;
    procedure FormPaint(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

var
  FontNr : integer = 0;
  TimerCount : integer = 0;

function GetTrueTypeFontName : string;
var
  TextMetrics : TTextMetric;
begin
  repeat
    Result := Screen.Fonts[Random(Screen.Fonts.Count)];
    Form1.Canvas.Font.Name := Result;
    GetTextMetrics (Form1.Canvas.Handle, TextMetrics);
  until (TextMetrics.tmPitchAndFamily and TMPF_TrueType) = TMPF_TrueType;
end;

procedure FillLabels (SmoothLabel:TSmoothLabel; Lab:TLabel);
var
  FontName : string;
begin
  FontName := GetTrueTypeFontName;
  SmoothLabel.Font.Name := FontName;
  SmoothLabel.Caption := 'TSmoothLabel, ' + FontName;;
  Lab.Font.Name := FontName;
  Lab.Caption := 'TLabel, ' + FontName;
end;

procedure DemoSmoothTextOut;
begin
  with Form1, Canvas do
    begin
    Brush.Style := bsClear;
    with Font do
      begin
      Name := 'Arial';
      Size := 14;
      Color := clWhite;
      SmoothTextOut (Canvas, SmoothLabel7.Left, SmoothLabel7.Top + 60,
                    'SmoothTextOut, Arial, Size = 16', taLeftJustify);
      TextOut (Label6.Left, Label6.Top + 60, 'TextOut, Arial, Size = 16');
      Color := clRed;
      SmoothTextOut (Canvas, SmoothLabel7.Left + 5, SmoothLabel7.Top + 65,
                    'SmoothTextOut, Arial, Size = 16', taLeftJustify);
      TextOut (Label6.Left + 5, Label6.Top + 65, 'TextOut, Arial, Size = 16');
      Color := clYellow;
      SmoothTextOut (Canvas, SmoothLabel7.Left + 10, SmoothLabel7.Top + 70,
                    'SmoothTextOut, Arial, Size = 16', taLeftJustify);
      TextOut (Label6.Left + 10, Label6.Top + 70, 'TextOut, Arial, Size = 16');
      Color := clBlue;
      SmoothTextOut (Canvas, SmoothLabel7.Left + 15, SmoothLabel7.Top + 75,
                    'SmoothTextOut, Arial, Size = 16', taLeftJustify);
      TextOut (Label6.Left + 15, Label6.Top + 75, 'TextOut, Arial, Size = 16');
      Color := clLime;
      SmoothTextOut (Canvas, SmoothLabel7.Left + 20, SmoothLabel7.Top + 80,
                    'SmoothTextOut, Arial, Size = 16', taLeftJustify);
      TextOut (Label6.Left + 20, Label6.Top + 80, 'TextOut, Arial, Size = 16');
      end;
    end;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  DemoSmoothTextOut;
  Randomize;
  Timer1.Enabled := true;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  case TimerCount mod 3 of
    0 : FillLabels (SmoothLabel5, Label4);
    1 : FillLabels (SmoothLabel6, Label5);
    2 : FillLabels (SmoothLabel7, Label6);
    end;
  inc (TimerCount);
end;

end.
