{*************************************************************}
{               Simple Query pack version 1.3                 }
{    Copyright  1998,99 Sergey Korzh, Sergey Lelyushkin      }
{            http://www.korzh.com/simplequery.htm             }
{                   mailto:info@korzh.com                     }
{-------------------------------------------------------------}
{            property editors & register procedures           }
{                  last updated: May-12-1999                  }
{*************************************************************}


unit sqreg;

interface
uses SysUtils, Classes, DBTables, DsgnIntf, DDLabel, kdbstruc, kquerpnl;

procedure Register;

implementation

{$R *.DCR}

type

  TDatabaseNameProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValueList(List: TStrings); virtual;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

  TMainTableNameProperty = class(TDatabaseNameProperty)
  public
    procedure GetValueList(List: TStrings); override;
    //procedure GetValues(Proc: TGetStrProc); override;
  end;

  TKDBStructEditor = class(TComponentEditor)
  public
    function GetVerbCount : integer;override;
    function GetVerb(Index : integer) : string;override;
    procedure ExecuteVerb(Index : integer);override;
  end;

  TQResultProperty = class(TClassProperty)
  private
   function GetAttributes : TPropertyAttributes; override;
   procedure Edit ; override;
  end;

//------------------------------


function TDatabaseNameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList];
end;

procedure TDatabaseNameProperty.GetValueList(List: TStrings);
begin
  (GetComponent(0) as TKDBStructure).DBInfo.GetDatabaseNames(List);
end;

procedure TDatabaseNameProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

//-----------------------------

procedure TMainTableNameProperty.GetValueList(List: TStrings);
var
 i: Integer;
begin
  with (GetComponent(0) as TKQueryPanel) do
  if DbStruct <> nil then
    for i:=0 to DbStruct.TableCount -1 do
      List.Add(DbStruct.Tables[i].TableName);
end;


//-------------------

function TKDBStructEditor.GetVerbCount : integer;
begin
  Result := 1;
end;

function TKDBStructEditor.GetVerb(Index : integer) : string;
begin
  if Index = 0 then Result := 'Structure editor..';
end;

procedure TKDBStructEditor.ExecuteVerb(Index : integer);
begin
  if Index = 0 then
  begin
    (Component as TKDBStructure).EditStructure;
     Designer.Modified;
  end;
end;

// -------------------------

function TQResultProperty.GetAttributes : TPropertyAttributes;
begin
  Result := [paDialog];
end;

procedure TQResultProperty.Edit;
begin
 (GetComponent(0) as TKQueryPanel).EditQResult;
 Designer.Modified;
end;

// ------------------

procedure Register;
begin
 RegisterComponents('SimpleQuery', [TDropDownLabel]);
 RegisterComponents('SimpleQuery', [TKDBStructure]);
 RegisterComponents('SimpleQuery', [TKQueryPanel]);
 RegisterPropertyEditor(TQueryResult.ClassInfo, TKQueryPanel,'QResult', TQResultProperty);
 RegisterPropertyEditor(TypeInfo(String),TKDBStructure,'DatabaseName',TDatabaseNameProperty);
 RegisterPropertyEditor(TypeInfo(String),TKQueryPanel,'MainTableName',TMainTableNameProperty);
 RegisterComponentEditor(TKDBStructure, TKDBStructEditor);
end;



end.
