{*************************************************************}
{               Simple Query pack version 1.3                 }
{    Copyright  1998,99 Sergey Korzh, Sergey Lelyushkin      }
{            http://www.korzh.com/simplequery.htm             }
{                   mailto:info@korzh.com                     }
{-------------------------------------------------------------}
{                      TKDBInfo component                     }
{                  last updated: May-12-1999                  }
{*************************************************************}

unit kdbinfo;

interface
uses Classes, BDE, DB, DBTables,SysUtils;

{$I sq_defs.inc}

type
  TDBFieldInfo = class
    FieldName : string;
    FieldSize : integer;
    FieldType : TFieldType;
  end;

  TDBFieldList = class(TList)
  private
    function GetItem(Index : integer) : TDBFieldInfo;
  public
     destructor Destroy;override;
     procedure Clear;{$IFDEF D4_PLUS}override;{$ENDIF}
     function FindByName(const FieldName : string) : TDBFieldInfo;
     property Items[Index : integer] : TDBFieldInfo read GetItem; default;
  end;

  TKDBInfo = class(TComponent)
  private
    FTables : TStrings;
    FFields : TDBFieldList;
    FDatabaseName : string;
    FCurTableName : string;
    procedure SetDatabaseName(Value : string);
    function GetTableNames : TStrings;
    function GetFieldList(TableName : string) : TDBFieldList;
  protected
    procedure TablesByDatabase(TablesList : TStrings);virtual;
    procedure FieldsByTable(const TableName : string; FieldsList : TDBFieldList);virtual;
  public
    constructor Create(AOwner : TComponent);override;
    destructor Destroy;override;
    procedure GetDatabaseNames(AList : TStrings);virtual;
  public
    property DatabaseName : string read FDatabaseName write SetDatabaseName;
    property Tables : TStrings read GetTableNames;
    property Fields[TableName : string] : TDBFieldList read GetFieldList;
  end;


implementation

destructor TDBFieldList.Destroy;
begin
  Clear;
  inherited Destroy;
end;

function TDBFieldList.GetItem(Index : integer) : TDBFieldInfo;
begin
  Result := TDBFieldInfo(inherited Items[Index]);
end;

procedure TDBFieldList.Clear;
var
  i : integer;
begin
  for i := 0 to Count - 1 do Items[i].Free;
  inherited Clear;
end;

function TDBFieldList.FindByName(const FieldName : string) : TDBFieldInfo;
var
  i : integer;
begin
  for i := 0 to Count - 1 do
    if CompareText(Items[i].FieldName, FieldName) = 0 then
      begin Result := Items[i]; exit; end;
  Result := nil;
end;

constructor TKDBInfo.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  FTables := TStringList.Create;
  FFields := TDBFieldList.Create;
  FCurTableName := '';
end;

destructor TKDBInfo.Destroy;
begin
  FTables.Free;
  FFields.Free;
  inherited Destroy;
end;

procedure TKDBInfo.SetDatabaseName(Value : string);
begin
  if Value <> FDatabaseName then
  begin
    FDatabaseName := Value;
    FCurTableName := '';
  end;
end;

function TKDBInfo.GetTableNames : TStrings;
begin
  FTables.Clear;
  TablesByDatabase(FTables);
  Result := FTables;
end;

procedure TKDBInfo.GetDatabaseNames(AList : TStrings);
begin
  Session.GetDatabaseNames(AList);
end;

procedure TKDBInfo.TablesByDatabase(TablesList : TStrings);
begin
  Session.GetTableNames(DatabaseName, '*.*', false, false, TablesList);
end;

function TKDBInfo.GetFieldList(TableName : string) : TDBFieldList;
begin
  if TableName <> FCurTableName then
  begin
    FCurTableName := TableName;
    FFields.Clear;
    FieldsByTable(FCurTableName, FFields);
  end;
  Result := FFields;
end;

procedure TKDBInfo.FieldsByTable(const TableName : string; FieldsList : TDBFieldList);
var
  Table : TTable;
  i : integer;
  FI : TDBFieldInfo;
begin
  Table := TTable.Create(nil);
  try
    Table.DatabaseName := DatabaseName;
    Table.TableName := TableName;
    Table.FieldDefs.Update;
    FieldsList.Clear;
    for i := 0 to Table.FieldDefs.Count - 1 do
    begin
      FI := TDBFieldInfo.Create;
      FI.FieldName := Table.FieldDefs[i].Name;
      FI.FieldType := Table.FieldDefs[i].DataType;
      FI.FieldSize := Table.FieldDefs[i].Size;
      FieldsList.Add(FI);
    end;
  finally
    Table.Free;
  end;
end;


end.
