{*************************************************************}
{               Simple Query pack version 1.3                 }
{    Copyright  1998,99 Sergey Korzh, Sergey Lelyushkin      }
{            http://www.korzh.com/simplequery.htm             }
{                   mailto:info@korzh.com                     }
{-------------------------------------------------------------}
{                    TOEDBInfo component                      }
{                 for ODBC Express 5 support                  }
{                  last updated: May-12-1999                  }
{*************************************************************}


unit odbcxinf;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, KDbInfo, ODSI, OCL, OVCL;

type
  TOEDBInfo = class(TKDBInfo)
  private
    Hdbc: THdbc;
  protected
    procedure TablesByDatabase(TablesList : TStrings);override;
    procedure FieldsByTable(const TableName : string; FieldsList : TDBFieldList);override;
  public
    constructor Create(AOwner : TComponent);override;
    destructor Destroy;override;
    procedure GetDatabaseNames(AList : TStrings);override;
  end;

procedure Register;

implementation

constructor TOEDBInfo.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  Hdbc := THdbc.Create(Self);
end;

destructor TOEDBInfo.Destroy;
begin
  Hdbc.Free;
  inherited;
end;

procedure TOEDBInfo.GetDatabaseNames(AList : TStrings);
var
  OEAdministrator: TOEAdministrator;
begin
  OEAdministrator := TOEAdministrator.Create(nil);
  AList.Assign(OEAdministrator.DataSources);
  OEAdministrator.Free;
end;

procedure TOEDBInfo.TablesByDatabase(TablesList : TStrings);
var
  OECatalog: TOECatalog;
begin
  Hdbc.DataSource := DatabaseName;
  OECatalog := TOECatalog.Create(Self);
  try
    OECatalog.hDbc := Hdbc;
    TablesList.Assign(OECatalog.TableNames);
  finally
    OECatalog.Free;
  end;
end;

procedure TOEDBInfo.FieldsByTable(const TableName : string; FieldsList : TDBFieldList);
var
  FI : TDBFieldInfo;
  ATable: TOEDataset;
  i : integer;
begin
  Hdbc.DataSource := DatabaseName;
  ATable := TOEDataset.Create(nil);
  try
    ATable.hDbc := Hdbc;
    ATable.Table := TableName;

    ATable.Open;
    FieldsList.Clear;
    for i := 0 to ATable.FieldCount - 1 do
    begin
      FI := TDBFieldInfo.Create;
      FI.FieldName := ATable.FieldDefs[i].Name;
      FI.FieldType := ATable.FieldDefs[i].DataType;
      FI.FieldSize := ATable.FieldDefs[i].Size;
      FieldsList.Add(FI);
    end;
    ATable.Close;
  finally
    ATable.Free;
  end;
end;

procedure Register;
begin
  RegisterComponents('SimpleQuery', [TOEDBInfo]);
end;

end.
