AUTODIAL(1)               P32 Programmer's Manual                AUTODIAL(1)

NAME
        autodial - toggle demand dialing

        autodisc - interact with the auto-disconnect mechanism
        
SYNOPSIS
        autodial [on | off]
        
        autodisc [off | minutes]
        
DESCRIPTION
        When invoked with one argument, the autodial command will turn
        demand dialing on or off.
        
        The Status Bar AutoDial field is updated to reflect the current 
        state of demand dialing (also know as AutoDial).
        
        When AutoDial is on, dialing takes place the next time a packet 
        is forwarded to the PPP interface.
        
        Command autodisc with no arguments prints the current state of the
        auto-disconnect timers.
        
        To activate auto-disconnect, an autodisc shell command specifying 
        a monitoring interval in minutes must be issued. 
        You may place this command in your 'startup' file.
                
NOTES
        Autodial is configured using Menu item Configure.
        
        Auto-disconnect counts non-broadcast packets arriving at the PPP 
        interface. Windows packets are included in this count. If no such 
        packets arrive within the specified time, the connection will be 
        terminated.
        
        Auto-disconnect can be toggled via the relevant Menu Item. Holding
        down the left mouse button shows the time remaining. Release the 
        mouse button elsewhere if you do not actually want to toggle the
        feature.

        Many Windows Modem Drivers have an Auto-disconnect feature. NAT32's
        auto-disconnect is not required in this case. 

BUGS
        NAT32 detects the following packet types transferred via the native 
        Windows TCP/IP stack bound to the DUN adapter:
        
                        TCP Resets, UDP, ICMP, ARP
            
        This presents a problem if, during the current Auto-disconnect 
        interval, TCP data segments are the only packet types being 
        transferred. This is often the case if the only Windows networking 
        application running on the NAT32 machine is a lengthy file transfer.
        
        To prevent the Auto-disconnect timer from closing the DUN connection
        in this case, the user should concurrently run some other networking
        application which generates packets of the type included in the 
        above list. 
        
SEE ALSO
        dun(1), hangup(1), ppp(1)
