unit am2000shortcut;

interface

uses
  SysUtils, ComCtrls, StdCtrls, Controls, ExtCtrls, Classes, Forms,
  dsgnintf;

type
  // shortcut property
  T_AM2000_ShortCutProperty = class(TPropertyEditor)
  public
    function GetValue: string; override;
    function GetAttributes: TPropertyAttributes; override;
    function AllEqual: Boolean; override;
    procedure Edit; override;

  end;

  // shortcut editor
  T_AM2000_ShortCutEditor = class(TForm)
    ListView1: TListView;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    StatusBar1: TStatusBar;
    PrefC: TCheckBox;
    PrefSC: TCheckBox;
    PrefCA: TCheckBox;
    PrefSCA: TCheckBox;
    Button3: TButton;
    PrefS: TCheckBox;
    PrefFn: TCheckBox;
    procedure RebuildShortCuts(Sender: TObject);
    procedure Button2Click(Sender: TObject);

  private
    FShortCuts: String;
    procedure SetShortCuts(AShortCuts: String);
    function GetShortCuts: String;

  protected
    procedure Loaded; override;

  public
    function EditShortCuts(var AShortCuts: String): Boolean;

  end;

implementation

{$R *.DFM}

procedure T_AM2000_ShortCutEditor.Loaded;
begin
  RebuildShortCuts(nil);
end;

procedure T_AM2000_ShortCutEditor.SetShortCuts(AShortCuts: String);
var
  I, P, E: Integer;
  T: TListItem;
  S: String;
begin
  FShortCuts:= AShortCuts;

  // add visible shortcuts
  for I:= 0 to ListView1.Items.Count -1 do begin
    T:= ListView1.Items[I];
    P:= Pos(T.Caption, AShortCuts);
    E:= P + Length(T.Caption);
    if (P <> 0)
    and ((P = 1) or (AShortCuts[P -1] = ';'))
    and ((E > Length(AShortCuts)) or (AShortCuts[E] = ';'))
    then begin
      T.Checked:= True;
      Delete(AShortCuts, P, E -P);
    end
    else
      if T.Checked
      then T.Checked:= False;
  end;

  // add other shortcuts
  while AShortCuts <> '' do begin
    P:= Pos(';', AShortCuts);
    if P = 0 then P:= Length(AShortCuts) +1;
    S:= Copy(AShortCuts, 1, P -1);
    Delete(AShortCuts, 1, P);

    if S <> '' then
      with ListView1.Items.Add do begin
        Caption:= S;
        Checked:= True;
      end;
  end;
end;

function T_AM2000_ShortCutEditor.GetShortCuts: String;
var
  I: Integer;
  T: TListItem;
begin
  Result:= '';

  for I:= 0 to ListView1.Items.Count -1 do begin
    T:= ListView1.Items[I];
    if T.Checked then begin
      if Result <> '' then AppendStr(Result, ';');
      AppendStr(Result, T.Caption);
    end;
  end;
end;

procedure T_AM2000_ShortCutEditor.RebuildShortCuts(Sender: TObject);
const
  nMaxPref = 6;
  Prefixes : array [0..nMaxPref -1] of String =
    ('', 'Ctrl+', 'Shift+', 'Ctrl+Alt+', 'Shift+Ctrl+', 'Shift+Ctrl+Alt+');
var
  I, J: Integer;
  C: Char;
  PrefCheck : array [0..nMaxPref -1] of TCheckBox;

  procedure AddCustomShortCut(SC: String);
  var
    I: Integer;
  begin
    ListView1.Items.Add.Caption:= SC;
    ListView1.Items.Add.Caption:= 'Shift+' + SC;
    for I:= 1 to nMaxPref -1 do
      if PrefCheck[I].Checked then
        ListView1.Items.Add.Caption:= Prefixes[I] + SC;
  end;

begin
  PrefCheck[0]:= nil;
  PrefCheck[1]:= PrefC;
  PrefCheck[2]:= PrefS;
  PrefCheck[3]:= PrefCA;
  PrefCheck[4]:= PrefSC;
  PrefCheck[5]:= PrefSCA;

  with ListView1.Items do begin
    BeginUpdate;
    Clear;

    for I:= 1 to nMaxPref -1 do
      if PrefCheck[I].Checked
      and (I <> 2)
      then
        for C:= 'A' to 'Z' do
          Add.Caption:= Prefixes[I] + C;

    if PrefFn.Checked then
      for I:= 0 to nMaxPref -1 do
        if (PrefCheck[I] = nil)
        or PrefCheck[I].Checked
        then
          for J:= 1 to 12 do
            Add.Caption:= Prefixes[I] + 'F' + IntToStr(J);

    // custom shortcuts
    AddCustomShortCut('Ins');
    AddCustomShortCut('Del');
    AddCustomShortCut('BkSp');

    EndUpdate;
  end;

  SetShortCuts(FShortCuts);
end;

procedure T_AM2000_ShortCutEditor.Button2Click(Sender: TObject);
begin
  SetShortCuts('');
end;

function T_AM2000_ShortCutEditor.EditShortCuts(
  var AShortCuts: String): Boolean;
begin
  SetShortCuts(AShortCuts);
  Result:= ShowModal = mrOk;
  if Result then AShortCuts:= GetShortCuts;
end;


{ T_AM2000_ShortCutProperty }

procedure T_AM2000_ShortCutProperty.Edit;
var
  ShortCutEditor: T_AM2000_ShortCutEditor;
  S: String;
begin
  ShortCutEditor:= T_AM2000_ShortCutEditor.Create(Application);

  S:= GetStrValue;
  if ShortCutEditor.EditShortCuts(S) then begin
    SetStrValue(S);
    Modified;
  end;

  ShortCutEditor.Free;
end;

function T_AM2000_ShortCutProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog];
end;

function T_AM2000_ShortCutProperty.GetValue: string;
begin
  Result:= GetStrValue;
  if Result = '' then Result:= '(None)';
end;

function T_AM2000_ShortCutProperty.AllEqual: Boolean;
var
  I: Integer;
  S: String;
begin
  Result:= False;
  if PropCount > 1 then
  begin
    S:= GetStrValue;
    for I:= 1 to PropCount - 1 do
      if GetStrValueAt(I) <> S then Exit;
  end;
  Result:= True;
end;

end.

