unit DebugPro;

interface

Uses DebuggerX_TLB, Windows, SysUtils;

const

{ MessageTypes }

  mtGeneral = 0;
  mtInfo = 1;
  mtWarning = 2;
  mtError = 3;

{ MessageGroups }

  mgRed = 0;
  mgBlue = 1;
  mgGreen = 2;
  mgLime = 3;
  mgYellow = 4;


Var
   ComputerName : Array[0..255] Of Char;
   ArraySize : Integer;

Procedure AddDebug(Obj : TObject; MessageStr : String; MessageType :Integer;
   MessageGroup, MessageID, UnitFileName, RemoteName : String);

implementation

Uses ActiveX;


{$IFDEF DEBUGPRO_ON}
Procedure AddDebug(Obj : TObject; MessageStr : String; MessageType :Integer;
   MessageGroup, MessageID, UnitFileName, RemoteName : String);
Var
   DebuggerProUnknown : IUnknown;
   DebuggerPro : IDebuggerPro;
Begin
   Arraysize := SizeOf(ComputerName);
   GetComputerName(ComputerName, Arraysize);

   If RemoteName = '' Then
   Begin
      Try
         GetActiveObject(Class_DebuggerPro, Nil, DebuggerProUnknown);
         If Assigned(DebuggerProUnknown) Then
         Begin
            DebuggerProUnknown.QueryInterface(IDebuggerPro, DebuggerPro);
            If Assigned(DebuggerPro) Then
            Begin
               If Assigned(Obj) Then
               Begin
                  DebuggerPro.AddTrace(Obj.ClassName, MessageStr, MessageType, MessageGroup,
                     ComputerName, MessageID, UnitFileName, Now);
               End
               Else
               Begin
                  DebuggerPro.AddTrace('', MessageStr, MessageType, MessageGroup,
                     ComputerName, MessageID, UnitFileName, Now);
               End;
            End;
         End
         Else
         Begin
            DebuggerPro := CoDebuggerPro.Create;
            If Assigned(DebuggerPro) Then
            Begin
               If Assigned(Obj) Then
               Begin
                  DebuggerPro.AddTrace(Obj.ClassName, MessageStr, MessageType, MessageGroup,
                     ComputerName, MessageID, UnitFileName, Now);
               End
               Else
               Begin
                  DebuggerPro.AddTrace('', MessageStr, MessageType, MessageGroup,
                     ComputerName, MessageID, UnitFileName, Now);
               End;
            End;
         End;
      Except
         //
      End;
   End
   Else
   Begin
      Try
         DebuggerPro := CoDebuggerPro.CreateRemote(RemoteName);
         If Assigned(DebuggerPro) Then
         Begin
            If Assigned(Obj) Then
            Begin
               DebuggerPro.AddTrace(Obj.ClassName, MessageStr, MessageType, MessageGroup,
                  ComputerName, MessageID, UnitFileName, Now);
            End
            Else
            Begin
               DebuggerPro.AddTrace('', MessageStr, MessageType, MessageGroup,
                  ComputerName, MessageID, UnitFileName, Now);
            End;
         End;
      Except
         //
      End;
   End;
End;
{$ELSE}
Procedure AddDebug(Obj : TObject; MessageStr : String; MessageType :Integer;
   MessageGroup, MessageID, UnitFileName, RemoteName : String);
Begin
   // Do Nothing
End;
{$ENDIF}

end.
