unit ElastFrm;

(*Comment out the next line if this is not an evaluation copy*)
{{$DEFINE EVALUATION}

{$IFDEF WIN32}

  {$DEBUGINFO OFF}
  {$LOCALSYMBOLS OFF}
  {$IFNDEF VER90}
    {$ASSERTIONS OFF}
  {$ENDIF}
  {$OPTIMIZATION ON}

  {$ALIGN ON}
  {$BOOLEVAL OFF}
  {$OVERFLOWCHECKS OFF}
  {$STACKFRAMES OFF}
  {$STACKCHECKS OFF}
  {$IOCHECKS ON}
  {$RANGECHECKS OFF }
  {$SAFEDIVIDE OFF}

  {$REFERENCEINFO OFF}

{$ELSE}
  {$A+}
  {$B-}
  {$D-}
  {$L-}

  {$Q-}
  {$W-}
  {$I+}
  {$R-}
  {$U-}
  {$O+}
  {$Y-}

{$ENDIF}


(******************************************************************************
    TElasticForm Component.
    Version 4 Revision 1  April 26, 1999

    Copyright : Q-Systems Engineering. 8950 N. Calle Buena Vista. Tucson AZ

******************************************************************************)

(******************************************************************************)

(*
    ******************************************************************************
    ******************************************************************************
    COPYRIGHT NOTICE:
    THE SOURCE OF THIS COMPONENT IS PROVIDED AS A PERSONAL COPY.  Q-SYSTEMS ENGINEERING
    CLAIMS NO ROYALTIES FOR THE USE OF TElasticForm IN YOUR PROGRAMS.  HOWEVER, YOU MAY
    NOT DISTRIBUTE THE SOURCE -IN PART OR WHOLE-, THE .DCU, OR THE .OBJ OF THIS FILE.

    ******************************************************************************
    ******************************************************************************
*)

(*

    Future arrangements:
      Add boolean properties:
        GridColumnWidthResize
        GridRowHeightResize
        GridFontResize

    KNOWN PROBLEMS:
      Toolbars do not work very well in C++Builder 3
      The problem is reduced if the form that owns a toolbar has the
      MaintainProportions = true


    Functions of this component:
    1) resizes all visual  components in your form as you resize your form.
    2) keeps  the initial size of your form constant as you change screen  resolution or font size.
    3) will set min and max size of form.

    Changes in version 1.2

    All sizing and position properties could only take positive values
    in version 1.1 which were measured in pixels.
    These components can now be negative, (from -1 to -100) where the absolute
    value of the number now means percentage of the current screen resolution.

    New public procedure UpdateSize(aControl:TControl).  If during run time any contol's
    size is changed then this procedure must be called for the new size of the control
    to be recorded and be considered in any resizing.

    Changes in version 1.3
    Ability to exclude any component(s) from resizing

    Changes in version 1.4
    Examines the position property of the form and makes proper position decisions when
    the form first appears on the screen

    Changes in version 1.41
    Correction in line :
      fFrames^[i].initialize(fScreenCorrectionH,fScreenCorrectionV,fPixelsCorrection,
      -----> this has been changed to just 1.0: ---> 1.0*fDesignPixelsperInch/fPixelsPerInch,
                                 TControl(fList.items[i]));
    Changes in version 1.42
    When the component is dropped on a form, the SCALED property of the form is set to FALSE
    If this is not done then only the primary form of a project will be resized properly
    between different font sizes (small fonts, large fonts).

    Changes in version 1.5
    Added timed recording of design form geometry.  This allows design at high resolution that can be
    transferred to user's low resolution.
    Also TDBLookupComboBox in Delphi 3 or TDBLookupCombo in Delphi 1 does not show well
    on the screen when you set visible := true.  Thus, if our application has this component, its
    resizing happens without hiding and reshowing the components

    Changes in Version 2.0
    All components and the form are origininally resized BEFORE the appear on the screen.
    This makes the loading in a different resolution than the compile resolution much faster
    and much more pleasant.  The special treatement of TDBLookupCombo has also become unnecessary.
    The components are now always hidden before resizing which make resizing faster.
    The resizing of TDBText and TLabel when they are autosized is also more accurate.
    Finally, font is resized before the components are resized.  This makes for a more
    accurate resizing of Data Controls that tend to self-resize when their font is resized.

    Changes in Version 2.02
    Find all controls excludes all nameless components.  That is the resizing of all
    multicomponent components is left to the main control.
    Removed all restrictions regarding type of BorderStyle.  Exception is the one
    of bsNone because this is a special case where width equals client width and
    height equals clientheight

    Changes in Version 2.05
    InitializeForm has been changed by removing the Setbounds(L0, T0, cW0, cH0) for the form.
    Eventhough this was working fine in general, it seemed to have problems with TFileListBox.
    Changes were made also in NewWndMethod to take care of the change above.

    Changes in Version 2.06
    The size of each component if first recorded by calling TFrame.PreInitialize(TControl).
    This secures correct appearance when two components have the same align property.  For
    example alTop.  Up until now, the hiding and reshowing of components would make them reverse
    order.

    Changes in Version 2.1
    Added public (not published) properties : ManualPosition, ManualLeft,ManualTop.
    if ManualPosition is true then the design left and top position of the form are overriden.
    The idea behind this is that the user program may have saved the position of the form
    in an INI file.  Then next time the program should start at the last position rather
    than the design position.
    In this case, the OnCreate event of the form, should first read the saved left and top
    position of the form and then impose them to the Elasticform.
    A problem may arise if the user saved the data under one resolution and then reloads the
    program under a new resolution.  IN this case, while ElasticForm will redraw the form to
    maintain the same screen proportions this will not be the case with left and top if they
    are saved as pixel coordinates.
    To bypass this problem, ManualLeft and ManualTop are saved and read as percentages of the
    screen size at the time of save and read.
    Here is a typical example that sets the form at: 5% of the width and 10% of the height
    of the screen:

    procedure TForm1.FormCreate(Sender: TObject);
      begin
        with ElasticForm1 do
          begin
            ManualPosition := true;
            ManualLeft := 0.05;
            ManualTop  := 0.10;
          end;
      end;

    Changes in Version 2.2
      May 17
      added option to maintainformproportions during resizing
      June 26
      Moved call for the default window procedure for every message in the
      beginning of the NewWndMethod procedure.  This way, we secure that minimizing
      is possible.
      June 27
      Boolean bOntheScreen is now controlled by WM_WINDOWPOSCHANGING for all Delphi processes.

    Changes in Version 2.25 - Only Bug fixes
      - ElasticFont := false was not working.  Now it has been fixed.
      - Changes in NewWndMethod to allow deleting a secondary form with Elasticform.
      Closing was always working.  However, if closing of a secondary window was
      done with action := caFree then a GPF error was generated.  Now it has been fixed.
      Unfortunately the problem still exists with Delphi 1.0.
      - Changes in NewWndMethod to make things work for MDI child windows (MDI parent does
        not work if it contains no components.
      - Changes in NewWndMethod to make MDI parent work even when empty.

    Changes in Version 2.26 - Only Bug Fixes
      in procedure TFrame.Resize
      Added restrictions in the if aControl is Tlabel part.
      apparently when the label was alTop or alBottom or ... the resizing could enter an
      infinite loop.

    Changes in Version 2.27 - Only Bug Fixes
      This was a rather important bug in TFrame.Resize regarding TCustomGrid components.
      If vertical elasticity was enabled (the most usual case) then a large enough number
      of resizings could cause a floating point error as the TFrame.DefaultRowHeight and the
      TCustomGrid.DefautlRowHeight were mixed - up.
      Also in NewWndMethod: Earlier corrections on the size of MDI child forms do not appear
      to be needed any more.

    Changes in Version 2.3
       In NewWndMethod
         under case wm_ShowWindow: added following two lines to STOP THE FORM FROM SHOWING
         THE WRONG SIZE BEFORE IT RESIZES with different resolution that the design one:

        if bFirstFormResize then
          TForm(Owner).Setbounds(L0, T0, CW0, CH0);

       Added property FONT :
         The component uppon loading will use the Form's font rather than using the default
         Arial as was doing up until now.  If font is not True Type, a warning is displayed
         to point out that this is not desirable.

    Changes in Version 2.4 (released only internally)
      In NewWndMethod
        Under case ms_ShowWindow removed lines
                   Msg.Result := 0;
                   Exit;
        This allowed the movement of line
          Msg.Result := CallWindowProc (OldWndProc,
                 FormHandle, Msg.Msg, Msg.WParam, Msg.LParam);
        at the end of the method.  This fixes problem reported above in version 2.25
        under unfortunately....
      In TFrame.Initialize:
        TLabel AutoSize property is set to be always true.  Wordwrap benefits from that.

    Changes in Version 2.5

      In TFrame.Initialize and TFrame.Resize added in multiple spots for TCustomGrid controls the check:
        if GetPropInfo(aControl.ClassInfo,'defaultcolwidth') <> nil)
        to see if defaultcolwidth is published.  If it is not, it is assumed that the
        grid type component has its own column width resizing mechnanism and we do nothing about it
        Up until now, each grids needed almost a "case by case" approach to them.  If they had
        internal resizing mechanism, such as TCalendar, they needed t be excluded (explicitly)
        from column width and row height resizing.  Otherwise the overall resizing was
        getting screwed up.


        Introduced InitTitleFontSize in TFrame to store TitleFont if it exists and parentfont is false
        Up until now, DBGrids with ParentFont = false would not resize their Title Font.

        In Frame.resize, changed the check for vertical size of a TCustomGrid control.
      ***********************************************************
      Maintenance Release 2:
      Added public (not published properties:
      ManualSize, ManualWidth, ManualHeight.  Their purpose is to make them work in a similar
      way to ManualLeft and ManualTop of version 2.1.
      ManualWidth and Manual Height are also saved and read as percentages of screen:
      procedure TForm1.FormCreate(Sender: TObject);
        begin
          with ElasticForm1 do
            begin
              ManualPosition := true;
              ManualLeft := 0.05;
              ManualTop  := 0.10;
              {*****************************************}
              ManualSize := true;
              ManualWidth := 0.5;
              ManualHeight := 0.5;
            end;
        end;
      ***********************************************************
    Changes in Version 2.6
    Added capability of tiling an image in the background of the form

   Changes in Version 2.6 revision 1 : Changed the approach of reading and resizing
             TitleFont.  This was done because some of the third party Database grids
             do not originate form TCustomDBGrid, which makes their typecast as
             TCustomDBGrid to generate a run time access error

   Changes in Version 2.6 revision 2:
       + Removed the need for explicit reference to
         DBGrid and DBText. Also some CustomGrids handling has been refined.
       + Cleaned up code from unneeded variables.
       + Added changes related to TToolBar:
           When TToolBar is resized, we also resize its buttonwidht and buttonheight properties
       + Added procedures DisableResize, EnableResize, and ReInitializeResize
       + changed resizing of DBGrid so that ElasticForm takes over its column resizing.
       + Added the ability to make a form that was designed as wsNormal to
         open maximized if so desired.  However it flickers.
       + Added ability to change font size and color of the owner form and
         controls with ParentFont= true that could not be done up until now.
         HOW:  To change the form's font color:  Change the font color of the
               ElasticForm NOT directly the form.
               To change the form's font size: Change the font size of the
               ElasticForm followed by UpdateSize(form1), where form1 stands
               as the name of the form.

   Changes in Version 2.6 revision 3:
      + Fixed a bug that was created in revision 2 where control of DBGrid could be
        off depending on hardware
      + added property DBGridSelfResize to give user the option of allowing DBGrid to
        resize its own columns (=true) or make ElasticForm to resize the DBGrid cells.
      + In the case of ElasticForm resizing the DBGrid cells more precise resizing was
        enforced.

   *****************************************************************************
   *****************************************************************************

   Changes in Version 3
      + Added Property ElFrmIniFile:
        ElFrmIniFile stores information about the last size of the form and the
        visible state of each control.
        This way ini files are not needed.
      + Added method DynamicCreationUpdate which is needed to add ElasticForm
        dynamically to an existing form.  Example:
          ElasticForm1 := TElasticForm.create(form1);
          with ElasticForm1 do
            begin
              DynamicCreationUpdate;
              resizeForm;
            end;
      + Added method AddControl to add resizeable controls dynamically. Example:

           NewButton := TButton.Create(form1);
           NewButton.parent := form1;
           NewButton.name := 'New Button';
           NewButton.left := 50;
           NewButton.top := 100;
           NewButton.height := 70;
           NewButton.width := 180;
           ElasticForm1.AddControl(NewButton);

      + Corrected the Destroy Destructor of the component to remove a memory leak
        Thank you JZitt!
      + Corrected method ReInitializeResizing.  There was an error on the
        form's font size.
      + Made several corrections - rearrangements of resizing code to speed up
        resizing.
      + Now all versions except cbuilder1 install using elfrmreg.pas.
        Cbuilder1 installs using elastfrm.pas.

   Changes in Version 3 Revision 1

     + Excluded Ttabsheets (of TPageControl) from being included in the detectable
       controls for resizing.  This was necessary because elasticForm's handling of
       hiding and reshowing controls during resizing was changing what needed to be
       shown.
   Changes in Version 3 Revision 2

     + Added TFrame property HeadRowHeight to ensure proper resizing of DBGrids
       when the head row differs in FONT and therefore in size.  Added some additional
       row size controls for DBGrids.
     + Corrected bug with UpdateResize of StringGrids

   Changes in Version 3 Revision 3
     + Made changes in FindAllControls and TFrame.Initialize, and TFrame.Resize regarding
       Win31 control TTabbedNotebook.
     + Made changes to fix problem with excluding components from resizing.
     + Fixed ability to setfocus before showing the form.
   Changes in Version 3 Revision 4
     + Added public boolean variable AllowNoBorderResize : If set true (must be
       at run time and AFTER the form is shown, it allows for programming resizing
       a BorderStyly bsNone form.
     + Made corrections in NewWndMethod to fix MDI problems - Marked with 3.04
     + Made correction to ShowAllControls method to remove flicker in some cases.
     + If form's border style is not bsSizeable or bsSizeToolWin  AutoScroll is not
       allowed to be true -ver 3.042-
     + Fixed bug that would change the design height of rows in StringGrids -ver 3.042-
     + Added additional code to make resizing of StringGrids smoother -ver 3.042-
    Changes in Version 3 Final Revision 4
      + Eliminated bWasVisible.  Made it part of TFrame - Thank you Ed Eickman.
      + Fonts are assigned implicitly using the assign method - Thank you Ed Eickman.
      + Corrected method DynamicCreationUpdate.
      + Added boolean bDynamicCreation which prevents hiding components if Elasticform
        is added dynamically.
      + Excluded DBText from forced Autosize.
    Changes in Version 3 Revision 5
      + Fixed error in wm_ExitSizeMove related to bMaintainProportions case
      + Labels are not automatically AutoSized any more.
      + Added property Version.


    Changes in Version 4
      + Changed Version property to an integer. Version 3.05 would now be 305
        while version 4 is 400.
      + Added properties
        GridColumnWidthResize
        GridRowHeightResize
        GridFontResize
      + Corrected resizing of ToolBar.
      + Corrected resizing of DBGrids by recording design column heights
        recorded in the application's resource.
      + Record and resize the font and title font of each DBGrid column
        separately.

    Changes in Version 4 Revision 1

      + Added property FontWarning.  If you choose to keep a non- TT font in your form
        and set FontWarning to false you will not continue to get the font warning
        every time you open the project.
      + Added property LookForExtraFonts. Revision 1 has the capability to search
        deeper into components in a form and find fonts that it could not detect before.
        This way better resizing is possible.
      + Added method IncludeToResizing which allows the programmer to add component properties
        to resizing that where not included before.  For example, you can add the bevelWidth to
        the properties to be resized.  Also there are some unconventional sizes that ElasticForm
        is not aware that need to be resized.  You can add them with IncludeResizing.
        Finally, if a Font is not detected by ElasticForm, you can add its size to the
        resizeable quantities using IncludeResizing.

    Changes in Version 4 Revision 2

      + Added property ResolutionIndependence
      + Improved speed of resizing
      + Reduced (or Removed) flicker

    Changes in Version 4 Revision 3
      + Fixed problem with hiding controls that was created by the
        changes in ShowAllControls method.  


*)

interface


uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,ExtCtrls,stdctrls,{$IFDEF WIN32 THEN} comctrls,{$ENDIF}
  Grids,FileCtrl,TypInfo;


{$ifdef VER80}
  {$define DELPHI}
{$else}
  {$ifdef VER90}
    {$define DELPHI}
  {$else}
    {$ifdef VER100}
      {$define DELPHI}
    {$else}
      {$ifdef VER120}
        {$define DELPHI}
      {$else}
        {$ifdef VER93}
          {$define CPPBUILDER}
        {$else}
          {$ifdef VER110}
            {$define CPPBUILDER}
          {$else}
            {$ifdef VER125}
              {$define CPPBUILDER}
            {$endif}
          {$endif}
        {$endif}
      {$endif}
    {$endif}
  {$endif}
{$endif}

{$ifdef VER110} {CBUILDER 3}
{$ObjExportAll On}
{$ENDIF}
{$ifdef VER125} {CBUILDER 4}
{$ObjExportAll On}
{$ENDIF}




const
  gVersion = 403;
{$IFNDEF WIN32}
  SM_CXMAXIMIZED   = 61;
  SM_CYMAXIMIZED   = 62;
  WM_DISPLAYCHANGE = 126;
  WM_SIZING        = 532;
  WM_ENTERSIZEMOVE = 561;
  WM_EXITSIZEMOVE  = 562;

{$ENDIF}


type
  TArrayInteger = array[0..$FFFF div SizeOf(Integer)-1] of integer;
  pTArrayInteger = ^TArrayInteger;
  TArrayBoolean = array[0..$FFFF div SizeOf(boolean)-1] of boolean;
  pTArrayBoolean = ^TArrayBoolean;

  TResizeOrientation = (roHorizontal,roVertical,roAverage); (*4.01*)
  TPartialControl = class  (*4.01*)
    aControl : TControl;
    addedProperties : TStringList;
    ResizeOrientation : TResizeOrientation;
    InitSize : integer;

    constructor create;
    destructor destroy; override;
  end;

  TPartialControlArray = array[0..($FFFF-4) div SizeOf(TPartialControl)] of TPartialControl; (*4.01*)
  pTPartialControlArray = ^TPartialControlArray;


  TFrame = class

    owner                         : TComponent;
    left                          : integer;
    width                         : integer;
    top                           : integer;
    height                        : integer;
    font                          : TFont;
    fXResize,fYResize,fFResize    : double; (*global variables that hold the resized ratios for UpdateSize*)
    bStatusBar                    : boolean;
    HeadRowHeight                 : integer;
    ColumnWidths                  : pTArrayInteger;
    bColumnWidthRecorded          : pTArrayBoolean;
    ColumnWidthsMax               : integer;
    ColumnFontSize                : pTArrayInteger;
    ColumnTitleFontSize           : pTArrayInteger;
    bDBGridDefined                : boolean;
    bColumnWidthsFixed            : boolean;
    PanelWidths                   : pTArrayInteger;
    PanelWidthsMax                : integer;
    InitFontSize                  : integer;
    InitTitleFontSize             : integer;
    DesignFontSize                : integer;
    DesignTitleFontSize           : integer;
    InitTabFontSize               : integer;
    FontRatio                     : double;
    FontSizeBeforeMax             : integer;
    DefaultRowHeight              : integer;
    ButtonHeight                  : integer;
    ButtonWidth                   : integer;
    BtnAspect                     : single;
    WasVisible                    : boolean;
    Fonts                         : TList;
    InitFontsSize                 : pTArrayInteger;
    Resizeable                    : Boolean;


    constructor create;
    destructor  destroy; override;
    {$ifdef WIN32}
    procedure ReadDBGridResource(aControl:TControl);
    procedure EnumerateGridColumns(Grid: TControl;bStore:boolean);
    procedure GridEnumerationToStore(Grid: TControl;Column: TCollectionItem;ColIndex:integer);
    procedure GridEnumerationToResize(Column: TCollectionItem;ColIndex:integer);
    {$endif}
    procedure preInitialize(aControl:TControl);
    procedure DBGridInitialize(aControl:TControl;ScreenCorrectionH,ScreenCorrectionV:double);
    procedure initialize(ScreenCorrectionH,ScreenCorrectionV, PixelsCorrection,PurePixelsCorrection : double;
                         aControl:TControl);
    procedure resize( ElasticH,ElasticV,ElasticF : boolean;
                          FormClientWidth,FormClientHeight,cW,cH,cF:integer;FontCorrection:double;
                          ScreenCorrectionH,ScreenCorrectionV, PixelsCorrection : double;
                          aControl:TControl);
    procedure GetFontsOfControl(aControl:TControl);
  end;

  TFrameArray = array[0..($FFFF-4) div SizeOf(TFrame)] of TFrame;
  pTFrameArray = ^TFrameArray;


  (*The following three classes are identical to their parents.  However, all the
  private properties of their parents become available to procedures in this unit*)

  TMyControl = class(TControl);       (*publish ParentFont*)

  TMyWinControl = class(TWinControl); (*publish property Controlcount*)

  TMyCustomGrid = class(TCustomGrid); (*publish properties ColCount, ColWidths*)


  TElasticForm = class(TComponent)

  private
     (* window procedures *)
     OldWndProc, NewWndProc: Pointer;
     OldMDIClientWndProc, NewMDIClientWndProc : Pointer;
     FHorz, FVert: boolean;
     FElasticFont      : boolean;
     fResizeCounter : Integer;
     cW,cH,cF : integer; (*sizes at creation*)
     cWc,cHc     : integer; (*current sizes*)
     cW0,cH0,cF0 : integer; (*initial sizes at creation after correction*)
     L0,T0       : integer; (*initial left and top at creation after correction *)
     bFirstTime : boolean;
     fFrames    : pTFrameArray;

     fDesignScreenWidth        : integer;
     fDesignScreenHeight       : integer;
     fDesignPixelsPerInch      : integer;
     fDesignTimer              : TTimer;
     fDesignFormWidth          : integer;
     fDesignFormHeight         : integer;
     fDesignFormClientWidth    : integer;
     fDesignFormClientHeight   : integer;
     fDesignFormLeft           : integer;
     fDesignFormTop            : integer;

     fManualPosition           : boolean;
     fManualLeft               : double;
     fManualTop                : double;
     fManualSize               : boolean;
     fManualWidth              : double;
     fManualHeight             : double;


     fScreenWidth              : integer;
     fScreenHeight             : integer;
     fPixelsPerInch            : integer;

     fScreenCorrectionH        : Double;
     fScreenCorrectionV        : Double;
     fPixelsCorrection         : Double;
     FontCorrection            : Double;

     fList                     : TList;
     fParentList               : TList;
     FTotalControls            : integer;
     FInitTotalControls        : integer;

     fBkGrndImage              : TImage;
     FPictureAssigned          : boolean;

     (*Variables for limiting the size of the form*)
     fMaximizedWidth           : Integer;
     fMaximizedHeight          : Integer;
     fMaximizedPosX            : Integer;
     fMaximizedPosY            : Integer;
     fMinimumTrackWidth        : Integer;
     fMinimumTrackHeight       : Integer;
     fMaximumTrackWidth        : Integer;
     fMaximumTrackHeight       : Integer;
     fOwnerFormPosition        : TPosition; (*Holds the position of the form, such as poDesigned, poScreenCenter *)

     bBeforeShow        : boolean;  (*Forces initialize form to be called ONCE in the beginning*)
     bMustShow          : boolean; (*The components are first hidden.  This boolean forces
                                     a first time show.  After that it does nothing*)
     bFirstFormResize   : boolean;
     bOnTheScreen       : boolean;
     fBorderStyle       : TFormBorderStyle;
     bFormStartsMaximized : Boolean;

     bMaintainProportions     : boolean;
     bIncreasing              : boolean;
     fFont                    : TFont;
     bDisableResize           : boolean;
     bTemporaryDisableResize  : boolean;
     bAfterMaximize           : boolean;
     bDBGridSelfResize        : boolean;
     fElFrmIniFile            : string;
     bRestoreFormFromIni      : boolean;
     bFramesInitialize        : boolean;
     bMustResize              : boolean;
     bDynamicCreation         : boolean;
     fVersion                 : Single;

     fGridColumnWidthResize   : boolean;
     fGridRowHeightResize     : boolean;
     fGridFontResize          : boolean;

     fWindowPlacement          : TWindowPlacement;
     bWindowPlacement          : boolean;
     bWindowPlacementMaximized : boolean;
     fFontWarning,bFirstFontWarning : boolean;

     PartialControlArray : pTPartialControlArray; (*4.01*)
     PartialControlArrayCounter : integer; (*4.01*)
     bLookForExtraFonts         : boolean; (*4.01*)
     bListFree                  : boolean; (*4.01*)

     fResolutionIndependence    : boolean; (*4.02*)
     bControlsAreHidden         : boolean; (*4.02*)
     bEvaluate                  : boolean; (*4.02*)
     bDisableOnShow             : boolean; (*4.03 removes onclose flicker*)
     WasVisibleArray            : pTArrayBoolean;


  private

    fDynamicControls : integer;
    procedure FindAllControls(ofMyControl:TControl);
    procedure FindAllParentControls;
    procedure RearrangeAllControls; (*4.03*)
    function FormHandle: THandle;
    function MDIClientFormHandle: THandle;
    procedure NewWndMethod (var Msg: TMessage);
    procedure NewMDIClientWndMethod (var Msg: TMessage);
    function InList(Container:TList;aControl:TControl;var index:integer):boolean;
    procedure Timer(Sender:TObject);
    function DefinedMaxLeft: integer;
    function DefinedMaxTop : integer;
    procedure InitializeForm;
    procedure ResizeFormMaintainingProportions;
    procedure SetFont(aFont:TFont);
    procedure TilePicture(DC: hDC);
    procedure SetImage(value:TImage);
    procedure TTFontWarning;
    procedure SetVersion(value:Single);
    procedure ResizePartialControls; (*4.01*)
    procedure FindProperMaxSizes; (*4.02*)
    {$IFDEF EVALUATION}
    Function Decrypt(s:String):string; (*4.01*)
    function IDERunning: Boolean; (*4.01*)
    {$ENDIF}

  protected

  public
     GlobalInt   : LongInt;
     ExcludeList : TList; (*Components in this list are excluded from resizing*)
     ShowMaximized : boolean;
     MessageNumber : integer;
     AllowNoBorderResize  : boolean;
     constructor Create( AOwner: TComponent ); override;
     destructor Destroy;override;
     procedure ReSizeForm;
     procedure UpdateSize(aControl:TControl);
     procedure EnforceMaximized;
     procedure AddToExcludeList(aControl:TControl);
     procedure AddControl(aControl:TControl);
     procedure RemoveControl(aControl:TControl); (*4.03*)
     procedure DisableResize;
     procedure EnableResize;
     procedure ReInitializeResizing;
     procedure SaveIniFile; (*ver. 3.0*)
     procedure RestoreFormFromIni; (*ver 3.0*)
     procedure DynamicCreationUpdate; (* ver 3.0*)
     procedure HideAllControls;
     procedure ShowAllControls;
     procedure IncludeToResizing(aControl:String;aProperty:String; ResizeOrientation : TResizeOrientation); (*4.01*)
     procedure TerminateForm; (*4.03*)

     property ManualPosition : boolean read fManualPosition write fManualPosition;
     property ManualSize : boolean read fManualSize write fManualSize;
     property ManualLeft : double read fManualLeft write fManualLeft;
     property ManualTop  : double read fManualTop write fManualTop;
     property ManualWidth : double read fManualWidth write fManualWidth;
     property ManualHeight: double read fManualHeight write fManualHeight;


  published
     property ElasticHorizontal: boolean read FHorz write FHorz default TRUE;
     property ElasticVertical: boolean read FVert write FVert default TRUE;
     property ElasticFont    : boolean read FElasticFont write FElasticFont default TRUE;
     property DesignScreenWidth : integer read fDesignScreenWidth write fDesignScreenWidth;
     property DesignScreenHeight : integer read fDesignScreenHeight write fDesignScreenHeight;
     property DesignPixelsPerInch : integer read fDesignPixelsPerInch write fDesignPixelsPerInch;

     property MaximizedPosX: Integer read fMaximizedPosX write fMaximizedPosX
       default 0;
     property MaximizedPosY: Integer read fMaximizedPosY write fMaximizedPosY
       default 0;
     property MinimumTrackWidth: Integer read fMinimumTrackWidth write fMinimumTrackWidth
       default 0;
     property MinimumTrackHeight: Integer read fMinimumTrackHeight write fMinimumTrackHeight
       default 0;
     property MaximumTrackWidth: Integer read fMaximumTrackWidth write fMaximumTrackWidth
       default 0;
     property MaximumTrackHeight: Integer read fMaximumTrackHeight write fMaximumTrackHeight
       default 0;

     property DesignFormWidth : Integer read fDesignFormWidth write fDesignFormWidth;
     property DesignFormHeight : Integer read fDesignFormHeight write fDesignFormHeight;
     property DesignFormClientWidth : Integer read fDesignFormClientWidth write fDesignFormClientWidth;
     property DesignFormClientHeight : Integer read fDesignFormClientHeight write fDesignFormClientHeight;
     property DesignFormLeft  : Integer read fDesignFormLeft write fDesignFormLeft;
     property DesignFormTop   : integer read fDesignFormTop write fDesignFormTop;
     property MaintainProportions : boolean read bMaintainProportions write bMaintainProportions
              default false;
     property Font : TFont read fFont write SetFont;
     property BkGrndImage : TImage read fBkGrndImage write SetImage;
     property DBGridSelfResize : boolean read bDBGridSelfResize write bDBGridSelfResize default false;
     property ElFrmIniFile : String read fElFrmIniFile write fElFrmIniFile;
     property Version : Single read fVersion write SetVersion;
     property GridColumnWidthResize : boolean read fGridColumnWidthResize write fGridColumnWidthResize default true;
     property GridRowHeightResize : boolean read fGridRowHeightResize write fGridRowHeightResize default true;
     property GridFontResize : boolean read fGridFontResize write fGridFontResize default true;
     property FontWarning : boolean read fFontWarning write fFontWarning default true; (*4.01*)
     property LookForExtraFonts:boolean read bLookForExtraFonts write bLookForExtraFonts default true; (*4.01*)
     property ResolutionIndependence : boolean read fResolutionIndependence write fResolutionIndependence
              default true;  (*4.02*)
  end;


{$ifdef ver93 then}
procedure Register;
{$endif}

implementation

var
  bMaxState : boolean;

{$ifdef ver93 then}
procedure Register;
begin
  RegisterComponents('QSysGraph', [TElasticForm]);
end;
{$endif}


function MyTrunc(x:double):integer;

begin
  if x-trunc(x) > 0.5 then result := round(x)
  else result := trunc(x);
end;

constructor TPartialControl.create; (*4.01*)

begin
  inherited Create;
  addedProperties := TStringList.Create;
  InitSize := -1;
end;

destructor TPartialControl.destroy; (*4.01*)
begin
  addedProperties.Free;
  inherited destroy;
end;


constructor TFrame.create;

begin
  inherited Create;
  fXResize := 1;
  fYResize := 1;
  fFResize := 1;
  bColumnWidthsFixed := False;
  Resizeable := True;
end;

destructor TFrame.destroy;
begin
  {$IFDEF WIN32 THEN}
  ReAllocMem(ColumnWidths,0);
  ReAllocMem(bColumnWidthRecorded,0);
  ReAllocMem(ColumnFontSize,0);
  ReAllocMem(ColumnTitleFontSize,0);
  ReAllocMem(PanelWidths,0);
  {$ELSE}
  FreeMem(ColumnWidths,ColumnWidthsMax*SizeOf(Integer));
  FreeMem(bColumnWidthRecorded,ColumnWidthsMax*SizeOf(Boolean));
  FreeMem(ColumnFontSize,ColumnWidthsMax*SizeOf(Boolean));
  FreeMem(ColumnTitleFontSize,ColumnWidthsMax*SizeOf(Boolean));
  {$ENDIF}

  fonts.free;
  inherited Destroy;
end;



{$ifdef WIN32}
procedure TFrame.ReadDBGridResource(aControl:TControl);

var
  i      : integer;
  ResStr : TResourceStream;
  MemStr : TMemoryStream;
  parse  : TParser;
  aOwner : TComponent;
  GridName : string;

begin
  aOwner := TElasticForm(Owner).Owner;
  GridName := aControl.Name;
  ResStr := TResourceStream.Create(hInstance,aOwner.ClassName,RT_RCDATA);
  try
    MemStr := TMemoryStream.Create;
    try
      ResStr.Position := 0;
      ObjectBinaryToText(resStr,MemStr);
      MemStr.Position := 0;
      i := -1;
      parse := TParser.Create(MemStr);
      while (Parse.Token <> toEOF) and (Parse.TokenString <> GridName) do
        Parse.NextToken;
      if Parse.TokenString = GridName then (*I found the grid*)
        while (Parse.TokenString <> 'object') and (Parse.TokenString <> 'Columns') and
              (Parse.Token <> toEOF) do
          Parse.NextToken;
      if Parse.TokenString = 'Columns' then (*Columns have beer recorded*)
        while (Parse.Token <> toEOF) and (Parse.TokenString <> '>') and (i < ColumnWidthsMax-1) do
          begin
            Parse.NextToken;
            if Parse.TokenString = 'item' then
              begin
                inc(i);
                bColumnWidthRecorded^[i] := false;
              end;
            if Parse.TokenString = 'Width' then
              bColumnWidthRecorded[i] := true;
          end;
    finally
      MemStr.free;
    end;
  finally
    ResStr.Free;
  end;
end;


procedure TFrame.EnumerateGridColumns(Grid: TControl;bStore:boolean);

var
  PropInfo: PPropInfo;
  Columns: TCollection;
  Loop: Integer;
begin
  PropInfo := GetPropInfo(Grid.ClassInfo, 'Columns');
  if Assigned(PropInfo) then
  begin
    Columns := TCollection(GetOrdProp(Grid, PropInfo));
    if Assigned(Columns) then
      for Loop := 0 to Columns.Count - 1 do
        if bStore then
          GridEnumerationToStore(Grid,Columns.Items[Loop],Loop) (*record the values of fonts*)
        else
          GridEnumerationToResize(Columns.Items[Loop],Loop); (*resize the values of fonts*)
  end
end;

procedure TFrame.GridEnumerationToStore(Grid: TControl;Column: TCollectionItem;ColIndex:integer);

var
  PropInfo: PPropInfo;
  cFont: TFont;
  Title : TPersistent;
  FontRatio : double;

begin
  (*Get Column font*)
  PropInfo := GetPropInfo(Column.ClassInfo, 'Font');
  if not Assigned(PropInfo) then
    Exit;
  cFont := TFont(GetOrdProp(Column, PropInfo));
  ColumnFontSize^[ColIndex] := cFont.Size;
  if ColumnFontSize^[ColIndex] <> DesignFontSize then
    begin
      ColumnFontSize^[ColIndex] := myTrunc(TElasticForm(owner).FontCorrection*ColumnFontSize^[ColIndex]);
      FontRatio := 1.0*ColumnFontSize^[ColIndex]/InitFontSize;
      if DefaultRowHeight <= round(FontRatio*TMyCustomGrid(Grid).canvas.TextHeight('1')) then
        repeat
          DefaultRowHeight := DefaultRowHeight+1;
        until DefaultRowHeight > round(FontRatio*TMyCustomGrid(Grid).canvas.TextHeight('1'))
    end;

  (*Get Column TitleFont*)

  PropInfo := GetPropInfo(Column.ClassInfo, 'Title');
  if not Assigned(PropInfo) then
    Exit;
  Title := TPersistent(GetOrdProp(Column, PropInfo));

  PropInfo := GetPropInfo(Title.ClassInfo, 'Font');
  if not Assigned(PropInfo) then
    Exit;
  cFont := TFont(GetOrdProp(Title, PropInfo));
  ColumnTitleFontSize^[ColIndex] := cFont.Size;
  if ColumnTitleFontSize^[ColIndex] <> DesignTitleFontSize then
    ColumnTitleFontSize^[ColIndex] := myTrunc(TElasticForm(owner).FontCorrection*ColumnTitleFontSize^[ColIndex]);
end;


procedure TFrame.GridEnumerationToResize(Column: TCollectionItem;ColIndex:integer);

var
  PropInfo: PPropInfo;
  cFont: TFont;
  Title : TPersistent;

begin
  (*Get Column font*)
  PropInfo := GetPropInfo(Column.ClassInfo, 'Font');
  if not Assigned(PropInfo) then
    Exit;
  cFont := TFont(GetOrdProp(Column, PropInfo));

  cFont.Size := myTrunc(ColumnFontSize^[ColIndex] * TElasticForm(owner).FontCorrection);
  SetOrdProp(Column, PropInfo, Integer(cFont));


  (*Get Column TitleFont*)

  PropInfo := GetPropInfo(Column.ClassInfo, 'Title');
  if not Assigned(PropInfo) then
    Exit;
  Title := TPersistent(GetOrdProp(Column, PropInfo));

  PropInfo := GetPropInfo(Title.ClassInfo, 'Font');
  if not Assigned(PropInfo) then
    Exit;
  cFont := TFont(GetOrdProp(Title, PropInfo));

  cFont.Size := myTrunc(ColumnTitleFontSize^[ColIndex] * TElasticForm(owner).FontCorrection);
  SetOrdProp(Title, PropInfo, Integer(cFont));
end;

{$endif}

procedure TFrame.PreInitialize(aControl:TControl);


begin
  left := aControl.left;
  top  := aControl.top;
  width := aControl.width;
  height := aControl.height;
  fonts := TList.Create;
end;


procedure TFrame.initialize(ScreenCorrectionH,ScreenCorrectionV, PixelsCorrection,PurePixelsCorrection : double;
                         aControl:TControl);

(*Store control information to frame*)
var
  j : integer;
  p : pPropInfo;
  pp   : Pointer;
  FontDesignSize : integer;
  i     : integer;


begin
  bStatusBar := False;
  GetFontsOfControl(aControl);

  if fonts.count > 0 then
    begin
      if InitFontsSize = nil then
        {$IFDEF WIN32 THEN }
        ReAllocMem(InitFontsSize,fonts.count*SizeOf(Integer));
        {$ELSE}
        GetMem(InitFontsSize,fonts.count*SizeOf(Integer));
        {$ENDIF}

      for i := 0 to fonts.count-1 do
        InitFontsSize^[i] := TFont(Fonts[i]).size;
    end;

  {$IFDEF WIN32 THEN}
  if aControl is TStatusBar then
    begin
      bStatusBar := true;
      (*Allocate memory for the panel widths of the Status Bar*)
      PanelWidthsMax := TStatusBar(aControl).panels.count;
      if PanelWidths = nil then
        ReAllocMem(PanelWidths,PanelWidthsMax*SizeOf(Integer));

      (*correct for initial resolution and save*)
      for j := 0 to TStatusBar(aControl).panels.count-1 do
        begin
          TStatusBar(aControl).Panels[j].width :=
             round(PurePixelsCorrection*ScreenCorrectionH*TStatusBar(aControl).Panels[j].width);
          PanelWidths^[j] := TStatusBar(aControl).Panels[j].width;
        end;
    end
  {$IFNDEF VER90 THEN} (*DELPHI 2*)
  {$IFNDEF VER93 THEN} (*CBUILDER 1*)

  else if (aControl is TToolBar) then
    begin
      ButtonHeight := round(TToolBar(aControl).ButtonHeight*ScreenCorrectionV);(*ver 4*)
      ButtonWidth := round(TToolBar(aControl).ButtonWidth*ScreenCorrectionH); (*ver 4*)
      BtnAspect := 1.0*ButtonWidth/ButtonHeight;
      TToolBar(aControl).parentFont := false;
    end
  {$ENDIF}
  {$ENDIF}


  else {$ENDIF} If (aControl is TCustomGrid) and
    ((GetPropInfo(aControl.ClassInfo,'defaultcolwidth') <> nil)) then
        begin
          HeadRowHeight := TMyCustomGrid(aControl).RowHeights[0];
          DefaultRowHeight := TMyCustomGrid(aControl).DefaultRowHeight;
          DBGridInitialize(aControl,ScreenCorrectionH,ScreenCorrectionV);
          HeadRowHeight := round(ScreenCorrectionV*TMyCustomGrid(aControl).RowHeights[0]);
          DefaultRowHeight := round(ScreenCorrectionV*TMyCustomGrid(aControl).DefaultRowHeight);
        end;

  If (aControl is TCustomGrid) and
    (GetPropInfo(aControl.ClassInfo,'defaultrowheight') <> nil) then
    begin
      DefaultRowHeight := round(ScreenCorrectionV*TMyCustomGrid(aControl).DefaultRowHeight);
      if (GetPropInfo(aControl.ClassInfo,'columns') <> nil) or (*ver 3.042*)
        (GetPropInfo(aControl.ClassInfo,'DataSource') <> nil) then
         if DefaultRowHeight <= round(1.2*TMyCustomGrid(aControl).canvas.TextHeight('1')) then
           repeat
             DefaultRowHeight := DefaultRowHeight+1;
           until DefaultRowHeight > round(1.2*TMyCustomGrid(aControl).canvas.TextHeight('1'))
    end;

  (*correct the initial size of each component-saved in preInitialize-for screen resolution differences*)
  left := round(PurePixelsCorrection*ScreenCorrectionH*left);
  top  := round(PurePixelsCorrection*ScreenCorrectionV*top);
  width := round(PurePixelsCorrection*ScreenCorrectionH*width);
  height := round(PurePixelsCorrection*ScreenCorrectionV*height);


 (*Record initial font size of each component.  We do it last because some components,
   such as Edit resize automatically when their font changes.  So, first we record
   their initial and modified size, and then we record their font.*)

  If (aControl is TCustomGrid) or
     (GetPropInfo(aControl.ClassInfo,'defaultRowHeight') <> nil) or
     (GetPropInfo(aControl.ClassInfo,'columns') <> nil) or
     (GetPropInfo(aControl.ClassInfo,'DataSource') <> nil) then
       TMyCustomGrid(aControl).ParentFont := false;


  with TMyControl(aControl) do
    begin
      if not ParentFont then
        begin
          InitFontSize := Trunc(PixelsCorrection*TMyControl(aControl).font.size);
          for i := 0 to fonts.count-1 do
            InitFontsSize^[i] := Trunc(PixelsCorrection*InitfontsSize^[i]);
          DesignFontSize := TMyControl(aControl).font.size;

          if GetPropInfo(aControl.ClassInfo,'TitleFont') <> nil then
            begin
              p := GetPropInfo(aControl.ClassInfo,'titlefont');
              pp := Pointer(GetOrdProp(aControl,p));
              DesignTitleFontSize := TFont(pp).size;
              InitTitleFontSize := Trunc(PixelsCorrection*DesignTitleFontSize);
              FontRatio := 1.0*InitTitleFontSize/InitFontSize;
            end;
        end;

       if GetPropInfo(aControl.ClassInfo,'TabFont') <> nil then {ver 3.03}
         begin
           p := GetPropInfo(aControl.ClassInfo,'TabFont');
           pp := Pointer(GetOrdProp(aControl,p));
           FontDesignSize := TFont(pp).size;
           InitTabFontSize := Trunc(PixelsCorrection*FontDesignSize);
         end;
    end;


end;

procedure TFrame.DBGridInitialize(aControl:TControl;ScreenCorrectionH,ScreenCorrectionV:double);

var
  j : integer;

begin
  if (GetPropInfo(aControl.ClassInfo,'defaultrowheight') = nil) then
    begin
      HeadRowHeight := round(TMyCustomGrid(aControl).RowHeights[0]);
      DefaultRowHeight := round(TMyCustomGrid(aControl).DefaultRowHeight);
    end;

  if not (ColumnWidths = nil) then
    begin
      FreeMem(ColumnWidths,ColumnWidthsMax*SizeOf(Integer));
      ColumnWidths := nil;
    end;


  if not (bColumnWidthRecorded = nil) then
    begin
      FreeMem(bColumnWidthRecorded,ColumnWidthsMax*SizeOf(boolean));
      bColumnWidthRecorded := nil;
    end;

  if not (ColumnFontSize = nil) then
    begin
      FreeMem(ColumnFontSize,ColumnWidthsMax*SizeOf(Integer));
      ColumnFontSize := nil;
    end;

  if not (ColumnTitleFontSize = nil) then
    begin
      FreeMem(ColumnTitleFontSize,ColumnWidthsMax*SizeOf(Integer));
      ColumnTitleFontSize := nil;
    end;

  (*Allocate memory for the column widths of this grid*)
  if not bColumnWidthsFixed then (*it has not been read in*)
    ColumnWidthsMax := TMyCustomGrid(aControl).ColCount;
 (* I prefer using ReAllocMem.  However, in Delphi 1, this function cannot initialize a non
    existing pointer.*)
  if ColumnWidths = nil then
    {$IFDEF WIN32 THEN }
    ReAllocMem(ColumnWidths,ColumnWidthsMax*SizeOf(Integer));
    {$ELSE}
    GetMem(ColumnWidths,ColumnWidthsMax*SizeOf(Integer));
    {$ENDIF}

  if bColumnWidthRecorded = nil then
    {$IFDEF WIN32 THEN }
    ReAllocMem(bColumnWidthRecorded,ColumnWidthsMax*SizeOf(Boolean));
    {$ELSE}
    GetMem(bColumnWidthRecorded,ColumnWidthsMax*SizeOf(Boolean));
    {$ENDIF}

  if ColumnFontSize = nil then
    {$IFDEF WIN32 THEN }
    ReAllocMem(ColumnFontSize,ColumnWidthsMax*SizeOf(Integer));
    {$ELSE}
    GetMem(ColumnFontSize,ColumnWidthsMax*SizeOf(Integer));
    {$ENDIF}

  if ColumnTitleFontSize = nil then
    {$IFDEF WIN32 THEN }
    ReAllocMem(ColumnTitleFontSize,ColumnWidthsMax*SizeOf(Integer));
    {$ELSE}
    GetMem(ColumnTitleFontSize,ColumnWidthsMax*SizeOf(Integer));
    {$ENDIF}


  for j := 0 to ColumnWidthsMax - 1 do
    bColumnWidthRecorded^[j] := false;

   if (TMyCustomGrid(aControl).ColCount = 2) and (TMyCustomGrid(aControl).ColWidths[0] = 64) and
       (TMyCustomGrid(aControl).ColWidths[1] = 64) then bDBGridDefined := false
   else bDBGridDefined := true;

   {$ifdef WIN32}
   if bDBGridDefined then
     if (GetPropInfo(aControl.ClassInfo,'columns') <> nil) or
       (GetPropInfo(aControl.ClassInfo,'DataSource') <> nil) then
         begin
           ReadDBGridResource(aControl);
           EnumerateGridColumns(aControl,true);
         end;
   {$endif}

   (*Save*)
   {$ifdef WIN32}
   for j := 0 to TMyCustomGrid(aControl).ColCount-1 do
     if bColumnWidthRecorded^[j] then
       ColumnWidths^[j] := round(ScreenCorrectionH*TMyCustomGrid(aControl).ColWidths[j])
     else
       ColumnWidths^[j] := round(TMyCustomGrid(aControl).ColWidths[j]);
   {$else}
   for j := 0 to TMyCustomGrid(aControl).ColCount-1 do
     ColumnWidths^[j] := round(TMyCustomGrid(aControl).ColWidths[j]);
   {$endif}

   if (GetPropInfo(aControl.ClassInfo,'DefaultColWidth') <> nil) then (*StringGrid*)
     for j := 0 to TMyCustomGrid(aControl).ColCount-1 do
       ColumnWidths^[j] := round(ScreenCorrectionH*TMyCustomGrid(aControl).ColWidths[j])



end;


procedure TFrame.Resize(  ElasticH,ElasticV,ElasticF : boolean;
                          FormClientWidth,FormClientHeight,cW,cH,cF:integer;FontCorrection:double;
                          ScreenCorrectionH,ScreenCorrectionV, PixelsCorrection : double;
                          aControl:TControl);
var
  xRatio, yRatio   : double;
  pxRatio, pyRatio : double;(*used for more precise resizing*)
  pDif             : integer;
  sLocal           : double;
  i,j              : integer;
  s                : integer;
  l,t,w,h          : integer;
  p                : pPropInfo;
  pp               : Pointer;
  lblLeft          : Integer;
  lblTop           : Integer;
  lblWidth         : Integer;
  lblHeight        : Integer;


begin

  (*Initialize l,t,w,h in case ElasticF,ElasticH, and ElasticV are all FALSE.*)
  l := left;
  t := top;
  w := width;
  h := height;
  xRatio := 1;
  yRatio := 1;

  if not Resizeable then
    begin
      aControl.Setbounds(l, t, w, h);
      exit;
    end;


  if ElasticF then
    {$IFDEF WIN32 THEN} {$IFNDEF VER90 THEN} (*DELPHI 2*) {$IFNDEF VER93 THEN} (*CBUILDER 1*)
    if not (aControl.classname = 'TToolBar') then {$endif} {$endif} {$endif}
      begin
        if not ((aControl is TCustomGrid) and (not TElasticForm(owner).fGridFontResize)) then
          begin
            With TMyControl(aControl) do
              begin
                fFResize := FontCorrection;
                if not ParentFont then
                  begin
                    sLocal := InitFontSize*FontCorrection;

                    for i := 0 to fonts.count-1 do
                      begin
                        sLocal := InitfontsSize^[i]*FontCorrection;
                        TFont(Fonts[i]).Size := MyTrunc(sLocal);
                      end;

                    font.size := MyTrunc(sLocal);
                    if GetPropInfo(aControl.ClassInfo,'titlefont') <> nil then
                      begin
                        p := GetPropInfo(aControl.ClassInfo,'titlefont');
                        pp := Pointer(GetOrdProp(aControl,p));
                        TFont(pp).size := MyTrunc(InitTitleFontSize*FontCorrection);
                      end;
                  end;
                {$ifdef WIN32}
                if (GetPropInfo(aControl.ClassInfo,'Columns')<>nil) then
                  if bDBGridDefined then
                    EnumerateGridColumns(aControl,False);
                {$ENDIF}

                if GetPropInfo(aControl.ClassInfo,'TabFont') <> nil then {ver 3.03}
                  begin
                    p := GetPropInfo(aControl.ClassInfo,'TabFont');
                    pp := Pointer(GetOrdProp(aControl,p));
                    TFont(pp).size := MyTrunc(InitTabFontSize*FontCorrection);
                  end;
              end;
          end
        else if ((aControl is TCustomGrid) and (not TElasticForm(owner).fGridFontResize)) then
          begin
            TMyControl(aControl).font.size := InitFontSize;
            if GetPropInfo(aControl.ClassInfo,'titlefont') <> nil then
              begin
                p := GetPropInfo(aControl.ClassInfo,'titlefont');
                pp := Pointer(GetOrdProp(aControl,p));
                TFont(pp).size := MyTrunc(InitTitleFontSize);
              end;
          end;

      end;


  if ElasticH then
    begin
       xRatio := FormClientWidth/cW;
       fXResize := xRatio;
       l := round(left*xRatio);
       w := round(width*xRatio);
    end;



  if ElasticV then
    begin
       yRatio := FormClientHeight/cH;
       fYResize := yRatio;
       t := Round(top*yRatio);
       h := Round(height*yRatio);
    end;

  aControl.Setbounds(l, t, w, h);


  if ElasticH then
    begin
       {$IFDEF WIN32 THEN}
       if bStatusBar then
         begin
           with TStatusBar(aControl)do
             begin
               for j := 0 to panels.count-1 do
                 panels[j].width := round(PanelWidths^[j]*xRatio);
             end;
         end;
       {$ENDIF}


       If (aControl is TCustomGrid) and
           ((GetPropInfo(aControl.ClassInfo,'defaultcolwidth') <> nil) or
            (GetPropInfo(aControl.ClassInfo,'columns') <> nil) or
             (GetPropInfo(aControl.ClassInfo,'DataSource') <> nil)) then (*this recognizes dbgrid in newer delphi*)
               begin
                 pDif := aControl.width - aControl.ClientWidth;
                 if ((width - pDif) > 0) and ((w-pDif)>0) then
                   pXRatio := 1.0*(w-pDif)/(width-pDif)
                 else
                   pXRatio := xRatio;
                 if not (ColumnWidthsMax = TMyCustomGrid(aControl).ColCount) then
                   begin
                      TMyControl(aControl).font.size := InitFontSize;
                      if GetPropInfo(aControl.ClassInfo,'titlefont') <> nil then
                        begin
                          p := GetPropInfo(aControl.ClassInfo,'titlefont');
                          pp := Pointer(GetOrdProp(aControl,p));
                          TFont(pp).size := MyTrunc(InitTitleFontSize);
                        end;
                     DBGridInitialize(aControl,ScreenCorrectionH,ScreenCorrectionV);
                   end;
                 if not TElasticForm(owner).bDBGridSelfResize or
                   (GetPropInfo(aControl.ClassInfo,'defaultcolwidth') <> nil) then (*EF Grid column resizing-4.01*)
                   begin
                     if bDBGridDefined then  (*ver 4 *)
                     if TElasticForm(owner).fGridColumnWidthResize then
                       for j := 0 to TMyCustomGrid(aControl).ColCount-1 do
                         TMyCustomGrid(aControl).ColWidths[j] := round(ColumnWidths^[j]*pxRatio)
                     else
                       for j := 0 to TMyCustomGrid(aControl).ColCount-1 do
                         TMyCustomGrid(aControl).ColWidths[j] := round(ColumnWidths^[j]);
                   end;
               end;

    end;

  if ElasticV then
    begin

       If (aControl is TCustomGrid)and
           (GetPropInfo(aControl.ClassInfo,'defaultrowheight') <> nil) then
             if TElasticForm(owner).fGridRowHeightResize then
               TMyCustomGrid(aControl).DefaultRowHeight := round(DefaultRowHeight*yRatio)
             else
               TMyCustomGrid(aControl).DefaultRowHeight := round(DefaultRowHeight);

       If (aControl is TCustomGrid) and
           ((GetPropInfo(aControl.ClassInfo,'defaultRowHeight') <> nil) or
            (GetPropInfo(aControl.ClassInfo,'columns') <> nil) or
             (GetPropInfo(aControl.ClassInfo,'DataSource') <> nil)) then (*this recognizes dbgrid in newer delphi*)
               begin
                 pDif := aControl.Height - aControl.ClientHeight;
                 if ((Height - pDif) > 0) and ((h-pDif)>0) then
                   pYRatio := 1.0*(h-pDif)/(height-pDif)
                 else
                   pYRatio := yRatio;
                 if not (ColumnWidthsMax = TMyCustomGrid(aControl).ColCount) then
                   begin

                      TMyControl(aControl).font.size := InitFontSize;
                      if GetPropInfo(aControl.ClassInfo,'titlefont') <> nil then
                        begin
                          p := GetPropInfo(aControl.ClassInfo,'titlefont');
                          pp := Pointer(GetOrdProp(aControl,p));
                          TFont(pp).size := MyTrunc(InitTitleFontSize);
                        end;
                     DBGridInitialize(aControl,ScreenCorrectionH,ScreenCorrectionV);
                   end;
                 if TElasticForm(owner).fGridRowHeightResize then
                   TMyCustomGrid(aControl).DefaultRowHeight := round(DefaultRowHeight*pYRatio)
                 else
                   TMyCustomGrid(aControl).DefaultRowHeight := round(DefaultRowHeight);

                 if (GetPropInfo(aControl.ClassInfo,'columns') <> nil) or
                    (GetPropInfo(aControl.ClassInfo,'DataSource') <> nil) then
                      begin (*ver 3.042*)  (*Do this only for DBGrids and equivalents*)
                         s := round(TMyCustomGrid(aControl).canvas.TextHeight('1'));
                         if TElasticForm(owner).fGridRowHeightResize then
                           if pyRatio < 0.8 then  (*This is realy a heuristic choice*)
                             if (TMyCustomGrid(aControl).DefaultRowHeight <= 0.7*s) then
                              TMyCustomGrid(aControl).DefaultRowHeight := round(0.7*s);

                         if TElasticForm(owner).fGridRowHeightResize then
                           TMyCustomGrid(aControl).RowHeights[0] := round(HeadRowHeight*pYRatio)
                         else
                           TMyCustomGrid(aControl).RowHeights[0] := round(HeadRowHeight);

                         if TElasticForm(owner).fGridRowHeightResize then
                           if (1.0*TMyCustomGrid(aControl).RowHeights[0]/TMyCustomGrid(aControl).DefaultRowHeight) <
                              FontRatio then
                             TMyCustomGrid(aControl).RowHeights[0] :=
                              1+round(TMyCustomGrid(aControl).DefaultRowHeight*fontRatio);
                      end
                 else (*if it is a StringGrid component*) (*ver 3.042*)
                   (*Make font slightly smaller to ensure that it fits within the
                     cells during resizing*)
                   if TElasticForm(owner).ElasticFont and (TElasticForm(owner).GridFontResize) then
                     TMyCustomGrid(aControl).font.size := TMyCustomGrid(aControl).font.size -1;
               end;
    end;



  {$IFDEF WIN32 THEN}
  {$IFNDEF VER90 THEN} (*DELPHI 2*)
  {$IFNDEF VER93 THEN} (*CBUILDER1*)
  if aControl.classname = 'TToolBar' then
    begin (*We always want the Toolbar buttons to be square*)
      if TToolBar(aControl).width > TToolBar(aControl).height then
        begin
          TToolBar(aControl).ButtonHeight := trunc(ButtonHeight*yRatio);
          TToolBar(aControl).ButtonWidth := trunc(ButtonHeight*yRatio);
        end
      else
        begin
          TToolBar(aControl).ButtonHeight := trunc(ButtonHeight*xRatio);
          TToolBar(aControl).ButtonWidth := trunc(ButtonHeight*xRatio);
        end
    end;
  {$ENDIF}
  {$ENDIF}
  {$ENDIF}
  (*Sometimes Label captions may be slightly clipped during resizing due to
    snug fitting of the label caption within the label *)


  if aControl is TLabel then
    begin
      if not (TLabel(aControl).AutoSize) then
        begin
            lblLeft := TLabel(aControl).left;
            lbltop := TLabel(aControl).top;
            lblHeight := TLabel(aControl).Height;
            lblWidth := TLabel(aControl).Width;
            TLabel(AControl).Autosize := true;
            TLabel(AControl).Autosize := false;
            With TLabel(aControl) do
              begin
                left := lblLeft;
                top := lblTop;
                if lblWidth > width then width := lblWidth;
                if lblHeight > height then height := lblHeight;
              end;
        end
      else
        begin
          TLabel(AControl).Autosize := false;
          TLabel(AControl).Autosize := true;
        end;
    end;

  if GetPropInfo(aControl.ClassInfo,'AutoSize') <> nil then
    begin
      p := GetPropInfo(aControl.ClassInfo,'AutoSize');
      if boolean(GetOrdProp(acontrol,p)) then
        begin
          setOrdProp(aControl,p,integer(false));
          setOrdProp(aControl,p,integer(true));
        end;
    end;
end;


(****************************************************************************)

procedure TFrame.GetFontsOfControl(aControl:TControl);

var
  i1,i2,i3 : integer;
  Count1 : integer;
  PropList1:PPropList;
  PropInfo : PPropInfo;

  aFont : TFont;

  aObject : TObject;
  bObject : TObject;

  PropList2:PPropList;
  Count2   : integer;

  PropList3:PPropList;
  Count3   : integer;

begin
  if Owner <> nil then
    if not TElasticForm(Owner).bLookForExtraFonts then exit;
  new(PropList1);
  Count1 := GetPropList(aControl.ClassInfo,[tkClass],PropList1);
  if fonts.count > 0 then fonts.Clear;
  for i1 := 0 to Count1-1 do
    begin (*Find first tier font properties *)
      if PropList1^[i1]^.PropType^.name = 'TFont' then
        begin
          if not(upperCase(PropList1^[i1]^.name) = 'FONT') and
            not(upperCase(PropList1^[i1]^.name) = 'TITLEFONT') and
            not(upperCase(PropList1^[i1]^.name) = 'TABFONT') then
              begin
                PropInfo := GetPropInfo(aControl.ClassInfo, PropList1^[i1]^.name);
                if PropInfo <> nil then
                  begin
                    aFont := TFont(GetOrdProp(aControl,Propinfo));
                    fonts.Add(aFont);
                  end;
              end;
        end
      else
        begin (*Find Second tier fonts*)
          PropInfo := GetPropInfo(aControl.ClassInfo, PropList1^[i1]^.name);
          if PropInfo <> nil then
            begin
              Count2 := 0;
              aObject := TObject(GetOrdProp(aControl,Propinfo));
              new(PropList2);
              if (aObject <> nil) then if (aObject.ClassInfo <> nil) then
                Count2 := GetPropList(aObject.ClassInfo,[tkClass],PropList2)
              else Count2 := 0;
              for i2 := 0 to Count2 -1 do
                begin
                  If PropList2^[i2]^.proptype^.name = 'TFont' then
                    begin
                      PropInfo := GetPropInfo(aObject.ClassInfo, PropList2^[i2]^.name);
                      if PropInfo <> nil then
                        begin
                          aFont := TFont(GetOrdProp(aObject,Propinfo));
                          fonts.Add(aFont);
                        end;
                    end
                  else
                    begin (*Find Third tier fonts*)
                      PropInfo := GetPropInfo(aObject.ClassInfo, PropList2^[i2]^.name);
                      if PropInfo <> nil then
                        begin
                          Count3 := 0;
                          bObject := TObject(GetOrdProp(aObject,Propinfo));
                          new(PropList3);
                          if bObject <> nil then if (bObject.ClassInfo <> nil) then
                            Count3 := GetPropList(bObject.ClassInfo,[tkClass],PropList3)
                          else Count3 := 0;
                          for i3 := 0 to Count3 -1 do
                            begin
                              If PropList3^[i3]^.proptype^.name = 'TFont' then
                                begin
                                  PropInfo := GetPropInfo(bObject.ClassInfo, PropList3^[i3]^.name);
                                  if PropInfo <> nil then
                                    begin
                                      aFont := TFont(GetOrdProp(bObject,Propinfo));
                                      fonts.Add(aFont);
                                    end;
                                end;
                            end;
                          Dispose(PropList3);
                        end;
                    end;

                end;
              Dispose(PropList2);
            end;
        end;
    end;
  Dispose(PropList1);

end;



(****************************************************************************)
(****************************************************************************)
(****************************************************************************)
(****************************************************************************)


procedure TElasticForm.TTFontWarning;

var
  TheSize  : LongInt;

begin
  if (csDesigning in ComponentState) then (*See if form's font is True Type*)
    begin
    (****************************************************************************)
    TheSize := GetOutlineTextMetrics(TForm(Owner).canvas.handle,0,nil);
    if (TheSize = 0) then
      MessageDlg('Form''s Font is not True Type.  Only True Type font are guaranteed to resize '+
                 'well at all form sizes.  Consider Changing the form''s font to one that is True Type.',
                  mtWarning,[mbOK],0);
    (****************************************************************************)
    end;
end;

procedure TElasticForm.SetVersion;

begin
  fVersion := gVersion;
end;

constructor TElasticForm.Create( AOwner: TComponent );

var
  i : integer;
  counter : integer;

begin
  inherited Create(AOwner);
  (*Owner can only be a FORM*)

  if (AOwner = nil) or not (AOwner is TForm) then
    begin
      raise Exception.Create ('Owner of TElasticForm component must be a form');
    end;
  (* create a single instance only *)
  counter := 0;
  for I := 0 to AOwner.ComponentCount - 1 do
    if AOwner.Components[I] is TElasticForm then
      inc(counter);
  if counter > 1 then (*One is itself*)
    begin
      raise Exception.Create ('A TElasticForm component already exists in ' +
            AOwner.Name);
    end;

  if not (csDesigning in ComponentState) then
    begin
      NewWndProc := MakeObjectInstance (NewWndMethod);
      OldWndProc := Pointer (SetWindowLong (FormHandle, gwl_WndProc, Longint (NewWndProc)));
      if (TForm(AOwner).ClientHandle > 0) then
        begin
          NewMDIClientWndProc := MakeObjectInstance (NewMDIClientWndMethod);
          OldMDIClientWndProc := Pointer (SetWindowLong (MDIClientFormHandle, gwl_WndProc, Longint (NewMDIClientWndProc)));
        end;
    end
  else
    begin
      NewWndProc := nil;
      OldWndPRoc := nil;
      fDesignFormWidth := TForm(AOwner).Width;
      fDesignFormHeight := TForm(AOwner).Height;
      fDesignFormClientWidth := TForm(AOwner).ClientWidth;
      fDesignFormClientHeight := TForm(AOwner).ClientHeight;
      fDesignFormTop := TForm(AOwner).Top;
      fDesignFormLeft := TForm(AOwner).Left;
      fDesignTimer :=  TTimer.create(self);
      fDesignTimer.interval := 500;
      fDesignTimer.OnTimer := Timer;
      fDesignTimer.enabled := true;
    end;

  FHorz := TRUE; (*Make elastic in x*)
  FVert := TRUE; (*Make Elastic in y*)
  FElasticFont := TRUE; (*Make Fonts elastic*)
  bFirstTime := true;  (*the first time we shall calculate the components.*)

  bLookForExtraFonts := True;
  fFont := TFont.create;

  if not (fFont = nil) then
    fFont.Assign(TForm(AOwner).font);

  (*Design time only - begin*)
  if (csDesigning in ComponentState) then
    begin
      With AOwner as TForm do
        begin
          HorzScrollBar.Visible := false;
          VertScrollBar.Visible := false;
          scaled := false;
        end;
      fDesignScreenWidth := GetSystemMetrics (SM_CXMAXIMIZED);
      fDesignScreenHeight := GetSystemMetrics (SM_CYMAXIMIZED);
      fDesignPixelsPerInch := Screen.PixelsPerInch;
    end;
  (*Design time only - end*)

  fScreenWidth := GetSystemMetrics (SM_CXMAXIMIZED);
  fScreenHeight := GetSystemMetrics (SM_CYMAXIMIZED);

  fPixelsPerInch := Screen.PixelsPerInch;
  fOwnerFormPosition := TForm(AOwner).position;

  (*Create and Clear List of components that are excluded from resizing*)
  ExcludeList := TList.Create;
  ExcludeList.Clear;

  bBeforeShow := true;
  bMustShow := true;
  bFirstFormResize := true;
  bOnTheScreen := false;
  bFormStartsMaximized := (TForm(Owner).WindowState = wsMaximized);
  fManualPosition := false; (*no manual positioning of the form*)
  bMaintainProportions := false;
  ShowMaximized := false;
  bMaxState := bFormStartsMaximized;

  fBkGrndImage := nil;
  FPictureAssigned := false;
  bDisableResize := false;
  bTemporaryDisableResize := false;
  bAfterMaximize := false;
  bDBGridSelfResize := false;
  bRestoreFormFromIni := true;
  bFramesInitialize := true;
  fDynamicControls := 200; (* can add up to 200 controls dynamically*)
  bMustResize := false;
  AllowNoBorderResize := false;
  bDynamicCreation := false;
  SetVersion(gVersion);
  fGridColumnWidthResize := true;
  fGridRowHeightResize := true;
  fGridFontResize := true;

  bWindowPlacement  := false;
  bWindowPlacementMaximized := false;
  fFontWarning := true;
  bFirstFontWarning := true;
  bListFree := false;
  fResolutionIndependence := true;
  bControlsAreHidden := true;
  bDisableOnShow := false;
  {$IFDEF EVALUATION}
  bEvaluate := true;
  {$ELSE}
  bEvaluate := false;
  {$ENDIF}
end;


destructor TElasticForm.destroy;

var
  i : integer;

begin
  if Assigned (NewWndProc) then
    begin
      SetWindowLong(FormHandle,gwl_WndProc,LongInt(OldWndProc));
      FreeObjectInstance (NewWndProc);
    end;

  inherited destroy;
  if fList <> nil then
    fList.free;

  if fParentList <> nil then
    fParentList.free;

  if not (fFrames = nil) then
    begin
      for i := 0 to fTotalControls-1 do
        fFrames^[i].Free;
      FreeMem(fFrames,(FInitTotalControls+fDynamicControls)*SizeOf(TFrame));
    end;

  if ExcludeList <> nil then
    ExcludeList.Free;

  if fFont <> nil then
    fFont.free;

  if PartialControlArray <> nil then

    {$ifdef win32}
    ReAllocMem(PartialControlArray,0);(*4.01*)
    {$else}
    FreeMem(PartialControlArray,(PartialControlArrayCounter+1)*SizeOf(TPartialControl));
    {$endif}

end;


function TElasticForm.FormHandle: THandle;

begin
  Result := (Owner as TForm).Handle;
end;

function TElasticForm.MDIClientFormHandle: THandle;

begin
  Result := (Owner as TForm).ClientHandle;
end;

procedure TElasticForm.FindAllControls(ofMyControl:TControl);


(* This procedure parses all the children of one component before it goes to the next*)
var
  i : integer;
  ctrl : TControl;
  s    : String;

begin
  S := ofMycontrol.name;
  If TWinControl(ofMyControl).ControlCount > 0 then
    with TWinControl(ofMyControl) do
      for i := 0 to ControlCount-1 do
        begin
          ctrl := controls[i];
          if not (ctrl.name = '')
            and ((GetPropInfo(ctrl.ClassInfo,'PageIndex') = nil) or
             ((GetPropInfo(ctrl.ClassInfo,'PageIndex') <> nil) and
               (GetPropInfo(ctrl.ClassInfo,'Pages') <> nil))) (*exclude tabsheets from resizing*)
             {$ifdef win32 then} {$IFNDEF VER90 THEN} {$IFNDEF VER93 THEN}  (*DELPHI 2 OR CBUILDER1*)
                and (not (ctrl.parent is TToolBar)){$ENDIF}{$endif}{$ENDIF} then {ver 3.03}
                                        (*It is assumed that nameless controls are
                                         internal to other controls, and are the
                                         responsibility of their parents to resize them*)
            fList.add(ctrl);

          if (TControl(controls[i]) is TWinControl) then
            FindAllControls(TControl(ctrl));
        end;
end;

procedure TElasticForm.RearrangeAllControls;  (*4.03*)

var
  TempList : TList;
  i,j        : integer;

begin
  TempList := TList.Create;
  for i := 0 to fParentList.count-1 do
    TempList.Add(fParentList.items[i]);
  for i := 0 to fList.Count-1 do
    if not inList(fParentList,fList.items[i],j) then
      TempList.Add(fList.Items[i]);
  fList.Clear;
  for i := 0 to TempList.Count-1 do
    fList.Add(TempList.Items[i]);

  TempList.Free;

end;

procedure TElasticForm.FindAllParentControls;
var
  i : Integer;
  Current : Integer;
  LeftList,RightList,TopList,BottomList,NoAlignList,ClientList : TList;
  aControl : TControl;


begin
  LeftList := TList.Create;
  RightList := TList.Create;
  TopList := TList.Create;
  BottomList := TList.Create;
  NoAlignList := TList.Create;
  ClientList := TList.Create;

  for i := 0 to fList.Count-1 do
    begin
      aControl := TMyControl(fList.Items[i]);
      if aControl.parent = TForm(Owner) then
        begin
          if GetPropInfo(aControl.ClassInfo,'Align') <> nil then
            begin
              if aControl.Align = alLeft then
                LeftList.Add(aControl)
              else if aControl.Align = alRight then
                RightList.Add(aControl)
              else if aControl.Align = alTop then
                TopList.Add(aControl)
              else if aControl.Align = alBottom then
                BottomList.Add(aControl)
              else if aControl.Align = alClient then
                ClientList.Add(aControl)
              else (*alNone*)
                NoAlignList.Add(aControl);
            end
          else (*Align property is not published*)
            NoAlignList.Add(aControl);
        end;
    end;


  if TopList.Count > 0 then
    repeat
      aControl := TControl(TopList.Items[0]);
      Current := 0;
      for i := 0 to TopList.Count-1 do
        begin
          if TControl(TopList.Items[i]).top <= aControl.Top then
            begin
              aControl := TControl(TopList.Items[i]);
              Current := i;
            end;
        end;
      fParentList.add(aControl);
      TopList.Delete(Current);
    until TopList.Count = 0;

  if BottomList.Count > 0 then
    repeat
      aControl := TControl(BottomList.Items[0]);
      Current := 0;
      for i := 0 to BottomList.Count-1 do
        begin
          if TControl(BottomList.Items[i]).top >= aControl.Top then
            begin
              aControl := TControl(BottomList.Items[i]);
              Current := i;
            end;
        end;
      fParentList.add(aControl);
      BottomList.Delete(Current);
    until BottomList.Count = 0;

  if LeftList.Count > 0 then
    repeat
      aControl := TControl(LeftList.Items[0]);
      Current := 0;
      for i := 0 to LeftList.Count-1 do
        begin
          if TControl(LeftList.Items[i]).Left <= aControl.Left then
            begin
              aControl := TControl(LeftList.Items[i]);
              Current := i;
            end;
        end;
      fParentList.add(aControl);
      LeftList.Delete(Current);
    until LeftList.Count = 0;

  if RightList.Count > 0 then
    repeat
      aControl := TControl(RightList.Items[0]);
      Current := 0;
      for i := 0 to RightList.Count-1 do
        begin
          if TControl(RightList.Items[i]).Left >= aControl.Left then
            begin
              aControl := TControl(RightList.Items[i]);
              Current := i;
            end;
        end;
      fParentList.add(aControl);
      RightList.Delete(Current);
    until RightList.Count = 0;

  if ClientList.Count > 0 then
    repeat
      aControl := TControl(ClientList.Items[0]);
      Current := 0;
      for i := 0 to ClientList.Count-1 do
        begin
          if TControl(ClientList.Items[i]).Left <= aControl.Left then
            begin
              aControl := TControl(ClientList.Items[i]);
              Current := i;
            end;
        end;
      fParentList.add(aControl);
      ClientList.Delete(Current);
    until ClientList.Count = 0;


  for i := 0 to NoAlignList.Count-1 do
    fParentList.add(TControl(NoAlignList.Items[i]));


  GetMem(WasVisibleArray,fParentList.count*SizeOf(Boolean));
  for i := 0 to fParentList.Count-1 do
    WasVisibleArray^[i] := TControl(fParentList.Items[i]).Visible;

  LeftList.free;
  RightList.free;
  TopList.free;
  BottomList.free;
  NoAlignList.free;
  ClientList.free;

  RearrangeAllControls; (*4.03*)

end;

procedure TElasticForm.ReSizeForm;

var

  i,j: integer;
  h,w: integer;
  s    : Double;

begin
  if not bControlsAreHidden then exit; (*ver 4.02*)
  if bTemporaryDisableResize then exit;
  with TForm(owner) do
    begin
      if bFirstTime then
        begin
          if bFramesInitialize then
            for i := 0 to fTotalControls-1 do
              fFrames^[i].initialize(fScreenCorrectionH,fScreenCorrectionV,fPixelsCorrection,
                                      1.0,TControl(fList.items[i]));


  (*Now that component sizes have been stored I can change the Form's font size CF0 which was stored
  when the component first came to existence and before the form was shown*)

          if cF0 <> 0 then
            fFont.Size := cF0;
          cW := round(fDesignFormClientWidth*fScreenCorrectionH);
          cH := round(fDesignFormClientHeight*fScreenCorrectionV);
          cF := fFont.size;
          bFirstTime := false;

        end (*if bFirstTime*)
      else
        if ExcludeList.count > 0 then(*remove all excluded controls*)
        begin
          i := 0;
          while i <= FList.Count-1 do
            begin
              if InList(ExcludeList,FList.items[i],j) then
                begin
                  fFrames^[i].Resizeable := False;
                  inc(i);
                end
              else {ver 3.03}
                inc(i);
            end;
          fTotalControls := FList.Count;
          ExcludeList.Clear;
        end;

      if not ( csDesigning in ComponentState ) then
        begin
          h := height;
          w := width;
          s := cF*h/cH;
          if s > cF*w/cW then
            s := cF*w/cW;
          if ElasticFont then
            fFont.size := round(s);

          s := s/cF;
          FontCorrection := s;


          (*If the component is resizeable then is is resized based on current values.
            This will happen on every resize*)

          for i := 0 to fTotalControls - 1 do
              fFrames^[i].Resize(fHorz,fVert,fElasticFont,ClientWidth,ClientHeight,cW,cH,cF,FontCorrection,
                        fScreenCorrectionH,fScreenCorrectionV, fPixelsCorrection,
                        TControl(fList.items[i]));

          if PartialControlArrayCounter > 0 then (*4.01*)
            ResizePartialControls;
          (*After resizing show all components*)

          if bMustShow then
            begin
              ShowAllControls;
              bMustShow := false;
            end;

        end
      else
         begin
            if bFirstTime then
              begin
                cW := width;
                cH := height;
                cF := fFont.size;
                bFirstTime := false;
              end;
         end;
    end;

end;


procedure TElasticForm.ResizePartialControls; (*4.01*)

var

  i,j              : integer;
  aControl         : TControl;
  p                : pPropInfo;
  PropInfo         : pPropInfo;
  xRatio, yRatio   : double;
  aPartialControl  : TPartialControl;
  c                : integer;
  Pers             : TPersistent;

begin

  xRatio := TForm(Owner).ClientWidth/cW;
  yRatio := TForm(Owner).ClientHeight/cH;

  for i := 0 to PartialControlArrayCounter-1 do
    begin
      aPartialControl := TPartialControl(PartialControlArray^[i]);
      aControl := aPartialControl.aControl;
      c := aPartialcontrol.addedProperties.Count;

      Pers := aControl;
      PropInfo := GetPropInfo(aControl.ClassInfo, aPartialcontrol.addedProperties[0]);
      if not Assigned(PropInfo) then
        Exit;

      for j := 2 to c do
        begin
          Pers := TPersistent(GetOrdProp(Pers, PropInfo));
          PropInfo := GetPropInfo(Pers.ClassInfo, aPartialcontrol.addedProperties[j-1]);
          if not Assigned(PropInfo) then
            Exit;
        end;

      if (GetPropInfo(Pers.ClassInfo,aPartialcontrol.addedProperties[c-1]) <> nil) then
        begin
          p := GetPropInfo(Pers.ClassInfo,aPartialcontrol.addedProperties[c-1]);
          if p^.PropType^.Name = 'TFont'then (* this should also include size. I shall add it myself.*)
             begin
               Pers := TPersistent(GetOrdProp(Pers, PropInfo));
(*               PropInfo := GetPropInfo(Pers.ClassInfo,'size');*)
               p := GetPropInfo(Pers.ClassInfo,'size');
             end;

          if aPartialcontrol.InitSize = -1 then
            begin
              if aPartialcontrol.ResizeOrientation = roHorizontal then
                aPartialcontrol.InitSize := round(fScreenCorrectionH*Integer(GetOrdProp(Pers,p)))
              else if aPartialcontrol.ResizeOrientation = roVertical then
                aPartialcontrol.InitSize := round(fScreenCorrectionV*Integer(GetOrdProp(Pers,p)))
              else if aPartialcontrol.ResizeOrientation = roAverage then
                aPartialcontrol.InitSize := round(sqrt(fScreenCorrectionH*fScreenCorrectionV)*Integer(GetOrdProp(Pers,p)))
            end;
          if aPartialcontrol.ResizeOrientation = roHorizontal then
            setOrdProp(Pers,p,round(aPartialcontrol.InitSize*xRatio))
          else if aPartialcontrol.ResizeOrientation = roVertical then
            setOrdProp(Pers,p,round(aPartialcontrol.InitSize*yRatio))
          else
            setOrdProp(Pers,p,round(aPartialcontrol.InitSize*sqrt(yRatio*xRatio)));
        end;
    end;
end;


procedure TElasticForm.FindProperMaxSizes; (*4.02*)

var
  Rx,Ry,Rxy : double;

begin
  if not bMaintainProportions then exit;

  Rx := 1.0*fDesignFormWidth/fScreenWidth;
  Ry := 1.0*fDesignFormHeight/fScreenHeight;
  Rxy := 1.0*fDesignFormWidth/fDesignFormHeight;
  if Rx >= Ry then
    begin
      fMaximumTrackWidth := fScreenWidth-6;
      fMaximumTrackHeight := round((fScreenWidth-6)/Rxy);
    end
  else
    begin
      fMaximumTrackHeight := fScreenHeight-5;
      fMaximumTrackWidth := round((fScreenHeight-5)*Rxy);
    end;

  fMaximizedWidth := fMaximumTrackWidth;
  fMaximizedHeight := fMaximumTrackHeight;
end;


procedure TElasticForm.UpdateSize(aControl:TControl);

var
  i : integer;
begin
  if aControl is TForm then
    begin
      cF := font.size;
    end;
  i := -1;
  repeat
    inc(i)
  until (i >= fTotalControls) or (aControl = TControl(fList.items[i]));
  if i < fTotalControls then
    with fFrames^[i] do
      begin
        try
          left   := round(aControl.Left/fXResize);
          width  := round(aControl.Width/fXResize);
          top    := round(aControl.Top/fYResize);
          height := round(aControl.Height/fYResize);
          WasVisible := aControl.Visible;
        except
        end;

        if not bDBGridSelfResize then (*ElasticForm DBGrid column resizing*)
        If (aControl is TCustomGrid)  and
           ((GetPropInfo(aControl.ClassInfo,'defaultcolwidth') <> nil) or
           (GetPropInfo(aControl.ClassInfo,'columns') <> nil)  or
             (GetPropInfo(aControl.ClassInfo,'DataSource') <> nil)) then (*this recognizes dbgrid in newer delphi*)
              for i := 0 to TMyCustomGrid(aControl).ColCount-1 do
                ColumnWidths^[i] := round(TMyCustomGrid(aControl).ColWidths[i]/fXResize);
      end;
end;

procedure TElasticForm.EnforceMaximized;

begin
  ShowWindow(TForm(Owner).handle,SW_SHOWMAXIMIZED);
end;

function TElasticForm.InList(Container:TList;aControl:TControl;var index:integer):boolean;

var
  i : integer;

begin
  result := false;
  if Container <> nil then
    begin
      for i := 0 to Container.Count-1 do
        if Container.Items[i] = aControl then
          begin
            index := i;
            result := true;
            break;
          end;
    end;
end;


procedure TElasticForm.Timer(Sender:TObject);

begin
  fDesignFormWidth := TForm(Owner).Width;
  fDesignFormHeight := TForm(Owner).Height;
  fDesignFormClientWidth := TForm(Owner).ClientWidth;
  fDesignFormClientHeight := TForm(Owner).ClientHeight;
  fDesignFormTop := TForm(Owner).Top;
  fDesignFormLeft := TForm(Owner).Left;


  if not (TForm(Owner).BorderStyle in [bsSizeable{$IFDEF WIN32 THEN},bsSizeToolWin{$ENDIF}]) then
    TForm(Owner).AutoScroll := false; (*ver 3.04*)

  if not (fFont = nil) then
    fFont.Assign(TForm(Owner).font);

  if fFontWarning and bFirstFontWarning then
    begin
      bFirstFontWarning := false;
      TTFontWarning;
    end;

end;


procedure TElasticForm.AddToExcludeList(aControl:TControl);

var
  i,j : integer;

begin
  try
    If (aControl.Owner = Owner) or (aControl.parent=Owner) then
      begin
        ExcludeList.add(aControl);
        TMyControl(aControl).ParentFont := false;
      end;

    if (fList <> nil) and (fList.count > 0) then(*ver 4*)
      begin
        i := 0;
        while i <= FList.Count-1 do
          begin
            if InList(ExcludeList,FList.items[i],j) then
              begin
                fFrames^[i].Resizeable := False;
                inc(i);
               end
            else (*ver 3.03*)
              inc(i);
          end;
        fTotalControls := FList.Count;
        ExcludeList.Clear;
      end;

  except
    ShowMessage('Control ' + aControl.Name + ' is not a member of ' + TForm(owner).name);
  end;
end;


procedure TElasticForm.AddControl(aControl:TControl);

var
  i : integer;

begin
  inc(fTotalControls);


  if aControl.Parent = Owner then (*4.03*)
    fList.Insert(fParentList.Count,aControl)
  else
    fList.add(aControl);


  if aControl.Parent = Owner then (*4.03*)
    begin
      for i := fTotalControls-1 downto fParentList.Count+1 do
        fFrames^[i] := fFrames^[i-1];

      fFrames^[fParentList.Count] := TFrame.Create;
      fFrames^[fParentList.Count].PreInitialize(aControl);
      fFrames^[fParentList.Count].owner := self; (*ver 4.02*)
      fFrames^[fParentList.Count].initialize(fScreenCorrectionH,fScreenCorrectionV,fPixelsCorrection,
                                  1.0, TControl(aControl));
      fFrames^[fParentList.Count].WasVisible := aControl.visible;
    end
  else
    begin
      fFrames^[fTotalControls-1] := TFrame.Create;
      fFrames^[fTotalControls-1].PreInitialize(aControl);
      fFrames^[fTotalControls-1].owner := self; (*ver 4.02*)
      fFrames^[fTotalControls-1].initialize(fScreenCorrectionH,fScreenCorrectionV,fPixelsCorrection,
                                  1.0, TControl(aControl));
      fFrames^[fTotalControls-1].WasVisible := aControl.visible;
    end;


  if aControl.Parent = owner then (*4.03*)
    begin
      if aControl.Align = alNone then
        fParentList.Add(aControl)
      else
        begin
          fParentList.Clear;
          FindAllParentControls;
        end;
    end;

  ReInitializeResizing;
end;


procedure TElasticForm.RemoveControl(aControl:TControl); (*4.03*)

var
  index : integer;
begin
  if InList(FList,aControl,index) then
    begin
      fList.Delete(Index);
      dec(fTotalControls);
    end;
  if InList(fParentList,aControl,index) then
    fParentList.Delete(index);
end;

procedure TElasticForm.DisableResize;

begin
  bDisableResize := true;
end;

procedure TElasticForm.EnableResize;

begin
  bDisableResize := false;
end;

procedure TElasticForm.ReInitializeResizing;

var
  i : integer;

begin
  DesignFormClientHeight := TForm(owner).ClientHeight;
  DesignFormClientWidth := TForm(owner).ClientWidth;
  DesignFormHeight := TForm(owner).Height;
  DesignFormWidth := TForm(owner).Width;


  for i := 0 to fTotalControls-1 do
    begin
      fFrames^[i].PreInitialize(TControl(fList.items[i]));
      fFrames^[i].initialize(fScreenCorrectionH,fScreenCorrectionV,fPixelsCorrection,
                              1.0,
                             TControl(fList.items[i]));
      end;

  cW := TForm(owner).clientwidth;
  cH := TForm(owner).clientheight;
  cF := TForm(owner).font.size;

end;

procedure TElasticForm.SaveIniFile;

var
  f : file;
  s : double;
  i : integer;
  ws : TWindowState;
  b : byte;


begin
  if (fElFrmIniFile <> '') then (*prepare ini file*)
    try
      assignFile(f,fElFrmIniFile);
      rewrite(f,1);

      BlockWrite(f,fTotalControls,sizeOf(fTotalControls));
      
      ws := TForm(owner).WindowState;

      if bMaxState then ws := wsMaximized
       else ws := wsNormal;

      BlockWrite(f,ws,SizeOf(ws));
      if bWindowPlacementMaximized then ws := wsMaximized;

      if (ws = wsNormal) then
        begin
          s := 1.0*TForm(owner).left/fScreenWidth;
          BlockWrite(f,s,sizeOf(s));
          s := 1.0*TForm(owner).top/fScreenHeight;
          BlockWrite(f,s,sizeOf(s));
          s := 1.0*TForm(owner).width/fScreenWidth;
          BlockWrite(f,s,sizeOf(s));
          s := 1.0*TForm(owner).height/fScreenHeight;
          BlockWrite(f,s,sizeOf(s));
          fWindowPlacement.Length := SizeOf (fWindowPlacement);
          GetWindowPlacement (FormHandle, @fWindowPlacement);
        end;

      if bMaxState then
        begin
          fMaximumTrackWidth := -round(TForm(owner).width/fScreenWidth*100);
          if fMaximumTrackWidth <= -100 then fMaximumTrackWidth := 0;
          fMaximumTrackHeight := -round(TForm(owner).height/fScreenHeight*100);
          if fMaximumTrackHeight <= -100 then fMaximumTrackHeight := 0;
        end;

      blockWrite(f,fMaximumTrackWidth,sizeOf(fMaximumTrackWidth));
      blockWrite(f,fMaximumTrackHeight,sizeOf(fMaximumTrackHeight));


      for i := 0 to fTotalControls-1 do
        begin
          b := byte(TControl(fList.items[i]).visible);
          BlockWrite(f,b,sizeOf(b));
        end;

      blockWrite(f,fWindowPlacement,SizeOf(fWindowPlacement));

      CloseFile(f);
    except
    end;
end;


procedure TElasticForm.RestoreFormFromIni;

var
   f : file;
   ws : TWindowState;
   i  : integer;
   b  : byte;

begin

  if fElFrmIniFile <> '' then (*Ini File has been defined*)
    begin
      if FileExists(fElFrmIniFile) then
        try
          AssignFile(f,fElFrmIniFile);
          reset(f,1);

          Blockread(f,i,sizeOf(i));
          if i <> fTotalControls then (*programmer has changed components.  exit*)
            exit;

          BlockRead(f,ws,SizeOf(ws));
          TForm(owner).WindowState := ws;

          if ws = wsNormal then
            begin
              fManualPosition := true;
              BlockRead(f,fManualLeft,sizeOf(fManualLeft));
              BlockRead(f,fManualTop,sizeOf(fManualTop));
              fManualSize := true;
              BlockRead(f,fManualWidth,sizeOf(fManualWidth));
              BlockRead(f,fManualHeight,sizeOf(fManualHeight));
            end
          else
            bWindowPlacementMaximized := true;

          blockRead(f,fMaximumTrackWidth,sizeOf(fMaximumTrackWidth));
          blockRead(f,fMaximumTrackHeight,sizeOf(fMaximumTrackHeight));

          if not (fList = nil) then
            begin
              for i := 0 to fTotalControls-1 do
                begin
                  BlockRead(f,b,sizeOf(byte));
                  TControl(fList.items[i]).visible := boolean(b);
              end;
            end;

            try
              blockRead(f,fWindowPlacement,SizeOf(fWindowPlacement));
              bWindowPlacement := true;
            finally
              closeFile(f);
            end;
        except
        end;
    end;

end;


procedure TElasticForm.DynamicCreationUpdate;

begin
  bFirstFormResize := false;
  bOnTheScreen := true;
  bDynamicCreation := true;
  DesignFormClientHeight := TForm(owner).ClientHeight;
  DesignFormClientWidth := TForm(owner).ClientWidth;
  DesignFormHeight := TForm(owner).Height;
  DesignFormWidth := TForm(owner).Width;
  DesignFormLeft := TForm(owner).Left;
  DesignFormTop := TForm(owner).Top;
  DesignPixelsPerInch := Screen.PixelsPerInch;
  DesignScreenHeight := fScreenHeight;
  DesignScreenWidth := fScreenWidth;
  font.Assign(TForm(owner).Font);
end;

function TElasticForm.DefinedMaxLeft: integer;
(*Left position of maximized form*)
begin
  result := 0;
  if fMaximizedPosX > 0 then
    result := fMaximizedPosX
  else if fMaximizedPosX < 0 then
    result := round(1.0*abs(fMaximizedPosX)*fDesignScreenWidth / 100);
end;

function TElasticForm.DefinedMaxTop : integer;
(*Top position of maximized form*)
begin
  result := 0;
  if fMaximizedPosY > 0 then
    result := fMaximizedPosY;
  if fMaximizedPosY < 0 then
    result := round(1.0*abs(fMaximizedPosY)*fDesignScreenHeight / 100);
end;

{$IFDEF EVALUATION}
{$I decrypt.inc}
{$ENDIF}

procedure TElasticForm.InitializeForm;



var
  i : integer;
  bProper : boolean;
{$IFDEF EVALUATION}
  s : string;
  {$I DEFCRYPT.INC}
{$ENDIF}



begin
  (* Find all controls, record their visible property and then hide them.
     This enhanses the loading speed *)

  if not fResolutionIndependence then
    begin
      fDesignScreenWidth := GetSystemMetrics (SM_CXMAXIMIZED);
      fDesignScreenHeight := GetSystemMetrics (SM_CYMAXIMIZED);
    end;

  with TForm(Owner) do
    begin
      t0 := top;
      l0 := left;
    end;

  if bListFree then
    begin
      fList.Free;
      fList := nil;
      bListFree := false;
    end;

  if fList = nil then
    begin
      fTotalControls := 0;
      fList := TList.create;
      fList.Clear;

      fParentList := TList.Create;
      fParentLIst.Clear;

      FindAllControls(TForm(owner));
      fTotalControls := fList.count;
      FInitTotalControls := FTotalControls;
      FindAllParentControls; (*only controls that are the parents need to be hidden*)

      {$IFDEF WIN32 THEN }
      ReAllocMem(fFrames,(fTotalControls+fDynamicControls)*SizeOf(TFrame));
      {$ELSE}
      GetMem(fFrames,(fTotalControls+fDynamicControls)*SizeOf(TFrame));
      {$ENDIF}


      (*Record the initial size and position of all the components BEFORE they are hidden.
        Otherwise, the order of two consecutive components that are both aligned to the top,
        or bottom, or right, or left may be reversed after hiding and reshowing.*)

      for i := 0 to fTotalControls-1 do
        begin
          fFrames^[i] := TFrame.create;
          fFrames^[i].PreInitialize(TControl(fList.items[i]));
          fFrames^[i].owner := self; (*ver 4*)
        end;

      RestoreFormFromIni;

      for i := 0 to (fTotalControls-1) do
        fFrames^[i].WasVisible := TControl(fList.items[i]).visible;

(*
      if not bDynamicCreation then
        HideAllControls;
*)
    end;

  if TForm(Owner).WindowState = wsMaximized then
    begin
      fDesignFormWidth := DesignScreenWidth;
      fDesignFormHeight := DesignScreenHeight;
      fDesignFormTop := DefinedMaxTop;
      fDesignFormLeft := DefinedMaxLeft;
    end;

  (*Define the corrections*)

  fBorderStyle := TForm(Owner).BorderStyle;

  bProper := false;
  if fDesignScreenWidth = 0 then
    begin
      fScreenCorrectionH := 1;
      bProper := true;
    end;

  if fDesignScreenHeight = 0 then
    begin
      fScreenCorrectionH := 1;
      bProper := true;
    end;
  if not bProper then
    begin
      fScreenCorrectionH := 1.0*fScreenWidth/fDesignScreenWidth;
      fScreenCorrectionV := 1.0*fScreenHeight/fDesignScreenHeight;
    end;

(*  fPixelsCorrection := sqrt(fScreenCorrectionV*fScreenCorrectionH); *)
  fPixelsCorrection := fScreenCorrectionV; (* Ver 4.02 - Force font to have the same hight*)

  (*bBeforeShow := false;*)
  bBeforeShow := bProper;

(*
  Record the Corrected Font of the form.  However, do not correct the font yet because
  changing the font causes many components to automatically resize before their original
  size has been recorded.
*)

  cf0 := MyTrunc(TForm(Owner).font.size*fPixelsCorrection);

  (*resize the form for initial resolution*)
  with TForm(Owner) do
    begin
      if not (BorderStyle = bsNone) then
        begin
          L0 := round(fDesignFormLeft*fScreenCorrectionH);
          T0 := round(fDesignFormTop*fScreenCorrectionV);
          cW0 := round(fDesignFormwidth*fScreenCorrectionH);
          cH0 := round(fDesignFormHeight*fScreenCorrectionV);
        end
      else
        begin
          L0 := round(fDesignFormLeft*fScreenCorrectionH);
          T0 := round(fDesignFormTop*fScreenCorrectionV);
          cW0 := round(fDesignFormClientWidth*fScreenCorrectionH);
          cH0 := round(fDesignFormClientHeight*fScreenCorrectionV);
        end;


      if fOwnerFormPosition = poDesigned then
        begin
          L0 := round(fDesignFormLeft*fScreenCorrectionH);
          T0 := round(fDesignFormTop*fScreenCorrectionV);
        end;

      if fOwnerFormPosition = poScreenCenter then
        begin
          L0 := (fScreenWidth - cW0) div 2;
          T0  := (fScreenHeight - cH0) div 2;
        end;

      (*poDeskTopCenter is the 6th definition within type TPosition, i.e.
      it is TPosition(5).  It is not defined in all version of Delphi and
      C++Builder.  Thus it done here in the way it follows so that it will
      work in all versions.*)
      if fOwnerFormPosition = TPosition(5) then
        begin
          L0 := (fScreenWidth - cW0) div 2;
          T0  := (fScreenHeight - cH0) div 2;
        end;

      if (L0 + cW0) > fScreenWidth  then begin L0 := (fScreenWidth - cW0) div 2; end;
      if (T0 + cH0) > fScreenHeight then begin T0  := (fScreenHeight - cH0) div 2; end;
      if L0 < 0 then begin L0 := 0;  end;
      if T0  < 0 then begin T0 := 0; end;

    end;

  fResizeCounter := 0;

  {$IFDEF EVALUATION THEN}
  if bEvaluate then
    begin
      bEvaluate := false;
      s := sEval;
      if not(csDesigning in ComponentState) then
        MessageDlg(Decrypt(s), mtInformation,[mbOK],0);


      if not IDERunning then
        begin
          {$ifdef DELPHI}
           s := sDelphi;
           MessageDlg(Decrypt(s),mtInformation,[mbOK],0);
          {$else}
           s := scpp;
           MessageDlg(Decrypt(s), mtInformation,[mbOK],0);
           {$endif}
           application.terminate;
           {$ifdef win32}
           halt;
           {$endif}
        end;
    end;
  {$ENDIF}



end;

procedure TElasticForm.ResizeFormMaintainingProportions;

var
  h,w : integer;
begin
  h := TForm(owner).height;
  w := TForm(owner).width;
  if (h+w) > (cHc + cWc) then bIncreasing := true
  else bIncreasing := false;
  if bIncreasing and ((w-cWc) > (h-cHc)) then
    h := round(1.0*w*cHc/cWc)
  else if bIncreasing and ((w-cWc) < (h-cHc)) then
    w := round(1.0*h*cWc/cHc)
  else if not bIncreasing and ((w-cWc) > (h-cHc)) then
    w := round(1.0*h*cWc/cHc)
  else if not bIncreasing and ((w-cWc) < (h-cHc)) then
    h := round(1.0*w*cHc/cWc);
  with TForm(Owner) do
    Setbounds(left, top, w, h);
end;

procedure TElasticForm.SetFont(aFont:TFont);

begin
  fFont.Assign(aFont);
  TForm(owner).font.Assign(fFont);
  TForm(owner).repaint;
end;


procedure TElasticForm.SetImage(Value: TImage);
begin
  if value = nil then
    begin
      FPictureAssigned := false;
      fBkGrndImage := value;
    end
  else
    begin
      FPictureAssigned := true;
      fBkGrndImage := Value;
      fBkGrndImage.visible := false;
    end;
end;

procedure TElasticForm.HideAllControls;

var
  i : integer;

begin

  for i := fParentList.Count - 1 downto 0 do
    TControl(fParentList.items[i]).visible := false;

  bControlsAreHidden := true; (* ver 4.02 *)

end;


procedure TElasticForm.ShowAllControls;

var
  i : integer;

begin
  (*Switched order from last to first.  This is better because of the way
    that the controls have been found.  What this change does is enforces
    the parent controls to be shown first*)

  for i := 0 to fTotalControls  - 1 do (*back to pre - 4.02 way*)
    TControl(fList.items[i]).visible := fFrames^[i].WasVisible;


  bControlsAreHidden := false; (* ver 4.02 *)

end;

procedure TElasticForm.TerminateForm;
begin
  SendMessage(FormHandle,wm_SYSCOMMAND,SC_CLOSE,0);
end;

procedure TElasticForm.IncludeToResizing(aControl:String;aProperty:String; ResizeOrientation : TResizeOrientation); (*4.01*)

  (*/////////////////////////////////////////////*)
  procedure FindProperties(aProperty:String; addedProperties:TStringList);
  var
    i, StartPos, EndPos : integer;
    s,sn : string;

  begin
    s := aProperty;
    addedProperties.Clear;
    StartPos := 1;
    for i := 1 to length(s) do
      begin
        if (s[i] = '.') or (i = length(s)) then
          begin
            EndPos := i;
            sn := copy(s,StartPos,(EndPos-StartPos+1));
            if sn[length(sn)] = '.' then
            sn := copy(sn,1,Length(sn)-1);
            addedProperties.Add(sn);
            StartPos := i+1;
          end;
      end;
  end;
(*/////////////////////////////////////////////*)

var
  i : integer;
  bFound : boolean;

begin
  if fList = nil then
    begin
      fList := TList.create;
      fList.Clear;
      FindAllControls(Tform(owner));
    end;
  bListFree := true; (*Eventually fList must be freed to be populated again
                       in InitializeForm*)
  {$ifdef win32}
  ReAllocMem(PartialControlArray,(PartialControlArrayCounter+1)*SizeOf(TPartialControl));
  {$else}
(*  ReAllocMem(PartialControlArray,(PartialControlArrayCounter+1)*SizeOf(TPartialControl),0);*)
  GetMem(PartialControlArray,(PartialControlArrayCounter+1)*SizeOf(TPartialControl));
  {$endif}

  bFound := false;

  for i := 0 to fList.Count-1 do
    begin
      if UpperCase(TControl(flist.items[i]).name)  = UpperCase(aControl) then
        begin
          PartialControlArray^[PartialControlArrayCounter] := TPartialControl.Create;
          PartialControlArray^[PartialControlArrayCounter].aControl := TControl(flist.items[i]);
          bFound := true;
          break;
        end;
    end;
  if not bFound then exit;
  FindProperties(aProperty, PartialControlArray^[PartialControlArrayCounter].addedProperties);
  PartialControlArray^[PartialControlArrayCounter].ResizeOrientation := ResizeOrientation;
  Inc(PartialControlArrayCounter);
end;


procedure TElasticForm.TilePicture(DC: hDC);
var
  CRect, IRect: TRect;
  I, J, Rows, Cols, CRow, CCol: Integer;
begin
  { Get size of client and image }
  if TForm(owner).clientHandle > 0 then
    GetClientRect(TForm(owner).ClientHandle, CRect)
  else
    GetClientRect(TForm(owner).Handle, CRect);
  IRect := Rect(0,0,fBkGrndImage.picture.width,fBkGrndImage.picture.Height);
  { Calculate required # of rows and columns }
  if not (fBkGrndImage.Align = alClient) then
    begin
      Cols := CRect.Right div IRect.Right;
      Rows := CRect.Bottom div IRect.Bottom;
      { Blast the bitmaps on the client }
      for I := 0 to Rows do
        begin
          CRow := I * IRect.Bottom;
          for J := 0 to Cols do
          begin
            CCol := J * IRect.Right;
            BitBlt(DC, CCol-J, CRow-I, IRect.Right, IRect.Bottom,
              fBkGrndImage.canvas.handle, 0, 0, SRCCOPY);
          end;
        end;
    end
  else
    StretchBlt(DC,0,0,TForm(Owner).width,TForm(Owner).height,fBkGrndImage.canvas.handle,
       0,0,fBkGrndImage.picture.width, fBkGrndImage.picture.height,SRCCOPY);

end;


(******************************************************************************)
(**NewMDIClientWndMethod : Substitute default method for the client window of**)
(************ the parent window if that is MDIForm parent window **************)
(******************************************************************************)

procedure TElasticForm.NewMDIClientWndMethod (var Msg: TMessage);


begin

  if Msg.Msg = wm_EraseBkGnd then
    begin
      if FPictureAssigned then
          TilePicture(Msg.WParam)
      else
        Msg.Result := CallWindowProc (OldMDIClientWndProc,
          MDIClientFormHandle, Msg.Msg, Msg.WParam, Msg.LParam);
    end
  else
    Msg.Result := CallWindowProc (OldMDIClientWndProc,
        MDIClientFormHandle, Msg.Msg, Msg.WParam, Msg.LParam);
end;

(******************************************************************************)
(**********NewWndMethod : Substitute default method for parent window *********)
(******************************************************************************)

procedure TElasticForm.NewWndMethod (var Msg: TMessage);

var
  pMinMax          : PMinMaxInfo;
  FocusHandle      : HWND;
  xo,yo            : integer;
  l,t,w,h          : integer;
  rx,ry            : double;

begin

  if bDisableResize then
    begin
        Msg.Result := CallWindowProc (OldWndProc,
          FormHandle, Msg.Msg, Msg.WParam, Msg.LParam);
        exit;
    end;

  GlobalInt := Msg.Msg;

  FocusHandle := GetFocus;

  if (Tform(owner).font.color <> font.color)
    or (tform(owner).font.size <> font.size) then
      setfont(font); (*ver 2.62*)

  if bBeforeShow then
    begin
      InitializeForm;
      cWc := cW0;
      cHc := cH0;

      (*ver 4.02*)
      if bMaintainProportions then
        FindProperMaxSizes;

      if not bDynamicCreation then
        hideAllControls;

      (*when an MDI chind window is first opened the wm_size message is not called.*)
      if TForm(Owner).FormStyle = fsMDIChild then
        begin
(*ver 3.04 - begin*)
          xo := TForm(Owner).Left;
          yo := TForm(Owner).top;
          TForm(Owner).Setbounds(xo, yo, CW0, CH0);(*Call it here to force size*)
(*ver 3.04 - end;*)
          ResizeForm;
          fResizeCounter := 10000;
(*ver 3.04 - begin*)
          TForm(Owner).Setbounds(xo, yo, CW0, CH0); (*Needs to be Called  here to enfforce position*)
(*ver 3.04 - end;*)

       end
      else if TForm(Owner).FormStyle = fsMDIForm then
        begin
          TForm(Owner).Setbounds(L0, T0, CW0, CH0);
        end;
    end;

  if fManualPosition then
    begin
      fManualPosition := false; (*Just do it once*)
      L0 := round(fManualLeft*fScreenWidth);
      T0 := round(fManualTop*fScreenHeight);
      TForm(Owner).Setbounds(L0, T0, CW0, CH0);
    end;

(******************************************************************************)

  MessageNumber := Msg.Msg;

  case Msg.Msg of

    wm_GetMinMaxInfo:
      begin

        if bFirstTime and (TForm(Owner).WindowState = wsMaximized) then
          begin
            ResizeForm;
            if bAfterMaximize then (*The form has not been designed to
                          be maximized but it is asked to be maximized
                          at start-up*)
                bAfterMaximize := false;
          end
       (*We do not want to do this the first time around.  All these checks
              should be available after the form appears on the screen resized at
              to the same relative dimensions during design time: Thus it can occur
              only if not bFirstTime*)
        else if bFirstTime then
          begin
            bAfterMaximize := true;
          end;

{
        if bMaintainProportions then
          FindProperMaxSizes;
}
{
          begin
            if 1.0*cW0/cH0 > 1.0*fScreenWidth/fScreenHeight then
              begin
                fMaximumTrackHeight := round(1.0*fScreenWidth*cH0/cW0);
                fMaximizedHeight := fMaximumTrackHeight;//round(1.0*fScreenWidth*cH0/cW0);
                if fOwnerFormPosition = poScreenCenter then
                  fMaximizedPosY := (fScreenHeight - fMaximumTrackHeight) div 2;
              end
            else
              begin
                fMaximumTrackWidth := round(1.0*fScreenHeight*cW0/cH0);
                fMaximizedWidth := fMaximumTrackWidth;//round(1.0*fScreenHeight*cW0/cH0);
                if fOwnerFormPosition = poScreenCenter then
                  fMaximizedPosX := (fScreenWidth - fMaximumTrackWidth) div 2;
              end;
          end;
}
        if ((fMaximizedWidth + fMaximizedHeight + fMaximizedPosX +
          fMaximizedPosY + fMinimumTrackWidth + fMinimumTrackHeight +
          fMaximumTrackWidth + fMaximumTrackHeight) <> 0) and (not bFirstTime) then
            begin
              pMinMax := PMinMaxInfo (Msg.lParam);
              if fMaximizedWidth <> 0 then
                pMinMax^.ptMaxSize.X := fMaximizedWidth;
              if fMaximizedHeight <> 0 then
                pMinMax^.ptMaxSize.Y := fMaximizedHeight;
              if fMaximizedPosX > 0 then
                pMinMax^.ptMaxPosition.X := fMaximizedPosX;
              if fMaximizedPosX < 0 then
                pMinMax^.ptMaxPosition.X := round(1.0*abs(fMaximizedPosX)*fScreenWidth / 100);
              if fMaximizedPosY > 0 then
                pMinMax^.ptMaxPosition.Y := fMaximizedPosY;
              if fMaximizedPosY < 0 then
                pMinMax^.ptMaxPosition.Y := round(1.0*abs(fMaximizedPosY)*fScreenHeight / 100);
              if fMinimumTrackWidth > 0 then
                pMinMax^.ptMinTrackSize.X := fMinimumTrackWidth;
              if fMinimumTrackWidth < 0 then
                pMinMax^.ptMinTrackSize.X := round(1.0*abs(fMinimumTrackWidth)*fScreenWidth / 100);
              if fMinimumTrackHeight > 0 then
                pMinMax^.ptMinTrackSize.Y := fMinimumTrackHeight;
              if fMinimumTrackHeight < 0 then
                pMinMax^.ptMinTrackSize.Y := round(1.0*abs(fMinimumTrackHeight)*fScreenHeight / 100);
              if fMaximumTrackWidth > 0 then
                pMinMax^.ptMaxTrackSize.X := fMaximumTrackWidth;
              if fMaximumTrackWidth < 0 then
                pMinMax^.ptMaxTrackSize.X := round(1.0*abs(fMaximumTrackWidth)*fScreenWidth / 100);
              if fMaximumTrackHeight > 0 then
                pMinMax^.ptMaxTrackSize.Y := fMaximumTrackHeight;
              if fMaximumTrackHeight < 0 then
                pMinMax^.ptMaxTrackSize.Y := round(1.0*abs(fMaximumTrackHeight)*fScreenHeight / 100);
            end;
      end;

    wm_Size :

      if (not bTemporaryDisableResize) and (not (Msg.WParam = SIZE_MINIMIZED))(*ver 4.0*)then
        begin
          (*maximizing and coming back from maximized form are not handled by wm_sizing*)
          if (Msg.wParam = SIZE_MAXIMIZED) then
            begin
              if not bmaxState then (*ver 3.04*)
                begin
                  FocusHandle := GetFocus; (*Get control that has focus*)
                  hideAllControls;
                  bOnTheScreen := true;
                  bMaxState := true;
                  setfont(fFont); (*ver 2.62*)
                end;
            end;
          if bOnTheScreen and (Msg.wParam = SIZE_RESTORED) then
            begin
              if bMaxState then
                begin
                  FocusHandle := GetFocus; (*Get control that has focus*)
                  hideAllControls;
                end;
              bFirstFormResize := false;  (*coming back from maximized form*)
              bMaxState := false;
              setfont(fFont); (*ver 2.62*)
            end;
          if not AllowNoBorderResize then
            if ((TForm(Owner).BorderStyle = bsNone) or bFirstFormResize or not bOnTheScreen) then
            TForm(Owner).Setbounds(L0, T0, CW0, CH0);
           (*ver 3.04 - begin;*)
          if TForm(Owner).FormStyle = fsMDIChild then
            hideAllControls;

          (*ver 3.04 - end;*)
          ResizeForm;
          TForm(owner).repaint;
          ShowAllControls;
          SetFocus(FocusHandle);   (*Set Focus back to control that had it.*)
          SaveIniFile;
        end;

    wm_Sizing:
      begin
        bTemporaryDisableResize := true;
        bMustResize := true;
      end;

    wm_EraseBkGnd :
      begin
        if not (TForm(Owner).FormStyle = fsMDIForm) and not (TForm(Owner).FormStyle = fsMDIChild) then
          begin
            if FPictureAssigned then
              begin
                TilePicture(Msg.WParam);
                Msg.result := 0;
                exit;
              end
            else
              Msg.Result := CallWindowProc (OldWndProc,
                FormHandle, Msg.Msg, Msg.WParam, Msg.LParam);
              end;
      end;

    wm_ShowWindow:
      begin
        (*Make sure that TForm(Owner).Setbounds(L0, T0, CW0, CH0); from above
          will not be called again.  It just needed to be don the first time
          until the window became visible on the screen*)
        (*CORRECTION IN VERSION 3.0 : IT STOPS THE FORM FROM SHOWING THE WRONG SIZE BEFORE IT RESIZES THE FIRST TIME*)
        if bFirstFormResize then
          if (TForm(Owner).FormStyle <> fsMDIChild) then
            TForm(Owner).Setbounds(L0, T0, CW0, CH0)
          else  (*if MDI child*)
            begin
              hideAllControls;
              ResizeForm;
              ShowAllControls;
            end;
        bFirstFormResize := false;

        if fManualSize then
          begin
            if not fResolutionIndependence then (*ver 4.02*)
              HideAllControls;
            fManualSize := false; (*Just do it once*)
            CW0 := round(fManualWidth*fScreenWidth);
            CH0 := round(fManualHeight*fScreenHeight);
            TForm(Owner).Setbounds(L0, T0, CW0, CH0); (*This forces a FormResize call*)
          end;
        if not bDisableOnShow then
          begin
            HideAllControls; (*ver 4.02 - removes start-up flicker*)
            ResizeForm;      (*ver 4.02 - removes start-up flicker*)
            ShowAllControls; (*ver 4.02 - removes start-up flicker*)
          end;
        (*Message handled and exit should not be used here, otherwise, simple minimize
          process will not be handled*)
      end;


    wm_EnterSizeMove:
      begin
        bFramesInitialize := true;
        cWc := TForm(Owner).width;
        cHc := TForm(Owner).height;
      end;


    wm_ExitSizeMove:
      begin
        bTemporaryDisableResize := false;
        if bMustResize then
          begin
            FocusHandle := GetFocus; (*Get control that has focus*)
            hideAllControls;
            if bMaintainProportions then
              ResizeFormMaintainingProportions
            else
              ResizeForm;
            TForm(owner).repaint;
            ShowAllControls;
            SetFocus(FocusHandle);   (*Set Focus back to control that had it.*)
            bMustResize := false;
          end;
        bMaxState := false;
        SaveIniFile;
      end;

    (*wm_activate and wm_windowposchanging are working together.
      wm_windowposchanging is called first with fresizecounter = 0.
      So, for a while bOnTheScreen is false.  Once WM_ACtivate is
      called then fResizeConter = 10000.  Next time that wm_windowposchanging
      is called the bOnthescreen becomes true*)


    WM_ACTIVATE :
      begin
        fResizeCounter := 10000; (*fResizeCounter can be set to any
                                            initial number larger than 2.  However,
                                            the more the forms that are used by an
                                            application the higher it should be.*)

        if bWindowPlacement then
          if bWindowPlacementMaximized then
            begin
              TForm(owner).WindowState := wsMaximized;
              bWindowPlacement := false;
              bWindowPlacementMaximized := false;
              fWindowPlacement.showCmd := SW_SHOWMAXIMIZED;
              SetWindowPlacement (FormHandle, @fWindowPlacement);
            end;

      end;

    WM_DISPLAYCHANGE : (*ver 4.02*)
      begin
        xo := fDesignScreenWidth;
        yo := fDesignScreenHeight;
        fDesignScreenWidth := GetSystemMetrics (SM_CXMAXIMIZED);
        fDesignScreenHeight := GetSystemMetrics (SM_CYMAXIMIZED);
        rx := 1.0*fDesignScreenWidth/xo;
        ry := 1.0*fDesignScreenHeight/yo;
        l  := round(TForm(Owner).left*rx);
        t  := round(TForm(Owner).top*ry);
        w  := round(TForm(Owner).width*rx);
        h  := round(TForm(Owner).height*ry);
        TForm(Owner).Setbounds(l, t, w, h);
        HideAllControls;
        ResizeForm;
        ShowAllControls;
      end;

    WM_WINDOWPOSCHANGING :
      begin
        inc(fResizeCounter);
        if fResizeCounter >= 10000 then
          bOnTheScreen := true;
      end;

    WM_SYSCOMMAND:
      begin
        if msg.WParam = sc_Close then (*4.03*)
          begin
            SaveIniFile; (*4.03*)
            bDisableOnShow := true
          end
        else
          bDisableOnShow := false;
      end;

    WM_Destroy :
      if Assigned (NewWndProc) then
        begin
          SetWindowLong(FormHandle,gwl_WndProc,LongInt(OldWndProc));
          FreeObjectInstance (NewWndProc);
          NewWndProc := nil;
          Msg.Result := 0;
        end;


  end;

(******************************************************************************)
(******************************************************************************)

  Msg.Result := CallWindowProc (OldWndProc,
      FormHandle, Msg.Msg, Msg.WParam, Msg.LParam);

end;


end.



