program DeskTop;

(*
Transparent Desktop utility by Kitchentable Software
an Application Software Division of Q-Systems Engineering
Copyright by Q-Systems Engineering

Date of release October 9, 1998
Version 1.00
*)

uses
  windows,CommCtrl;


Const
  SLEEP_TIME = 1000;//Check every 1 second if the Desktop colors have changed.

var
  fListView: hWnd;
  color : integer;
  bkColor : integer;
  Code  : integer;
  bRandomTextColor : boolean;
  bRandomTextBkColor : boolean;
  f                  : file;
  done               : boolean;
  bChanged           : boolean;
  fg,bg              : integer;
  bContinuous        : boolean;


function FileExists(const FileName: string): boolean;
var
  Handle: THandle;
  FindData: TWin32FindData;

begin
  Handle := FindFirstFile(PChar(FileName), FindData);
  result := Handle <> INVALID_HANDLE_VALUE;
end;

function DeleteFile(const FileName: string): Boolean;
begin
  Result := Windows.DeleteFile(PChar(FileName));
end;


var
  p1, p2 : string;

begin
    //Check if file Dekstop.end exists and if so delete it.  It is simply a
    // remnant of unrully termination of this program
    if FileExists('Desktop.end') then
      DeleteFile('Desktop.end');

    //Check if the program is already running.  If so then then purpose of this
    //instanse is to simply terminate the running instanse
    CreateMutex(nil,false,'DeksTop');
    if GetLastError = ERROR_ALREADY_EXISTS then //Yes it is
      begin
        //Create a File as a terminate message to the running instanse and terminate
        assignFile(f,'Desktop.end');
        rewrite(f);
        closeFile(f);
        halt;
      end;

    //Set the execution of the program to the lowest priority.
    //We do not want this program to influence the performance of any other
    //running programs.
    SetThreadPriority(GetCurrentThread,THREAD_PRIORITY_LOWEST);
    //No other instanse is running.  Run this instanse
    color := 16777215;   //white
    bkcolor := -1; // transparent
    bRandomTextColor := false;
    bRandomTextBkColor := false;
    bContinuous := false;

    if paramCount > 0 then //ParamStr(1) is for Text
      begin
        p1 := CharLower(PChar(ParamStr(1)));
        if p1[1] = '#' then
          begin
            p1 := copy(p1,2,length(p1));
            bContinuous := true;
          end;
        if p1 = 'h' then
          winexec(PChar('notepad.exe DeskTop.txt'),SW_SHOWNORMAL);
        if p1 = 'r' then bRandomTextColor := true
        else if p1 = 'white' then
          color := 16777215
        else if p1 = 'black' then
          color := 0
        else if p1 = 'yellow' then
          color := 8454143
        else if p1 = 'lime' then
          color := 65280
        else if p1 = 'orange' then
          color := 33023
        else if p1 = 'red' then
          color := 255
        else if p1 = 'green' then
          color := 32768
        else if p1 = 'blue' then
          color := 16711680
        else if p1 = 'fuchsia' then
          color := 16711935
        else if p1 = 'brown' then
          color := 128
        else if p1 = 'teal' then
          color := 8421440
        else if p1 = 'navy' then
          color := 8388608
        else
          begin
            {$I-}
            Val(p1,color,Code);
            if Code <> 0 then Color := 16777215;//white
            {$I+}
          end;
      end;

    if paramCount = 2 then //ParamStr(2) is for Text background
      begin
        p2 := CharLower(PChar(ParamStr(2)));
        if p2 = 'r' then bRandomTextBkColor := true
        else if p2 = 'white' then
          bkColor := 16777215
        else if p2 = 'black' then
          bkColor := 0
        else if p2 = 'yellow' then
          bkColor := 8454143
        else if p2 = 'lime' then
          bkcolor := 65280
        else if p2 = 'orange' then
          bkcolor := 33023
        else if p2 = 'red' then
          bkcolor := 255
        else if p2 = 'green' then
          bkcolor := 32768
        else if p2 = 'blue' then
          bkcolor := 16711680
        else if p2 = 'fuchsia' then
          bkcolor := 16711935
        else if p2 = 'brown' then
          bkcolor := 128
        else if p2 = 'teal' then
          bkcolor := 8421440
        else if p2 = 'navy' then
          bkcolor := 8388608
        else if p2 = 'transparent' then
          bkcolor := -1
        else
          begin
            {I-}
            Val(p2,color,Code);
            if Code <> 0 then bkcolor := -1; // transparent
            {I+}
          end;
      end;

    fListView := GetDesktopWindow;
    // Search through desktop children for the shell
    fListView := FindWindowEx (fListView, 0, 'Progman', 'Program Manager');
    // Search shell's children for the shell default view
    fListView := FindWindowEx (fListView, 0, 'SHELLDLL_DefView', nil);
    // Finally, get the listview that's inside the shell default view
    fListView := FindWindowEx (fListView, 0, 'SysListView32', nil);

    if bRandomTextBkColor then
      begin
        randomize;
        ListView_SetTextBkColor(fListView,random($FFFFFFFF-1));
      end
    else
      ListView_SetTextBkColor(fListView,bkColor);

    if bRandomTextColor then
      begin
        if not bRandomTextBkColor then
          randomize;
        ListView_SetTextColor(fListView,random($FFFFFFFF-1));
      end
    else
      ListView_SetTextColor(fListView,color);

    InvalidateRect (fListView, Nil, True);

    //There is no point in timer run of the program if it uses random colors
    if integer(bRandomTextColor)+integer(bRandomTextBkColor) > 0 then halt;
    if not bContinuous then halt;

    //Simulate a timer
    repeat
      Sleep(SLEEP_TIME);//wait for 2 seconds
      done := FileExists('DeskTop.end'); //Terminate message exists
      bg := ListView_GetTextbkColor(fListView);
      fg := ListView_GetTextColor(fListView);
      bChanged := (color <> fg) or (bkcolor <> bg);
      if bChanged then
        begin
          ListView_SetTextColor(fListView,color);
          ListView_SetTextbkColor(fListView,bkcolor);
          InvalidateRect (fListView, Nil, True);
        end;
    until done;
    
  DeleteFile('DeskTop.end'); //If I have come here, the terminate file exists.
end.

