unit Qspaint;


(******************************************************************************
    TQSPaintBox Component. - It is meant to work as an integral part of TQSWorldGraph



    Version BETA.  Last Update July 6, 1998
    Copyright : Q-Systems Engineering. 8950 N. Calle Buena Vista. Tucson AZ


    Version BETA - Release 2  July 16, 1998
       ADDED: bRedraw Public boolean.  It starts as TRUE.  It is set false after
       the OnPaint event of TQSWorldGraph occurs.  When bRedraw is false, the repaint
       event of QSPaint is NOT called.


******************************************************************************)

(******************************************************************************)

(*
    ******************************************************************************
    ******************************************************************************
    COPYRIGHT NOTICE:
    THE SOURCE OF THIS COMPONENT IS PROVIDED AS A PERSONAL COPY.  Q-SYSTEMS ENGINEERING
    CLAIMS NO ROYALTIES FOR THE USE OF TQSPaintBox IN YOUR PROGRAMS.  HOWEVER, YOU MAY
    NOT DISTRIBUTE THE SOURCE -IN PART OR WHOLE-, THE .DCU, OR THE .OBJ OF THIS FILE.

    ******************************************************************************
    ******************************************************************************
*)

interface

uses
  {$IFDEF WIN32}Windows,{$ELSE}
  WinTypes, WinProcs,{$ENDIF} Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  extctrls,wGraph,pbRulers;

{$ifdef VER110} {CBUILDER 3}
{$ObjExportAll On}
{$ENDIF}
  

const
  MAX_POLYGON_POINTS = {$IFDEF WIN32 THEN}1000 {$ELSE}200{$ENDIF};

type

  TWPoint = record
    x  : double;
    y  : double;
  end;

  TPCPoint = record
    x  : integer;
    y  : integer;
  end;

  TWPointArray = array[1..MAX_POLYGON_POINTS] of TWPoint;


  TXIncrease = (LeftToRight,RightToLeft);
  TYIncrease = (BottomToTop,TopToBottom);
  TMapMode   = (ANISOTROPIC,HIENGLISH,HIMETRIC,ISOTROPIC,LOENGLISH,LOMETRIC,aTEXT,TWIPS);
(*
  The above MapModes correspond to the MapModes of Windows function:
           SetMapMode(DC: HDC; MapMode: Integer): Integer;
  MM_ANISOTROPIC     Logical units are converted to arbitrary units with arbitrarily scaled axes.
                     Setting the mapping mode to MM_ANISOTROPIC does not change the current window or viewport settings.
                     To change the units, orientation, and scaling, an application should use the SetWindowExt
                     and SetViewportExt functions.
  MM_HIENGLISH	     Each logical unit is converted to 0.001 inch. Positive x is to the right; positive y is up.
  MM_HIMETRIC	     Each logical unit is converted to 0.01 millimeter. Positive x is to the right; positive y is up.
  MM_ISOTROPIC	     Logical units are converted to arbitrary units with equally scaled axes; that is,
                     one unit along the x-axis is equal to one unit along the y-axis.
                     The SetWindowExt and SetViewportExt functions must be used to specify the
                     desired units and the orientation of the axes. GDI makes adjustments as necessary to ensure
                     that the x and y units remain the same size.
  MM_LOENGLISH	     Each logical unit is converted to 0.01 inch. Positive x is to the right; positive y is up.
  MM_LOMETRIC	     Each logical unit is converted to 0.1 millimeter. Positive x is to the right; positive y is up.
  MM_TEXT	     Each logical unit is converted to one device pixel. Positive x is to the right; positive y is down.
  MM_TWIPS           Each logical unit is converted to 1/20 of a point. (Because a point is 1/72 inch, a twip is 1/1440 inch).
                     Positive x is to the right; positive y is up.
*)

type
  TQSPaintBox = class(TPaintBox)
  private
    fXMinDesired  : double;
    fXMaxDesired  : double;
    fYMinDesired  : double;
    fYMaxDesired  : double;
    fXMinZoom     : double;
    fXMaxZoom     : double;
    fYMinZoom     : double;
    fYMaxZoom     : double;
    bZoom         : boolean;
    fProportional : boolean;

    procedure SetXMin(value:double);
    procedure SetXMax(value:double);
    procedure SetYMin(value:double);
    procedure SetYMax(value:double);

  protected
    ResetPenColor  :TColor;
    ResetPenMode   :TPenMode;
    ResetPenStyle  :TPenStyle;
    ResetPenwidth  :integer;


  public

    FOnPaint      : TNotifyEvent;
    FXMin         : double;
    FXMax         : double;
    FYMin         : double;
    FYMax         : double;
    XIncrease     : TXIncrease;
    YIncrease     : TYIncrease;
    BReDraw       : boolean;
    FCurrentCanvas : TCanvas;

    procedure    SetProportional(value:boolean);
    procedure    SetPrintProportional(value:boolean;multiplier:double);
    procedure    Paint; override;
    constructor  Create(AOwner: TComponent); override;
    destructor   Destroy; override;
    procedure    Zoom(x1,y1,x2,y2:double);
    procedure    ResetZoom;
    function     Wxy(PCx,PCy:integer):TWPoint;
    function     PCxy(wx,wy:double):TPCPoint;
    procedure    WorldLineTo (Wx,Wy:double);
    procedure    WorldMoveTo (Wx,Wy:double);

    procedure    WorldArc(WX1, WY1, WX2, WY2, WX3, WY3, WX4, WY4: Double);
    procedure    WorldEllipse(WX1, WY1, WX2, WY2: Double);

    procedure    WorldQuad4 (Wx1,Wy1,Wx2,Wy2,Wx3,Wy3,Wx4,Wy4:Double;
                   color:TColor;bShowBoundary:boolean);
    procedure    WorldQuad8 (Wx1,Wy1,Wx2,Wy2,Wx3,Wy3,Wx4,Wy4:Double;
                                   Wx5,Wy5,Wx6,Wy6,Wx7,Wy7,Wx8,Wy8:Double;
                                   color:TColor;bShowBoundary:boolean);

    procedure    WorldPolygon(NumberOfPoints:word; Points: TWPointArray;
                           PenColor,FillColor:TColor;bShowBoundary:boolean);

    procedure    SquarePoint(PointSize:integer;x,y:Double;color:TColor);
    procedure    TrianglePoint(PointSize:integer;x,y:Double;color:TColor);
    procedure    CirclePoint(PointSize:integer;x,y:Double;color:TColor);
    procedure    EmptySquarePoint(PointSize:integer;x,y:Double;color:TColor);
    procedure    EmptyTrianglePoint(PointSize:integer;x,y:Double;color:TColor);
    procedure    EmptyCirclePoint(PointSize:integer;x,y:Double;color:TColor);
    procedure    CrossPoint(PointSize:Integer;x,y:Double;Color:TColor);

    procedure    SetPen(PenColor:TColor;PenMode:TPenMode;PenStyle:TPenStyle;PenWidth:integer);
    procedure    ResetPen;

    procedure    DrawCrossAt(pm:TPenMode;X,Y:Integer);
    property     Canvas;


(*  published *)
    property Align default alNone;
    property Color default clWhite;
    property Height default 100;
    property Width default 100;
    property Top   default 10;
    property Left  default 10;
    property Visible default true;
    property XMin:double read fXMinDesired write SetXMin;
    property XMax:double read fXMaxDesired write SetXMax;
    property YMin:double read fYMinDesired write SetYMin;
    property YMax:double read fYMaxDesired write SetYMax;
    property Proportional:boolean read fProportional write SetProportional default true;

    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnPaint:TNotifyEvent read fOnPaint write fOnPaint;
  end;



(******************************************************************************)
(******************************************************************************)

implementation

uses
  QSGraph;

(******************************************************************************)

constructor TQSPaintBox.Create(AOwner: TComponent);

begin

  inherited Create(AOwner);
  parent := TWinControl(AOwner);

  fCurrentCanvas := canvas;
  Color    := clGray;

  Left     := 10;
  Top      := 10;
  width    := 100;
  height   := 100;

  fXMin    := 0;
  fXMax    := 10;
  fYMin    := 0;
  fYMax    := 10;

  fXMinDesired    := 0;
  fXMaxDesired    := 10;
  fYMinDesired    := 0;
  fYMaxDesired    := 10;
  fProportional   := true;
  bZoom           := false;
  XIncrease       := LeftToRight;
  YIncrease       := BottomToTop;

  bRedraw         := true;
end;

destructor TQSPaintBox.destroy;

begin
  inherited destroy;
end;
(******************************************************************************)

procedure TQSPaintBox.Paint;

begin
  if bRedraw then
    SetProportional(fProportional);
end;

(******************************************************************************)

procedure TQSPaintBox.SetXMin(value:double);
begin
  if fXMinDesired <> value then
    begin
      fXMinDesired := value;
      paint;
    end;
end;

(******************************************************************************)

procedure TQSPaintBox.SetXMax(value:double);
begin
  if fXMaxDesired <> value then
    begin
      fXMaxDesired := value;
(*      SetProportional(fProportional);*)
      paint;
    end;
end;

(******************************************************************************)

procedure TQSPaintBox.SetYMin(value:double);
begin
  if fYMinDesired <> value then
    begin
      fYMinDesired := value;
(*      SetProportional(fProportional);*)
      paint;
    end;
end;

(******************************************************************************)

procedure TQSPaintBox.SetYMax(value:double);
begin
  if fYMaxDesired <> value then
    begin
      fYMaxDesired := value;
      paint;
    end;
end;

(******************************************************************************)


procedure TQSPaintBox.SetPrintProportional(value:boolean;multiplier:double);

(*if false, then the world coordinates are attached to the PC coordinates as are.
  If true then PC and World coordinates must maintain the same proportions.  For
  example, if the X and Y PC ranges are 100 and 100 while the X and Y world
  ranges are 10 and 5 then the world range should not cover the entire canvas of
  the component, or the drawn shapes will be unrealistic.*)

var
 XRange,YRange  : double;
 wYXRatio,PCYXRatio : double;
 TempLow,TempHigh   : double;
 TempRange          : double;
 aLeft,aRight       : double;
 aTop,aBottom       : double;

begin

  fProportional := value;
  if not bZoom then
    begin
      fXMin := fXMinDesired;
      fXMax := fXMaxDesired;
      fYMin := fYMinDesired;
      fYMax := fYMaxDesired;
    end
  else
    begin
      fXMin := fXMinZoom;
      fXMax := fXMaxZoom;
      fYMin := fYMinZoom;
      fYMax := fYMaxZoom;
    end;

  if not fProportional then
    begin
      if XIncrease = LeftToRight then
        begin
          aLeft := fXMin;
          aRight := fXMax;
        end
      else
        begin
          aLeft := fXMax;
          aRight := fXMin;
        end;

      if YIncrease = BottomToTop then
        begin
          aTop := fYMax;
          aBottom := fYMin;
        end
      else
        begin
          aTop := fYMin;
          aBottom := fYMax;
        end;

      SetWorldWindow(aLeft,aRight,aTop,aBottom,0,0,0,0);
      SetPCWindow(0, round(multiplier*width),0,round(multiplier*height));
      exit;
    end;

  xRange := fXMax - fXMin;
  yRange := fYMax - fYMin;
  wYXRatio := yRange/xRange;
  PCYXRatio := 1.0*height/width;

  if wYXRatio > PCYXRatio then (*world system is "taller" than pc system*)
    begin
      TempRange := xRange*wYXRatio/PCYXRatio;
      TempLow := (fXMin+fXMax)*0.5 - TempRange*0.5;
      TempHigh := (fXMin+fXMax)*0.5 + TempRange*0.5;
      fXmin := TempLow;
      fXMax := TempHigh;
    end
  else if wYXRatio < PCYXRatio then
    begin
      TempRange := yRange*PCYXRatio/wYXRatio;
      TempLow := (fYMin+fYMax)*0.5 - TempRange*0.5;
      TempHigh := (fYMin+fYMax)*0.5 + TempRange*0.5;
      fYMin := TempLow;
      fYMax := TempHigh;
    end;


  if XIncrease = LeftToRight then
    begin
      aLeft := fXMin;
      aRight := fXMax;
    end
  else
    begin
      aLeft := fXMax;
      aRight := fXMin;
    end;

  if YIncrease = BottomToTop then
    begin
      aTop := fYMax;
      aBottom := fYMin;
    end
  else
    begin
      aTop := fYMin;
      aBottom := fYMax;
    end;

  SetWorldWindow(aLeft,aRight,aTop,aBottom,0,0,0,0);
  SetPCWindow(0, round(multiplier*width), 0,round(multiplier*height));
end;

(******************************************************************************)

procedure TQSPaintBox.SetProportional(value:boolean);

(*if false, then the world coordinates are attached to the PC coordinates as are.
  If true then PC and World coordinates must maintain the same proportions.  For
  example, if the X and Y PC ranges are 100 and 100 while the X and Y world
  ranges are 10 and 5 then the world range should not cover the entire canvas of
  the component, or the drawn shapes will be unrealistic.*)

var
 XRange,YRange  : double;
 wYXRatio,PCYXRatio : double;
 TempLow,TempHigh   : double;
 TempRange          : double;
 rect               : TRect;
 aLeft,aRight       : double;
 aTop,aBottom       : double;

begin
  fProportional := value;

  rect := ClientRect;
  fCurrentCanvas.brush.color := color;
  fCurrentCanvas.FillRect(Rect);

  if not bZoom then
    begin
      fXMin := fXMinDesired;
      fXMax := fXMaxDesired;
      fYMin := fYMinDesired;
      fYMax := fYMaxDesired;
    end
  else
    begin
      fXMin := fXMinZoom;
      fXMax := fXMaxZoom;
      fYMin := fYMinZoom;
      fYMax := fYMaxZoom;
    end;

  if not fProportional then
    begin
      if XIncrease = LeftToRight then
        begin
          aLeft := fXMin;
          aRight := fXMax;
        end
      else
        begin
          aLeft := fXMax;
          aRight := fXMin;
        end;

      if YIncrease = BottomToTop then
        begin
          aTop := fYMax;
          aBottom := fYMin;
        end
      else
        begin
          aTop := fYMin;
          aBottom := fYMax;
        end;

      SetWorldWindow(aLeft,aRight,aTop,aBottom,0,0,0,0);
      SetPCWindow(0, width, 0, height);
      exit;
    end;

  xRange := fXMax - fXMin;
  yRange := fYMax - fYMin;
  wYXRatio := yRange/xRange;
  PCYXRatio := 1.0*height/width;

  if wYXRatio > PCYXRatio then (*world system is "taller" than pc system*)
    begin
      TempRange := xRange*wYXRatio/PCYXRatio;
      TempLow := (fXMin+fXMax)*0.5 - TempRange*0.5;
      TempHigh := (fXMin+fXMax)*0.5 + TempRange*0.5;
      fXmin := TempLow;
      fXMax := TempHigh;
    end
  else if wYXRatio < PCYXRatio then
    begin
      TempRange := yRange*PCYXRatio/wYXRatio;
      TempLow := (fYMin+fYMax)*0.5 - TempRange*0.5;
      TempHigh := (fYMin+fYMax)*0.5 + TempRange*0.5;
      fYMin := TempLow;
      fYMax := TempHigh;
    end;


  if XIncrease = LeftToRight then
    begin
      aLeft := fXMin;
      aRight := fXMax;
    end
  else
    begin
      aLeft := fXMax;
      aRight := fXMin;
    end;

  if YIncrease = BottomToTop then
    begin
      aTop := fYMax;
      aBottom := fYMin;
    end
  else
    begin
      aTop := fYMin;
      aBottom := fYMax;
    end;

  SetWorldWindow(aLeft,aRight,aTop,aBottom,0,0,0,0);
  SetPCWindow(0, width, 0, height);

end;

(******************************************************************************)
procedure TQSPaintBox.zoom(x1,y1,x2,y2:double);

var
  temp : double;

begin
  (*Set the ZOOM frame coordinates*)
  fXMinZoom := x1;
  fYMinZoom := y1;
  fXMaxZoom := x2;
  fYMaxZoom := y2;

  (* if min > max then switch values*)
  if fXMinZoom > fXMaxZoom then
    begin
      temp := fXMinZoom;
      fXMinZoom := fXMaxZoom;
      fXMaxZoom := temp;
    end;
  if fYMinZoom > fYMaxZoom then
    begin
      temp := fYMinZoom;
      fYMinZoom := fYMaxZoom;
      fYMaxZoom := temp;
    end;
  bZoom := true;
  paint;
end;

(******************************************************************************)

procedure TQSPaintBox.ResetZoom;

begin
  bZoom := false;
  paint;
end;

(******************************************************************************)

function TQSPaintBox.Wxy(PCx,PCy:integer):TWPoint;

(*
   This function returns the world coordinates of a point within
   the Q-Systems WorldGraph component for a point of local
   screen coordinates PCx, PCy, such as the ones returned by the
   OnMouseMove, OnMouseUp and OnMouseDown events of this component
*)

var
  wx,wy : double;

begin
  if (aa = 0) or (cc = 0) then exit; (*aa and cc are denominator values in PCtoWorld*)
  PCToWorld(PCx,PCy, wx, wy);
  with result do
    begin
      x := wx;
      y := wy;
    end;
end;

(******************************************************************************)

function TQSPaintBox.PCxy(wx,wy:double):TPCPoint;

(*
   This function returns the local screen coordinates of a point within
   the Q-Systems WorldGraph component for a point of World Coordinates wx, wy
*)

var
  PCx, PCy : integer;

begin
  WorldToPC(wx, wy, PCx, PCy);
  with result do
    begin
      x := PCx;
      y := PCy;
    end;

end;

(******************************************************************************)

procedure TQSPaintBox.WorldLineTo (Wx,Wy:double);

begin
  WLineTo(fCurrentCanvas,Wx,Wy);
end;

(******************************************************************************)

procedure TQSPaintBox.WorldMoveTo (Wx,Wy:double);
begin
  WMoveTo(fCurrentCanvas,Wx,Wy);
end;

(******************************************************************************)

procedure  TQSPaintBox.WorldArc(WX1, WY1, WX2, WY2, WX3, WY3, WX4, WY4: Double);

begin                                
  WArc(fCurrentCanvas,WX1, WY1, WX2, WY2, WX3, WY3, WX4, WY4);
end;

(******************************************************************************)

procedure  TQSPaintBox.WorldEllipse(WX1, WY1, WX2, WY2: Double);

begin
  WEllipse(fCurrentCanvas,WX1,WY1,WX2,WY2);
end;

(******************************************************************************)

procedure TQSPaintBox.WorldQuad4 (Wx1,Wy1,Wx2,Wy2,Wx3,Wy3,Wx4,Wy4:Double;
                      color:TColor;bShowBoundary:boolean);
begin
  WQuad4 (fCurrentCanvas,Wx1,Wy1,Wx2,Wy2,Wx3,Wy3,Wx4,Wy4,color,bShowBoundary);
end;

(******************************************************************************)

procedure TQSPaintBox.WorldQuad8 (Wx1,Wy1,Wx2,Wy2,Wx3,Wy3,Wx4,Wy4:Double;
                      Wx5,Wy5,Wx6,Wy6,Wx7,Wy7,Wx8,Wy8:Double;
                      color:TColor;bShowBoundary:boolean);
begin
  WQuad8 (fCurrentCanvas,Wx1,Wy1,Wx2,Wy2,Wx3,Wy3,Wx4,Wy4,
                      Wx5,Wy5,Wx6,Wy6,Wx7,Wy7,Wx8,Wy8,
                      color,bShowBoundary);
end;

(******************************************************************************)

procedure TQSPaintBox.WorldPolygon(NumberOfPoints:word; Points: TWPointArray;
                                   PenColor,FillColor:TColor;bShowBoundary:boolean);

var
  PCPoints : array[0..MAX_POLYGON_POINTS-1] of TPoint;
  i        : word;
  ix,iy      : integer;
  OldPenColor,OldBrushColor : TColor;
  OldPenStyle               : TPenStyle;
  bs                        : TBrushStyle;


begin
  if NumberOfPoints = 0 then exit;
  for i := 1 to NumberOfPoints do
    begin
      WorldToPC(Points[i].x,Points[i].y,ix,iy);
      (*Note: Points, being passed here as an OPEN ARRAY starts its index from 0.*)
      PCPoints[i-1].x := ix;
      PCPoints[i-1].y := iy;
    end;

  {$ifdef win32 then}
  {$else} {fill up the array with the last point because I cannot use slice}
  for i := NumberOfPoints to (MAX_POLYGON_POINTS-1) do
    begin
      PCPoints[i].x := PCPoints[NumberOfPoints-1].x;
      PCPoints[i].y := PCPoints[NumberOfPoints-1].y;
    end;
  {$endif}

  OldPenColor   := fCurrentCanvas.Pen.Color;
  OldBrushColor := fCurrentCanvas.Brush.Color;
  OldPenStyle   := fCurrentCanvas.Pen.Style;

  if bShowBoundary then
    fCurrentCanvas.Pen.Color := PenColor
  else
    fCurrentCanvas.Pen.Style := psClear;

  bs := fCurrentCanvas.Brush.Style;
  fCurrentCanvas.Brush.Color := FillColor;
  fCurrentCanvas.Brush.Style := bs;

  fCurrentCanvas.Polygon({$ifdef win32}Slice{$endif}(PCPoints{$ifdef win32},NumberOfPoints{$endif}));
(*  fCurrentCanvas.Polygon(Slice(PCPoints,NumberOfPoints)); *)


  fCurrentCanvas.Pen.Color   := OldPenColor;
  fCurrentCanvas.Brush.Color := OldBrushColor;
  fCurrentCanvas.Pen.Style   := OldPenStyle;

end;

(******************************************************************************)

procedure TQSPaintBox.SquarePoint(PointSize:integer;x,y:Double;color:TColor);

begin
  DrawSquarePoint(fCurrentCanvas,PointSize,x,y,color);
end;

(******************************************************************************)

procedure TQSPaintBox.TrianglePoint(PointSize:integer;x,y:Double;color:TColor);

begin
  DrawTrianglePoint(fCurrentCanvas,PointSize,x,y,color);
end;

(******************************************************************************)
procedure TQSPaintBox.CirclePoint(PointSize:integer;x,y:Double;color:TColor);

begin
  DrawCirclePoint(fCurrentCanvas,PointSize,x,y,color);
end;

(******************************************************************************)

procedure TQSPaintBox.EmptySquarePoint(PointSize:integer;x,y:Double;color:TColor);

begin
  DrawEmptySquarePoint(fCurrentCanvas,PointSize,x,y,color);
end;

(******************************************************************************)

procedure TQSPaintBox.EmptyTrianglePoint(PointSize:integer;x,y:Double;color:TColor);

begin
  DrawEmptyTrianglePoint(fCurrentCanvas,PointSize,x,y,color);
end;

(******************************************************************************)

procedure TQSPaintBox.EmptyCirclePoint(PointSize:integer;x,y:Double;color:TColor);

begin
  DrawEmptyCirclePoint(fCurrentCanvas,PointSize,x,y,color);
end;

procedure TQSPaintBox.CrossPoint(PointSize:integer;x,y:Double;color:TColor);
begin
  DrawCrossPoint(fCurrentCanvas,PointSize,x,y,color);
end;

(******************************************************************************)
procedure TQSPaintBox.SetPen(PenColor:TColor;PenMode:TPenMode;PenStyle:TPenStyle;PenWidth:integer);

begin
  with fCurrentCanvas do
    begin
      ResetPenColor := Pen.Color;
      ResetPenMode  := Pen.Mode;
      ResetPenStyle := Pen.Style;
      ResetPenWidth := Pen.Width;
      Pen.Color := PenColor;
      Pen.Mode := PenMode;
      Pen.Style := PenStyle;
      Pen.Width := PenWidth;
    end;
end;

(******************************************************************************)
procedure TQSPaintBox.ResetPen;

begin
  with fCurrentCanvas do
    begin
      Pen.Color := ResetPenColor;
      Pen.Mode := ResetPenMode;
      Pen.Style := ResetPenStyle;
      Pen.Width := ResetPenWidth;
    end;
end;
(******************************************************************************)

procedure TQSPaintBox.DrawCrossAt(pm:TPenMode;X,Y:Integer);

var
  Oldpm : TPenMode;
begin
  with fCurrentCanvas do
    begin
      OldPm := Pen.Mode;
      Pen.Mode := pm;
      (*Horizontal Line*)
      MoveTo(0,Y);
      LineTo(width,Y);
      (*Vertical Line*)
      MoveTo(X,0);
      LineTo(X,Height);
      Pen.Mode := OldPm;
    end;
end;
(******************************************************************************)
(******************************************************************************)
(******************************************************************************)
(******************************************************************************)

end.
