unit alloc;


interface

uses
  SysUtils;
                                    

{$ifdef VER110} {CBUILDER 3}
{$ObjExportAll On}
{$ENDIF}

(**************************************************************************)
  
const
  {$IFNDEF WIN32 THEN}
  FLOATLINESIZE    = $FFFF div sizeOf(double); (*note that every $FF
                                                corresponds to the
                                                largest number for a byte.
                                                Thus, $FF is the largest
                                                one-byte number, $FFFF is the
                                                largest 2-byte number,
                                                $FFFFFFFF is the largest
                                                4-byte number and so on.*)
  WORDLINESIZE    = $FFFF div sizeOf(word);
  BOOLEANLINESIZE = $FFFF div sizeOf(Boolean);
  LONGINTLINESIZE = $FFFF div sizeOf(LongInt);
  {$ELSE}
  FLOATLINESIZE    = $FFFFFF div sizeOf(double);
  WORDLINESIZE    = $FFFFFF div sizeOf(word);
  BOOLEANLINESIZE = $FFFFFF div sizeOf(Boolean);
  LONGINTLINESIZE = $FFFFFF div sizeOf(LongInt);
  {$ENDIF}


type

  TWPoint = record
    x  : double;
    y  : double;
  end;

  TPointArray   = Array[1..FLOATLINESIZE div 2] of TWPoint;
  PTPointArray  = ^TPointArray;
  TLineArrayB       = array[1..BOOLEANLINESIZE] of boolean;
  PTLineArrayB      = ^TLineArrayB;
  TLineArrayW       = array[1..WORDLINESIZE] of word;
  PTLineArrayW      = ^TLineArrayW;
  T2DArrayW         = array[1..FLOATLINESIZE] of PTLineArrayW;
  PT2DArrayW        = ^T2DArrayW;
  TLineArrayLI      = array[1..LONGINTLINESIZE] of LongInt;
  PTLineArrayLI     = ^TLineArrayLI;

  TLineArrayF       = array[1..FLOATLINESIZE] of double;
  PTLineArrayF      = ^TLineArrayF;
  T2DArrayF         = array[1..FLOATLINESIZE] of PTLineArrayF;
  PT2DArrayF        = ^T2DArrayF;
  T3DArrayF         = array[1..FLOATLINESIZE] of PT2DArrayF;
  PT3DArrayF        = ^T3DArrayF;



Function AllocatePointArray(var Vector:PTPointArray;size:word):boolean;
Function DeAllocatePointArray(var Vector:PTPointArray;size:word):boolean;
Function AllocateLineArrayB(var pLineArrayB:ptLineArrayB;elements:word):boolean;
Function DeAllocateLineArrayB(var pLineArrayB:ptLineArrayB;elements:word):boolean;
Function AllocateLineArrayW(var PLineArrayW:PTLineArrayW;elements:word):boolean;
Function DeAllocateLineArrayW(var PLineArrayW:PTLineArrayW;elements:word):boolean;
Function Allocate2DArrayW(var P2DArrayW:PT2DArrayW;elements1,elements2:word;height:PTLineArrayW):boolean;
Function DeAllocate2DArrayW(var P2DArrayW:PT2DArrayW;elements1,elements2:word;height:PTLineArrayW):boolean;
Function AllocateLineArrayLI(var PLineArrayLI:PTLineArrayLI;elements:word):boolean;
Function DeAllocateLineArrayLI(var PLineArrayLI:PTLineArrayLI;elements:word):boolean;
Function AllocateLineArrayF(var PLineArrayF:PTLineArrayF;elements:word):boolean;
Function DeAllocateLineArrayF(var PLineArrayF:PTLineArrayF;elements:word):boolean;
Function Allocate2DArrayF(var P2DArrayF:PT2DArrayF;elements1,elements2:word;height:PTLineArrayW):boolean;
Function DeAllocate2DArrayF(var P2DArrayF:PT2DArrayF;elements1,elements2:word;height:PTLineArrayW):boolean;
Function Allocate3DArrayF(var P3DArrayF:PT3DArrayF;elements1,elements2,elements3:word):boolean;
Function DeAllocate3DArrayF(var P3DArrayF:PT3DArrayF;elements1,elements2,elements3:word):boolean;

(****************************************************************************
   Allocate3DArrayF and AllocateStresses are both meant to allocate space
   for a pointer to a stress vector in the form stress[i,j,k].
   The Function AllocateStresses uses a pointer to an array of pointers to a
   record of sigma[j,k].  The use of "with .... do" which is followed by
   non-pointer expressions may be faster than the use of stress^[i]^[j]^[k]!!
****************************************************************************)


implementation



function AllocatePointArray(var Vector:PTPointArray;size:word):boolean;

var
  c: longInt;

begin
  c := size*sizeOf(TWPoint);
  if size > FLOATLINESIZE then
    begin
      result := false;
      exit;
    end;
  try
    GetMem(Vector,c);
    for c:= 1 to size do
      begin
        vector^[c].x := 0;
        vector^[c].y := 0;
      end;
    result := true;
  except
    on EOutOfMemory do result := false;
  end;
end;

function DeAllocatePointArray(var Vector:PTPointArray;size:word):boolean;

var
  c: longInt;

begin
  result := false;
  if Vector <> nil then
    begin
      c := size*sizeOf(TWPoint);
      FreeMem(Vector,c);
      vector := nil;
      result := true;
    end;
end;

(**************************************************************************)
(*************** ALLOCATION OF A 1-D ARRAY OF WORDS************************)
(**************************************************************************)


Function AllocateLineArrayB(var pLineArrayB:ptLineArrayB;elements:word):boolean;
var
  c: longInt;

begin
  If elements > WORDLINESIZE*16 then
    begin
      result := False;
      exit;
    end;
  c := LongInt(elements)*sizeof(boolean);
  try
    getmem(PLineArrayB,c);
    result := true;
  except
    on EOutOfMemory do result := false;
  end;
end;

function DeAllocateLineArrayB(var pLineArrayB:ptLineArrayB;elements:word):boolean;

var
  c: longInt;

begin
  result := false;
  if pLineArrayB <> nil then
    begin
      c := LongInt(elements)*sizeOf(Boolean);
      FreeMem(pLineArrayB,c);
      pLineArrayB := nil;
      result := true;
    end;
end;


Function AllocateLineArrayW(var PLineArrayW:PTLineArrayW;elements:word):boolean;

var
  c: longInt;

begin
  If elements > WORDLINESIZE then
    begin
      AllocateLineArrayW := False;
      exit;
    end;
  c := LongInt(elements)*sizeof(word);
  try
    getmem(PLineArrayW,c);
    result := true;
  except
    on EOutOfMemory do result := false;
  end;
end;

Function DeAllocateLineArrayW(var PLineArrayW:PTLineArrayW;elements:word):boolean;

var
  c: longInt;

begin
  result := false;
  if pLineArrayW <> nil then
    begin
      c := LongInt(elements)*sizeOf(word);
      FreeMem(pLineArrayW,c);
      pLineArrayW:= nil;
      result := true;
    end;
end;



(**************************************************************************)
(********************* ALLOCATION OF A 2-D ARRAY of words  ****************)
(**************************************************************************)

Function AllocateSecondDimensionOf2DArrayW(var P2DArrayW:PT2DArrayW;row1,elements:word):boolean;

var
  c: longInt;

begin
  c := LongInt(elements)*sizeof(word);
  try
    getmem(P2DArrayW^[row1],c);
    result := True;
  except
    on EOutOfMemory do result := false;
  end;

end;


Function DeAllocateSecondDimensionOf2DArrayW(var P2DArrayW:PT2DArrayW;row1,elements:word):boolean;

var
  c: longInt;

begin
  c := LongInt(elements)*sizeof(word);
  result := false;
  if not (P2DArrayW^[row1] = nil) then
    begin
      FreeMem(P2DArrayW^[row1],c);
      P2DArrayW^[row1] := nil;
      result := True;
    end;
end;

Function Allocate2DArrayW(var P2DArrayW:PT2DArrayW;elements1,elements2:word;height:PTLineArrayW):boolean;

var
  c           : longInt;
  i           : word;

begin
  If elements1 > WORDLINESIZE then
    begin
      result := False;
      exit;
    end;

  c := LongInt(elements1) * sizeof(pointer);

  try
    Getmem(P2DArrayW,c);
  except
    on EOutOfMemory do begin result := false; exit; end;
  end;

  if not (height = nil) then
    begin
      for i := 1 to elements1 do
        if not AllocateSecondDimensionOf2DArrayW(P2DArrayW,i,height^[i]) then
          begin
            result := False;
            exit;
          end
    end
  else
    for i := 1 to elements1 do
      if not AllocateSecondDimensionOf2DArrayW(P2DArrayW,i,elements2) then
        begin
          result := False;
          exit;
        end;
  result := True;
end;


Function DeAllocate2DArrayW(var P2DArrayW:PT2DArrayW;elements1,elements2:word;height:PTLineArrayW):boolean;

var
  c           : longInt;
  i           : word;

begin
  c := LongInt(elements1) * sizeof(pointer);
  result := false;

  if not (P2DArrayW = nil) then
    begin
      if not (height = nil) then
        begin
          for i := 1 to elements1 do
            if not DeAllocateSecondDimensionOf2DArrayW(P2DArrayW,i,height^[i]) then
              begin
                result := False;
                exit;
              end
        end
      else
        for i := 1 to elements1 do
          if not DeAllocateSecondDimensionOf2DArrayW(P2DArrayW,i,elements2) then
            begin
              result := False;
              exit;
            end;
       FreeMem(P2DArrayW,c);
       P2DArrayW := nil;
       result := True;
    end;
end;


Function AllocateLineArrayLI(var PLineArrayLI:PTLineArrayLI;elements:word):boolean;

var
  c: longInt;

begin
  c := LongInt(elements)*sizeof(word);
  try
    getmem(PLineArrayLI,c);
    Result := True;
  except
    on EOutOfMemory do result := false;
  end;
end;


Function DeAllocateLineArrayLI(var PLineArrayLI:PTLineArrayLI;elements:word):boolean;

var
  c: longInt;

begin
  result := false;
  if pLineArrayLI <> nil then
    begin
      c := LongInt(elements)*sizeOf(LongInt);
      FreeMem(pLineArrayLI,c);
      pLineArrayLI:= nil;
      result := true;
    end;
end;


(**************************************************************************)
(*************** ALLOCATION OF A 1-D ARRAY OF FLOATS **********************)
(**************************************************************************)


Function AllocateLineArrayF(var PLineArrayF:PTLineArrayF;elements:word):boolean;

var
  c: longInt;

begin
  c := LongINt(elements)*sizeof(double);
  try
    getmem(PLineArrayF,c);
    Result := True;
  except
    on EOutOfMemory do result := false;
  end;

end;


Function DeAllocateLineArrayF(var PLineArrayF:PTLineArrayF;elements:word):boolean;

var
  c: longInt;

begin
  result := false;
  if pLineArrayF <> nil then
    begin
      c := LongInt(elements)*sizeOf(double);
      FreeMem(pLineArrayF,c);
      pLineArrayF:= nil;
      result := true;
    end;
end;

(**************************************************************************)
(********************* ALLOCATION OF A 2-D ARRAY of FLOATS ****************)
(**************************************************************************)

Function AllocateSecondDimensionOf2DArrayF(var P2DArrayF:PT2DArrayF;row1,elements:word):boolean;

var
  c: longInt;

begin
  c := LongInt(elements)*sizeof(double);
  try
    getmem(P2DArrayF^[row1],c);
    result := True;
  except
    on EOutOfMemory do result := false;
  end;

end;

Function DeAllocateSecondDimensionOf2DArrayF(var P2DArrayF:PT2DArrayF;row1,elements:word):boolean;

var
  c: longInt;

begin
  c := LongInt(elements)*sizeof(double);
  result := false;
  if not (P2DArrayF^[row1] = nil) then
    begin
      FreeMem(P2DArrayF^[row1],c);
      P2DArrayF^[row1] := nil;
      result := True;
    end;
end;


Function Allocate2DArrayF(var P2DArrayF:PT2DArrayF;elements1,elements2:word;height:PTLineArrayW):boolean;

var
  c           : longInt;
  i           : word;

begin
  If elements1 > FLOATLINESIZE then
    begin
      result := False;
      exit;
    end;

  c := LongInt(elements1) * sizeof(pointer);

  try
    Getmem(P2DArrayF,c);
  except
    on EOutOfMemory do begin result := false; exit; end;
  end;

  if not (height = nil) then
    begin
      for i := 1 to elements1 do
        if not AllocateSecondDimensionOf2DArrayF(P2DArrayF,i,height^[i]) then
          begin
            Allocate2DArrayF := False;
            exit;
          end
    end
  else
    for i := 1 to elements1 do
      if not AllocateSecondDimensionOf2DArrayF(P2DArrayF,i,elements2) then
        begin
          Allocate2DArrayF := False;
          exit;
        end;
  Allocate2DArrayF := True;
end;

Function DeAllocate2DArrayF(var P2DArrayF:PT2DArrayF;elements1,elements2:word;height:PTLineArrayW):boolean;

var
  c           : longInt;
  i           : word;

begin
  c := LongInt(elements1) * sizeof(pointer);
  result := false;

  if not (P2DArrayF = nil) then
    begin
      if not (height = nil) then
        begin
          for i := 1 to elements1 do
            if not DeAllocateSecondDimensionOf2DArrayF(P2DArrayF,i,height^[i]) then
              begin
                result := False;
                exit;
              end
        end
      else
        for i := 1 to elements1 do
          if not DeAllocateSecondDimensionOf2DArrayF(P2DArrayF,i,elements2) then
            begin
              result := False;
              exit;
            end;
       FreeMem(P2DArrayF,c);
       P2DArrayF := nil;
       result := True;
    end;
end;


(**************************************************************************)
(********************* ALLOCATION OF A 3-D ARRAY **************************)
(**************************************************************************)

Function AllocateThirdDimensionOf3DArrayF(var P3DArrayF:PT3DArrayF;row1,row2,elements:word):boolean;

var
  c: longInt;

begin
  c := LongInt(elements)*sizeof(double);

  try
    getmem(P3DArrayF^[row1]^[row2],c);
    result := True;
  except
    on EOutOfMemory do result := false;
  end;

end;


Function DeAllocateThirdDimensionOf3DArrayF(var P3DArrayF:PT3DArrayF;row1,row2,elements:word):boolean;

var
  c: longInt;

begin
  c := LongInt(elements)*sizeof(double);
  result := false;
  if not (P3DArrayF^[row1]^[row2] = nil) then
    begin
      FreeMem(P3DArrayF^[row1]^[row2],c);
      P3DArrayF^[row1]^[row2] := nil;
      result := True;
    end;
end;

Function AllocateSecondDimensionOf3DArrayF(var P3DArrayF:PT3DArrayF;row1,elements2,elements3:word):boolean;

var
  c           : longInt;
  i           : word;

begin
  c := LongInt(elements2)*sizeof(pointer);

  try
    Getmem(P3DArrayF^[row1],c);
  except
    on EOutOfMemory do begin result := false; exit; end;
  end;

  for i := 1 to elements2 do
    if not AllocateThirdDimensionOf3DArrayF(P3DArrayF,row1,i,elements3) then
      begin
        AllocateSecondDimensionOf3DArrayF := False;
        exit;
      end;
  AllocateSecondDimensionOf3DArrayF := True;
end;


Function DeAllocateSecondDimensionOf3DArrayF(var P3DArrayF:PT3DArrayF;row1,elements2,elements3:word):boolean;
var
  c           : longInt;
  i           : word;

begin
  c := LongInt(elements2) * sizeof(pointer);
  result := false;

  if not (P3DArrayF^[row1] = nil) then
    begin
      for i := 1 to elements2 do
        if not DeAllocateThirdDimensionOf3DArrayF(P3DArrayF,row1,i,elements3) then
          begin
            result := False;
            exit;
          end;
     FreeMem(P3DArrayF^[row1],c);
     P3DArrayF^[row1] := nil;
     result := True;
  end;
end;


Function Allocate3DArrayF(var P3DArrayF:PT3DArrayF;elements1,elements2,elements3:word):boolean;

var
  c             : LongInt;
  i             : word;

begin
  c:= LongINt(elements1) * sizeOf(pointer);
  try
    GetMem(P3DArrayF,c);
  except
    on EOutOfMemory do
      begin
        result := false;
        exit;
      end;
  end;

  for i := 1 to elements1 do
    if not AllocateSecondDimensionOf3DArrayF(P3DArrayF,i,elements2,elements3) then
      begin
        result := False;
        exit;
      end;
  result := true;
end;

Function DeAllocate3DArrayF(var P3DArrayF:PT3DArrayF;elements1,elements2,elements3:word):boolean;

var
  c             : LongInt;
  i             : word;

begin
  c:= LongInt(elements1) * sizeOf(pointer);
  result := False;
  if not (P3DArrayF = nil) then
    begin
      for i := 1 to elements1 do
        if not DeAllocateSecondDimensionOf3DArrayF(P3DArrayF,i,elements2,elements3) then
          begin
            result := false;
            exit;
          end;
      FreeMem(P3DArrayF,c);
      P3DArrayF := nil;
      result := true;
    end;
end;

end.
